/*
 * Decompiled with CFR 0.152.
 */
package io.zulia.server.search;

import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import io.zulia.message.ZuliaIndex;
import io.zulia.server.config.ServerIndexConfig;
import io.zulia.server.field.FieldTypeUtil;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class ZuliaQueryParser
extends QueryParser {
    protected ServerIndexConfig indexConfig;
    private int minimumNumberShouldMatch;

    public ZuliaQueryParser(Analyzer analyzer, ServerIndexConfig indexConfig) {
        super(null, analyzer);
        this.indexConfig = indexConfig;
        this.setAllowLeadingWildcard(true);
    }

    private static Long getDateAsLong(String dateString) {
        long epochMilli;
        if (dateString.contains(":")) {
            epochMilli = Instant.parse(dateString).toEpochMilli();
        } else {
            LocalDate parse = LocalDate.parse(dateString, DateTimeFormatter.ISO_LOCAL_DATE);
            epochMilli = parse.atStartOfDay().toInstant(ZoneOffset.UTC).toEpochMilli();
        }
        return epochMilli;
    }

    public void setDefaultField(String field) {
        this.field = field;
    }

    public void setMinimumNumberShouldMatch(int minimumNumberShouldMatch) {
        this.minimumNumberShouldMatch = minimumNumberShouldMatch;
    }

    protected Query getRangeQuery(String field, String start, String end, boolean startInclusive, boolean endInclusive) throws ParseException {
        ZuliaIndex.FieldConfig.FieldType fieldType = this.indexConfig.getFieldTypeForIndexField(field);
        if (FieldTypeUtil.isNumericOrDateFieldType((ZuliaIndex.FieldConfig.FieldType)fieldType)) {
            return this.getNumericOrDateRange(field, start, end, startInclusive, endInclusive);
        }
        return super.getRangeQuery(field, start, end, startInclusive, endInclusive);
    }

    private Query getNumericOrDateRange(String fieldName, String start, String end, boolean startInclusive, boolean endInclusive) {
        ZuliaIndex.FieldConfig.FieldType fieldType = this.indexConfig.getFieldTypeForIndexField(fieldName);
        if (FieldTypeUtil.isNumericIntFieldType((ZuliaIndex.FieldConfig.FieldType)fieldType)) {
            int max;
            int min = start == null ? Integer.MIN_VALUE : Integer.parseInt(start);
            int n = max = end == null ? Integer.MAX_VALUE : Integer.parseInt(end);
            if (!startInclusive) {
                min = Math.addExact(min, 1);
            }
            if (!endInclusive) {
                max = Math.addExact(max, -1);
            }
            return IntPoint.newRangeQuery((String)fieldName, (int)min, (int)max);
        }
        if (FieldTypeUtil.isNumericLongFieldType((ZuliaIndex.FieldConfig.FieldType)fieldType)) {
            long max;
            long min = start == null ? Long.MIN_VALUE : Long.parseLong(start);
            long l = max = end == null ? Long.MAX_VALUE : Long.parseLong(end);
            if (!startInclusive) {
                min = Math.addExact(min, 1L);
            }
            if (!endInclusive) {
                max = Math.addExact(max, -1L);
            }
            return LongPoint.newRangeQuery((String)fieldName, (long)min, (long)max);
        }
        if (FieldTypeUtil.isNumericFloatFieldType((ZuliaIndex.FieldConfig.FieldType)fieldType)) {
            float max;
            float min = start == null ? Float.NEGATIVE_INFINITY : Float.parseFloat(start);
            float f = max = end == null ? Float.POSITIVE_INFINITY : Float.parseFloat(end);
            if (!startInclusive) {
                min = Math.nextUp(min);
            }
            if (!endInclusive) {
                max = Math.nextDown(max);
            }
            return FloatPoint.newRangeQuery((String)fieldName, (float)min, (float)max);
        }
        if (FieldTypeUtil.isNumericDoubleFieldType((ZuliaIndex.FieldConfig.FieldType)fieldType)) {
            double max;
            double min = start == null ? Double.NEGATIVE_INFINITY : Double.parseDouble(start);
            double d = max = end == null ? Double.POSITIVE_INFINITY : Double.parseDouble(end);
            if (!startInclusive) {
                min = Math.nextUp(min);
            }
            if (!endInclusive) {
                max = Math.nextDown(max);
            }
            return DoublePoint.newRangeQuery((String)fieldName, (double)min, (double)max);
        }
        if (FieldTypeUtil.isDateFieldType((ZuliaIndex.FieldConfig.FieldType)fieldType)) {
            long min = Long.MIN_VALUE;
            long max = Long.MAX_VALUE;
            if (start != null) {
                min = ZuliaQueryParser.getDateAsLong(start);
            }
            if (end != null) {
                max = ZuliaQueryParser.getDateAsLong(end);
            }
            if (!startInclusive) {
                min = Math.addExact(min, 1L);
            }
            if (!endInclusive) {
                max = Math.addExact(max, 1L);
            }
            return LongPoint.newRangeQuery((String)fieldName, (long)min, (long)max);
        }
        throw new RuntimeException("Not a valid numeric field <" + fieldName + ">");
    }

    protected Query newTermQuery(Term term) {
        String field = term.field();
        String text = term.text();
        ZuliaIndex.FieldConfig.FieldType fieldType = this.indexConfig.getFieldTypeForIndexField(field);
        if (FieldTypeUtil.isNumericOrDateFieldType((ZuliaIndex.FieldConfig.FieldType)fieldType)) {
            if (FieldTypeUtil.isDateFieldType((ZuliaIndex.FieldConfig.FieldType)fieldType)) {
                try {
                    ZuliaQueryParser.getDateAsLong(text);
                    return this.getNumericOrDateRange(field, text, text, true, true);
                }
                catch (Exception e) {
                    return new MatchNoDocsQuery(field + " expects date");
                }
            }
            if (FieldTypeUtil.isNumericIntFieldType((ZuliaIndex.FieldConfig.FieldType)fieldType) && Ints.tryParse((String)text) != null) {
                return this.getNumericOrDateRange(field, text, text, true, true);
            }
            if (FieldTypeUtil.isNumericLongFieldType((ZuliaIndex.FieldConfig.FieldType)fieldType) && Longs.tryParse((String)text) != null) {
                return this.getNumericOrDateRange(field, text, text, true, true);
            }
            if (FieldTypeUtil.isNumericFloatFieldType((ZuliaIndex.FieldConfig.FieldType)fieldType) && Floats.tryParse((String)text) != null) {
                return this.getNumericOrDateRange(field, text, text, true, true);
            }
            if (FieldTypeUtil.isNumericDoubleFieldType((ZuliaIndex.FieldConfig.FieldType)fieldType) && Doubles.tryParse((String)text) != null) {
                return this.getNumericOrDateRange(field, text, text, true, true);
            }
            return new MatchNoDocsQuery(field + " expects numeric");
        }
        return super.newTermQuery(term);
    }

    protected BooleanQuery.Builder newBooleanQuery() {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.setMinimumNumberShouldMatch(this.minimumNumberShouldMatch);
        return builder;
    }

    protected Query getWildcardQuery(String field, String termStr) throws ParseException {
        if (termStr.equals("*") && !field.equals("*")) {
            return new TermQuery(new Term("_lmflf_", field));
        }
        return super.getWildcardQuery(field, termStr);
    }
}

