/*
 * Decompiled with CFR 0.152.
 */
package io.zulia.server.search;

import io.zulia.server.config.ServerIndexConfig;
import io.zulia.server.search.ZuliaQueryParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;

public class ZuliaMultiFieldQueryParser
extends ZuliaQueryParser {
    protected List<String> fields;
    protected Map<String, Float> boosts;
    private float dismaxTie = 0.0f;
    private boolean dismax = false;

    public ZuliaMultiFieldQueryParser(Analyzer analyzer, ServerIndexConfig indexConfig) {
        super(analyzer, indexConfig);
    }

    public void enableDismax(float dismaxTie) {
        this.dismaxTie = dismaxTie;
        this.dismax = true;
    }

    public void disableDismax() {
        this.dismax = false;
    }

    public void setDefaultFields(Collection<String> fields) {
        HashMap<String, Float> boostMap = new HashMap<String, Float>();
        TreeSet<String> allFields = new TreeSet<String>();
        for (String field : fields) {
            Float boost = null;
            if (field.contains("^")) {
                boost = Float.valueOf(Float.parseFloat(field.substring(field.indexOf("^") + 1)));
                try {
                    field = field.substring(0, field.indexOf("^"));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid queryText field boost <" + field + ">");
                }
            }
            if (field.contains("*")) {
                String regex = field.replace("*", ".*");
                Set fieldNames = this.indexConfig.getMatchingFields(regex);
                allFields.addAll(fieldNames);
                if (boost == null) continue;
                for (String f : fieldNames) {
                    boostMap.put(f, boost);
                }
                continue;
            }
            allFields.add(field);
            if (boost == null) continue;
            boostMap.put(field, boost);
        }
        super.setDefaultField(null);
        this.fields = new ArrayList<String>(allFields);
        this.boosts = boostMap;
    }

    @Override
    public void setDefaultField(String field) {
        super.setDefaultField(field);
        this.fields = null;
    }

    protected Query getFieldQuery(String field, String queryText, int slop) throws ParseException {
        if (field == null) {
            ArrayList<Query> clauses = new ArrayList<Query>();
            for (String f : this.fields) {
                Float boost;
                Query q = super.getFieldQuery(f, queryText, true);
                if (q == null) continue;
                if (this.boosts != null && (boost = this.boosts.get(f)) != null) {
                    q = new BoostQuery(q, boost.floatValue());
                }
                q = this.applySlop(q, slop);
                clauses.add(q);
            }
            if (clauses.size() == 0) {
                return null;
            }
            return this.getMultiFieldQuery(clauses);
        }
        Query q = super.getFieldQuery(field, queryText, true);
        q = this.applySlop(q, slop);
        return q;
    }

    private Query applySlop(Query q, int slop) {
        MultiPhraseQuery mpq;
        if (q instanceof PhraseQuery) {
            PhraseQuery.Builder builder = new PhraseQuery.Builder();
            builder.setSlop(slop);
            PhraseQuery pq = (PhraseQuery)q;
            Term[] terms = pq.getTerms();
            int[] positions = pq.getPositions();
            for (int i = 0; i < terms.length; ++i) {
                builder.add(terms[i], positions[i]);
            }
            q = builder.build();
        } else if (q instanceof MultiPhraseQuery && slop != (mpq = (MultiPhraseQuery)q).getSlop()) {
            q = new MultiPhraseQuery.Builder(mpq).setSlop(slop).build();
        }
        return q;
    }

    protected Query getFieldQuery(String field, String queryText, boolean quoted) throws ParseException {
        if (field == null) {
            ArrayList<Query> clauses = new ArrayList<Query>();
            Query[] fieldQueries = new Query[this.fields.size()];
            int maxTerms = 0;
            for (int i = 0; i < this.fields.size(); ++i) {
                Query q = super.getFieldQuery(this.fields.get(i), queryText, quoted);
                if (q == null) continue;
                maxTerms = q instanceof BooleanQuery ? Math.max(maxTerms, ((BooleanQuery)q).clauses().size()) : Math.max(1, maxTerms);
                fieldQueries[i] = q;
            }
            for (int termNum = 0; termNum < maxTerms; ++termNum) {
                ArrayList<Query> termClauses = new ArrayList<Query>();
                for (int i = 0; i < this.fields.size(); ++i) {
                    Float boost;
                    if (fieldQueries[i] == null) continue;
                    Query q = null;
                    if (fieldQueries[i] instanceof BooleanQuery) {
                        List nestedClauses = ((BooleanQuery)fieldQueries[i]).clauses();
                        if (termNum < nestedClauses.size()) {
                            q = ((BooleanClause)nestedClauses.get(termNum)).getQuery();
                        }
                    } else if (termNum == 0) {
                        q = fieldQueries[i];
                    }
                    if (q == null) continue;
                    if (this.boosts != null && (boost = this.boosts.get(this.fields.get(i))) != null) {
                        q = new BoostQuery(q, boost.floatValue());
                    }
                    termClauses.add(q);
                }
                if (maxTerms > 1) {
                    if (termClauses.size() <= 0) continue;
                    BooleanQuery.Builder builder = new BooleanQuery.Builder();
                    for (Query termClause : termClauses) {
                        builder.add(termClause, BooleanClause.Occur.SHOULD);
                    }
                    clauses.add((Query)builder.build());
                    continue;
                }
                clauses.addAll(termClauses);
            }
            if (clauses.size() == 0) {
                return null;
            }
            return this.getMultiFieldQuery(clauses);
        }
        Query q = super.getFieldQuery(field, queryText, quoted);
        return q;
    }

    protected Query getFuzzyQuery(String field, String termStr, float minSimilarity) throws ParseException {
        if (field == null) {
            ArrayList<Query> clauses = new ArrayList<Query>();
            for (String f : this.fields) {
                clauses.add(this.getFuzzyQuery(f, termStr, minSimilarity));
            }
            return this.getMultiFieldQuery(clauses);
        }
        return super.getFuzzyQuery(field, termStr, minSimilarity);
    }

    protected Query getPrefixQuery(String field, String termStr) throws ParseException {
        if (field == null) {
            ArrayList<Query> clauses = new ArrayList<Query>();
            for (String f : this.fields) {
                clauses.add(this.getPrefixQuery(f, termStr));
            }
            return this.getMultiFieldQuery(clauses);
        }
        return super.getPrefixQuery(field, termStr);
    }

    @Override
    protected Query getWildcardQuery(String field, String termStr) throws ParseException {
        if (field == null) {
            ArrayList<Query> clauses = new ArrayList<Query>();
            for (String f : this.fields) {
                clauses.add(this.getWildcardQuery(f, termStr));
            }
            return this.getMultiFieldQuery(clauses);
        }
        return super.getWildcardQuery(field, termStr);
    }

    @Override
    protected Query getRangeQuery(String field, String part1, String part2, boolean startInclusive, boolean endInclusive) throws ParseException {
        if (field == null) {
            ArrayList<Query> clauses = new ArrayList<Query>();
            for (String f : this.fields) {
                clauses.add(this.getRangeQuery(f, part1, part2, startInclusive, endInclusive));
            }
            return this.getMultiFieldQuery(clauses);
        }
        return super.getRangeQuery(field, part1, part2, startInclusive, endInclusive);
    }

    protected Query getRegexpQuery(String field, String termStr) throws ParseException {
        if (field == null) {
            ArrayList<Query> clauses = new ArrayList<Query>();
            for (String f : this.fields) {
                clauses.add(this.getRegexpQuery(f, termStr));
            }
            return this.getMultiFieldQuery(clauses);
        }
        return super.getRegexpQuery(field, termStr);
    }

    protected Query getMultiFieldQuery(List<Query> queries) throws ParseException {
        if (queries.isEmpty()) {
            return null;
        }
        if (this.dismax) {
            return new DisjunctionMaxQuery(queries, this.dismaxTie);
        }
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        for (Query sub : queries) {
            query.add(sub, BooleanClause.Occur.SHOULD);
        }
        return query.build();
    }
}

