/*
 * Decompiled with CFR 0.152.
 */
package io.zeko.db.sql.utilities;

import io.vertx.core.json.JsonArray;
import io.vertx.sqlclient.Tuple;
import io.zeko.model.Entity;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u001a\u0016\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u001a\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t\u001a\u0012\u0010\u0007\u001a\u00020\u00062\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0003\u001a\u001c\u0010\u0007\u001a\u00020\u00062\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u000b\u001a\n\u0010\r\u001a\u00020\f*\u00020\f\u001a\n\u0010\u000e\u001a\u00020\f*\u00020\f\u00a8\u0006\u000f"}, d2={"convertParams", "Lio/vertx/core/json/JsonArray;", "params", "", "", "convertTuple", "Lio/vertx/sqlclient/Tuple;", "tuple", "entity", "Lio/zeko/model/Entity;", "param", "", "", "toCamelCase", "toSnakeCase", "zeko-sql-builder"})
public final class DeclarationsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String toSnakeCase(@NotNull String $this$toSnakeCase) {
        Intrinsics.checkNotNullParameter((Object)$this$toSnakeCase, (String)"<this>");
        Object text = null;
        text = "";
        CharSequence $this$forEachIndexed$iv = $this$toSnakeCase;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (int i = 0; i < $this$forEachIndexed$iv.length(); ++i) {
            void c;
            char item$iv = $this$forEachIndexed$iv.charAt(i);
            int n = index$iv++;
            char c2 = item$iv;
            int index = n;
            boolean bl = false;
            if (Character.isUpperCase((char)c)) {
                if (index > 0) {
                    text = text + "_";
                }
                text = "" + text + Character.toLowerCase((char)c);
                continue;
            }
            text = "" + text + (char)c;
        }
        return text;
    }

    @NotNull
    public static final String toCamelCase(@NotNull String $this$toCamelCase) {
        Intrinsics.checkNotNullParameter((Object)$this$toCamelCase, (String)"<this>");
        if (((CharSequence)$this$toCamelCase).length() == 0) {
            return "";
        }
        String string = $this$toCamelCase.substring(0, 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String string2 = string.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase()");
        Object camelCase = string2;
        if ($this$toCamelCase.length() > 1) {
            boolean wordStart = false;
            int n = $this$toCamelCase.length();
            for (int i = 1; i < n; ++i) {
                char currChar = $this$toCamelCase.charAt(i);
                if (currChar == '_') {
                    wordStart = true;
                    continue;
                }
                camelCase = wordStart ? (String)camelCase + Character.toUpperCase(currChar) : (String)camelCase + Character.toLowerCase(currChar);
                wordStart = false;
            }
        }
        return camelCase;
    }

    @NotNull
    public static final Tuple tuple(@NotNull List<?> param) {
        Intrinsics.checkNotNullParameter(param, (String)"param");
        Tuple tuple = Tuple.from((List)DeclarationsKt.convertParams(param).getList());
        Intrinsics.checkNotNullExpressionValue((Object)tuple, (String)"from(convertParams(param).list)");
        return tuple;
    }

    @NotNull
    public static final Tuple tuple(@NotNull Map<String, Object> param) {
        Intrinsics.checkNotNullParameter(param, (String)"param");
        Tuple tuple = Tuple.from((List)DeclarationsKt.convertParams(CollectionsKt.toList((Iterable)param.values())).getList());
        Intrinsics.checkNotNullExpressionValue((Object)tuple, (String)"from(convertParams(param.values.toList()).list)");
        return tuple;
    }

    @NotNull
    public static final Tuple tuple(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Tuple tuple = Tuple.from((List)DeclarationsKt.convertParams(CollectionsKt.toList((Iterable)entity.dataMap().values())).getList());
        Intrinsics.checkNotNullExpressionValue((Object)tuple, (String)"from(convertParams(entit\u2026().values.toList()).list)");
        return tuple;
    }

    @NotNull
    public static final Tuple convertTuple(@NotNull List<? extends Object> params) {
        Intrinsics.checkNotNullParameter(params, (String)"params");
        Tuple tuple = Tuple.from((List)DeclarationsKt.convertParams(params).getList());
        Intrinsics.checkNotNullExpressionValue((Object)tuple, (String)"from(convertParams(params).list)");
        return tuple;
    }

    @NotNull
    public static final JsonArray convertParams(@NotNull List<? extends Object> params) {
        Intrinsics.checkNotNullParameter(params, (String)"params");
        if (!((Collection)params).isEmpty()) {
            ArrayList<Date> converted = new ArrayList<Date>();
            Iterable $this$forEach$iv = params;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                java.util.Date date;
                Object element$iv;
                Object value = element$iv = iterator.next();
                boolean bl = false;
                Object t = value;
                if (t instanceof LocalDate) {
                    date = Date.valueOf((LocalDate)value);
                } else if (t instanceof LocalDateTime) {
                    date = Timestamp.valueOf((LocalDateTime)value);
                } else if (t instanceof LocalTime) {
                    date = Time.valueOf((LocalTime)value);
                } else if (t instanceof Instant) {
                    date = Timestamp.valueOf(((Instant)value).atZone(ZoneId.systemDefault()).toLocalDateTime());
                } else if (t instanceof ZonedDateTime) {
                    ZonedDateTime systemZoneDateTime = ((ZonedDateTime)value).withZoneSameInstant(ZoneId.of("UTC"));
                    LocalDateTime local = systemZoneDateTime.toLocalDateTime();
                    date = new Timestamp(ZonedDateTime.of(local, ZoneId.systemDefault()).toInstant().toEpochMilli());
                } else {
                    date = value;
                }
                Date v = date;
                converted.add(v);
            }
            return new JsonArray((List)converted);
        }
        return new JsonArray(params);
    }
}

