/*
 * Decompiled with CFR 0.152.
 */
package io.zeko.db.sql.connections;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.mysqlclient.MySQLBuilder;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.zeko.db.sql.connections.DBConn;
import io.zeko.db.sql.connections.DBPool;
import io.zeko.db.sql.connections.VertxAsyncMysqlConn;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u000b\u001a\u00020\fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u000e\u001a\u00020\bJ\b\u0010\u000f\u001a\u00020\nH\u0016J\u0006\u0010\u0010\u001a\u00020\u0003J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\nH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2={"Lio/zeko/db/sql/connections/VertxAsyncMysqlPool;", "Lio/zeko/db/sql/connections/DBPool;", "vertx", "Lio/vertx/core/Vertx;", "json", "Lio/vertx/core/json/JsonObject;", "(Lio/vertx/core/Vertx;Lio/vertx/core/json/JsonObject;)V", "client", "Lio/vertx/sqlclient/Pool;", "insertStatementMode", "", "createConnection", "Lio/zeko/db/sql/connections/DBConn;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getClient", "getInsertStatementMode", "getVertx", "init", "", "config", "setInsertStatementMode", "mode", "zeko-sql-builder"})
public final class VertxAsyncMysqlPool
implements DBPool {
    private Pool client;
    @NotNull
    private Vertx vertx;
    private int insertStatementMode;

    public VertxAsyncMysqlPool(@NotNull Vertx vertx, @NotNull JsonObject json) {
        Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.insertStatementMode = -1;
        this.vertx = vertx;
        this.init(json);
    }

    @NotNull
    public final Vertx getVertx() {
        return this.vertx;
    }

    @NotNull
    public final Pool getClient() {
        Pool pool = this.client;
        if (pool == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            pool = null;
        }
        return pool;
    }

    private final void init(JsonObject config) {
        MySQLConnectOptions mySQLConnectOptions = new MySQLConnectOptions().setHost(config.getString("host"));
        Integer n = config.getInteger("port");
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"config.getInteger(\"port\")");
        MySQLConnectOptions mySQLConnectOptions2 = mySQLConnectOptions.setPort(((Number)n).intValue()).setDatabase(config.getString("database")).setUser(config.getString("user")).setPassword(config.getString("password"));
        Integer n2 = config.getInteger("reconnectAttempts", Integer.valueOf(1));
        Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"config.getInteger(\"reconnectAttempts\", 1)");
        MySQLConnectOptions mySQLConnectOptions3 = mySQLConnectOptions2.setReconnectAttempts(((Number)n2).intValue());
        Long l = config.getLong("reconnectInterval", Long.valueOf(1000L));
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"config.getLong(\"reconnectInterval\", 1000)");
        MySQLConnectOptions conf = mySQLConnectOptions3.setReconnectInterval(((Number)l).longValue());
        PoolOptions poolOptions = new PoolOptions();
        Integer n3 = config.getInteger("poolSize");
        Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"config.getInteger(\"poolSize\")");
        PoolOptions poolOptions2 = poolOptions.setMaxSize(((Number)n3).intValue());
        Object object = MySQLBuilder.pool().with(poolOptions2).connectingTo((SqlConnectOptions)conf).build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pool()\n            .with\u2026onf)\n            .build()");
        this.client = (Pool)object;
    }

    @Override
    @Nullable
    public Object createConnection(@NotNull Continuation<? super DBConn> $completion) {
        Pool pool = this.client;
        if (pool == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            pool = null;
        }
        return new VertxAsyncMysqlConn(pool);
    }

    @Override
    public int getInsertStatementMode() {
        return this.insertStatementMode;
    }

    @Override
    public void setInsertStatementMode(int mode) {
        this.insertStatementMode = mode;
    }
}

