/*
 * Decompiled with CFR 0.152.
 */
package io.zeko.db.sql;

import io.zeko.db.sql.DataManipulation;
import io.zeko.db.sql.Query;
import io.zeko.db.sql.QueryBlock;
import io.zeko.db.sql.utilities.DeclarationsKt;
import io.zeko.model.Entity;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u00002\u00020\u0001B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010$\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0006\u0010\u0013\u001a\u00020\u0000J\u001e\u0010%\u001a\u00020\u00002\u0016\u0010&\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0018\u00010\rJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u001fJ\b\u0010(\u001a\u00020\nH\u0016R*\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0018\u00010\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\"\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0019X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u0006)"}, d2={"Lio/zeko/db/sql/Insert;", "Lio/zeko/db/sql/DataManipulation;", "entity", "Lio/zeko/model/Entity;", "parameterize", "", "espTableName", "(Lio/zeko/model/Entity;ZZ)V", "columns", "", "", "(Lio/zeko/model/Entity;[Ljava/lang/String;)V", "duplicateUpdateFields", "", "", "getDuplicateUpdateFields", "()Ljava/util/Map;", "setDuplicateUpdateFields", "(Ljava/util/Map;)V", "ignore", "getIgnore", "()Z", "setIgnore", "(Z)V", "insertFields", "", "getInsertFields", "()Ljava/util/List;", "setInsertFields", "(Ljava/util/List;)V", "select", "Lio/zeko/db/sql/Query;", "getSelect", "()Lio/zeko/db/sql/Query;", "setSelect", "(Lio/zeko/db/sql/Query;)V", "escapeTable", "onDuplicateUpdate", "fields", "query", "toSql", "zeko-sql-builder"})
public class Insert
extends DataManipulation {
    @Nullable
    private Map<String, ? extends Object> duplicateUpdateFields;
    private boolean ignore;
    @Nullable
    private Query select;
    @Nullable
    private List<String> insertFields;

    @Nullable
    protected final Map<String, Object> getDuplicateUpdateFields() {
        return this.duplicateUpdateFields;
    }

    protected final void setDuplicateUpdateFields(@Nullable Map<String, ? extends Object> map) {
        this.duplicateUpdateFields = map;
    }

    protected final boolean getIgnore() {
        return this.ignore;
    }

    protected final void setIgnore(boolean bl) {
        this.ignore = bl;
    }

    @Nullable
    protected final Query getSelect() {
        return this.select;
    }

    protected final void setSelect(@Nullable Query query2) {
        this.select = query2;
    }

    @Nullable
    protected final List<String> getInsertFields() {
        return this.insertFields;
    }

    protected final void setInsertFields(@Nullable List<String> list) {
        this.insertFields = list;
    }

    public Insert(@NotNull Entity entity, boolean parameterize, boolean espTableName) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.setEntity(entity);
        this.setParameterize(parameterize);
        this.setEspTableName(espTableName);
    }

    public /* synthetic */ Insert(Entity entity, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        this(entity, bl, bl2);
    }

    public Insert(@NotNull Entity entity, String ... columns) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)columns, (String)"columns");
        this.setEntity(entity);
        this.insertFields = CollectionsKt.arrayListOf((Object[])Arrays.copyOf(columns, columns.length));
    }

    @Override
    @NotNull
    public Insert escapeTable(boolean espTableName) {
        super.escapeTable(espTableName);
        return this;
    }

    @NotNull
    public final Insert select(@NotNull Query query2) {
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        this.select = query2;
        return this;
    }

    @NotNull
    public final Insert ignore() {
        this.ignore = true;
        return this;
    }

    @NotNull
    public final Insert onDuplicateUpdate(@Nullable Map<String, ? extends Object> fields) {
        this.duplicateUpdateFields = fields;
        return this;
    }

    @Override
    @NotNull
    public String toSql() {
        String sql = this.ignore ? "INSERT IGNORE INTO " + this.getTableName() : "INSERT INTO " + this.getTableName();
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<CallSite> onDuplicatePart = new ArrayList<CallSite>();
        Object onDuplicateSql = "";
        if (this.duplicateUpdateFields != null) {
            Map<String, ? extends Object> map = this.duplicateUpdateFields;
            Intrinsics.checkNotNull(map);
            for (Map.Entry<String, ? extends Object> entry : map.entrySet()) {
                String propName = entry.getKey();
                Object value = entry.getValue();
                if (value == null) continue;
                if (this.getParameterize()) {
                    if (value instanceof QueryBlock) {
                        onDuplicatePart.add((CallSite)((Object)(propName + " = " + value)));
                        continue;
                    }
                    onDuplicatePart.add((CallSite)((Object)(propName + " = ?")));
                    continue;
                }
                if (value instanceof String) {
                    onDuplicatePart.add((CallSite)((Object)(propName + " = '" + StringsKt.replace$default((String)((String)value), (String)"'", (String)"''", (boolean)false, (int)4, null) + "'")));
                    continue;
                }
                if (value instanceof QueryBlock) {
                    onDuplicatePart.add((CallSite)((Object)(propName + " = " + value)));
                    continue;
                }
                onDuplicatePart.add((CallSite)((Object)(propName + " = " + value)));
            }
            onDuplicateSql = " ON DUPLICATE KEY UPDATE " + CollectionsKt.joinToString$default((Iterable)onDuplicatePart, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        }
        if (!this.getEntity().dataMap().isEmpty()) {
            Set<Map.Entry<String, Object>> entries = this.getEntity().dataMap().entrySet();
            List<String> ignores = this.getEntity().ignoreFields();
            for (Map.Entry<String, Object> entry : entries) {
                String propName = entry.getKey();
                Object value = entry.getValue();
                if (!((Collection)ignores).isEmpty() && ignores.indexOf(propName) > -1) continue;
                String prop = DeclarationsKt.toSnakeCase(propName);
                if (this.shouldIgnoreType(value)) continue;
                columns.add(prop);
                if (this.getParameterize()) {
                    values.add("?");
                    continue;
                }
                if (value instanceof String) {
                    values.add("'" + StringsKt.replace$default((String)((String)value), (String)"'", (String)"''", (boolean)false, (int)4, null) + "'");
                    continue;
                }
                values.add(String.valueOf(value));
            }
            sql = sql + " ( " + CollectionsKt.joinToString$default((Iterable)columns, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + " ) ";
            sql = sql + "VALUES ( " + CollectionsKt.joinToString$default((Iterable)values, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + " ) ";
        } else if (this.insertFields != null) {
            List<String> list = this.insertFields;
            sql = sql + " ( " + (list != null ? CollectionsKt.joinToString$default((Iterable)list, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) : null) + " ) ";
        } else {
            sql = sql + " ";
        }
        if (this.select != null) {
            Query query2 = this.select;
            sql = sql + (query2 != null ? Query.toSql$default(query2, false, 1, null) : null);
        }
        sql = sql + (String)onDuplicateSql;
        return ((Object)StringsKt.trimEnd((CharSequence)sql)).toString();
    }
}

