/*
 * Decompiled with CFR 0.152.
 */
package io.zeko.db.sql.connections;

import com.github.jasync.sql.db.Configuration;
import com.github.jasync.sql.db.ConnectionPoolConfiguration;
import com.github.jasync.sql.db.ConnectionPoolConfigurationBuilder;
import com.github.jasync.sql.db.mysql.MySQLConnectionBuilder;
import com.github.jasync.sql.db.mysql.pool.MySQLConnectionFactory;
import com.github.jasync.sql.db.pool.ConnectionPool;
import com.github.jasync.sql.db.pool.ObjectFactory;
import com.github.jasync.sql.db.postgresql.PostgreSQLConnectionBuilder;
import com.github.jasync.sql.db.postgresql.pool.PostgreSQLConnectionFactory;
import com.github.jasync.sql.db.util.KotlinUtilsKt;
import io.vertx.core.json.JsonObject;
import io.zeko.db.sql.connections.DBConn;
import io.zeko.db.sql.connections.DBPool;
import io.zeko.db.sql.connections.JasyncDBConn;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0013\b\u0016\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eB\u0017\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0011\u0010\u0013\u001a\u00020\u0014H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\u001c\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000f0\u00172\u0006\u0010\u0018\u001a\u00020\tH\u0002J\b\u0010\u0019\u001a\u00020\u0012H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0002J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0012H\u0016R\u0012\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001e"}, d2={"Lio/zeko/db/sql/connections/JasyncDBPool;", "Lio/zeko/db/sql/connections/DBPool;", "json", "Lio/vertx/core/json/JsonObject;", "(Lio/vertx/core/json/JsonObject;)V", "client", "Lcom/github/jasync/sql/db/pool/ConnectionPool;", "(Lcom/github/jasync/sql/db/pool/ConnectionPool;)V", "database", "", "config", "Lcom/github/jasync/sql/db/Configuration;", "poolConfig", "Lcom/github/jasync/sql/db/ConnectionPoolConfiguration;", "(Ljava/lang/String;Lcom/github/jasync/sql/db/Configuration;Lcom/github/jasync/sql/db/ConnectionPoolConfiguration;)V", "Lcom/github/jasync/sql/db/ConnectionPoolConfigurationBuilder;", "(Ljava/lang/String;Lcom/github/jasync/sql/db/ConnectionPoolConfigurationBuilder;)V", "insertStatementMode", "", "createConnection", "Lio/zeko/db/sql/connections/DBConn;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getConfigFromURL", "Lkotlin/Pair;", "url", "getInsertStatementMode", "init", "", "setInsertStatementMode", "mode", "zeko-sql-builder"})
public final class JasyncDBPool
implements DBPool {
    private ConnectionPool<?> client;
    private int insertStatementMode;

    public JasyncDBPool(@NotNull JsonObject json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.insertStatementMode = -1;
        this.init(json);
    }

    public JasyncDBPool(@NotNull ConnectionPool<?> client) {
        Intrinsics.checkNotNullParameter(client, (String)"client");
        this.insertStatementMode = -1;
        this.client = client;
    }

    public JasyncDBPool(@NotNull String database, @NotNull Configuration config, @NotNull ConnectionPoolConfiguration poolConfig) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)poolConfig, (String)"poolConfig");
        this.insertStatementMode = -1;
        this.init(database, config, poolConfig);
    }

    public JasyncDBPool(@NotNull String database, @NotNull ConnectionPoolConfigurationBuilder config) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.insertStatementMode = -1;
        this.init(database, config);
    }

    private final Pair<String, ConnectionPoolConfigurationBuilder> getConfigFromURL(String url) {
        Charset charset;
        Object object;
        HashMap config = new HashMap();
        String string = url.substring(5);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        String noJdbc = string;
        String[] stringArray = new String[]{"/"};
        List parts = StringsKt.split$default((CharSequence)noJdbc, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String string2 = ((String)parts.get(0)).substring(0, KotlinUtilsKt.getSize((String)((String)parts.get(0))) - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String databaseType = string2;
        String[] stringArray2 = new String[]{":"};
        List hostParts = StringsKt.split$default((CharSequence)((CharSequence)parts.get(2)), (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
        ((Map)config).put("host", hostParts.get(0));
        ((Map)config).put("port", hostParts.get(1));
        String[] stringArray3 = new String[]{"?"};
        List uriParts = StringsKt.split$default((CharSequence)((CharSequence)parts.get(3)), (String[])stringArray3, (boolean)false, (int)0, (int)6, null);
        ((Map)config).put("database", uriParts.get(0));
        if (uriParts.size() > 1) {
            String query2 = (String)uriParts.get(1);
            object = new String[]{"&"};
            List pairs = StringsKt.split$default((CharSequence)query2, (String[])object, (boolean)false, (int)0, (int)6, null);
            object = pairs.iterator();
            while (object.hasNext()) {
                String string3;
                String key;
                String string4;
                String pair = (String)object.next();
                int idx = StringsKt.indexOf$default((CharSequence)pair, (String)"=", (int)0, (boolean)false, (int)6, null);
                if (idx > 0) {
                    String string5 = pair.substring(0, idx);
                    string4 = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                } else {
                    string4 = key = pair;
                }
                if (idx > 0 && pair.length() > idx + 1) {
                    String string6 = pair.substring(idx + 1);
                    string3 = string6;
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).substring(startIndex)");
                } else {
                    string3 = "";
                }
                String value = string3;
                ((Map)config).put(key, value);
            }
        }
        Charset charset2 = null;
        if (config.containsKey("characterEncoding")) {
            Charset charset3 = Charset.forName((String)config.get("characterEncoding"));
            charset = charset3;
            Intrinsics.checkNotNullExpressionValue((Object)charset3, (String)"forName(config[\"characterEncoding\"])");
        } else {
            Charset charset4 = Charset.forName("utf-8");
            charset = charset4;
            Intrinsics.checkNotNullExpressionValue((Object)charset4, (String)"forName(\"utf-8\")");
        }
        charset2 = charset;
        Object $this$getConfigFromURL_u24lambda_u2d0 = object = new ConnectionPoolConfigurationBuilder(null, 0, null, null, null, 0, 0L, 0, 0L, 0L, 0L, null, null, null, null, null, null, 0, null, null, null, null, 0x3FFFFF, null);
        boolean bl = false;
        Object v = config.get("host");
        Intrinsics.checkNotNull(v);
        $this$getConfigFromURL_u24lambda_u2d0.setHost((String)v);
        Object v2 = config.get("port");
        Intrinsics.checkNotNull(v2);
        $this$getConfigFromURL_u24lambda_u2d0.setPort(Integer.parseInt((String)v2));
        Object v3 = config.get("database");
        Intrinsics.checkNotNull(v3);
        $this$getConfigFromURL_u24lambda_u2d0.setDatabase((String)v3);
        Object v4 = config.get("user");
        Intrinsics.checkNotNull(v4);
        $this$getConfigFromURL_u24lambda_u2d0.setUsername((String)v4);
        if (config.containsKey("password")) {
            Object v5 = config.get("password");
            Intrinsics.checkNotNull(v5);
            $this$getConfigFromURL_u24lambda_u2d0.setPassword((String)v5);
        }
        if (config.containsKey("queryTimeout")) {
            $this$getConfigFromURL_u24lambda_u2d0.setQueryTimeout(Long.valueOf(Long.parseLong(String.valueOf(config.get("queryTimeout")))));
        }
        if (config.containsKey("maxIdleTime")) {
            $this$getConfigFromURL_u24lambda_u2d0.setMaxIdleTime(Long.parseLong(String.valueOf(config.get("queryTimeout"))));
        }
        if (config.containsKey("maxConnectionTtl")) {
            $this$getConfigFromURL_u24lambda_u2d0.setMaxConnectionTtl(Long.valueOf(Long.parseLong(String.valueOf(config.get("maxConnectionTtl")))));
        }
        if (config.containsKey("maxActiveConnections")) {
            $this$getConfigFromURL_u24lambda_u2d0.setMaxActiveConnections(Integer.parseInt(String.valueOf(config.get("maxActiveConnections"))));
        }
        if (config.containsKey("maxPendingQueries")) {
            $this$getConfigFromURL_u24lambda_u2d0.setMaxPendingQueries(Integer.parseInt(String.valueOf(config.get("maxPendingQueries"))));
        }
        if (config.containsKey("maximumMessageSize")) {
            $this$getConfigFromURL_u24lambda_u2d0.setMaximumMessageSize(Integer.parseInt(String.valueOf(config.get("maximumMessageSize"))));
        }
        Object dbConfig = object;
        return TuplesKt.to((Object)databaseType, (Object)dbConfig);
    }

    private final void init(JsonObject json) {
        String url = json.getString("jdbcUrl");
        if (url == null) {
            url = json.getString("url");
        }
        String string = url;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url");
        Pair<String, ConnectionPoolConfigurationBuilder> pair = this.getConfigFromURL(string);
        String dbType = (String)pair.component1();
        ConnectionPoolConfigurationBuilder config = (ConnectionPoolConfigurationBuilder)pair.component2();
        if (json.containsKey("maxActiveConnections")) {
            Integer n = json.getInteger("maxActiveConnections");
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"json.getInteger(\"maxActiveConnections\")");
            config.setMaxActiveConnections(((Number)n).intValue());
        } else if (json.containsKey("max_pool_size")) {
            Integer n = json.getInteger("max_pool_size");
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"json.getInteger(\"max_pool_size\")");
            config.setMaxActiveConnections(((Number)n).intValue());
        } else {
            config.setMaxActiveConnections(15);
        }
        if (json.containsKey("maxIdleTime")) {
            Long l = json.getLong("maxIdleTime");
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"json.getLong(\"maxIdleTime\")");
            config.setMaxIdleTime(((Number)l).longValue());
        } else if (json.containsKey("max_idle_time")) {
            Long l = json.getLong("max_idle_time");
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"json.getLong(\"max_idle_time\")");
            config.setMaxIdleTime(((Number)l).longValue());
        }
        if (json.containsKey("maxPendingQueries")) {
            Integer n = json.getInteger("maxPendingQueries");
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"json.getInteger(\"maxPendingQueries\")");
            config.setMaxPendingQueries(((Number)n).intValue());
        } else if (json.containsKey("max_statements")) {
            Integer n = json.getInteger("max_statements");
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"json.getInteger(\"max_statements\")");
            config.setMaxPendingQueries(((Number)n).intValue());
        }
        if (json.containsKey("maxConnectionTtl")) {
            config.setMaxConnectionTtl(json.getLong("maxConnectionTtl"));
        }
        if (json.containsKey("connectionCreateTimeout")) {
            Long l = json.getLong("connectionCreateTimeout");
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"json.getLong(\"connectionCreateTimeout\")");
            config.setConnectionCreateTimeout(((Number)l).longValue());
        }
        if (json.containsKey("connectionTestTimeout")) {
            Long l = json.getLong("connectionTestTimeout");
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"json.getLong(\"connectionTestTimeout\")");
            config.setConnectionTestTimeout(((Number)l).longValue());
        }
        if (json.containsKey("maximumMessageSize")) {
            Integer n = json.getInteger("maximumMessageSize");
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"json.getInteger(\"maximumMessageSize\")");
            config.setMaximumMessageSize(((Number)n).intValue());
        }
        if (json.containsKey("queryTimeout")) {
            config.setQueryTimeout(json.getLong("queryTimeout"));
        }
        if (Intrinsics.areEqual((Object)dbType, (Object)"mysql")) {
            this.client = MySQLConnectionBuilder.createConnectionPool((ConnectionPoolConfigurationBuilder)config);
        } else {
            String string2 = url;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"url");
            this.client = PostgreSQLConnectionBuilder.createConnectionPool$default((String)string2, null, (int)2, null);
        }
    }

    private final void init(String database, Configuration config, ConnectionPoolConfiguration poolConfig) {
        this.client = Intrinsics.areEqual((Object)database, (Object)"mysql") ? new ConnectionPool((ObjectFactory)new MySQLConnectionFactory(config), poolConfig) : new ConnectionPool((ObjectFactory)new PostgreSQLConnectionFactory(config), poolConfig);
    }

    private final void init(String database, ConnectionPoolConfigurationBuilder config) {
        this.client = Intrinsics.areEqual((Object)database, (Object)"mysql") ? MySQLConnectionBuilder.createConnectionPool((ConnectionPoolConfigurationBuilder)config) : PostgreSQLConnectionBuilder.createConnectionPool((ConnectionPoolConfigurationBuilder)config);
    }

    @Override
    @Nullable
    public Object createConnection(@NotNull Continuation<? super DBConn> $completion) {
        ConnectionPool<?> connectionPool = this.client;
        if (connectionPool == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            connectionPool = null;
        }
        return new JasyncDBConn(connectionPool);
    }

    @Override
    public int getInsertStatementMode() {
        return this.insertStatementMode;
    }

    @Override
    public void setInsertStatementMode(int mode) {
        this.insertStatementMode = mode;
    }
}

