/*
 * Decompiled with CFR 0.152.
 */
package io.zeko.db.sql;

import io.zeko.db.sql.DataManipulation;
import io.zeko.db.sql.Query;
import io.zeko.db.sql.utilities.DeclarationsKt;
import io.zeko.model.Entity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0013J\b\u0010\u001a\u001a\u00020\nH\u0016R\"\u0010\f\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lio/zeko/db/sql/Merge;", "Lio/zeko/db/sql/DataManipulation;", "entity", "Lio/zeko/model/Entity;", "parameterize", "", "espTableName", "(Lio/zeko/model/Entity;ZZ)V", "columns", "", "", "(Lio/zeko/model/Entity;[Ljava/lang/String;)V", "insertFields", "", "getInsertFields", "()Ljava/util/List;", "setInsertFields", "(Ljava/util/List;)V", "select", "Lio/zeko/db/sql/Query;", "getSelect", "()Lio/zeko/db/sql/Query;", "setSelect", "(Lio/zeko/db/sql/Query;)V", "escapeTable", "query", "toSql", "zeko-sql-builder"})
public class Merge
extends DataManipulation {
    @Nullable
    private Query select;
    @Nullable
    private List<String> insertFields;

    @Nullable
    protected final Query getSelect() {
        return this.select;
    }

    protected final void setSelect(@Nullable Query query2) {
        this.select = query2;
    }

    @Nullable
    protected final List<String> getInsertFields() {
        return this.insertFields;
    }

    protected final void setInsertFields(@Nullable List<String> list) {
        this.insertFields = list;
    }

    public Merge(@NotNull Entity entity, boolean parameterize, boolean espTableName) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.setEntity(entity);
        this.setParameterize(parameterize);
        this.setEspTableName(espTableName);
    }

    public /* synthetic */ Merge(Entity entity, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        this(entity, bl, bl2);
    }

    public Merge(@NotNull Entity entity, String ... columns) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)columns, (String)"columns");
        this.setEntity(entity);
        this.insertFields = CollectionsKt.arrayListOf((Object[])Arrays.copyOf(columns, columns.length));
    }

    @Override
    @NotNull
    public Merge escapeTable(boolean espTableName) {
        super.escapeTable(espTableName);
        return this;
    }

    @NotNull
    public final Merge select(@NotNull Query query2) {
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        this.select = query2;
        return this;
    }

    @Override
    @NotNull
    public String toSql() {
        String sql = "MERGE INTO " + this.getTableName();
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        if (!this.getEntity().dataMap().isEmpty()) {
            Set<Map.Entry<String, Object>> entries = this.getEntity().dataMap().entrySet();
            List<String> ignores = this.getEntity().ignoreFields();
            for (Map.Entry<String, Object> entry : entries) {
                String propName = entry.getKey();
                Object value = entry.getValue();
                if (!((Collection)ignores).isEmpty() && ignores.indexOf(propName) > -1) continue;
                String prop = DeclarationsKt.toSnakeCase(propName);
                if (this.shouldIgnoreType(value)) continue;
                columns.add(prop);
                if (this.getParameterize()) {
                    values.add("?");
                    continue;
                }
                if (value instanceof String) {
                    values.add("'" + StringsKt.replace$default((String)((String)value), (String)"'", (String)"''", (boolean)false, (int)4, null) + "'");
                    continue;
                }
                values.add(String.valueOf(value));
            }
            sql = sql + " ( " + CollectionsKt.joinToString$default((Iterable)columns, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + " ) ";
            sql = sql + "VALUES ( " + CollectionsKt.joinToString$default((Iterable)values, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + " ) ";
        } else if (this.insertFields != null) {
            List<String> list = this.insertFields;
            sql = sql + " ( " + (list != null ? CollectionsKt.joinToString$default((Iterable)list, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) : null) + " ) ";
        } else {
            sql = sql + " ";
        }
        if (this.select != null) {
            Query query2 = this.select;
            sql = sql + (query2 != null ? Query.toSql$default(query2, false, 1, null) : null);
        }
        return ((Object)StringsKt.trimEnd((CharSequence)sql)).toString();
    }
}

