/*
 * Decompiled with CFR 0.152.
 */
package io.zeko.db.sql.connections;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.zeko.db.sql.connections.DBConn;
import io.zeko.db.sql.connections.DBPool;
import io.zeko.db.sql.connections.HikariDBConn;
import java.sql.Connection;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\u000e\u001a\u00020\u000fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\rH\u0016J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\u0005H\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\rH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2={"Lio/zeko/db/sql/connections/HikariDBPool;", "Lio/zeko/db/sql/connections/DBPool;", "vertx", "Lio/vertx/core/Vertx;", "json", "Lio/vertx/core/json/JsonObject;", "(Lio/vertx/core/Vertx;Lio/vertx/core/json/JsonObject;)V", "config", "Lcom/zaxxer/hikari/HikariConfig;", "(Lio/vertx/core/Vertx;Lcom/zaxxer/hikari/HikariConfig;)V", "ds", "Lcom/zaxxer/hikari/HikariDataSource;", "insertStatementMode", "", "createConnection", "Lio/zeko/db/sql/connections/DBConn;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getInsertStatementMode", "init", "", "setInsertStatementMode", "mode", "zeko-sql-builder"})
public final class HikariDBPool
implements DBPool {
    private HikariDataSource ds;
    private Vertx vertx;
    private int insertStatementMode;

    private final void init(JsonObject config) {
        int n;
        int n2;
        HikariConfig hkConfig = new HikariConfig();
        if (config.containsKey("driverClassName")) {
            hkConfig.setDriverClassName(config.getString("driverClassName"));
        }
        if (config.containsKey("url")) {
            hkConfig.setJdbcUrl(config.getString("url"));
        } else {
            hkConfig.setJdbcUrl(config.getString("jdbcUrl"));
        }
        if (config.containsKey("username")) {
            hkConfig.setUsername(config.getString("username"));
        }
        if (config.containsKey("password")) {
            hkConfig.setPassword(config.getString("password"));
        }
        if (config.containsKey("max_pool_size")) {
            Integer n3 = config.getInteger("max_pool_size");
            Intrinsics.checkExpressionValueIsNotNull((Object)n3, (String)"config.getInteger(\"max_pool_size\")");
            n2 = n3;
        } else {
            n2 = 15;
        }
        hkConfig.setMaximumPoolSize(n2);
        if (config.containsKey("initial_pool_size")) {
            Integer n4 = config.getInteger("initial_pool_size");
            Intrinsics.checkExpressionValueIsNotNull((Object)n4, (String)"config.getInteger(\"initial_pool_size\")");
            n = n4;
        } else {
            n = 3;
        }
        hkConfig.setMinimumIdle(n);
        if (config.containsKey("max_idle_time")) {
            Long l = config.getLong("max_idle_time");
            Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"config.getLong(\"max_idle_time\")");
            hkConfig.setMaxLifetime(l.longValue());
        }
        if (config.containsKey("aliveBypassWindowMs")) {
            Long l = config.getLong("aliveBypassWindowMs");
            Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"config.getLong(\"aliveBypassWindowMs\")");
            hkConfig.setConnectionTimeout(l.longValue());
        }
        this.ds = new HikariDataSource(hkConfig);
    }

    public final void init(@NotNull HikariConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.ds = new HikariDataSource(config);
    }

    @Override
    @Nullable
    public Object createConnection(@NotNull Continuation<? super DBConn> $completion) {
        HikariDataSource hikariDataSource = this.ds;
        if (hikariDataSource == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ds");
        }
        Connection connection = hikariDataSource.getConnection();
        Intrinsics.checkExpressionValueIsNotNull((Object)connection, (String)"ds.connection");
        return new HikariDBConn(connection);
    }

    @Override
    public int getInsertStatementMode() {
        return this.insertStatementMode;
    }

    @Override
    public void setInsertStatementMode(int mode) {
        this.insertStatementMode = mode;
    }

    public HikariDBPool(@NotNull Vertx vertx, @NotNull JsonObject json) {
        Intrinsics.checkParameterIsNotNull((Object)vertx, (String)"vertx");
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        this.insertStatementMode = -1;
        this.vertx = vertx;
        this.init(json);
    }

    public HikariDBPool(@NotNull Vertx vertx, @NotNull HikariConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)vertx, (String)"vertx");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.insertStatementMode = -1;
        this.vertx = vertx;
        this.init(config);
    }
}

