/*
 * Decompiled with CFR 0.152.
 */
package io.zeko.restapi.core.security;

import io.vertx.core.AsyncResult;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.JWTOptions;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.jwt.JWTAuth;
import io.vertx.ext.auth.jwt.JWTAuthOptions;
import io.vertx.kotlin.core.json.Json;
import io.vertx.kotlin.core.json.JsonKt;
import io.zeko.db.sql.utilities.DeclarationsKt;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 %2\u00020\u0001:\u0001%B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J.\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\t2\b\b\u0002\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u0018J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0015H\u0004JP\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u00152\b\b\u0002\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u00182\b\b\u0002\u0010\u001f\u001a\u00020\u00062\u001a\u0010 \u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\"\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001d0!J,\u0010#\u001a\u00020\u001d2\b\u0010$\u001a\u0004\u0018\u00010\u00152\u001a\u0010 \u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\"\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001d0!R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006&"}, d2={"Lio/zeko/restapi/core/security/JWTAuthHelper;", "", "jwtAuth", "Lio/vertx/ext/auth/jwt/JWTAuth;", "jwtAuthRefresh", "useCamelCase", "", "(Lio/vertx/ext/auth/jwt/JWTAuth;Lio/vertx/ext/auth/jwt/JWTAuth;Z)V", "expireMsg", "Lio/vertx/core/json/JsonObject;", "getExpireMsg", "()Lio/vertx/core/json/JsonObject;", "invalidMsg", "getInvalidMsg", "getJwtAuth", "()Lio/vertx/ext/auth/jwt/JWTAuth;", "getJwtAuthRefresh", "getUseCamelCase", "()Z", "generateAuthTokens", "", "", "jwtAuthData", "tokenExpireSeconds", "", "refreshExpireSeconds", "getJsonKey", "key", "refreshToken", "", "accessToken", "refreshAfterExpired", "authHandler", "Lkotlin/Function2;", "Lio/vertx/ext/auth/User;", "validateToken", "authHeader", "Companion", "zeko-restapi"})
public class JWTAuthHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JWTAuth jwtAuth;
    @Nullable
    private final JWTAuth jwtAuthRefresh;
    private final boolean useCamelCase;
    @NotNull
    private final JsonObject expireMsg;
    @NotNull
    private final JsonObject invalidMsg;

    /*
     * WARNING - void declaration
     */
    public JWTAuthHelper(@NotNull JWTAuth jwtAuth, @Nullable JWTAuth jwtAuthRefresh, boolean useCamelCase) {
        void $this$_init__u24lambda_u241;
        Json $this$_init__u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)jwtAuth, (String)"jwtAuth");
        this.jwtAuth = jwtAuth;
        this.jwtAuthRefresh = jwtAuthRefresh;
        this.useCamelCase = useCamelCase;
        boolean $i$f$json = false;
        Json json = Json.INSTANCE;
        JWTAuthHelper jWTAuthHelper = this;
        boolean bl = false;
        Pair[] pairArray = new Pair[2];
        pairArray[0] = TuplesKt.to((Object)"auth", (Object)false);
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)this.getJsonKey("token_status"), (Object)"expired")};
        pairArray[1] = TuplesKt.to((Object)"error", (Object)JsonKt.obj((Json)$this$_init__u24lambda_u240, (Pair[])pairArray2));
        jWTAuthHelper.expireMsg = JsonKt.obj((Json)$this$_init__u24lambda_u240, (Pair[])pairArray);
        $i$f$json = false;
        $this$_init__u24lambda_u240 = Json.INSTANCE;
        jWTAuthHelper = this;
        boolean bl2 = false;
        pairArray = new Pair[2];
        pairArray[0] = TuplesKt.to((Object)"auth", (Object)false);
        pairArray2 = new Pair[]{TuplesKt.to((Object)this.getJsonKey("token_status"), (Object)"invalid")};
        pairArray[1] = TuplesKt.to((Object)"error", (Object)JsonKt.obj((Json)$this$_init__u24lambda_u241, (Pair[])pairArray2));
        jWTAuthHelper.invalidMsg = JsonKt.obj((Json)$this$_init__u24lambda_u241, (Pair[])pairArray);
    }

    public /* synthetic */ JWTAuthHelper(JWTAuth jWTAuth, JWTAuth jWTAuth2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(jWTAuth, jWTAuth2, bl);
    }

    @NotNull
    public final JWTAuth getJwtAuth() {
        return this.jwtAuth;
    }

    @Nullable
    public final JWTAuth getJwtAuthRefresh() {
        return this.jwtAuthRefresh;
    }

    public final boolean getUseCamelCase() {
        return this.useCamelCase;
    }

    @NotNull
    public final JsonObject getExpireMsg() {
        return this.expireMsg;
    }

    @NotNull
    public final JsonObject getInvalidMsg() {
        return this.invalidMsg;
    }

    /*
     * WARNING - void declaration
     */
    public final void refreshToken(@NotNull String refreshToken, @NotNull String accessToken, int tokenExpireSeconds, int refreshExpireSeconds, boolean refreshAfterExpired, @NotNull Function2<? super User, ? super JsonObject, Unit> authHandler) {
        void $this$refreshToken_u24lambda_u242;
        Intrinsics.checkNotNullParameter((Object)refreshToken, (String)"refreshToken");
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        Intrinsics.checkNotNullParameter(authHandler, (String)"authHandler");
        boolean $i$f$json = false;
        Json json = Json.INSTANCE;
        JWTAuth jWTAuth = this.jwtAuth;
        boolean bl = false;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"jwt", (Object)accessToken), TuplesKt.to((Object)"token", (Object)accessToken)};
        jWTAuth.authenticate(JsonKt.obj((Json)$this$refreshToken_u24lambda_u242, (Pair[])pairArray), arg_0 -> JWTAuthHelper.refreshToken$lambda$5(authHandler, this, refreshAfterExpired, refreshToken, accessToken, tokenExpireSeconds, refreshExpireSeconds, arg_0));
    }

    public static /* synthetic */ void refreshToken$default(JWTAuthHelper jWTAuthHelper, String string, String string2, int n, int n2, boolean bl, Function2 function2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: refreshToken");
        }
        if ((n3 & 4) != 0) {
            n = 259200;
        }
        if ((n3 & 8) != 0) {
            n2 = 604800;
        }
        if ((n3 & 0x10) != 0) {
            bl = false;
        }
        jWTAuthHelper.refreshToken(string, string2, n, n2, bl, (Function2<? super User, ? super JsonObject, Unit>)function2);
    }

    public final void validateToken(@Nullable String authHeader, @NotNull Function2<? super User, ? super JsonObject, Unit> authHandler) {
        Intrinsics.checkNotNullParameter(authHandler, (String)"authHandler");
        CharSequence charSequence = authHeader;
        if (charSequence == null || charSequence.length() == 0) {
            authHandler.invoke(null, (Object)this.invalidMsg);
            return;
        }
        String accessToken = null;
        accessToken = StringsKt.removePrefix((String)authHeader, (CharSequence)"Bearer ");
        boolean $i$f$json = false;
        Json $this$validateToken_u24lambda_u246 = Json.INSTANCE;
        boolean bl = false;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"jwt", (Object)accessToken), TuplesKt.to((Object)"token", (Object)accessToken)};
        JsonObject tokenData = JsonKt.obj((Json)$this$validateToken_u24lambda_u246, (Pair[])pairArray);
        this.jwtAuth.authenticate(tokenData, arg_0 -> JWTAuthHelper.validateToken$lambda$7(authHandler, this, arg_0));
    }

    @NotNull
    public final Map<String, String> generateAuthTokens(@NotNull JsonObject jwtAuthData, int tokenExpireSeconds, int refreshExpireSeconds) {
        Intrinsics.checkNotNullParameter((Object)jwtAuthData, (String)"jwtAuthData");
        String token = this.jwtAuth.generateToken(jwtAuthData, new JWTOptions().setExpiresInSeconds(tokenExpireSeconds));
        JsonObject refreshData = jwtAuthData.copy().put(this.getJsonKey("for_token"), (Object)token);
        JWTAuth jWTAuth = this.jwtAuthRefresh;
        String refreshToken = jWTAuth != null ? jWTAuth.generateToken(refreshData, new JWTOptions().setExpiresInSeconds(refreshExpireSeconds)) : null;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)this.getJsonKey("access_token"), (Object)token), TuplesKt.to((Object)this.getJsonKey("refresh_token"), (Object)refreshToken)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    public static /* synthetic */ Map generateAuthTokens$default(JWTAuthHelper jWTAuthHelper, JsonObject jsonObject, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: generateAuthTokens");
        }
        if ((n3 & 2) != 0) {
            n = 259200;
        }
        if ((n3 & 4) != 0) {
            n2 = 604800;
        }
        return jWTAuthHelper.generateAuthTokens(jsonObject, n, n2);
    }

    @NotNull
    protected final String getJsonKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (this.useCamelCase) {
            return DeclarationsKt.toCamelCase((String)key);
        }
        return key;
    }

    private static final void refreshToken$lambda$5$lambda$4(Function2 $authHandler, JWTAuthHelper this$0, String $accessToken, int $tokenExpireSeconds, int $refreshExpireSeconds, AsyncResult it) {
        Intrinsics.checkNotNullParameter((Object)$authHandler, (String)"$authHandler");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$accessToken, (String)"$accessToken");
        if (it.failed()) {
            String msg = it.cause().getMessage();
            String string = msg.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            if (StringsKt.indexOf$default((CharSequence)string, (String)"expired", (int)0, (boolean)false, (int)6, null) > -1) {
                $authHandler.invoke(null, (Object)this$0.expireMsg);
            } else {
                $authHandler.invoke(null, (Object)this$0.invalidMsg);
            }
        } else {
            Object object = it.result();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type io.vertx.ext.auth.User");
            User authUser = (User)object;
            Map user = authUser.principal().getMap();
            if (((CharSequence)$accessToken).length() == 0) {
                $authHandler.invoke(null, (Object)this$0.invalidMsg);
            } else if (user.containsKey(this$0.getJsonKey("for_token")) && Intrinsics.areEqual(user.get(this$0.getJsonKey("for_token")), (Object)$accessToken)) {
                user.remove(this$0.getJsonKey("for_token"));
                $authHandler.invoke((Object)authUser, (Object)new JsonObject(this$0.generateAuthTokens(new JsonObject(user), $tokenExpireSeconds, $refreshExpireSeconds)));
            } else {
                $authHandler.invoke(null, (Object)this$0.invalidMsg);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void refreshToken$lambda$5(Function2 $authHandler, JWTAuthHelper this$0, boolean $refreshAfterExpired, String $refreshToken, String $accessToken, int $tokenExpireSeconds, int $refreshExpireSeconds, AsyncResult it) {
        block3: {
            void $this$refreshToken_u24lambda_u245_u24lambda_u243;
            Intrinsics.checkNotNullParameter((Object)$authHandler, (String)"$authHandler");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$refreshToken, (String)"$refreshToken");
            Intrinsics.checkNotNullParameter((Object)$accessToken, (String)"$accessToken");
            boolean expired = false;
            if (it.failed()) {
                String msg = it.cause().getMessage();
                boolean bl = expired = StringsKt.indexOf$default((CharSequence)msg, (String)"Expired", (int)0, (boolean)false, (int)6, null) > -1;
                if (!expired) {
                    $authHandler.invoke(null, (Object)this$0.invalidMsg);
                    return;
                }
            }
            if ($refreshAfterExpired && !expired) {
                $authHandler.invoke(null, (Object)this$0.invalidMsg);
                return;
            }
            JWTAuth jWTAuth = this$0.jwtAuthRefresh;
            if (jWTAuth == null) break block3;
            boolean $i$f$json = false;
            Json json = Json.INSTANCE;
            JWTAuth jWTAuth2 = jWTAuth;
            boolean bl = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"jwt", (Object)$refreshToken), TuplesKt.to((Object)"token", (Object)$refreshToken)};
            jWTAuth2.authenticate(JsonKt.obj((Json)$this$refreshToken_u24lambda_u245_u24lambda_u243, (Pair[])pairArray), arg_0 -> JWTAuthHelper.refreshToken$lambda$5$lambda$4($authHandler, this$0, $accessToken, $tokenExpireSeconds, $refreshExpireSeconds, arg_0));
        }
    }

    private static final void validateToken$lambda$7(Function2 $authHandler, JWTAuthHelper this$0, AsyncResult it) {
        Intrinsics.checkNotNullParameter((Object)$authHandler, (String)"$authHandler");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (it.failed()) {
            String msg = it.cause().getMessage();
            if (StringsKt.indexOf$default((CharSequence)msg, (String)"Expired", (int)0, (boolean)false, (int)6, null) > -1) {
                $authHandler.invoke(null, (Object)this$0.expireMsg);
            } else {
                $authHandler.invoke(null, (Object)this$0.invalidMsg);
            }
        } else {
            Object object = it.result();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type io.vertx.ext.auth.User");
            User user = (User)object;
            JsonObject jsonObject = user.principal();
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"user.principal()");
            $authHandler.invoke((Object)user, (Object)jsonObject);
        }
    }

    @JvmStatic
    public static final JWTAuth createJWTAuth(@NotNull Vertx vertx, @NotNull JWTAuthOptions jwtOptions) {
        return Companion.createJWTAuth(vertx, jwtOptions);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lio/zeko/restapi/core/security/JWTAuthHelper$Companion;", "", "()V", "createJWTAuth", "Lio/vertx/ext/auth/jwt/JWTAuth;", "kotlin.jvm.PlatformType", "vertx", "Lio/vertx/core/Vertx;", "jwtOptions", "Lio/vertx/ext/auth/jwt/JWTAuthOptions;", "zeko-restapi"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final JWTAuth createJWTAuth(@NotNull Vertx vertx, @NotNull JWTAuthOptions jwtOptions) {
            Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
            Intrinsics.checkNotNullParameter((Object)jwtOptions, (String)"jwtOptions");
            return JWTAuth.create((Vertx)vertx, (JWTAuthOptions)jwtOptions);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

