/*
 * Decompiled with CFR 0.152.
 */
package io.zeko.restapi.core.cron;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import io.vertx.core.Vertx;
import io.zeko.restapi.core.cron.CronRunner;
import io.zeko.restapi.core.utilities.TimerKt;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\"\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u0017J\u001c\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u0017J=\u0010\u001c\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u001c\u0010\u0019\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001dH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ7\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u001c\u0010\u0019\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001dH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010!\u001a\u00020\u001bR\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\""}, d2={"Lio/zeko/restapi/core/cron/CronRunner;", "", "vertx", "Lio/vertx/core/Vertx;", "logger", "Lorg/slf4j/Logger;", "(Lio/vertx/core/Vertx;Lorg/slf4j/Logger;)V", "cronParser", "Lcom/cronutils/parser/CronParser;", "getCronParser", "()Lcom/cronutils/parser/CronParser;", "setCronParser", "(Lcom/cronutils/parser/CronParser;)V", "getLogger", "()Lorg/slf4j/Logger;", "getVertx", "()Lio/vertx/core/Vertx;", "init", "cronType", "Lcom/cronutils/model/CronType;", "run", "", "scheduleBlock", "Lkotlin/Function0;", "", "block", "schedule", "", "runSuspend", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "expression", "zeko-restapi"})
public class CronRunner {
    @NotNull
    private final Vertx vertx;
    @NotNull
    private final Logger logger;
    @Nullable
    private CronParser cronParser;

    public CronRunner(@NotNull Vertx vertx, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.vertx = vertx;
        this.logger = logger;
    }

    @NotNull
    public final Vertx getVertx() {
        return this.vertx;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @Nullable
    public final CronParser getCronParser() {
        return this.cronParser;
    }

    public final void setCronParser(@Nullable CronParser cronParser) {
        this.cronParser = cronParser;
    }

    @NotNull
    public final CronRunner init(@NotNull CronType cronType) {
        Intrinsics.checkNotNullParameter((Object)cronType, (String)"cronType");
        CronDefinition cronDef = CronDefinitionBuilder.instanceDefinitionFor((CronType)cronType);
        this.cronParser = new CronParser(cronDef);
        return this;
    }

    public static /* synthetic */ CronRunner init$default(CronRunner cronRunner, CronType cronType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: init");
        }
        if ((n & 1) != 0) {
            cronType = CronType.UNIX;
        }
        return cronRunner.init(cronType);
    }

    @NotNull
    public final Function0<Long> schedule(@NotNull String expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return (Function0)new Function0<Long>(this, expression){
            final /* synthetic */ CronRunner this$0;
            final /* synthetic */ String $expression;
            {
                this.this$0 = $receiver;
                this.$expression = $expression;
                super(0);
            }

            @NotNull
            public final Long invoke() {
                Duration duration;
                ZonedDateTime now = ZonedDateTime.now();
                CronParser cronParser = this.this$0.getCronParser();
                ExecutionTime executionTime = ExecutionTime.forCron((Cron)(cronParser != null ? cronParser.parse(this.$expression) : null));
                Optional timeToNextExec = executionTime.timeToNextExecution(now);
                Ref.ObjectRef duration2 = new Ref.ObjectRef();
                timeToNextExec.map(arg_0 -> schedule.1.invoke$lambda$0((Function1)new Function1<Duration, Unit>((Ref.ObjectRef<Duration>)duration2){
                    final /* synthetic */ Ref.ObjectRef<Duration> $duration;
                    {
                        this.$duration = $duration;
                        super(1);
                    }

                    public final void invoke(Duration it) {
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        this.$duration.element = it;
                    }
                }, arg_0));
                if (duration2.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"duration");
                    duration = null;
                } else {
                    duration = (Duration)duration2.element;
                }
                return duration.toMillis();
            }

            private static final Unit invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Unit)$tmp0.invoke(p0);
            }
        };
    }

    public final void run(@NotNull String schedule2, @NotNull Function0<? extends Object> block) {
        Intrinsics.checkNotNullParameter((Object)schedule2, (String)"schedule");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        TimerKt.runCron(this.vertx, this.schedule(schedule2), block);
    }

    @Nullable
    public final Object runSuspend(@NotNull String schedule2, @NotNull Function1<? super Continuation<Object>, ? extends Object> block, @NotNull Continuation<? super Unit> $completion) {
        Object object = TimerKt.runCronSuspend(this.vertx, this.schedule(schedule2), block, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final void run(@NotNull Function0<Long> scheduleBlock, @NotNull Function0<? extends Object> block) {
        Intrinsics.checkNotNullParameter(scheduleBlock, (String)"scheduleBlock");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        TimerKt.runCron(this.vertx, scheduleBlock, block);
    }

    @Nullable
    public final Object runSuspend(@NotNull Function0<Long> scheduleBlock, @NotNull Function1<? super Continuation<Object>, ? extends Object> block, @NotNull Continuation<? super Unit> $completion) {
        Object object = TimerKt.runCronSuspend(this.vertx, scheduleBlock, block, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }
}

