/*
 * Decompiled with CFR 0.152.
 */
package io.zeko.restapi.core.utilities.zip;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.streams.Pump;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.ext.web.RoutingContext;
import io.zeko.restapi.core.utilities.zip.FileEntry;
import io.zeko.restapi.core.utilities.zip.FileEntryIterator;
import io.zeko.restapi.core.utilities.zip.GeneratedFileEntry;
import io.zeko.restapi.core.utilities.zip.TempFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 82\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00018B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001aH\u0002J\u0018\u0010\u001c\u001a\u00020\u001a2\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0002J\"\u0010\u001c\u001a\u00020\u001a2\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\b\u0010\u001e\u001a\u0004\u0018\u00010\fH\u0002J\b\u0010\u001f\u001a\u00020\u001aH\u0002J\b\u0010 \u001a\u00020\u001aH\u0002J\b\u0010!\u001a\u00020\u001aH\u0002J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0016J\u001e\u0010#\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u000bH\u0016J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u0011H\u0002J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0016J\b\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020-H\u0002J\u0016\u0010.\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u0001000/0\u000bH\u0002J&\u00101\u001a\u00020\u001a2\u0006\u00102\u001a\u0002032\u0014\u0010\u001d\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\f0/0\u000bH\u0002J\u0010\u00104\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0001H\u0016J&\u00105\u001a\u00020\u001a2\u0006\u00102\u001a\u0002032\u0014\u0010\u001d\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\f0/0\u000bH\u0002J&\u00106\u001a\u00020\u001a2\u0006\u00102\u001a\u0002032\u0014\u0010\u001d\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\f0/0\u000bH\u0002J\u0010\u00107\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0001H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lio/zeko/restapi/core/utilities/zip/ZipGenerator;", "Lio/vertx/core/streams/ReadStream;", "Lio/vertx/core/buffer/Buffer;", "vertx", "Lio/vertx/core/Vertx;", "source", "Lio/zeko/restapi/core/utilities/zip/FileEntryIterator;", "(Lio/vertx/core/Vertx;Lio/zeko/restapi/core/utilities/zip/FileEntryIterator;)V", "CHUNK_SIZE", "", "closeHandler", "Lio/vertx/core/Handler;", "Ljava/lang/Void;", "context", "Lio/vertx/core/Context;", "dataHandler", "failureHandler", "", "fileEntryIS", "Ljava/io/InputStream;", "pis", "Ljava/io/PipedInputStream;", "state", "zos", "Ljava/util/zip/ZipOutputStream;", "acquireContext", "", "doCloseAndStop", "doCloseGenerator", "handler", "e", "doFlushPipe", "doRead", "doReadFile", "endHandler", "exceptionHandler", "fetch", "amount", "", "handleError", "cause", "hasNextFile", "", "next", "f", "Ljava/lang/Runnable;", "noop", "Lio/vertx/core/AsyncResult;", "", "openStreamForEntry", "entry", "Lio/zeko/restapi/core/utilities/zip/FileEntry;", "pause", "readFile", "readStreamForEntry", "resume", "Companion", "zeko-restapi"})
public final class ZipGenerator
implements ReadStream<Buffer> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vertx vertx;
    private volatile int state;
    @Nullable
    private Context context;
    @NotNull
    private final ZipOutputStream zos;
    @NotNull
    private final PipedInputStream pis;
    @Nullable
    private InputStream fileEntryIS;
    @Nullable
    private Handler<Throwable> failureHandler;
    @Nullable
    private Handler<Buffer> dataHandler;
    @Nullable
    private Handler<Void> closeHandler;
    @NotNull
    private final FileEntryIterator source;
    private final int CHUNK_SIZE;
    private static final Logger LOG = LoggerFactory.getLogger(ZipGenerator.class);
    public static final int STATUS_PAUSED = 0;
    public static final int STATUS_ACTIVE = 1;
    public static final int STATUS_CLOSED = 2;

    public ZipGenerator(@NotNull Vertx vertx, @NotNull FileEntryIterator source) {
        Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.vertx = vertx;
        this.state = 1;
        this.CHUNK_SIZE = 8092;
        this.source = source;
        PipedOutputStream out = new PipedOutputStream();
        this.zos = new ZipOutputStream(out);
        this.pis = new PipedInputStream(out, this.CHUNK_SIZE);
    }

    private final void doRead() {
        this.acquireContext();
        if (this.state == 1) {
            this.vertx.executeBlocking(arg_0 -> ZipGenerator.doRead$lambda-2(this, arg_0), this.noop());
        }
    }

    private final void doReadFile() {
        if (this.hasNextFile()) {
            Object e = this.source.next();
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type io.zeko.restapi.core.utilities.zip.FileEntry");
            }
            this.readFile((FileEntry)e, (Handler<AsyncResult<Void>>)((Handler)arg_0 -> ZipGenerator.doReadFile$lambda-4(this, arg_0)));
        } else {
            this.next(() -> ZipGenerator.doReadFile$lambda-5(this));
        }
    }

    private final void doCloseAndStop() {
        this.vertx.executeBlocking(arg_0 -> ZipGenerator.doCloseAndStop$lambda-6(this, arg_0), arg_0 -> ZipGenerator.doCloseAndStop$lambda-7(this, arg_0));
    }

    private final void readFile(FileEntry entry, Handler<AsyncResult<Void>> handler) {
        this.vertx.executeBlocking(arg_0 -> ZipGenerator.readFile$lambda-8(this, entry, handler, arg_0), this.noop());
    }

    private final void readStreamForEntry(FileEntry entry, Handler<AsyncResult<Void>> handler) throws IOException {
        int bytesRead = 0;
        int c = 0;
        Buffer buf = Buffer.buffer();
        while (true) {
            int n;
            InputStream inputStream = this.fileEntryIS;
            Intrinsics.checkNotNull((Object)inputStream);
            int it = n = inputStream.read();
            boolean bl = false;
            c = it;
            if (n == -1 || bytesRead >= this.CHUNK_SIZE) break;
            buf.appendByte((byte)c);
            ++bytesRead;
        }
        this.zos.write(buf.getBytes(0, bytesRead));
        if (bytesRead == this.CHUNK_SIZE) {
            this.vertx.runOnContext(arg_0 -> ZipGenerator.readStreamForEntry$lambda-10(this, entry, handler, arg_0));
        } else {
            InputStream inputStream = this.fileEntryIS;
            Intrinsics.checkNotNull((Object)inputStream);
            inputStream.close();
            this.fileEntryIS = null;
            handler.handle((Object)Future.succeededFuture());
        }
    }

    private final void openStreamForEntry(FileEntry entry, Handler<AsyncResult<Void>> handler) throws IOException {
        ZipEntry e = new ZipEntry(entry.getPath());
        this.zos.putNextEntry(e);
        entry.open((Handler<AsyncResult<InputStream>>)((Handler)arg_0 -> ZipGenerator.openStreamForEntry$lambda-12(this, entry, handler, arg_0)));
    }

    private final boolean hasNextFile() {
        return this.source.hasNext();
    }

    private final void doFlushPipe() {
        this.acquireContext();
        try {
            if (this.state == 1) {
                if (this.pis.available() > 0) {
                    byte[] tmp = new byte[this.pis.available()];
                    int readBytes = this.pis.read(tmp);
                    if (readBytes > 0) {
                        byte[] buffer = new byte[readBytes];
                        System.arraycopy(tmp, 0, buffer, 0, readBytes);
                        Handler<Buffer> handler = this.dataHandler;
                        Intrinsics.checkNotNull(handler);
                        handler.handle((Object)Buffer.buffer((byte[])buffer));
                    }
                    this.next(() -> ZipGenerator.doFlushPipe$lambda-13(this));
                } else {
                    this.next(() -> ZipGenerator.doFlushPipe$lambda-14(this));
                }
            }
        }
        catch (IOException e) {
            this.handleError(e);
        }
    }

    private final void next(Runnable f) {
        Context context = this.context;
        Intrinsics.checkNotNull((Object)context);
        context.runOnContext(arg_0 -> ZipGenerator.next$lambda-15(f, arg_0));
    }

    private final void acquireContext() {
        if (this.context == null) {
            this.context = this.vertx.getOrCreateContext();
        }
    }

    private final void doCloseGenerator(Handler<Void> handler) {
        this.doCloseGenerator(handler, null);
    }

    private final void doCloseGenerator(Handler<Void> handler, Void e) {
        this.state = 2;
        Context context = this.context;
        Intrinsics.checkNotNull((Object)context);
        context.runOnContext(arg_0 -> ZipGenerator.doCloseGenerator$lambda-16(handler, e, arg_0));
    }

    private final void handleError(Throwable cause) {
        this.state = 2;
        if (this.failureHandler != null) {
            LOG.error(cause.toString());
            Handler<Throwable> handler = this.failureHandler;
            Intrinsics.checkNotNull(handler);
            handler.handle((Object)cause);
        } else {
            LOG.warn("No handler for error: " + cause);
        }
    }

    @NotNull
    public ReadStream<Buffer> handler(@NotNull Handler<Buffer> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.dataHandler = handler;
        this.doRead();
        return this;
    }

    @NotNull
    public ReadStream<Buffer> fetch(long amount) {
        return this;
    }

    @Nullable
    public ReadStream<Buffer> pause() {
        if (this.state == 1) {
            this.state = 0;
        }
        return this;
    }

    @Nullable
    public ReadStream<Buffer> resume() {
        switch (this.state) {
            case 2: {
                throw new IllegalStateException("Cannot resume, already closed");
            }
            case 0: {
                this.state = 1;
                this.doRead();
            }
        }
        return this;
    }

    @Nullable
    public ReadStream<Buffer> exceptionHandler(@NotNull Handler<Throwable> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.failureHandler = handler;
        return this;
    }

    private final Handler<AsyncResult<Object>> noop() {
        return ZipGenerator::noop$lambda-18;
    }

    @NotNull
    public ReadStream<Buffer> endHandler(@Nullable Handler<Void> endHandler) {
        this.closeHandler = endHandler;
        return this;
    }

    private static final void doRead$lambda-2$lambda-0(ZipGenerator this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.doFlushPipe();
    }

    private static final void doRead$lambda-2$lambda-1(ZipGenerator this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.doReadFile();
    }

    private static final void doRead$lambda-2(ZipGenerator this$0, Promise promise) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
        this$0.next(() -> ZipGenerator.doRead$lambda-2$lambda-0(this$0));
        this$0.next(() -> ZipGenerator.doRead$lambda-2$lambda-1(this$0));
        promise.complete();
    }

    private static final void doReadFile$lambda-4$lambda-3(ZipGenerator this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.doReadFile();
    }

    private static final void doReadFile$lambda-4(ZipGenerator this$0, AsyncResult ar) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)ar, (String)"ar");
        if (ar.succeeded()) {
            this$0.next(() -> ZipGenerator.doReadFile$lambda-4$lambda-3(this$0));
        } else {
            Throwable throwable = ar.cause();
            Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"ar.cause()");
            this$0.handleError(throwable);
        }
    }

    private static final void doReadFile$lambda-5(ZipGenerator this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.doCloseAndStop();
    }

    private static final void doCloseAndStop$lambda-6(ZipGenerator this$0, Promise v) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        try {
            this$0.doFlushPipe();
            this$0.zos.close();
            v.complete();
        }
        catch (IOException e) {
            v.fail((Throwable)e);
        }
    }

    private static final void doCloseAndStop$lambda-7(ZipGenerator this$0, AsyncResult v) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        if (v.succeeded()) {
            this$0.doCloseGenerator(this$0.closeHandler);
        } else {
            Throwable throwable = v.cause();
            Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"v.cause()");
            this$0.handleError(throwable);
        }
    }

    private static final void readFile$lambda-8(ZipGenerator this$0, FileEntry $entry, Handler $handler, Promise promise) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$entry, (String)"$entry");
        Intrinsics.checkNotNullParameter((Object)$handler, (String)"$handler");
        try {
            if (this$0.fileEntryIS == null) {
                this$0.openStreamForEntry($entry, (Handler<AsyncResult<Void>>)$handler);
            } else {
                this$0.readStreamForEntry($entry, (Handler<AsyncResult<Void>>)$handler);
            }
        }
        catch (IOException e) {
            $handler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    private static final void readStreamForEntry$lambda-10(ZipGenerator this$0, FileEntry $entry, Handler $handler, Void v) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$entry, (String)"$entry");
        Intrinsics.checkNotNullParameter((Object)$handler, (String)"$handler");
        this$0.readFile($entry, (Handler<AsyncResult<Void>>)$handler);
    }

    private static final void openStreamForEntry$lambda-12$lambda-11(ZipGenerator this$0, FileEntry $entry, Handler $handler, Void it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$entry, (String)"$entry");
        Intrinsics.checkNotNullParameter((Object)$handler, (String)"$handler");
        this$0.readFile($entry, (Handler<AsyncResult<Void>>)$handler);
    }

    private static final void openStreamForEntry$lambda-12(ZipGenerator this$0, FileEntry $entry, Handler $handler, AsyncResult ar) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$entry, (String)"$entry");
        Intrinsics.checkNotNullParameter((Object)$handler, (String)"$handler");
        if (ar.succeeded()) {
            this$0.fileEntryIS = (InputStream)ar.result();
            this$0.vertx.runOnContext(arg_0 -> ZipGenerator.openStreamForEntry$lambda-12$lambda-11(this$0, $entry, $handler, arg_0));
        } else {
            Throwable throwable = ar.cause();
            Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"ar.cause()");
            this$0.handleError(throwable);
        }
    }

    private static final void doFlushPipe$lambda-13(ZipGenerator this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.doFlushPipe();
    }

    private static final void doFlushPipe$lambda-14(ZipGenerator this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.doFlushPipe();
    }

    private static final void next$lambda-15(Runnable $f, Void v) {
        Intrinsics.checkNotNullParameter((Object)$f, (String)"$f");
        $f.run();
    }

    private static final void doCloseGenerator$lambda-16(Handler $handler, Void $e, Void event) {
        block0: {
            Handler handler = $handler;
            if (handler == null) break block0;
            handler.handle((Object)$e);
        }
    }

    private static final void noop$lambda-18(AsyncResult v) {
    }

    @JvmStatic
    public static final void downloadZip(@NotNull Vertx vertx, @NotNull RoutingContext context, @NotNull String zipName, @NotNull List<TempFile> files, @Nullable Handler<Boolean> handler) {
        Companion.downloadZip(vertx, context, zipName, files, handler);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0010\b\u0002\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016H\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/zeko/restapi/core/utilities/zip/ZipGenerator$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "STATUS_ACTIVE", "", "STATUS_CLOSED", "STATUS_PAUSED", "downloadZip", "", "vertx", "Lio/vertx/core/Vertx;", "context", "Lio/vertx/ext/web/RoutingContext;", "zipName", "", "files", "", "Lio/zeko/restapi/core/utilities/zip/TempFile;", "handler", "Lio/vertx/core/Handler;", "", "zeko-restapi"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void downloadZip(@NotNull Vertx vertx, @NotNull RoutingContext context, @NotNull String zipName, @NotNull List<TempFile> files, @Nullable Handler<Boolean> handler) {
            Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)zipName, (String)"zipName");
            Intrinsics.checkNotNullParameter(files, (String)"files");
            FileEntryIterator fileEntries2 = new FileEntryIterator(files){
                private int index;
                final /* synthetic */ List<TempFile> $files;
                {
                    this.$files = $files;
                }

                public void remove() {
                }

                public boolean hasNext() {
                    return this.index < this.$files.size();
                }

                @Nullable
                public FileEntry next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    int n = this.index;
                    this.index = n + 1;
                    return new GeneratedFileEntry(this.$files.get(this.index).getName(), this.$files.get(n).getContent());
                }
            };
            ZipGenerator zip = new ZipGenerator(vertx, fileEntries2);
            zip.endHandler((Handler<Void>)((Handler)arg_0 -> Companion.downloadZip$lambda-0(context, handler, arg_0))).exceptionHandler(arg_0 -> Companion.downloadZip$lambda-1(handler, arg_0));
            context.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/zip, application/octet-stream").putHeader(HttpHeaders.CONTENT_DISPOSITION, (CharSequence)("attachment; filename=\"" + zipName + ".zip\""));
            Pump.pump((ReadStream)zip, (WriteStream)((WriteStream)context.response().setChunked(true))).start();
        }

        public static /* synthetic */ void downloadZip$default(Companion companion, Vertx vertx, RoutingContext routingContext, String string, List list, Handler handler, int n, Object object) {
            if ((n & 0x10) != 0) {
                handler = null;
            }
            companion.downloadZip(vertx, routingContext, string, list, (Handler<Boolean>)handler);
        }

        private static final void downloadZip$lambda-0(RoutingContext $context, Handler $handler, Void it) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
                $context.response().end();
                Handler handler = $handler;
                if (handler == null) break block0;
                handler.handle((Object)true);
            }
        }

        private static final void downloadZip$lambda-1(Handler $handler, Throwable err) {
            Handler handler = $handler;
            if (handler != null) {
                handler.handle((Object)false);
            }
            Intrinsics.checkNotNullExpressionValue((Object)err, (String)"err");
            throw err;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

