/*
 * Decompiled with CFR 0.152.
 */
package io.zeko.restapi.core.security;

import java.math.BigInteger;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\nH\u0002J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lio/zeko/restapi/core/security/PasswordSecurity;", "", "()V", "salt", "", "getSalt", "()Ljava/lang/String;", "saltAsString", "getSaltAsString", "fromHex", "", "hex", "generatePasswordHash", "password", "iterations", "", "hmacSha1", "secretKey", "rurl", "toHex", "array", "validatePassword", "", "originalPassword", "storedPassword", "zeko-restapi"})
public final class PasswordSecurity {
    @Nullable
    public final String hmacSha1(@NotNull String secretKey, @NotNull String rurl) {
        Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
        Intrinsics.checkNotNullParameter((Object)rurl, (String)"rurl");
        try {
            Mac mac = Mac.getInstance("HmacSHA1");
            String string = secretKey;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            SecretKeySpec secret = new SecretKeySpec(byArray, "HmacSHA1");
            mac.init(secret);
            String string2 = rurl;
            byte[] byArray2 = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
            byte[] digest = mac.doFinal(byArray2);
            String signature = Base64.getEncoder().encodeToString(digest);
            return URLEncoder.encode(signature, "UTF-8");
        }
        catch (Exception exception) {
            return null;
        }
    }

    @NotNull
    public final String generatePasswordHash(@NotNull String password, int iterations) throws NoSuchAlgorithmException, InvalidKeySpecException {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        char[] cArray = password.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        char[] chars = cArray;
        String string = this.getSalt();
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] salt = byArray;
        PBEKeySpec spec = new PBEKeySpec(chars, salt, iterations, 512);
        SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        byte[] hash = skf.generateSecret(spec).getEncoded();
        String string2 = this.toHex(salt);
        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"hash");
        return iterations + ":" + string2 + ":" + this.toHex(hash);
    }

    public static /* synthetic */ String generatePasswordHash$default(PasswordSecurity passwordSecurity, String string, int n, int n2, Object object) throws NoSuchAlgorithmException, InvalidKeySpecException {
        if ((n2 & 2) != 0) {
            n = 3;
        }
        return passwordSecurity.generatePasswordHash(string, n);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean validatePassword(@NotNull String originalPassword, @NotNull String storedPassword) throws NoSuchAlgorithmException, InvalidKeySpecException {
        void $this$toTypedArray$iv;
        Intrinsics.checkNotNullParameter((Object)originalPassword, (String)"originalPassword");
        Intrinsics.checkNotNullParameter((Object)storedPassword, (String)"storedPassword");
        Object object = storedPassword;
        Regex regex = new Regex(":");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        String[] parts = stringArray;
        int iterations = Integer.parseInt(parts[0]);
        byte[] salt = this.fromHex(parts[1]);
        byte[] hash = this.fromHex(parts[2]);
        char[] cArray = originalPassword.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        PBEKeySpec spec = new PBEKeySpec(cArray, salt, iterations, 512);
        SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        byte[] testHash = skf.generateSecret(spec).getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)testHash, (String)"testHash");
        return Intrinsics.areEqual((Object)this.toHex(testHash), (Object)this.toHex(hash));
    }

    @NotNull
    public final String getSalt() throws NoSuchAlgorithmException {
        SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
        byte[] salt = new byte[16];
        sr.nextBytes(salt);
        return salt.toString();
    }

    @NotNull
    public final String getSaltAsString() throws NoSuchAlgorithmException {
        SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
        byte[] salt = new byte[16];
        sr.nextBytes(salt);
        String string = salt.toString();
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return this.toHex(byArray);
    }

    private final String toHex(byte[] array) throws NoSuchAlgorithmException {
        Object object;
        BigInteger bi = new BigInteger(1, array);
        String hex = bi.toString(16);
        int paddingLength = array.length * 2 - hex.length();
        if (paddingLength > 0) {
            String string = "%0" + paddingLength + "d";
            Object[] objectArray = new Object[]{0};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            object = string2 + hex;
        } else {
            String string = hex;
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n            hex\n        }");
        }
        return object;
    }

    private final byte[] fromHex(String hex) throws NoSuchAlgorithmException {
        byte[] bytes = new byte[hex.length() / 2];
        int n = bytes.length;
        for (int i = 0; i < n; ++i) {
            String string = hex.substring(2 * i, 2 * i + 2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            bytes[i] = (byte)Integer.parseInt(string, CharsKt.checkRadix((int)16));
        }
        return bytes;
    }
}

