/*
 * Decompiled with CFR 0.152.
 */
package io.zeko.restapi.core.security;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.jwt.JWTAuth;
import io.vertx.ext.web.RoutingContext;
import io.zeko.restapi.core.security.JWTAuthHelper;
import io.zeko.restapi.core.utilities.ControllerKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0005\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\b\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0014\u0010\u000b\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lio/zeko/restapi/core/security/JWTAuthRefreshHandler;", "Lio/vertx/core/Handler;", "Lio/vertx/ext/web/RoutingContext;", "jwtAuth", "Lio/vertx/ext/auth/jwt/JWTAuth;", "jwtAuthRefresh", "tokenExpireSeconds", "", "refreshExpireSeconds", "refreshAfterExpired", "", "useCamelCase", "(Lio/vertx/ext/auth/jwt/JWTAuth;Lio/vertx/ext/auth/jwt/JWTAuth;IIZZ)V", "getJwtAuth", "()Lio/vertx/ext/auth/jwt/JWTAuth;", "getJwtAuthRefresh", "getRefreshAfterExpired", "()Z", "getRefreshExpireSeconds", "()I", "getTokenExpireSeconds", "getUseCamelCase", "handle", "", "ctx", "zeko-restapi"})
public class JWTAuthRefreshHandler
implements Handler<RoutingContext> {
    @NotNull
    private final JWTAuth jwtAuth;
    @NotNull
    private final JWTAuth jwtAuthRefresh;
    private final int tokenExpireSeconds;
    private final int refreshExpireSeconds;
    private final boolean refreshAfterExpired;
    private final boolean useCamelCase;

    public JWTAuthRefreshHandler(@NotNull JWTAuth jwtAuth, @NotNull JWTAuth jwtAuthRefresh, int tokenExpireSeconds, int refreshExpireSeconds, boolean refreshAfterExpired, boolean useCamelCase) {
        Intrinsics.checkNotNullParameter((Object)jwtAuth, (String)"jwtAuth");
        Intrinsics.checkNotNullParameter((Object)jwtAuthRefresh, (String)"jwtAuthRefresh");
        this.jwtAuth = jwtAuth;
        this.jwtAuthRefresh = jwtAuthRefresh;
        this.tokenExpireSeconds = tokenExpireSeconds;
        this.refreshExpireSeconds = refreshExpireSeconds;
        this.refreshAfterExpired = refreshAfterExpired;
        this.useCamelCase = useCamelCase;
    }

    public /* synthetic */ JWTAuthRefreshHandler(JWTAuth jWTAuth, JWTAuth jWTAuth2, int n, int n2, boolean bl, boolean bl2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n = 259200;
        }
        if ((n3 & 8) != 0) {
            n2 = 604800;
        }
        if ((n3 & 0x10) != 0) {
            bl = false;
        }
        if ((n3 & 0x20) != 0) {
            bl2 = false;
        }
        this(jWTAuth, jWTAuth2, n, n2, bl, bl2);
    }

    @NotNull
    protected final JWTAuth getJwtAuth() {
        return this.jwtAuth;
    }

    @NotNull
    protected final JWTAuth getJwtAuthRefresh() {
        return this.jwtAuthRefresh;
    }

    protected final int getTokenExpireSeconds() {
        return this.tokenExpireSeconds;
    }

    protected final int getRefreshExpireSeconds() {
        return this.refreshExpireSeconds;
    }

    protected final boolean getRefreshAfterExpired() {
        return this.refreshAfterExpired;
    }

    protected final boolean getUseCamelCase() {
        return this.useCamelCase;
    }

    public void handle(@NotNull RoutingContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        String accessToken = "";
        String authHeader = ctx.request().getHeader(((Object)HttpHeaders.AUTHORIZATION).toString());
        CharSequence charSequence = authHeader;
        if (!(charSequence == null || charSequence.length() == 0)) {
            Intrinsics.checkNotNullExpressionValue((Object)authHeader, (String)"authHeader");
            accessToken = StringsKt.removePrefix((String)authHeader, (CharSequence)"Bearer ");
        } else {
            accessToken = "invalid";
        }
        String refreshTokenKey = this.useCamelCase ? "refreshToken" : "refresh_token";
        String refreshToken = ctx.request().params().get(refreshTokenKey);
        JWTAuthHelper helper = new JWTAuthHelper(this.jwtAuth, this.jwtAuthRefresh, this.useCamelCase);
        helper.refreshToken(refreshToken, accessToken, this.tokenExpireSeconds, this.refreshExpireSeconds, this.refreshAfterExpired, (Function2<? super User, ? super JsonObject, Unit>)((Function2)new Function2<User, JsonObject, Unit>(ctx){
            final /* synthetic */ RoutingContext $ctx;
            {
                this.$ctx = $ctx;
                super(2);
            }

            public final void invoke(@Nullable User user, @NotNull JsonObject result) {
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                if (user == null) {
                    this.$ctx.response().setStatusCode(401);
                    ControllerKt.endJson$default(this.$ctx, result, 0, 2, null);
                } else {
                    ControllerKt.endJson$default(this.$ctx, result, 0, 2, null);
                }
            }
        }));
    }
}

