/*
 * Decompiled with CFR 0.152.
 */
package io.zeko.restapi.annotation.codegen;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lio/zeko/restapi/annotation/codegen/SwaggerUtils;", "", "()V", "Companion", "zeko-restapi"})
public final class SwaggerUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public static final Pattern getVertxUriParamPattern() {
        return Companion.getVertxUriParamPattern();
    }

    @JvmStatic
    @NotNull
    public static final String convertToSwaggerUri(@NotNull String path, @NotNull Pattern pattern) {
        return Companion.convertToSwaggerUri(path, pattern);
    }

    @JvmStatic
    @NotNull
    public static final List<String> paramsFromVertxUri(@NotNull String path, @NotNull Pattern uriParamPattern) {
        return Companion.paramsFromVertxUri(path, uriParamPattern);
    }

    @JvmStatic
    @NotNull
    public static final String stripFileExt(@NotNull String str) {
        return Companion.stripFileExt(str);
    }

    @JvmStatic
    @NotNull
    public static final String checkFieldType(@NotNull Map<String, ? extends List<? extends Object>> rule) {
        return Companion.checkFieldType(rule);
    }

    @JvmStatic
    public static final void addFieldFormat(@NotNull JsonObject fieldSchema, @NotNull String fieldType, @NotNull Map<String, ? extends List<? extends Object>> rule) {
        Companion.addFieldFormat(fieldSchema, fieldType, rule);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00100\u000fH\u0007J\"\u0010\u0011\u001a\u00020\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00100\u000fH\u0007J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u00162\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0004H\u0007J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\rH\u0007R\u001a\u0010\u0003\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lio/zeko/restapi/annotation/codegen/SwaggerUtils$Companion;", "", "()V", "vertxUriParamPattern", "Ljava/util/regex/Pattern;", "getVertxUriParamPattern$annotations", "getVertxUriParamPattern", "()Ljava/util/regex/Pattern;", "addFieldFormat", "", "fieldSchema", "Lio/vertx/core/json/JsonObject;", "fieldType", "", "rule", "", "", "checkFieldType", "convertToSwaggerUri", "path", "pattern", "paramsFromVertxUri", "", "uriParamPattern", "stripFileExt", "str", "zeko-restapi"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pattern getVertxUriParamPattern() {
            JsonObject paths = new JsonObject();
            String rgxStr = "\\:([a-zA-Z_0-9]+)";
            Regex rgx = new Regex(rgxStr);
            Pattern uriParamPattern = rgx.toPattern();
            return uriParamPattern;
        }

        @JvmStatic
        public static /* synthetic */ void getVertxUriParamPattern$annotations() {
        }

        @JvmStatic
        @NotNull
        public final String convertToSwaggerUri(@NotNull String path, @NotNull Pattern pattern) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            CharSequence charSequence = path;
            Regex regex = new Regex(pattern);
            String string = "\\{$1\\}";
            return regex.replace(charSequence, string);
        }

        @JvmStatic
        @NotNull
        public final List<String> paramsFromVertxUri(@NotNull String path, @NotNull Pattern uriParamPattern) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)uriParamPattern, (String)"uriParamPattern");
            Matcher matcher = uriParamPattern.matcher(path);
            List uriParam = new ArrayList();
            while (matcher.find()) {
                String string = matcher.group(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"matcher.group(1)");
                uriParam.add(string);
            }
            return uriParam;
        }

        @JvmStatic
        @NotNull
        public final String stripFileExt(@NotNull String str) {
            String string;
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            int pos = StringsKt.lastIndexOf$default((CharSequence)str, (String)".", (int)0, (boolean)false, (int)6, null);
            if (pos == -1) {
                string = str;
            } else {
                String string2 = str.substring(0, pos);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            }
            return string;
        }

        @JvmStatic
        @NotNull
        public final String checkFieldType(@NotNull Map<String, ? extends List<? extends Object>> rule) {
            Intrinsics.checkNotNullParameter(rule, (String)"rule");
            String fieldType = "string";
            if (rule.containsKey("isInteger") || rule.containsKey("isLong")) {
                fieldType = "integer";
            } else if (rule.containsKey("isDouble") || rule.containsKey("isFloat")) {
                fieldType = "number";
            } else if (rule.containsKey("isBoolean")) {
                fieldType = "boolean";
            }
            return fieldType;
        }

        @JvmStatic
        public final void addFieldFormat(@NotNull JsonObject fieldSchema, @NotNull String fieldType, @NotNull Map<String, ? extends List<? extends Object>> rule) {
            Intrinsics.checkNotNullParameter((Object)fieldSchema, (String)"fieldSchema");
            Intrinsics.checkNotNullParameter((Object)fieldType, (String)"fieldType");
            Intrinsics.checkNotNullParameter(rule, (String)"rule");
            if (Intrinsics.areEqual((Object)fieldType, (Object)"integer")) {
                fieldSchema.put("format", (Object)(rule.containsKey("isLong") ? "int64" : "int32"));
            } else if (rule.containsKey("dateFormat")) {
                fieldSchema.put("format", (Object)"date");
            } else if (rule.containsKey("dateTimeFormat")) {
                fieldSchema.put("format", (Object)"date-time");
            } else if (rule.containsKey("timeFormat")) {
                fieldSchema.put("format", (Object)"time");
            } else if (rule.containsKey("time24Hour")) {
                fieldSchema.put("format", (Object)"time24Hour");
            } else if (rule.containsKey("email")) {
                fieldSchema.put("format", (Object)"email");
            } else if (rule.containsKey("ipv4")) {
                fieldSchema.put("format", (Object)"ipv4");
            } else if (rule.containsKey("ipv6")) {
                fieldSchema.put("format", (Object)"ipv6");
            } else if (rule.containsKey("hostName")) {
                fieldSchema.put("format", (Object)"hostname");
            } else if (rule.containsKey("subdomain")) {
                fieldSchema.put("format", (Object)"subdomain");
            } else if (rule.containsKey("url")) {
                fieldSchema.put("format", (Object)"url");
            } else if (rule.containsKey("digit")) {
                fieldSchema.put("format", (Object)"digit");
            } else if (rule.containsKey("letter")) {
                fieldSchema.put("format", (Object)"letter");
            } else if (rule.containsKey("alphaNum")) {
                fieldSchema.put("format", (Object)"alphaNum");
            } else if (rule.containsKey("alphaNumSpace")) {
                fieldSchema.put("format", (Object)"alphaNumSpace");
            } else if (rule.containsKey("alphaNumDash")) {
                fieldSchema.put("format", (Object)"alphaNumDash");
            } else if (rule.containsKey("alphaNumDashSpace")) {
                fieldSchema.put("format", (Object)"alphaNumDashSpace");
            } else if (rule.containsKey("alphaNumUnderscore")) {
                fieldSchema.put("format", (Object)"alphaNumUnderscore");
            } else if (rule.containsKey("alphaNumQuoteDashSpace")) {
                fieldSchema.put("format", (Object)"alphaNumQuoteDashSpace");
            } else if (rule.containsKey("alphaNumQuoteSpace")) {
                fieldSchema.put("format", (Object)"alphaNumQuoteSpace");
            } else if (rule.containsKey("alphaQuoteDashSpace")) {
                fieldSchema.put("format", (Object)"alphaQuoteDashSpace");
            } else if (rule.containsKey("alphaQuoteSpace")) {
                fieldSchema.put("format", (Object)"alphaQuoteSpace");
            } else if (rule.containsKey("allLowerCase")) {
                fieldSchema.put("format", (Object)"allLowerCase");
            } else if (rule.containsKey("allUpperCase")) {
                fieldSchema.put("format", (Object)"allUpperCase");
            } else if (rule.containsKey("passwordSimple")) {
                fieldSchema.put("format", (Object)"password");
            } else if (rule.containsKey("creditCard")) {
                fieldSchema.put("format", (Object)"creditCard");
            }
            if (rule.containsKey("inArray")) {
                fieldSchema.put("format", (Object)"inArray");
                fieldSchema.put("enum", (Object)new JsonArray(rule.get("inArray")));
            } else if (rule.containsKey("notInArray")) {
                fieldSchema.put("format", (Object)"notInArray");
                fieldSchema.put("enum", (Object)new JsonArray(rule.get("notInArray")));
            }
            if (rule.containsKey("regex")) {
                List<? extends Object> list = rule.get("regex");
                Intrinsics.checkNotNull(list);
                fieldSchema.put("pattern", list.get(0));
            }
            if (rule.containsKey("min")) {
                List<? extends Object> list = rule.get("min");
                Intrinsics.checkNotNull(list);
                fieldSchema.put("minimum", list.get(0));
            }
            if (rule.containsKey("max")) {
                List<? extends Object> list = rule.get("max");
                Intrinsics.checkNotNull(list);
                fieldSchema.put("maximum", list.get(0));
            }
            if (rule.containsKey("length")) {
                List<? extends Object> list = rule.get("length");
                Intrinsics.checkNotNull(list);
                fieldSchema.put("minLength", list.get(0));
                List<? extends Object> list2 = rule.get("length");
                Intrinsics.checkNotNull(list2);
                fieldSchema.put("maxLength", list2.get(1));
            } else {
                if (rule.containsKey("minLength")) {
                    List<? extends Object> list = rule.get("minLength");
                    Intrinsics.checkNotNull(list);
                    fieldSchema.put("minLength", list.get(0));
                }
                if (rule.containsKey("maxLength")) {
                    List<? extends Object> list = rule.get("maxLength");
                    Intrinsics.checkNotNull(list);
                    fieldSchema.put("maxLength", list.get(0));
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

