/*
 * Decompiled with CFR 0.152.
 */
package io.zeko.restapi.core.security;

import java.math.BigInteger;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\nH\u0002J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lio/zeko/restapi/core/security/PasswordSecurity;", "", "()V", "salt", "", "getSalt", "()Ljava/lang/String;", "saltAsString", "getSaltAsString", "fromHex", "", "hex", "generatePasswordHash", "password", "iterations", "", "hmacSha1", "secretKey", "rurl", "toHex", "array", "validatePassword", "", "originalPassword", "storedPassword", "zeko-restapi"})
public final class PasswordSecurity {
    @Nullable
    public final String hmacSha1(@NotNull String secretKey, @NotNull String rurl) {
        Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
        Intrinsics.checkNotNullParameter((Object)rurl, (String)"rurl");
        try {
            Mac mac = Mac.getInstance("HmacSHA1");
            String string = secretKey;
            Object object = Charsets.UTF_8;
            boolean bl = false;
            byte[] byArray = string.getBytes((Charset)object);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            SecretKeySpec secret = new SecretKeySpec(byArray, "HmacSHA1");
            mac.init(secret);
            object = rurl;
            Charset charset = Charsets.UTF_8;
            boolean bl2 = false;
            byte[] byArray2 = ((String)object).getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] digest = mac.doFinal(byArray2);
            String signature = Base64.getEncoder().encodeToString(digest);
            return URLEncoder.encode(signature, "UTF-8");
        }
        catch (Exception exception) {
            return null;
        }
    }

    @NotNull
    public final String generatePasswordHash(@NotNull String password, int iterations) throws NoSuchAlgorithmException, InvalidKeySpecException {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        String string = password;
        boolean bl = false;
        char[] cArray = string.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] chars = cArray;
        String string2 = this.getSalt();
        Charset charset = Charsets.UTF_8;
        boolean bl2 = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] salt = byArray;
        PBEKeySpec spec = new PBEKeySpec(chars, salt, iterations, 512);
        SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        SecretKey secretKey = skf.generateSecret(spec);
        Intrinsics.checkNotNullExpressionValue((Object)secretKey, (String)"skf.generateSecret(spec)");
        byte[] hash = secretKey.getEncoded();
        StringBuilder stringBuilder = new StringBuilder().append(String.valueOf(iterations)).append(":").append(this.toHex(salt)).append(":");
        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"hash");
        return stringBuilder.append(this.toHex(hash)).toString();
    }

    public static /* synthetic */ String generatePasswordHash$default(PasswordSecurity passwordSecurity, String string, int n, int n2, Object object) throws NoSuchAlgorithmException, InvalidKeySpecException {
        if ((n2 & 2) != 0) {
            n = 3;
        }
        return passwordSecurity.generatePasswordHash(string, n);
    }

    public final boolean validatePassword(@NotNull String originalPassword, @NotNull String storedPassword) throws NoSuchAlgorithmException, InvalidKeySpecException {
        Intrinsics.checkNotNullParameter((Object)originalPassword, (String)"originalPassword");
        Intrinsics.checkNotNullParameter((Object)storedPassword, (String)"storedPassword");
        CharSequence charSequence = storedPassword;
        String string = ":";
        int n = 0;
        string = new Regex(string);
        n = 0;
        boolean bl = false;
        Collection $this$toTypedArray$iv = string.split(charSequence, n);
        boolean $i$f$toTypedArray22 = false;
        Collection thisCollection$iv22 = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv22.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] parts = stringArray;
        String $i$f$toTypedArray22 = parts[0];
        boolean thisCollection$iv22 = false;
        int iterations = Integer.parseInt($i$f$toTypedArray22);
        byte[] salt = this.fromHex(parts[1]);
        byte[] hash = this.fromHex(parts[2]);
        String string2 = originalPassword;
        boolean bl2 = false;
        char[] cArray = string2.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        PBEKeySpec spec = new PBEKeySpec(cArray, salt, iterations, 512);
        SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        SecretKey secretKey = skf.generateSecret(spec);
        Intrinsics.checkNotNullExpressionValue((Object)secretKey, (String)"skf.generateSecret(spec)");
        byte[] testHash = secretKey.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)testHash, (String)"testHash");
        return Intrinsics.areEqual((Object)this.toHex(testHash), (Object)this.toHex(hash));
    }

    @NotNull
    public final String getSalt() throws NoSuchAlgorithmException {
        SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
        byte[] salt = new byte[16];
        sr.nextBytes(salt);
        return salt.toString();
    }

    @NotNull
    public final String getSaltAsString() throws NoSuchAlgorithmException {
        SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
        byte[] salt = new byte[16];
        sr.nextBytes(salt);
        String string = salt.toString();
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return this.toHex(byArray);
    }

    private final String toHex(byte[] array) throws NoSuchAlgorithmException {
        String string;
        BigInteger bi = new BigInteger(1, array);
        String hex = bi.toString(16);
        int paddingLength = array.length * 2 - hex.length();
        if (paddingLength > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "%0" + paddingLength + "d";
            Object[] objectArray = new Object[]{0};
            boolean bl = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
            string = stringBuilder.append(string3).append(hex).toString();
        } else {
            String string4 = hex;
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"hex");
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] fromHex(String hex) throws NoSuchAlgorithmException {
        byte[] bytes = new byte[hex.length() / 2];
        int n = 0;
        int n2 = bytes.length;
        while (n < n2) {
            void i;
            String string = hex;
            int n3 = 2 * i;
            int n4 = 2 * i + 2;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n3, n4);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string = string3;
            n3 = 16;
            n4 = 0;
            bytes[i] = (byte)Integer.parseInt(string, CharsKt.checkRadix((int)n3));
            ++i;
        }
        return bytes;
    }
}

