package io.zeko.restapi.core.validations

class ValidationError {
    companion object {
        @JvmStatic
        val defaultMessages = mapOf(
            "required" to "__ is required",
            "regex" to "__ did not match any valid format",
            "length" to "__ length must be between %s and %s",
            "minLength" to "__ cannot be shorter than %s",
            "maxLength" to "__ cannot be longer than %s",
            "hasChar" to "__ must have a character of '%s'",
            "startWith" to "__ must start with %s",
            "endWith" to "__ must end with %s",
            "digit" to "__ should be digits only",
            "letter" to "__ should be alphabets only",
            "hasDigit" to "__ must have at least one digit",
            "hasLetter" to "__ must have at least alphabet",
            "min" to "__ minimum value is %s",
            "max" to "__ maximum value is %s",
            "alphaNum" to "__ must be alpha numeric",
            "alphaNum" to "__ must be alpha numeric",
            "timeBefore" to "__ must be before %s",
            "alphaNum" to "__ can only consist letters and digits only",
            "alphaNumLowerCase" to "__ can only consist of letters in lower case and digits",
            "alphaNumUpperCase" to "__ can only consist of letters in upper case and digits",
            "alphaNumSpace" to "__ can only consist of letters, digits and spaces",
            "alphaNumSpaceLowerCase" to "__ can only consist of letters in lower case, digits and spaces",
            "alphaNumSpaceUpperCase" to "__ can only consist of letters in upper case, digits and spaces",
            "alphaNumDash" to "__ can only consist of letters, digits, and dashes",
            "alphaNumDashSpace" to "__ can only consist of letters, digits, dashes and spaces",
            "alphaNumUnderscore" to "__ can only consist of letters, digits and underscores",
            "alphaNumUnderscoreSpace" to "__ can only consist of letters, digits, spaces and underscores",
            "alphaNumQuoteSpace" to "__ can only consist of letters, digits, single quotes and spaces",
            "alphaNumQuoteDashSpace" to "__ can only consist of letters, digits, single quotes, dashes and spaces",
            "alphaQuoteSpace" to "__ can only consist of letters, single quotes and spaces",
            "alphaQuoteDashSpace" to "__ can only consist of letters, single quotes, dashes and spaces",
            "allLowerCase" to "__ should be all lower case",
            "allUpperCase" to "__ should be all upper case",
            "passwordSimple" to "__ can only consist of letters, digits, underscores, dashes and punctuations",
            "creditCard" to "__ is not a valid credit card number",
            "ccVisa" to "__ is not a valid Visa card number",
            "ccMaster" to "__ is not a valid Master card number",
            "ccAmericanExpress" to "__ is not a valid American Express card number",
            "ccDinersClub" to "__ is not a valid Diners Club card number",
            "ccDiscover" to "__ is not a valid Discover card number",
            "ccJcb" to "__ is not a valid JCB card number",
            "email" to "__ is not a valid email address",
            "url" to "__ is not a valid URL",
            "ipv4" to "__ is not a valid IPV4 address",
            "hostName" to "__ is not a valid host name",
            "serverName" to "__ is not a valid server name",
            "subdomain" to "__ is not a valid subdomain",
            "colorHex" to "__ is not a valid color hex",
            "domain" to "__ is not a valid domain name",
            "isNumber" to "__ is not a valid number",
            "isLong" to "__ is not a valid long value",
            "isULong" to "__ is not a valid unsigned long value",
            "isInteger" to "__ is not a valid integer value",
            "isUInteger" to "__ is not a valid unsigned integer value",
            "isDouble" to "__ is not a valid double value",
            "isFloat" to "__ is not a valid float value",
            "isBoolean" to "__ is not true or false",
            "inArray" to "__ must be one of these values: %s",
            "notInArray" to "__ must not be one of these values: %s",
            "separateBy" to "__ must be a delimited list separated by '%s'",
            "separateByInArray" to "__ must be a delimited list separated by %s and one of these values: %s",
            "time24Hour" to "__ must be 24 hour time format. eg. 23:30",
            "dateFormat" to "__ must be valid date format %s",
            "dateBetween" to "__ must be a valid date and between %s and %s",
            "dateAfter" to "__ must be after %s",
            "dateBefore" to "__ must be before %s",
            "dateEq" to "__ must be same date as %s",
            "dateAfterYear" to "__ must be after year %s",
            "dateBeforeYear" to "__ must be before year %s",
            "dateEqYear" to "__ must be same year as %s",
            "dateAfterMonth" to "__ must be after month %s",
            "dateBeforeMonth" to "__ must be before month %s",
            "dateEqMonth" to "__ must be same month as %s",
            "timeFormat" to "__ must be valid time format %s",
            "timeBetween" to "__ must be a valid time format and between %s and %s",
            "timeAfter" to "__ must be after time %s",
            "timeBefore" to "__ must be before time %s",
            "timeEq" to "__ must be same time as %s",
            "timeAfterHour" to "__ must be after hour %s",
            "timeBeforeHour" to "__ must be before hour %s",
            "timeEqHour" to "__ must be same hour as %s",
            "timeAfterMinute" to "__ must be after minute %s",
            "timeBeforeMinute" to "__ must be before minute %s",
            "timeEqMinute" to "__ must be same minute as %s",
            "dateFormat" to "__ must be valid date time format %s",
            "dateTimeFormat" to "__ must be a valid time format and between %s and %s",
            "dateTimeBetween" to "__ must be a valid date time format and between %s and %s",
            "dateTimeAfter" to "__ must be after date time %s",
            "dateTimeBefore" to "__ must be before date time %s",
            "dateTimeEq" to "__ must be same date time as %s",
            "dateTimeAfterWeek" to "__ must be after the week of %s",
            "dateTimeBeforeWeek" to "__ must be before the week of %s",
            "dateTimeEqWeek" to "__ must be same as the week of %s",
            "dateTimeAfterMonth" to "__ must be after the month of %s",
            "dateTimeBeforeMonth" to "__ must be before the month of %s",
            "dateTimeEqMonth" to "__ must be same as the month of %s",
            "dateTimeAfterYear" to "__ must be after the year of %s",
            "dateTimeBeforeYear" to "__ must be before the year of %s",
            "dateTimeEqYear" to "__ must be same as the year of %s"
        )
    }
}
