/*
 * Decompiled with CFR 0.152.
 */
package io.zeko.restapi.core.utilities.zip;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.streams.Pump;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.ext.web.RoutingContext;
import io.zeko.restapi.core.utilities.zip.FileEntry;
import io.zeko.restapi.core.utilities.zip.FileEntryIterator;
import io.zeko.restapi.core.utilities.zip.GeneratedFileEntry;
import io.zeko.restapi.core.utilities.zip.TempFile;
import io.zeko.restapi.core.utilities.zip.ZipGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 82\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00018B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001aH\u0002J\u0018\u0010\u001c\u001a\u00020\u001a2\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0002J\"\u0010\u001c\u001a\u00020\u001a2\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\b\u0010\u001e\u001a\u0004\u0018\u00010\fH\u0002J\b\u0010\u001f\u001a\u00020\u001aH\u0002J\b\u0010 \u001a\u00020\u001aH\u0002J\b\u0010!\u001a\u00020\u001aH\u0002J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0016J\u001e\u0010#\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u000bH\u0016J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u0011H\u0002J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0016J\b\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020-H\u0002J\u0016\u0010.\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u0001000/0\u000bH\u0002J&\u00101\u001a\u00020\u001a2\u0006\u00102\u001a\u0002032\u0014\u0010\u001d\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\f0/0\u000bH\u0002J\u0010\u00104\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0001H\u0016J&\u00105\u001a\u00020\u001a2\u0006\u00102\u001a\u0002032\u0014\u0010\u001d\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\f0/0\u000bH\u0002J&\u00106\u001a\u00020\u001a2\u0006\u00102\u001a\u0002032\u0014\u0010\u001d\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\f0/0\u000bH\u0002J\u0010\u00107\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0001H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lio/zeko/restapi/core/utilities/zip/ZipGenerator;", "Lio/vertx/core/streams/ReadStream;", "Lio/vertx/core/buffer/Buffer;", "vertx", "Lio/vertx/core/Vertx;", "source", "Lio/zeko/restapi/core/utilities/zip/FileEntryIterator;", "(Lio/vertx/core/Vertx;Lio/zeko/restapi/core/utilities/zip/FileEntryIterator;)V", "CHUNK_SIZE", "", "closeHandler", "Lio/vertx/core/Handler;", "Ljava/lang/Void;", "context", "Lio/vertx/core/Context;", "dataHandler", "failureHandler", "", "fileEntryIS", "Ljava/io/InputStream;", "pis", "Ljava/io/PipedInputStream;", "state", "zos", "Ljava/util/zip/ZipOutputStream;", "acquireContext", "", "doCloseAndStop", "doCloseGenerator", "handler", "e", "doFlushPipe", "doRead", "doReadFile", "endHandler", "exceptionHandler", "fetch", "amount", "", "handleError", "cause", "hasNextFile", "", "next", "f", "Ljava/lang/Runnable;", "noop", "Lio/vertx/core/AsyncResult;", "", "openStreamForEntry", "entry", "Lio/zeko/restapi/core/utilities/zip/FileEntry;", "pause", "readFile", "readStreamForEntry", "resume", "Companion", "zeko-restapi"})
public final class ZipGenerator
implements ReadStream<Buffer> {
    private volatile int state;
    private Context context;
    private final ZipOutputStream zos;
    private final PipedInputStream pis;
    private InputStream fileEntryIS;
    private Handler<Throwable> failureHandler;
    private Handler<Buffer> dataHandler;
    private Handler<Void> closeHandler;
    private final FileEntryIterator source;
    private final int CHUNK_SIZE = 8092;
    private final Vertx vertx;
    private static final Logger LOG;
    public static final int STATUS_PAUSED = 0;
    public static final int STATUS_ACTIVE = 1;
    public static final int STATUS_CLOSED = 2;
    public static final Companion Companion;

    private final void doRead() {
        this.acquireContext();
        if (this.state == 1) {
            this.vertx.executeBlocking((Handler)new Handler<Promise<Object>>(this){
                final /* synthetic */ ZipGenerator this$0;

                public final void handle(@NotNull Promise<Object> promise) {
                    Intrinsics.checkParameterIsNotNull(promise, (String)"promise");
                    ZipGenerator.access$next(this.this$0, new Runnable(this){
                        final /* synthetic */ doRead.1 this$0;

                        public final void run() {
                            ZipGenerator.access$doFlushPipe(this.this$0.this$0);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                    ZipGenerator.access$next(this.this$0, new Runnable(this){
                        final /* synthetic */ doRead.1 this$0;

                        public final void run() {
                            ZipGenerator.access$doReadFile(this.this$0.this$0);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                    promise.complete();
                }
                {
                    this.this$0 = zipGenerator;
                }
            }, this.noop());
        }
    }

    private final void doReadFile() {
        if (this.hasNextFile()) {
            Object e = this.source.next();
            if (e == null) {
                throw new TypeCastException("null cannot be cast to non-null type io.zeko.restapi.core.utilities.zip.FileEntry");
            }
            this.readFile((FileEntry)e, (Handler<AsyncResult<Void>>)((Handler)new Handler<AsyncResult<Void>>(this){
                final /* synthetic */ ZipGenerator this$0;

                public final void handle(@NotNull AsyncResult<Void> ar) {
                    Intrinsics.checkParameterIsNotNull(ar, (String)"ar");
                    if (ar.succeeded()) {
                        ZipGenerator.access$next(this.this$0, new Runnable(this){
                            final /* synthetic */ doReadFile.1 this$0;

                            public final void run() {
                                ZipGenerator.access$doReadFile(this.this$0.this$0);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    } else {
                        Throwable throwable = ar.cause();
                        Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"ar.cause()");
                        ZipGenerator.access$handleError(this.this$0, throwable);
                    }
                }
                {
                    this.this$0 = zipGenerator;
                }
            }));
        } else {
            this.next(new Runnable(this){
                final /* synthetic */ ZipGenerator this$0;

                public final void run() {
                    ZipGenerator.access$doCloseAndStop(this.this$0);
                }
                {
                    this.this$0 = zipGenerator;
                }
            });
        }
    }

    private final void doCloseAndStop() {
        this.vertx.executeBlocking((Handler)new Handler<Promise<Object>>(this){
            final /* synthetic */ ZipGenerator this$0;

            public final void handle(@NotNull Promise<Object> v) {
                Intrinsics.checkParameterIsNotNull(v, (String)"v");
                try {
                    ZipGenerator.access$doFlushPipe(this.this$0);
                    ZipGenerator.access$getZos$p(this.this$0).close();
                    v.complete();
                }
                catch (IOException e) {
                    v.fail((Throwable)e);
                }
            }
            {
                this.this$0 = zipGenerator;
            }
        }, (Handler)new Handler<AsyncResult<Object>>(this){
            final /* synthetic */ ZipGenerator this$0;

            public final void handle(@NotNull AsyncResult<Object> v) {
                Intrinsics.checkParameterIsNotNull(v, (String)"v");
                if (v.succeeded()) {
                    ZipGenerator.access$doCloseGenerator(this.this$0, ZipGenerator.access$getCloseHandler$p(this.this$0));
                } else {
                    Throwable throwable = v.cause();
                    Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"v.cause()");
                    ZipGenerator.access$handleError(this.this$0, throwable);
                }
            }
            {
                this.this$0 = zipGenerator;
            }
        });
    }

    private final void readFile(FileEntry entry, Handler<AsyncResult<Void>> handler) {
        this.vertx.executeBlocking((Handler)new Handler<Promise<Object>>(this, entry, handler){
            final /* synthetic */ ZipGenerator this$0;
            final /* synthetic */ FileEntry $entry;
            final /* synthetic */ Handler $handler;

            public final void handle(@Nullable Promise<Object> promise) {
                try {
                    if (ZipGenerator.access$getFileEntryIS$p(this.this$0) == null) {
                        ZipGenerator.access$openStreamForEntry(this.this$0, this.$entry, this.$handler);
                    } else {
                        ZipGenerator.access$readStreamForEntry(this.this$0, this.$entry, this.$handler);
                    }
                }
                catch (IOException e) {
                    this.$handler.handle((Object)Future.failedFuture((Throwable)e));
                }
            }
            {
                this.this$0 = zipGenerator;
                this.$entry = fileEntry;
                this.$handler = handler;
            }
        }, this.noop());
    }

    private final void readStreamForEntry(FileEntry entry, Handler<AsyncResult<Void>> handler) throws IOException {
        int bytesRead = 0;
        int c = 0;
        Buffer buf = Buffer.buffer();
        while (true) {
            InputStream inputStream = this.fileEntryIS;
            if (inputStream == null) {
                Intrinsics.throwNpe();
            }
            int n = inputStream.read();
            boolean bl = false;
            boolean bl2 = false;
            int it = n;
            boolean bl3 = false;
            c = it;
            if (n == -1 || bytesRead >= this.CHUNK_SIZE) break;
            buf.appendByte((byte)c);
            ++bytesRead;
        }
        this.zos.write(buf.getBytes(0, bytesRead));
        if (bytesRead == this.CHUNK_SIZE) {
            this.vertx.runOnContext((Handler)new Handler<Void>(this, entry, handler){
                final /* synthetic */ ZipGenerator this$0;
                final /* synthetic */ FileEntry $entry;
                final /* synthetic */ Handler $handler;

                public final void handle(@Nullable Void v) {
                    ZipGenerator.access$readFile(this.this$0, this.$entry, this.$handler);
                }
                {
                    this.this$0 = zipGenerator;
                    this.$entry = fileEntry;
                    this.$handler = handler;
                }
            });
        } else {
            InputStream inputStream = this.fileEntryIS;
            if (inputStream == null) {
                Intrinsics.throwNpe();
            }
            inputStream.close();
            this.fileEntryIS = null;
            handler.handle((Object)Future.succeededFuture());
        }
    }

    private final void openStreamForEntry(FileEntry entry, Handler<AsyncResult<Void>> handler) throws IOException {
        ZipEntry e = new ZipEntry(entry.getPath());
        this.zos.putNextEntry(e);
        entry.open((Handler<AsyncResult<InputStream>>)((Handler)new Handler<AsyncResult<InputStream>>(this, entry, handler){
            final /* synthetic */ ZipGenerator this$0;
            final /* synthetic */ FileEntry $entry;
            final /* synthetic */ Handler $handler;

            public final void handle(AsyncResult<InputStream> ar) {
                if (ar.succeeded()) {
                    ZipGenerator.access$setFileEntryIS$p(this.this$0, (InputStream)ar.result());
                    ZipGenerator.access$getVertx$p(this.this$0).runOnContext((Handler)new Handler<Void>(this){
                        final /* synthetic */ openStreamForEntry.1 this$0;

                        public final void handle(Void it) {
                            ZipGenerator.access$readFile(this.this$0.this$0, this.this$0.$entry, this.this$0.$handler);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                } else {
                    Throwable throwable = ar.cause();
                    Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"ar.cause()");
                    ZipGenerator.access$handleError(this.this$0, throwable);
                }
            }
            {
                this.this$0 = zipGenerator;
                this.$entry = fileEntry;
                this.$handler = handler;
            }
        }));
    }

    private final boolean hasNextFile() {
        return this.source.hasNext();
    }

    private final void doFlushPipe() {
        this.acquireContext();
        try {
            if (this.state == 1) {
                if (this.pis.available() > 0) {
                    byte[] tmp = new byte[this.pis.available()];
                    int readBytes = this.pis.read(tmp);
                    if (readBytes > 0) {
                        byte[] buffer = new byte[readBytes];
                        System.arraycopy(tmp, 0, buffer, 0, readBytes);
                        Handler<Buffer> handler = this.dataHandler;
                        if (handler == null) {
                            Intrinsics.throwNpe();
                        }
                        handler.handle((Object)Buffer.buffer((byte[])buffer));
                    }
                    this.next(new Runnable(this){
                        final /* synthetic */ ZipGenerator this$0;

                        public final void run() {
                            ZipGenerator.access$doFlushPipe(this.this$0);
                        }
                        {
                            this.this$0 = zipGenerator;
                        }
                    });
                } else {
                    this.next(new Runnable(this){
                        final /* synthetic */ ZipGenerator this$0;

                        public final void run() {
                            ZipGenerator.access$doFlushPipe(this.this$0);
                        }
                        {
                            this.this$0 = zipGenerator;
                        }
                    });
                }
            }
        }
        catch (IOException e) {
            this.handleError(e);
        }
    }

    private final void next(Runnable f) {
        Context context = this.context;
        if (context == null) {
            Intrinsics.throwNpe();
        }
        context.runOnContext((Handler)new Handler<Void>(f){
            final /* synthetic */ Runnable $f;

            public final void handle(@Nullable Void v) {
                this.$f.run();
            }
            {
                this.$f = runnable;
            }
        });
    }

    private final void acquireContext() {
        if (this.context == null) {
            this.context = this.vertx.getOrCreateContext();
        }
    }

    private final void doCloseGenerator(Handler<Void> handler) {
        this.doCloseGenerator(handler, null);
    }

    private final void doCloseGenerator(Handler<Void> handler, Void e) {
        this.state = 2;
        Context context = this.context;
        if (context == null) {
            Intrinsics.throwNpe();
        }
        context.runOnContext((Handler)new Handler<Void>(handler, e){
            final /* synthetic */ Handler $handler;
            final /* synthetic */ Void $e;

            public final void handle(@Nullable Void event) {
                block0: {
                    Handler handler = this.$handler;
                    if (handler == null) break block0;
                    handler.handle((Object)this.$e);
                }
            }
            {
                this.$handler = handler;
                this.$e = void_;
            }
        });
    }

    private final void handleError(Throwable cause) {
        this.state = 2;
        if (this.failureHandler != null) {
            LOG.error((Object)cause);
            Handler<Throwable> handler = this.failureHandler;
            if (handler == null) {
                Intrinsics.throwNpe();
            }
            handler.handle((Object)cause);
        } else {
            LOG.warn((Object)("No handler for error: " + cause));
        }
    }

    @NotNull
    public ReadStream<Buffer> handler(@NotNull Handler<Buffer> handler) {
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        boolean bl = false;
        boolean bl2 = false;
        this.dataHandler = handler;
        this.doRead();
        return this;
    }

    @NotNull
    public ReadStream<Buffer> fetch(long amount) {
        return this;
    }

    @Nullable
    public ReadStream<Buffer> pause() {
        if (this.state == 1) {
            this.state = 0;
        }
        return this;
    }

    @Nullable
    public ReadStream<Buffer> resume() {
        switch (this.state) {
            case 2: {
                throw (Throwable)new IllegalStateException("Cannot resume, already closed");
            }
            case 0: {
                this.state = 1;
                this.doRead();
            }
        }
        return this;
    }

    @Nullable
    public ReadStream<Buffer> exceptionHandler(@NotNull Handler<Throwable> handler) {
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        this.failureHandler = handler;
        return this;
    }

    private final Handler<AsyncResult<Object>> noop() {
        return noop.1.INSTANCE;
    }

    @NotNull
    public ReadStream<Buffer> endHandler(@Nullable Handler<Void> endHandler) {
        this.closeHandler = endHandler;
        return this;
    }

    public ZipGenerator(@NotNull Vertx vertx, @NotNull FileEntryIterator source) {
        Intrinsics.checkParameterIsNotNull((Object)vertx, (String)"vertx");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.vertx = vertx;
        this.state = 1;
        this.CHUNK_SIZE = 8092;
        this.source = source;
        PipedOutputStream out = new PipedOutputStream();
        this.zos = new ZipOutputStream(out);
        this.pis = new PipedInputStream(out, this.CHUNK_SIZE);
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(ZipGenerator.class);
    }

    public static final /* synthetic */ void access$next(ZipGenerator $this, Runnable f) {
        $this.next(f);
    }

    public static final /* synthetic */ void access$doFlushPipe(ZipGenerator $this) {
        $this.doFlushPipe();
    }

    public static final /* synthetic */ void access$doReadFile(ZipGenerator $this) {
        $this.doReadFile();
    }

    public static final /* synthetic */ void access$handleError(ZipGenerator $this, Throwable cause) {
        $this.handleError(cause);
    }

    public static final /* synthetic */ void access$doCloseAndStop(ZipGenerator $this) {
        $this.doCloseAndStop();
    }

    public static final /* synthetic */ ZipOutputStream access$getZos$p(ZipGenerator $this) {
        return $this.zos;
    }

    public static final /* synthetic */ void access$doCloseGenerator(ZipGenerator $this, Handler handler) {
        $this.doCloseGenerator((Handler<Void>)handler);
    }

    public static final /* synthetic */ Handler access$getCloseHandler$p(ZipGenerator $this) {
        return $this.closeHandler;
    }

    public static final /* synthetic */ void access$setCloseHandler$p(ZipGenerator $this, Handler handler) {
        $this.closeHandler = handler;
    }

    public static final /* synthetic */ InputStream access$getFileEntryIS$p(ZipGenerator $this) {
        return $this.fileEntryIS;
    }

    public static final /* synthetic */ void access$setFileEntryIS$p(ZipGenerator $this, InputStream inputStream) {
        $this.fileEntryIS = inputStream;
    }

    public static final /* synthetic */ void access$openStreamForEntry(ZipGenerator $this, FileEntry entry, Handler handler) {
        $this.openStreamForEntry(entry, (Handler<AsyncResult<Void>>)handler);
    }

    public static final /* synthetic */ void access$readStreamForEntry(ZipGenerator $this, FileEntry entry, Handler handler) {
        $this.readStreamForEntry(entry, (Handler<AsyncResult<Void>>)handler);
    }

    public static final /* synthetic */ void access$readFile(ZipGenerator $this, FileEntry entry, Handler handler) {
        $this.readFile(entry, (Handler<AsyncResult<Void>>)handler);
    }

    public static final /* synthetic */ Vertx access$getVertx$p(ZipGenerator $this) {
        return $this.vertx;
    }

    @JvmStatic
    public static final void downloadZip(@NotNull Vertx vertx, @NotNull RoutingContext context, @NotNull String zipName, @NotNull List<TempFile> files) {
        Companion.downloadZip(vertx, context, zipName, files);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/zeko/restapi/core/utilities/zip/ZipGenerator$Companion;", "", "()V", "LOG", "Lio/vertx/core/logging/Logger;", "kotlin.jvm.PlatformType", "STATUS_ACTIVE", "", "STATUS_CLOSED", "STATUS_PAUSED", "downloadZip", "", "vertx", "Lio/vertx/core/Vertx;", "context", "Lio/vertx/ext/web/RoutingContext;", "zipName", "", "files", "", "Lio/zeko/restapi/core/utilities/zip/TempFile;", "zeko-restapi"})
    public static final class Companion {
        @JvmStatic
        public final void downloadZip(@NotNull Vertx vertx, @NotNull RoutingContext context, @NotNull String zipName, @NotNull List<TempFile> files) {
            Intrinsics.checkParameterIsNotNull((Object)vertx, (String)"vertx");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)zipName, (String)"zipName");
            Intrinsics.checkParameterIsNotNull(files, (String)"files");
            FileEntryIterator fileEntries2 = new FileEntryIterator(files){
                private int index;
                final /* synthetic */ List $files;

                public void remove() {
                }

                public boolean hasNext() {
                    return this.index < this.$files.size();
                }

                @Nullable
                public FileEntry next() {
                    if (!this.hasNext()) {
                        throw (Throwable)new NoSuchElementException();
                    }
                    int n = this.index;
                    this.index = n + 1;
                    return new GeneratedFileEntry(((TempFile)this.$files.get(this.index)).getName(), ((TempFile)this.$files.get(n)).getContent());
                }
                {
                    this.$files = $captured_local_variable$0;
                }
            };
            ZipGenerator zip = new ZipGenerator(vertx, fileEntries2);
            zip.endHandler((Handler<Void>)((Handler)new Handler<Void>(context){
                final /* synthetic */ RoutingContext $context;

                public final void handle(Void it) {
                    this.$context.response().end();
                }
                {
                    this.$context = routingContext;
                }
            })).exceptionHandler((Handler)downloadZip.2.INSTANCE);
            context.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/zip, application/octet-stream").putHeader(HttpHeaders.CONTENT_DISPOSITION, (CharSequence)("attachment; filename=\"" + zipName + ".zip\""));
            Pump.pump((ReadStream)zip, (WriteStream)((WriteStream)context.response().setChunked(true))).start();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

