/*
 * Decompiled with CFR 0.152.
 */
package io.zeko.restapi.core.controllers;

import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.ext.web.RoutingContext;
import io.zeko.db.sql.utilities.DeclarationsKt;
import io.zeko.restapi.core.controllers.ApiController;
import io.zeko.restapi.core.utilities.ControllerKt;
import io.zeko.restapi.core.utilities.zip.TempFile;
import io.zeko.restapi.core.validations.ValidateResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0019\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\r"}, d2={"Lio/zeko/restapi/core/controllers/ProjectInitController;", "Lio/zeko/restapi/core/controllers/ApiController;", "vertx", "Lio/vertx/core/Vertx;", "logger", "Lio/vertx/core/logging/Logger;", "context", "Lio/vertx/ext/web/RoutingContext;", "(Lio/vertx/core/Vertx;Lio/vertx/core/logging/Logger;Lio/vertx/ext/web/RoutingContext;)V", "createNew", "", "ctx", "(Lio/vertx/ext/web/RoutingContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "zeko-restapi"})
public class ProjectInitController
extends ApiController {
    @Nullable
    public Object createNew(@NotNull RoutingContext routingContext, @NotNull Continuation<? super Unit> $completion) {
        return ProjectInitController.createNew$suspendImpl(this, routingContext, $completion);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object createNew$suspendImpl(ProjectInitController this_, RoutingContext ctx, Continuation $completion) {
        ValidateResult res = ApiController.validateInput$default(this_, 0, 1, null);
        if (!res.getSuccess()) {
            return Unit.INSTANCE;
        }
        String packageName = String.valueOf(res.getValues().get("package_name"));
        String artifactId = String.valueOf(res.getValues().get("artifact_id"));
        String groupId = String.valueOf(res.getValues().get("group_id"));
        String version = String.valueOf(res.getValues().get("version"));
        String dbDriver = String.valueOf(res.getValues().get("db_driver"));
        Map drivers = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"jasync", (Object)"Jasync"), TuplesKt.to((Object)"hikari", (Object)"Hikari"), TuplesKt.to((Object)"vertx", (Object)"Vertx")});
        dbDriver = Intrinsics.stringPlus((String)((String)drivers.get(dbDriver)), (Object)"");
        String dbUrl = String.valueOf(res.getValues().get("jdbc_url"));
        String jwtKey = String.valueOf(res.getValues().get("jwt_key"));
        String jwtRefreshKey = String.valueOf(res.getValues().get("jwt_refresh_key"));
        String jwtExpiry = String.valueOf(res.getValues().get("jwt_expiry"));
        String jwtRefreshExpiry = String.valueOf(res.getValues().get("jwt_refresh_expiry"));
        String jwtRefreshWhenExpire = String.valueOf(res.getValues().get("jwt_refresh_when_expire"));
        String httpPort = String.valueOf(res.getValues().get("http_port"));
        List controllers = StringsKt.split$default((CharSequence)String.valueOf(res.getValues().get("controllers")), (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
        String clsDb = StringsKt.trimIndent((String)("\npackage " + packageName + "\n\nimport io.vertx.core.Vertx\nimport io.vertx.core.logging.Logger\nimport io.vertx.kotlin.core.json.json\nimport io.vertx.kotlin.core.json.obj\nimport io.zeko.db.sql.connections.*\n\nclass DB {\n    private var vertx: Vertx\n    private var connPool: " + dbDriver + "DBPool\n    private var dbLogger: DBLogger\n\n    constructor(vertx: Vertx, logger: Logger) {\n        this.vertx = vertx\n\n        val dbConfig = json {\n            obj(\n                    \"url\" to \"" + dbUrl + "\",\n                    \"max_pool_size\" to 30\n            )\n        }\n\n        dbLogger = AppDBLog(logger)\n        connPool = " + dbDriver + "DBPool(dbConfig)\n    }\n\n    suspend fun session(): DBSession = " + dbDriver + "DBSession(connPool, connPool.createConnection()).setQueryLogger(dbLogger)\n}\n        "));
        String clsAppDbLog = StringsKt.trimIndent((String)("\npackage " + packageName + "\n\nimport io.vertx.core.logging.Logger\nimport io.zeko.db.sql.connections.DBLogLevel\nimport io.zeko.db.sql.connections.DBLogger\n\nclass AppDBLog(val logger: Logger): DBLogger {\n    var paramsLevel: DBLogLevel = DBLogLevel.DEBUG\n    var sqlLevel: DBLogLevel = DBLogLevel.DEBUG\n\n    override fun logQuery(sql: String, params: List<Any?>?) {\n        if (sqlLevel.level >= DBLogLevel.DEBUG.level) {\n            logger.debug(\"[SQL] $sql\")\n        }\n        if (paramsLevel.level >= DBLogLevel.DEBUG.level && params != null) {\n            logger.debug(\"[SQL_PARAM] $params\")\n        }\n    }\n\n    override fun logRetry(numRetriesLeft: Int, err: Exception) {\n        logger.warn(\"[SQL_RETRY:$numRetriesLeft] $err\")\n    }\n\n    override fun logUnsupportedSql(err: Exception) {\n        logger.warn(\"[SQL_UNSUPPORTED] $err\")\n    }\n\n    override fun logError(err: Exception) {\n        logger.error(\"[SQL_ERROR] $err\")\n    }\n\n    override fun getParamsLogLevel(): DBLogLevel {\n        return paramsLevel\n    }\n\n    override fun getSqlLogLevel(): DBLogLevel {\n        return sqlLevel\n    }\n\n    override fun setParamsLogLevel(level: DBLogLevel): DBLogger {\n        this.paramsLevel = level\n        return this\n    }\n\n    override fun setSqlLogLevel(level: DBLogLevel): DBLogger {\n        this.sqlLevel = level\n        return this\n    }\n\n    override fun setLogLevels(sqlLevel: DBLogLevel, paramsLevel: DBLogLevel): DBLogger {\n        this.sqlLevel = sqlLevel\n        this.paramsLevel = paramsLevel\n        return this\n    }\n}\n        "));
        String clsKoinFactory = StringsKt.trimIndent((String)("\npackage " + packageName + "\n\nimport io.vertx.core.Verticle\nimport io.vertx.core.spi.VerticleFactory\nimport org.koin.standalone.KoinComponent\nimport org.koin.standalone.get\n\nobject KoinVerticleFactory : VerticleFactory, KoinComponent {\n    override fun prefix(): String = \"koin\"\n\n    override fun createVerticle(verticleName: String, classLoader: ClassLoader): Verticle {\n        return get(clazz = Class.forName(verticleName.substringAfter(\"koin:\")).kotlin)\n    }\n}\n        "));
        String clsBootstrap = StringsKt.trimIndent((String)("\npackage " + packageName + "\n\nimport com.fasterxml.jackson.databind.PropertyNamingStrategy\nimport com.fasterxml.jackson.databind.SerializationFeature\nimport com.fasterxml.jackson.datatype.jsr310.JavaTimeModule\nimport io.vertx.core.AbstractVerticle\nimport io.vertx.core.DeploymentOptions\nimport io.vertx.core.Vertx\nimport io.vertx.core.VertxOptions\nimport io.vertx.core.json.Json\nimport io.vertx.core.logging.LoggerFactory\nimport io.vertx.ext.auth.PubSecKeyOptions\nimport io.vertx.ext.auth.jwt.JWTAuth\nimport io.vertx.ext.auth.jwt.JWTAuthOptions\nimport org.koin.core.Koin\nimport org.koin.dsl.module.module\nimport org.koin.log.EmptyLogger\nimport org.koin.standalone.StandAloneContext\n\nclass BootstrapVerticle : AbstractVerticle() {\n    companion object {\n        @JvmStatic\n        fun main(args: Array<String>) {\n            val vertx = Vertx.vertx(VertxOptions().setHAEnabled(false))\n            vertx.deployVerticle(BootstrapVerticle())\n        }\n    }\n\n    override fun start() {\n        val logger = LoggerFactory.getLogger(\"app\")\n        logger.info(\"STARTING APP...\")\n\n        Json.mapper.registerModule(JavaTimeModule())\n        Json.mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false)\n        Json.mapper.propertyNamingStrategy = PropertyNamingStrategy.SNAKE_CASE\n\n        //set JWT keys for auth\n        val jwtAuthKeys = listOf(\n                PubSecKeyOptions().setAlgorithm(\"HS256\").setPublicKey(\"" + jwtKey + "\").setSymmetric(true)\n        )\n        val jwtOpt = JWTAuthOptions().setPubSecKeys(jwtAuthKeys)\n        var jwtAuth = JWTAuth.create(vertx, jwtOpt)\n\n        val jwtRefreshOpt = JWTAuthOptions().setPubSecKeys(listOf(\n                PubSecKeyOptions().setAlgorithm(\"HS256\").setPublicKey(\"" + jwtRefreshKey + "\").setSymmetric(true)\n        ))\n        var jwtAuthRefresh = JWTAuth.create(vertx, jwtRefreshOpt)\n\n        val appModules = listOf(module {\n            single { vertx }\n            single { logger }\n            single { DB(vertx, get()) }\n            single(\"jwtAuth\") { jwtAuth }\n            single(\"jwtAuthRefresh\") { jwtAuthRefresh }\n            factory { RestApiVerticle() }\n        })\n\n        StandAloneContext.stopKoin()\n        StandAloneContext.startKoin(appModules)\n        Koin.logger = EmptyLogger()\n\n        vertx.registerVerticleFactory(KoinVerticleFactory)\n        vertx.deployVerticle(\n                \"${KoinVerticleFactory.prefix()}:${RestApiVerticle::class.java.canonicalName}\",\n                DeploymentOptions().setInstances(1)\n        )\n    }\n}\n        "));
        String clsRestApi = StringsKt.trimIndent((String)("\npackage " + packageName + "\n\nimport io.vertx.core.logging.Logger\nimport io.vertx.ext.auth.jwt.JWTAuth\nimport io.vertx.ext.web.Router\nimport io.vertx.ext.web.handler.BodyHandler\nimport io.vertx.ext.web.handler.TimeoutHandler\nimport io.zeko.restapi.core.security.JWTAuthHandler\nimport io.zeko.restapi.core.security.JWTAuthRefreshHandler\nimport io.zeko.restapi.core.verticles.ZekoVerticle\nimport org.koin.standalone.KoinComponent\nimport org.koin.standalone.inject\n\nclass RestApiVerticle : ZekoVerticle(), KoinComponent {\n    val jwtAuth: JWTAuth by inject(\"jwtAuth\")\n    val jwtAuthRefresh: JWTAuth by inject(\"jwtAuthRefresh\")\n    val logger: Logger by inject()\n\n    val skipAuth = listOf(\"/user/login\", \"/user/register\", \"/user/refresh-token\", \"/ping-health\")\n\n    override suspend fun start() {\n        val router = Router.router(vertx)\n        router.route().handler(BodyHandler.create());\n        router.route().handler(TimeoutHandler.create(10000L, 503))\n\n        router.route(\"/*\").handler(JWTAuthHandler(jwtAuth, skipAuth))\n\n        //auth access token 60s, refresh token 300s, only allow refresh after token expired\n        router.post(\"/user/refresh-token\").handler(JWTAuthRefreshHandler(jwtAuth, jwtAuthRefresh, " + jwtExpiry + ", " + jwtRefreshExpiry + ", " + jwtRefreshWhenExpire + "))\n\n        bindRoutes(\"" + packageName + ".controller.GeneratedRoutes\", router, logger)\n        handleRuntimeError(router, logger)\n\n        //start running cron jobs\n        //startCronJobs(\"" + packageName + ".job.GeneratedCrons\", logger)\n\n        vertx.createHttpServer()\n                .requestHandler(router)\n                .listen(config.getInteger(\"http.port\", " + httpPort + "))\n    }\n}\n        "));
        boolean bl = false;
        HashMap clsControllers = new HashMap();
        for (String route : controllers) {
            String uri;
            String string = StringsKt.replace$default((String)DeclarationsKt.toSnakeCase((String)route), (String)"_", (String)"-", (boolean)false, (int)4, null);
            boolean bl2 = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string2.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
            String name = StringsKt.replace$default((String)route, (String)"-", (String)"_", (boolean)false, (int)4, null);
            name = StringsKt.indexOf$default((CharSequence)name, (String)"_", (int)0, (boolean)false, (int)6, null) > -1 ? StringsKt.capitalize((String)DeclarationsKt.toCamelCase((String)name)) : StringsKt.capitalize((String)name);
            String clsController = StringsKt.trimIndent((String)("\npackage " + packageName + ".controller\n\nimport io.vertx.core.Vertx\nimport io.zeko.restapi.annotation.http.*\nimport io.zeko.restapi.annotation.Params\nimport io.zeko.restapi.core.controllers.ApiController\nimport io.zeko.restapi.core.validations.ValidateResult\nimport io.vertx.core.logging.Logger\nimport io.vertx.ext.web.RoutingContext\nimport org.koin.standalone.KoinComponent\nimport org.koin.standalone.inject\n\n@Routing(\"/" + uri + "\")\nclass " + name + "Controller : KoinComponent, ApiController {\n    constructor(vertx: Vertx, logger: Logger, context: RoutingContext) : super(vertx, logger, context)\n\n    override fun validateInput(statusCode: Int): ValidateResult {\n        return super.validateInput(422)\n    }\n\n//    @GetSuspend(\"/check/:user_id\", \"Check this out\")\n//    @Params([\"user_id => required, isInteger, min;1, max;99999999\"])\n//    suspend fun checThisOut(ctx: RoutingContext) {\n//        val res = validateInput()\n//        if (!res.success) return\n//\n//        val uid = res.values[\"user_id\"].toString().toInt()\n//        val user = userService.getById(uid)\n//        endJson(user)\n//    }\n}            \n            "));
            ((Map)clsControllers).put(name + "Controller", clsController);
        }
        String vertxLogConf = "handlers=java.util.logging.ConsoleHandler,java.util.logging.FileHandler\njava.util.logging.SimpleFormatter.format=[%1$tF %1$tT] [%4$s] %5$s %6$s\\n\n#java.util.logging.SimpleFormatter.format=%5$s %6$s\\n\njava.util.logging.ConsoleHandler.formatter=java.util.logging.SimpleFormatter\njava.util.logging.ConsoleHandler.level=FINE\njava.util.logging.FileHandler.level=FINE\njava.util.logging.FileHandler.formatter=io.vertx.core.logging.impl.VertxLoggerFormatter\n\n# Put the log in the system temporary directory\njava.util.logging.FileHandler.pattern=%t/vertx.log\n\n.level=FINE\nio.vertx.level=FINE\ncom.hazelcast.level=SEVERE\nio.netty.util.internal.PlatformDependent.level=SEVERE";
        String runSh = StringsKt.trimIndent((String)("\nmvn clean compile vertx:run -Dvertx.verticle=\"" + packageName + ".BootstrapVerticle\" \\\n    -Dvertx.jvmArguments=\"-Djava.util.logging.config.file=vertx_conf/logging.properties\" \\\n    -Dvertx.runArgs=\"--redeploy-grace-period=5 --redeploy=src/main/kotlin/**/*\"\n#    -Dvertx.disableDnsResolver=true\n#    -Dvertx.runArgs=\"-cluster\"\n        "));
        String buildDockerSh = "mvn compile jib:dockerBuild";
        String pom = StringsKt.trimIndent((String)("\n<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\"\n         xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\n    <modelVersion>4.0.0</modelVersion>\n\n    <groupId>" + groupId + "</groupId>\n    <artifactId>" + artifactId + "</artifactId>\n    <version>" + version + "</version>\n\n    <properties>\n        <vertx.verticle>" + packageName + ".BootstrapVerticle</vertx.verticle>\n        <kotlin.version>1.3.61</kotlin.version>\n        <zeko-restapi.version>1.1.4</zeko-restapi.version>\n        <vertx.version>3.9.0</vertx.version>\n        <micrometer.version>1.1.0</micrometer.version>\n        <java.version>1.8</java.version>\n        <jib.version>2.2.0</jib.version>\n\n        <kotlin.compiler.incremental>true</kotlin.compiler.incremental>\n        <kotlin.compiler.jvmTarget>1.8</kotlin.compiler.jvmTarget>\n        <maven.compiler.source>1.8</maven.compiler.source>\n        <maven.compiler.target>1.8</maven.compiler.target>\n\n        <junit-jupiter.version>5.2.0</junit-jupiter.version>\n        <junit-platform-surefire-provider.version>1.2.0</junit-platform-surefire-provider.version>\n        <junit-platform-launcher.version>1.2.0</junit-platform-launcher.version>\n        <spek.version>2.0.9</spek.version>\n        <jupiter.version>5.2.0</jupiter.version>\n    </properties>\n\n    <repositories>\n        <repository>\n            <id>jcenter</id>\n            <url>https://jcenter.bintray.com/</url>\n        </repository>\n        <repository>\n            <id>spek-dev</id>\n            <url>https://dl.bintray.com/spekframework/spek-dev</url>\n        </repository>\n        <repository>\n            <id>jitpack.io</id>\n            <url>https://jitpack.io</url>\n        </repository>\n    </repositories>\n\n    <dependencyManagement>\n        <dependencies>\n            <dependency>\n                <groupId>io.vertx</groupId>\n                <artifactId>vertx-stack-depchain</artifactId>\n                <version>${vertx.version}</version>\n                <type>pom</type>\n                <scope>import</scope>\n            </dependency>\n        </dependencies>\n    </dependencyManagement>\n\n    <dependencies>\n        <dependency>\n            <groupId>io.zeko</groupId>\n            <artifactId>zeko-restapi</artifactId>\n            <version>${zeko-restapi.version}</version>\n        </dependency>\n        <dependency>\n            <groupId>org.jetbrains.kotlinx</groupId>\n            <artifactId>kotlinx-coroutines-core</artifactId>\n            <version>1.3.3</version>\n        </dependency>\n\n        <dependency>\n            <groupId>com.fasterxml.jackson.core</groupId>\n            <artifactId>jackson-core</artifactId>\n            <version>2.10.0</version>\n        </dependency>\n        <dependency>\n            <groupId>com.fasterxml.jackson.core</groupId>\n            <artifactId>jackson-databind</artifactId>\n            <version>2.10.0</version>\n        </dependency>\n        <dependency>\n            <groupId>com.fasterxml.jackson.module</groupId>\n            <artifactId>jackson-module-kotlin</artifactId>\n            <version>2.10.2</version>\n        </dependency>\n        <dependency>\n            <groupId>com.fasterxml.jackson.module</groupId>\n            <artifactId>jackson-module-parameter-names</artifactId>\n            <version>2.10.0</version>\n        </dependency>\n        <dependency>\n            <groupId>com.fasterxml.jackson.datatype</groupId>\n            <artifactId>jackson-datatype-jdk8</artifactId>\n            <version>2.10.0</version>\n        </dependency>\n        <dependency>\n            <groupId>com.fasterxml.jackson.datatype</groupId>\n            <artifactId>jackson-datatype-jsr310</artifactId>\n            <version>2.10.0</version>\n        </dependency>\n\n        <dependency>\n            <groupId>org.koin</groupId>\n            <artifactId>koin-core</artifactId>\n            <version>1.0.2</version>\n        </dependency>\n\n        <!-- Test dependencies-->\n        <dependency>\n            <groupId>io.vertx</groupId>\n            <artifactId>vertx-junit5</artifactId>\n            <version>${vertx.version}</version>\n            <scope>test</scope>\n        </dependency>\n        <dependency>\n            <groupId>org.junit.platform</groupId>\n            <artifactId>junit-platform-launcher</artifactId>\n            <version>${junit-platform-launcher.version}</version>\n            <scope>test</scope>\n        </dependency>\n        <dependency>\n            <groupId>org.junit.jupiter</groupId>\n            <artifactId>junit-jupiter-api</artifactId>\n            <version>${jupiter.version}</version>\n            <scope>test</scope>\n        </dependency>\n        <dependency>\n            <groupId>org.spekframework.spek2</groupId>\n            <artifactId>spek-dsl-jvm</artifactId>\n            <version>${spek.version}</version>\n            <scope>test</scope>\n        </dependency>\n        <dependency>\n            <groupId>org.spekframework.spek2</groupId>\n            <artifactId>spek-runner-junit5</artifactId>\n            <version>${spek.version}</version>\n            <scope>test</scope>\n        </dependency>\n    </dependencies>\n\n    <build>\n        <sourceDirectory>${project.basedir}/src/main/kotlin</sourceDirectory>\n        <testSourceDirectory>src/test/kotlin</testSourceDirectory>\n\n        <plugins>\n            <plugin>\n                <artifactId>maven-surefire-plugin</artifactId>\n                <version>2.22.0</version>\n                <dependencies>\n                    <dependency>\n                        <groupId>org.junit.platform</groupId>\n                        <artifactId>junit-platform-surefire-provider</artifactId>\n                        <version>1.2.0</version>\n                    </dependency>\n                    <dependency>\n                        <groupId>org.junit.jupiter</groupId>\n                        <artifactId>junit-jupiter-engine</artifactId>\n                        <version>${jupiter.version}</version>\n                    </dependency>\n                </dependencies>\n                <configuration>\n                    <includes>\n                        <include>**/*Spec.*</include>\n                    </includes>\n                </configuration>\n            </plugin>\n\n            <plugin>\n                <groupId>io.reactiverse</groupId>\n                <artifactId>vertx-maven-plugin</artifactId>\n                <version>1.0.18</version>\n                <executions>\n                    <execution>\n                        <id>vmp</id>\n                        <goals>\n                            <goal>initialize</goal>\n                            <goal>package</goal>\n                        </goals>\n                    </execution>\n                </executions>\n\n                <configuration>\n                    <redeploy>true</redeploy>\n                    <jvmArgs>\n                        <jvmArg>-Djava.util.logging.config.file=vertx_conf/logging.properties</jvmArg>\n                    </jvmArgs>\n                </configuration>\n            </plugin>\n\n            <plugin>\n                <artifactId>kotlin-maven-plugin</artifactId>\n                <groupId>org.jetbrains.kotlin</groupId>\n                <version>${kotlin.version}</version>\n\n                <executions>\n                    <execution>\n                        <id>kapt</id>\n                        <goals>\n                            <goal>kapt</goal>\n                        </goals>\n                        <configuration>\n                            <sourceDirs>\n                                <sourceDir>src/main/kotlin</sourceDir>\n                            </sourceDirs>\n\n                            <annotationProcessorPaths>\n                                <annotationProcessorPath>\n                                    <groupId>io.zeko</groupId>\n                                    <artifactId>zeko-restapi</artifactId>\n                                    <version>${zeko-restapi.version}</version>\n                                </annotationProcessorPath>\n                            </annotationProcessorPaths>\n\n                            <annotationProcessors>\n                                <annotationProcessor>io.zeko.restapi.annotation.codegen.RouteSchemaGenerator</annotationProcessor>\n                            </annotationProcessors>\n\n                            <annotationProcessorArgs>\n                                <processorArg>swagger.apiVersion=" + version + "</processorArg>\n                                <processorArg>swagger.title=Your Rest API</processorArg>\n                                <processorArg>swagger.description=This is a RESTful API</processorArg>\n                                <processorArg>swagger.host=localhost</processorArg>\n                                <processorArg>swagger.basePath=/</processorArg>\n                                <processorArg>swagger.sampleResultDir=/Users/you/Documents/" + artifactId + "/api-results</processorArg>\n                                <processorArg>swagger.outputFile=/Users/you/Documents/" + artifactId + "/api-doc/swagger.json</processorArg>\n                                <processorArg>swagger.cmpSchemaDir=/Users/you/Documents/" + artifactId + "/api-schemas</processorArg>\n                                <processorArg>default.produces=application/json</processorArg>\n                                <processorArg>default.consumes=application/x-www-form-urlencoded</processorArg>\n                            </annotationProcessorArgs>\n                        </configuration>\n                    </execution>\n\n                    <execution>\n                        <id>compile</id>\n                        <goals>\n                            <goal>compile</goal>\n                        </goals>\n                        <configuration>\n                            <sourceDirs>\n                                <sourceDir>${project.basedir}/src/main/kotlin</sourceDir>\n                                <!-- If you need to mix it with Java -->\n                                <sourceDir>${project.basedir}/src/main/java</sourceDir>\n                            </sourceDirs>\n                            <experimentalCoroutines>enable</experimentalCoroutines>\n                        </configuration>\n                    </execution>\n                </executions>\n            </plugin>\n\n            <plugin>\n                <groupId>com.google.cloud.tools</groupId>\n                <artifactId>jib-maven-plugin</artifactId>\n                <version>${jib.version}</version>\n                <configuration>\n                    <extraDirectories>\n                        <paths>vertx_conf</paths>\n                    </extraDirectories>\n                    <allowInsecureRegistries>true</allowInsecureRegistries>\n                    <container>\n                        <mainClass>${vertx.verticle}</mainClass>\n                    </container>\n                    <to>\n                        <image>" + groupId + '/' + artifactId + "</image>\n                        <tags>\n                            <tag>latest</tag>\n                            <tag>${version}</tag>\n                        </tags>\n                    </to>\n                </configuration>\n            </plugin>\n        </plugins>\n    </build>\n</project>\n        "));
        ArrayList classes = CollectionsKt.arrayListOf((Object[])new String[]{clsDb, clsAppDbLog, clsKoinFactory, clsRestApi, clsBootstrap});
        ArrayList classNames = CollectionsKt.arrayListOf((Object[])new String[]{"DB", "AppDbLog", "KoinVerticleFactory", "RestApiVerticle", "BootstrapVerticle"});
        Object object = clsControllers;
        boolean bl3 = false;
        for (Map.Entry entry : object.entrySet()) {
            void name;
            Object object2 = entry;
            boolean bl4 = false;
            object = (String)object2.getKey();
            object2 = entry;
            bl4 = false;
            String content = (String)object2.getValue();
            classes.add(content);
            classNames.add("controller/" + (String)name);
        }
        boolean bl5 = false;
        ArrayList<TempFile> files = new ArrayList<TempFile>();
        Iterable $this$forEachIndexed$iv = classNames;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void cls;
            int n = index$iv++;
            boolean bl6 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            String string = (String)item$iv;
            int index = ((Number)Boxing.boxInt((int)n2)).intValue();
            boolean bl7 = false;
            String fileName = artifactId + "/src/main/kotlin/" + CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)packageName, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null) + '/' + (String)cls + ".kt";
            Object e = classes.get(index);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"classes[index]");
            files.add(new TempFile(fileName, (String)e));
        }
        files.add(new TempFile(artifactId + "/vertx_conf/logging.properties", vertxLogConf));
        files.add(new TempFile(artifactId + "/run.sh", runSh));
        files.add(new TempFile(artifactId + "/build-docker-image.sh", buildDockerSh));
        files.add(new TempFile(artifactId + "/pom.xml", pom));
        ControllerKt.downloadZip(this_.getContext(), this_.getVertx(), artifactId, (List<TempFile>)files);
        return Unit.INSTANCE;
    }

    public ProjectInitController(@NotNull Vertx vertx, @NotNull Logger logger, @NotNull RoutingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)vertx, (String)"vertx");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(vertx, logger, context);
    }
}

