package io.fincast.portfolio.impl

import io.fincast.portfolio.SimDate
import io.fincast.portfolio.ValueProvider
import io.fincast.enums.FundsAllocation
import io.fincast.portfolio.Position
import io.fincast.enums.BookingKind
import io.fincast.enums.Periodicity

data class YieldCompo(
	override val position: Position,
	override val tag: String,
	val amount: ValueProvider<Double>, // eomBalance, eomCreditBalance, eomDebitBalance
	val yieldRate: ValueProvider<Double>,
	val yieldPeriodicity: Periodicity,
	val bookingKind: BookingKind,
	val fundsAllocation: FundsAllocation,
) : PositionCompoBase() {

	override fun handleLifecycle(date: SimDate) {
		val amount = amount.getValue(date)
		val yieldRate = yieldRate.getValue(date)
		val yield = amount * yieldRate / 100 / Periodicity.MONTHS_IN_YEAR
		addYield(yield)
		if (yieldPeriodicity.isCashflowDate(date)) {
			bookYield(date, bookingKind, fundsAllocation)
		}
	}

}
