package io.fincast.portfolio.impl

import io.fincast.enums.FundsAllocation
import io.fincast.portfolio.SimDate
import io.fincast.enums.BookingKind
import io.fincast.portfolio.Position
import io.fincast.portfolio.PositionCompo

abstract class PositionCompoBase : PositionCompo {

	private var yield = 0.0

	fun bookCashflow(date: SimDate, amount: Double, fundsAllocation: FundsAllocation) {
		if (amount != 0.0) {
			if (fundsAllocation == FundsAllocation.DISBURSE) {
				portfolio.pocketMoney.bookTurnover(date, BookingKind.TURNOVER, amount, this)
			} else {
				position.bookTurnover(date, BookingKind.TURNOVER, amount, this)
			}
			portfolio.externalMoney.bookTurnover(date, BookingKind.TURNOVER, -amount, this)
		}
	}

	fun bookTransfer(date: SimDate, from: Position, to: Position, amount: Double) {
		if (amount != 0.0) {
			from.bookTurnover(date, BookingKind.TRANSFER, amount, this)
			to.bookTurnover(date, BookingKind.TRANSFER, -amount, this)
		}
	}

	fun addYield(yield: Double) {
		this.yield += yield
	}

	override fun getYield(): Double {
		return this.yield
	}

	fun bookYield(date: SimDate, bookingKind: BookingKind, fundsAllocation: FundsAllocation) {
		if (yield != 0.0) {
			portfolio.externalMoney.bookTurnover(date, bookingKind, -yield, this)
			if (fundsAllocation == FundsAllocation.COMPOUND) {
				position.bookTurnover(date, bookingKind, yield, this)
			} else {
				portfolio.pocketMoney.bookTurnover(date, bookingKind, yield, this)
			}
			yield = 0.0
		}
	}

}
