package io.fincast.portfolio

object ValueProviders {

	fun <T> constValue(value: T): ValueProvider<T> {
		return ValueProvider { value }
	}

	fun eomBalance(pos: Position): ValueProvider<Double> {
		return ValueProvider { date ->
			return@ValueProvider pos.getBalance(date - 1)
		}
	}

	fun eomCreditBalance(pos: Position): ValueProvider<Double> {
		return ValueProvider { date ->
			val eomBalance = pos.getBalance(date - 1)
			return@ValueProvider eomBalance.coerceAtLeast(0.0)
		}
	}

	fun eomDebitBalance(pos: Position): ValueProvider<Double> {
		return ValueProvider { date ->
			val eomBalance = pos.getBalance(date - 1)
			return@ValueProvider eomBalance.coerceAtMost(0.0)
		}
	}

}
