package io.fincast.household.impl

import io.fincast.household.Contract
import io.fincast.enums.FundsAllocation
import io.fincast.enums.ProductType
import io.fincast.portfolio.*
import io.fincast.enums.Periodicity
import io.fincast.portfolio.ValueProviders.constValue
import io.fincast.portfolio.impl.CashflowCompo

data class Salary(
	override val tag: String,
	val amount: Double,
	val periodicity: Periodicity = Periodicity.YEARLY,
	override val startDate: SimDate? = null,
	override val endDate: SimDate? = null,
) : Contract {

	override val productType = ProductType.INCOME

	class Builder {
		private var tag: String? = null
		private var amount: Double? = null
		private var periodicity: Periodicity? = null
		private var startDate: SimDate? = null
		private var endDate: SimDate? = null
		fun tag(tag: String) = apply { this.tag = tag }
		fun amount(amount: Double) = apply { this.amount = amount }
		fun periodicity(periodicity: Periodicity) = apply { this.periodicity = periodicity }
		fun startDate(startDate: SimDate) = apply { this.startDate = startDate }
		fun endDate(endDate: SimDate) = apply { this.endDate = endDate }
		fun build(): Salary {
			return Salary(
				tag = tag ?: throw IllegalArgumentException("tag is required"),
				amount = amount ?: throw IllegalArgumentException("amount is required"),
				periodicity = periodicity ?: Periodicity.YEARLY,
				startDate = startDate,
				endDate = endDate,
			)
		}
	}

	override fun createCompos(portfolio: Portfolio, pos: Position): List<PositionCompo> {
		val startDate = SimDate.max(startDate ?: portfolio.reconDate, portfolio.reconDate)
		val cf = CashflowCompo(
			position = pos,
			tag = "income",
			fundsAllocation = FundsAllocation.DISBURSE,
			amount = constValue(amount / periodicity.months),
			sign = 1,
			startDate = startDate,
			endDate = endDate,
			periodicity = Periodicity.MONTHLY,
		)
		return listOf(cf)
	}

}
