/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.household;

import io.fincast.engine.SimDate;
import io.fincast.enums.Gender;
import io.fincast.enums.Religion;
import io.fincast.household.impl.PersonImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\f\bf\u0018\u00002\u00020\u0001:\u0001 J\b\u0010\u0018\u001a\u00020\u0011H\u0016J\b\u0010\u0019\u001a\u00020\u0003H\u0016J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0003H\u0016J\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u00032\b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u0016J\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u00032\b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010\u001f\u001a\u00020\u0011H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00020\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006!"}, d2={"Lio/fincast/household/Person;", "", "birthDate", "Lio/fincast/engine/SimDate;", "getBirthDate", "()Lio/fincast/engine/SimDate;", "deathDate", "getDeathDate", "registeredGender", "Lio/fincast/enums/Gender;", "getRegisteredGender", "()Lio/fincast/enums/Gender;", "religiousAffiliation", "Lio/fincast/enums/Religion;", "getReligiousAffiliation", "()Lio/fincast/enums/Religion;", "retirementAge", "", "getRetirementAge", "()Ljava/lang/Integer;", "tag", "", "getTag", "()Ljava/lang/String;", "getActualRetirementAge", "getActualRetirementDate", "getAgeAt", "date", "getEndOfExpenseDate", "endDate", "getEndOfSalaryDate", "getStatutoryRetirementAge", "Builder", "fincast"})
public interface Person {
    @NotNull
    public String getTag();

    @NotNull
    public SimDate getBirthDate();

    @NotNull
    public Gender getRegisteredGender();

    @NotNull
    public Religion getReligiousAffiliation();

    @Nullable
    public Integer getRetirementAge();

    @Nullable
    public SimDate getDeathDate();

    public int getAgeAt(@NotNull SimDate var1);

    @NotNull
    public SimDate getActualRetirementDate();

    public int getActualRetirementAge();

    public int getStatutoryRetirementAge();

    @Nullable
    public SimDate getEndOfSalaryDate(@Nullable SimDate var1);

    @Nullable
    public SimDate getEndOfExpenseDate(@Nullable SimDate var1);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0005\u001a\u00020\u00002\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u0015\u0010\n\u001a\u00020\u00002\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/fincast/household/Person$Builder;", "", "()V", "birthDate", "Lio/fincast/engine/SimDate;", "deathDate", "registeredGender", "Lio/fincast/enums/Gender;", "religiousAffiliation", "Lio/fincast/enums/Religion;", "retirementAge", "", "Ljava/lang/Integer;", "tag", "", "build", "Lio/fincast/household/Person;", "(Ljava/lang/Integer;)Lio/fincast/household/Person$Builder;", "fincast"})
    @SourceDebugExtension(value={"SMAP\nPerson.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Person.kt\nio/fincast/household/Person$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1#2:120\n*E\n"})
    public static final class Builder {
        @Nullable
        private String tag;
        @Nullable
        private SimDate birthDate;
        @Nullable
        private Gender registeredGender;
        @Nullable
        private Religion religiousAffiliation;
        @Nullable
        private Integer retirementAge;
        @Nullable
        private SimDate deathDate;

        @NotNull
        public final Builder tag(@NotNull String tag) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Builder $this$tag_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$tag_u24lambda_u240.tag = tag;
            return builder;
        }

        @NotNull
        public final Builder birthDate(@NotNull SimDate birthDate) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)birthDate, (String)"birthDate");
            Builder $this$birthDate_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$birthDate_u24lambda_u241.birthDate = birthDate;
            return builder;
        }

        @NotNull
        public final Builder registeredGender(@NotNull Gender registeredGender) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)registeredGender), (String)"registeredGender");
            Builder $this$registeredGender_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$registeredGender_u24lambda_u242.registeredGender = registeredGender;
            return builder;
        }

        @NotNull
        public final Builder religiousAffiliation(@NotNull Religion religiousAffiliation) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)religiousAffiliation), (String)"religiousAffiliation");
            Builder $this$religiousAffiliation_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$religiousAffiliation_u24lambda_u243.religiousAffiliation = religiousAffiliation;
            return builder;
        }

        @NotNull
        public final Builder retirementAge(@Nullable Integer retirementAge) {
            Builder builder;
            Builder $this$retirementAge_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$retirementAge_u24lambda_u244.retirementAge = retirementAge;
            return builder;
        }

        @NotNull
        public final Builder deathDate(@Nullable SimDate deathDate) {
            Builder builder;
            Builder $this$deathDate_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$deathDate_u24lambda_u245.deathDate = deathDate;
            return builder;
        }

        @NotNull
        public final Person build() {
            String string = this.tag;
            if (string == null) {
                throw new IllegalArgumentException("tag is required");
            }
            SimDate simDate = this.birthDate;
            if (simDate == null) {
                throw new IllegalArgumentException("birthDate is required");
            }
            Gender gender = this.registeredGender;
            if (gender == null) {
                throw new IllegalArgumentException("registeredGender is required");
            }
            Religion religion = this.religiousAffiliation;
            if (religion == null) {
                religion = Religion.OTHER;
            }
            return new PersonImpl(string, simDate, gender, religion, this.retirementAge, this.deathDate);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static int getAgeAt(@NotNull Person $this, @NotNull SimDate date) {
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            return date.minus($this.getBirthDate()) / 12;
        }

        @NotNull
        public static SimDate getActualRetirementDate(@NotNull Person $this) {
            return $this.getBirthDate().plus($this.getActualRetirementAge() * 12);
        }

        public static int getActualRetirementAge(@NotNull Person $this) {
            Integer n = $this.getRetirementAge();
            return n != null ? n.intValue() : $this.getStatutoryRetirementAge();
        }

        public static int getStatutoryRetirementAge(@NotNull Person $this) {
            return $this.getRegisteredGender() == Gender.FEMALE ? 64 : 65;
        }

        @Nullable
        public static SimDate getEndOfSalaryDate(@NotNull Person $this, @Nullable SimDate endDate) {
            SimDate deathDate = $this.getDeathDate();
            SimDate retirementDate = $this.getActualRetirementDate();
            if (endDate == null) {
                if (deathDate != null) {
                    return SimDate.Companion.min(retirementDate, deathDate);
                }
                return retirementDate;
            }
            return deathDate != null ? SimDate.Companion.min(endDate, deathDate) : endDate;
        }

        @Nullable
        public static SimDate getEndOfExpenseDate(@NotNull Person $this, @Nullable SimDate endDate) {
            SimDate deathDate = $this.getDeathDate();
            return endDate == null ? deathDate : (deathDate != null ? SimDate.Companion.min(endDate, deathDate) : endDate);
        }
    }
}

