/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.household;

import io.fincast.engine.SimDate;
import io.fincast.enums.CivilStatus;
import io.fincast.holding.Holding;
import io.fincast.holding.impl.core.BankAccount;
import io.fincast.holding.impl.core.Investment;
import io.fincast.household.Person;
import io.fincast.household.impl.HouseholdImpl;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u0000 ,2\u00020\u0001:\u0002+,J\u0012\u0010(\u001a\u0004\u0018\u00010\u000b2\u0006\u0010)\u001a\u00020*H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00020\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019R\u0012\u0010\u001c\u001a\u00020\u001dX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u0004\u0018\u00010!X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0012\u0010$\u001a\u00020%X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006-"}, d2={"Lio/fincast/household/Household;", "", "bufferInvestment", "Lio/fincast/holding/impl/core/Investment;", "getBufferInvestment", "()Lio/fincast/holding/impl/core/Investment;", "civilStatus", "Lio/fincast/enums/CivilStatus;", "getCivilStatus", "()Lio/fincast/enums/CivilStatus;", "externalCash", "Lio/fincast/holding/Holding;", "getExternalCash", "()Lio/fincast/holding/Holding;", "holdings", "", "getHoldings", "()Ljava/util/List;", "internalCash", "Lio/fincast/holding/impl/core/BankAccount;", "getInternalCash", "()Lio/fincast/holding/impl/core/BankAccount;", "partner1", "Lio/fincast/household/Person;", "getPartner1", "()Lio/fincast/household/Person;", "partner2", "getPartner2", "reconDate", "Lio/fincast/engine/SimDate;", "getReconDate", "()Lio/fincast/engine/SimDate;", "targetCashBalance", "", "getTargetCashBalance", "()Ljava/lang/Double;", "zip", "", "getZip", "()I", "getHoldingByTag", "tag", "", "Builder", "Companion", "fincast"})
public interface Household {
    @NotNull
    public static final Companion Companion = io.fincast.household.Household$Companion.$$INSTANCE;
    @NotNull
    public static final String EXTERNAL_CASH_TAG = "#externalCash";

    public int getZip();

    @NotNull
    public CivilStatus getCivilStatus();

    @NotNull
    public Person getPartner1();

    @Nullable
    public Person getPartner2();

    @NotNull
    public SimDate getReconDate();

    @NotNull
    public List<Holding> getHoldings();

    @NotNull
    public BankAccount getInternalCash();

    @NotNull
    public Investment getBufferInvestment();

    @Nullable
    public Double getTargetCashBalance();

    @NotNull
    public Holding getExternalCash();

    @Nullable
    public Holding getHoldingByTag(@NotNull String var1);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010\u0007\u001a\u00020\u00002\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u0015\u0010\u0011\u001a\u00020\u00002\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0019J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016\u00a8\u0006\u001a"}, d2={"Lio/fincast/household/Household$Builder;", "", "()V", "bufferInvestment", "Lio/fincast/holding/impl/core/Investment;", "civilStatus", "Lio/fincast/enums/CivilStatus;", "holdings", "", "Lio/fincast/holding/Holding;", "internalCash", "Lio/fincast/holding/impl/core/BankAccount;", "partner1", "Lio/fincast/household/Person;", "partner2", "reconDate", "Lio/fincast/engine/SimDate;", "targetCashBalance", "", "Ljava/lang/Double;", "zip", "", "Ljava/lang/Integer;", "build", "Lio/fincast/household/Household;", "(Ljava/lang/Double;)Lio/fincast/household/Household$Builder;", "fincast"})
    @SourceDebugExtension(value={"SMAP\nHousehold.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Household.kt\nio/fincast/household/Household$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
    public static final class Builder {
        @Nullable
        private Integer zip;
        @Nullable
        private CivilStatus civilStatus;
        @Nullable
        private Person partner1;
        @Nullable
        private Person partner2;
        @Nullable
        private SimDate reconDate;
        @NotNull
        private List<? extends Holding> holdings = CollectionsKt.emptyList();
        @Nullable
        private BankAccount internalCash;
        @Nullable
        private Investment bufferInvestment;
        @Nullable
        private Double targetCashBalance;

        @NotNull
        public final Builder zip(int zip) {
            Builder builder;
            Builder $this$zip_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$zip_u24lambda_u240.zip = zip;
            return builder;
        }

        @NotNull
        public final Builder civilStatus(@NotNull CivilStatus civilStatus) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)civilStatus), (String)"civilStatus");
            Builder $this$civilStatus_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$civilStatus_u24lambda_u241.civilStatus = civilStatus;
            return builder;
        }

        @NotNull
        public final Builder partner1(@NotNull Person partner1) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)partner1, (String)"partner1");
            Builder $this$partner1_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$partner1_u24lambda_u242.partner1 = partner1;
            return builder;
        }

        @NotNull
        public final Builder partner2(@NotNull Person partner2) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)partner2, (String)"partner2");
            Builder $this$partner2_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$partner2_u24lambda_u243.partner2 = partner2;
            return builder;
        }

        @NotNull
        public final Builder reconDate(@NotNull SimDate reconDate) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)reconDate, (String)"reconDate");
            Builder $this$reconDate_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$reconDate_u24lambda_u244.reconDate = reconDate;
            return builder;
        }

        @NotNull
        public final Builder holdings(@NotNull List<? extends Holding> holdings) {
            Builder builder;
            Intrinsics.checkNotNullParameter(holdings, (String)"holdings");
            Builder $this$holdings_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$holdings_u24lambda_u245.holdings = holdings;
            return builder;
        }

        @NotNull
        public final Builder internalCash(@NotNull BankAccount internalCash) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)internalCash, (String)"internalCash");
            Builder $this$internalCash_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$internalCash_u24lambda_u246.internalCash = internalCash;
            return builder;
        }

        @NotNull
        public final Builder bufferInvestment(@NotNull Investment bufferInvestment) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)bufferInvestment, (String)"bufferInvestment");
            Builder $this$bufferInvestment_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$bufferInvestment_u24lambda_u247.bufferInvestment = bufferInvestment;
            return builder;
        }

        @NotNull
        public final Builder targetCashBalance(@Nullable Double targetCashBalance) {
            Builder builder;
            Builder $this$targetCashBalance_u24lambda_u248 = builder = this;
            boolean bl = false;
            $this$targetCashBalance_u24lambda_u248.targetCashBalance = targetCashBalance;
            return builder;
        }

        @NotNull
        public final Household build() {
            Integer n = this.zip;
            if (n == null) {
                throw new IllegalArgumentException("zip is required");
            }
            CivilStatus civilStatus = this.civilStatus;
            if (civilStatus == null) {
                throw new IllegalArgumentException("civilStatus is required");
            }
            Person person = this.partner1;
            if (person == null) {
                throw new IllegalArgumentException("partner1 is required");
            }
            SimDate simDate = this.reconDate;
            if (simDate == null) {
                throw new IllegalArgumentException("reconDate is required");
            }
            BankAccount bankAccount = this.internalCash;
            if (bankAccount == null) {
                throw new IllegalArgumentException("internalCash is required");
            }
            Investment investment = this.bufferInvestment;
            if (investment == null) {
                throw new IllegalArgumentException("bufferInvestment is required");
            }
            return new HouseholdImpl(n, civilStatus, person, this.partner2, simDate, this.holdings, bankAccount, investment, this.targetCashBalance);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/fincast/household/Household$Companion;", "", "()V", "EXTERNAL_CASH_TAG", "", "fincast"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        public static final String EXTERNAL_CASH_TAG = "#externalCash";

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

