/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.holding.impl.core;

import io.fincast.compo.FinancialCompo;
import io.fincast.compo.ValueProvider;
import io.fincast.compo.ValueProviders;
import io.fincast.compo.impl.CashflowCompo;
import io.fincast.compo.impl.FlowDirection;
import io.fincast.compo.impl.InterestCompo;
import io.fincast.enums.FundsUtilisation;
import io.fincast.enums.Periodicity;
import io.fincast.enums.ProductType;
import io.fincast.holding.base.ValuableBase;
import io.fincast.household.Person;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b!\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001<B{\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000b\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u000bH\u00c6\u0003J\t\u0010'\u001a\u00020\u0011H\u00c6\u0003J\u000b\u0010(\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010)\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010*\u001a\u00020\bH\u00c6\u0003J\u0010\u0010+\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0016J\t\u0010,\u001a\u00020\u000bH\u00c6\u0003J\u0010\u0010-\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0016J\t\u0010.\u001a\u00020\u000bH\u00c6\u0003J\u0010\u0010/\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0016J\u0086\u0001\u00100\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\r\u001a\u00020\u000b2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\u000f\u001a\u00020\u000b2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u00c6\u0001\u00a2\u0006\u0002\u00101J\u000e\u00102\u001a\b\u0012\u0004\u0012\u00020403H\u0014J\u0013\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u000108H\u00d6\u0003J\t\u00109\u001a\u00020:H\u00d6\u0001J\t\u0010;\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0015\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\r\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u0015\u0010\f\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0019\u0010\u0016R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001fR\u0011\u0010\u000f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0014R\u0015\u0010\u000e\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\"\u0010\u0016R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006="}, d2={"Lio/fincast/holding/impl/core/TangibleAsset;", "Lio/fincast/holding/base/ValuableBase;", "tag", "", "owner", "Lio/fincast/household/Person;", "taxCode", "reconBalance", "", "insuranceRate", "insurancePeriodicity", "Lio/fincast/enums/Periodicity;", "maintenanceRate", "maintenancePeriodicity", "yieldRate", "yieldPeriodicity", "yieldUtilisation", "Lio/fincast/enums/FundsUtilisation;", "(Ljava/lang/String;Lio/fincast/household/Person;Ljava/lang/String;DLjava/lang/Double;Lio/fincast/enums/Periodicity;Ljava/lang/Double;Lio/fincast/enums/Periodicity;Ljava/lang/Double;Lio/fincast/enums/Periodicity;Lio/fincast/enums/FundsUtilisation;)V", "getInsurancePeriodicity", "()Lio/fincast/enums/Periodicity;", "getInsuranceRate", "()Ljava/lang/Double;", "Ljava/lang/Double;", "getMaintenancePeriodicity", "getMaintenanceRate", "getOwner", "()Lio/fincast/household/Person;", "getReconBalance", "()D", "getTag", "()Ljava/lang/String;", "getTaxCode", "getYieldPeriodicity", "getYieldRate", "getYieldUtilisation", "()Lio/fincast/enums/FundsUtilisation;", "component1", "component10", "component11", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Ljava/lang/String;Lio/fincast/household/Person;Ljava/lang/String;DLjava/lang/Double;Lio/fincast/enums/Periodicity;Ljava/lang/Double;Lio/fincast/enums/Periodicity;Ljava/lang/Double;Lio/fincast/enums/Periodicity;Lio/fincast/enums/FundsUtilisation;)Lio/fincast/holding/impl/core/TangibleAsset;", "createCompos", "", "Lio/fincast/compo/FinancialCompo;", "equals", "", "other", "", "hashCode", "", "toString", "Builder", "fincast"})
public final class TangibleAsset
extends ValuableBase {
    @NotNull
    private final String tag;
    @Nullable
    private final Person owner;
    @Nullable
    private final String taxCode;
    private final double reconBalance;
    @Nullable
    private final Double insuranceRate;
    @NotNull
    private final Periodicity insurancePeriodicity;
    @Nullable
    private final Double maintenanceRate;
    @NotNull
    private final Periodicity maintenancePeriodicity;
    @Nullable
    private final Double yieldRate;
    @NotNull
    private final Periodicity yieldPeriodicity;
    @NotNull
    private final FundsUtilisation yieldUtilisation;

    public TangibleAsset(@NotNull String tag, @Nullable Person owner, @Nullable String taxCode, double reconBalance, @Nullable Double insuranceRate, @NotNull Periodicity insurancePeriodicity, @Nullable Double maintenanceRate, @NotNull Periodicity maintenancePeriodicity, @Nullable Double yieldRate, @NotNull Periodicity yieldPeriodicity, @NotNull FundsUtilisation yieldUtilisation) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)insurancePeriodicity), (String)"insurancePeriodicity");
        Intrinsics.checkNotNullParameter((Object)((Object)maintenancePeriodicity), (String)"maintenancePeriodicity");
        Intrinsics.checkNotNullParameter((Object)((Object)yieldPeriodicity), (String)"yieldPeriodicity");
        Intrinsics.checkNotNullParameter((Object)((Object)yieldUtilisation), (String)"yieldUtilisation");
        super(tag, owner, ProductType.ASSET, taxCode, reconBalance);
        this.tag = tag;
        this.owner = owner;
        this.taxCode = taxCode;
        this.reconBalance = reconBalance;
        this.insuranceRate = insuranceRate;
        this.insurancePeriodicity = insurancePeriodicity;
        this.maintenanceRate = maintenanceRate;
        this.maintenancePeriodicity = maintenancePeriodicity;
        this.yieldRate = yieldRate;
        this.yieldPeriodicity = yieldPeriodicity;
        this.yieldUtilisation = yieldUtilisation;
    }

    public /* synthetic */ TangibleAsset(String string, Person person, String string2, double d, Double d2, Periodicity periodicity, Double d3, Periodicity periodicity2, Double d4, Periodicity periodicity3, FundsUtilisation fundsUtilisation, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            person = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            d = 0.0;
        }
        if ((n & 0x10) != 0) {
            d2 = null;
        }
        if ((n & 0x20) != 0) {
            periodicity = Periodicity.YEARLY;
        }
        if ((n & 0x40) != 0) {
            d3 = null;
        }
        if ((n & 0x80) != 0) {
            periodicity2 = Periodicity.YEARLY;
        }
        if ((n & 0x100) != 0) {
            d4 = null;
        }
        if ((n & 0x200) != 0) {
            periodicity3 = Periodicity.YEARLY;
        }
        if ((n & 0x400) != 0) {
            fundsUtilisation = FundsUtilisation.DISBURSE;
        }
        this(string, person, string2, d, d2, periodicity, d3, periodicity2, d4, periodicity3, fundsUtilisation);
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @Override
    @Nullable
    public Person getOwner() {
        return this.owner;
    }

    @Override
    @Nullable
    public String getTaxCode() {
        return this.taxCode;
    }

    @Override
    public double getReconBalance() {
        return this.reconBalance;
    }

    @Nullable
    public final Double getInsuranceRate() {
        return this.insuranceRate;
    }

    @NotNull
    public final Periodicity getInsurancePeriodicity() {
        return this.insurancePeriodicity;
    }

    @Nullable
    public final Double getMaintenanceRate() {
        return this.maintenanceRate;
    }

    @NotNull
    public final Periodicity getMaintenancePeriodicity() {
        return this.maintenancePeriodicity;
    }

    @Nullable
    public final Double getYieldRate() {
        return this.yieldRate;
    }

    @NotNull
    public final Periodicity getYieldPeriodicity() {
        return this.yieldPeriodicity;
    }

    @NotNull
    public final FundsUtilisation getYieldUtilisation() {
        return this.yieldUtilisation;
    }

    @Override
    @NotNull
    protected List<FinancialCompo> createCompos() {
        Periodicity periodicity;
        ValueProvider<Double> valueProvider;
        FlowDirection flowDirection;
        FundsUtilisation fundsUtilisation;
        List compos = new ArrayList();
        if (this.insuranceRate != null && !Intrinsics.areEqual((Double)this.insuranceRate, (double)0.0)) {
            fundsUtilisation = FundsUtilisation.DISBURSE;
            flowDirection = FlowDirection.OUTGOING;
            valueProvider = ValueProviders.constValue(this.insuranceRate / 100.0 * this.getReconBalance() * (double)this.insurancePeriodicity.getMonths() / (double)12);
            periodicity = this.insurancePeriodicity;
            compos.add(new CashflowCompo(this, "insurance", fundsUtilisation, valueProvider, flowDirection, periodicity, null, null, false, 448, null));
        }
        if (this.maintenanceRate != null && !Intrinsics.areEqual((Double)this.maintenanceRate, (double)0.0)) {
            fundsUtilisation = FundsUtilisation.DISBURSE;
            flowDirection = FlowDirection.OUTGOING;
            valueProvider = ValueProviders.constValue(this.maintenanceRate / 100.0 * this.getReconBalance() * (double)this.maintenancePeriodicity.getMonths() / (double)12);
            periodicity = this.maintenancePeriodicity;
            compos.add(new CashflowCompo(this, "maintenance", fundsUtilisation, valueProvider, flowDirection, periodicity, null, null, false, 448, null));
        }
        if (this.yieldRate != null && !Intrinsics.areEqual((Double)this.yieldRate, (double)0.0)) {
            compos.add(new InterestCompo(this, null, null, ValueProviders.constValue(this.yieldRate), this.yieldPeriodicity, this.yieldUtilisation, 6, null));
        }
        return compos;
    }

    @NotNull
    public final String component1() {
        return this.tag;
    }

    @Nullable
    public final Person component2() {
        return this.owner;
    }

    @Nullable
    public final String component3() {
        return this.taxCode;
    }

    public final double component4() {
        return this.reconBalance;
    }

    @Nullable
    public final Double component5() {
        return this.insuranceRate;
    }

    @NotNull
    public final Periodicity component6() {
        return this.insurancePeriodicity;
    }

    @Nullable
    public final Double component7() {
        return this.maintenanceRate;
    }

    @NotNull
    public final Periodicity component8() {
        return this.maintenancePeriodicity;
    }

    @Nullable
    public final Double component9() {
        return this.yieldRate;
    }

    @NotNull
    public final Periodicity component10() {
        return this.yieldPeriodicity;
    }

    @NotNull
    public final FundsUtilisation component11() {
        return this.yieldUtilisation;
    }

    @NotNull
    public final TangibleAsset copy(@NotNull String tag, @Nullable Person owner, @Nullable String taxCode, double reconBalance, @Nullable Double insuranceRate, @NotNull Periodicity insurancePeriodicity, @Nullable Double maintenanceRate, @NotNull Periodicity maintenancePeriodicity, @Nullable Double yieldRate, @NotNull Periodicity yieldPeriodicity, @NotNull FundsUtilisation yieldUtilisation) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)insurancePeriodicity), (String)"insurancePeriodicity");
        Intrinsics.checkNotNullParameter((Object)((Object)maintenancePeriodicity), (String)"maintenancePeriodicity");
        Intrinsics.checkNotNullParameter((Object)((Object)yieldPeriodicity), (String)"yieldPeriodicity");
        Intrinsics.checkNotNullParameter((Object)((Object)yieldUtilisation), (String)"yieldUtilisation");
        return new TangibleAsset(tag, owner, taxCode, reconBalance, insuranceRate, insurancePeriodicity, maintenanceRate, maintenancePeriodicity, yieldRate, yieldPeriodicity, yieldUtilisation);
    }

    public static /* synthetic */ TangibleAsset copy$default(TangibleAsset tangibleAsset, String string, Person person, String string2, double d, Double d2, Periodicity periodicity, Double d3, Periodicity periodicity2, Double d4, Periodicity periodicity3, FundsUtilisation fundsUtilisation, int n, Object object) {
        if ((n & 1) != 0) {
            string = tangibleAsset.tag;
        }
        if ((n & 2) != 0) {
            person = tangibleAsset.owner;
        }
        if ((n & 4) != 0) {
            string2 = tangibleAsset.taxCode;
        }
        if ((n & 8) != 0) {
            d = tangibleAsset.reconBalance;
        }
        if ((n & 0x10) != 0) {
            d2 = tangibleAsset.insuranceRate;
        }
        if ((n & 0x20) != 0) {
            periodicity = tangibleAsset.insurancePeriodicity;
        }
        if ((n & 0x40) != 0) {
            d3 = tangibleAsset.maintenanceRate;
        }
        if ((n & 0x80) != 0) {
            periodicity2 = tangibleAsset.maintenancePeriodicity;
        }
        if ((n & 0x100) != 0) {
            d4 = tangibleAsset.yieldRate;
        }
        if ((n & 0x200) != 0) {
            periodicity3 = tangibleAsset.yieldPeriodicity;
        }
        if ((n & 0x400) != 0) {
            fundsUtilisation = tangibleAsset.yieldUtilisation;
        }
        return tangibleAsset.copy(string, person, string2, d, d2, periodicity, d3, periodicity2, d4, periodicity3, fundsUtilisation);
    }

    @NotNull
    public String toString() {
        return "TangibleAsset(tag=" + this.tag + ", owner=" + this.owner + ", taxCode=" + this.taxCode + ", reconBalance=" + this.reconBalance + ", insuranceRate=" + this.insuranceRate + ", insurancePeriodicity=" + this.insurancePeriodicity + ", maintenanceRate=" + this.maintenanceRate + ", maintenancePeriodicity=" + this.maintenancePeriodicity + ", yieldRate=" + this.yieldRate + ", yieldPeriodicity=" + this.yieldPeriodicity + ", yieldUtilisation=" + this.yieldUtilisation + ")";
    }

    public int hashCode() {
        int result = this.tag.hashCode();
        result = result * 31 + (this.owner == null ? 0 : this.owner.hashCode());
        result = result * 31 + (this.taxCode == null ? 0 : this.taxCode.hashCode());
        result = result * 31 + Double.hashCode(this.reconBalance);
        result = result * 31 + (this.insuranceRate == null ? 0 : ((Object)this.insuranceRate).hashCode());
        result = result * 31 + this.insurancePeriodicity.hashCode();
        result = result * 31 + (this.maintenanceRate == null ? 0 : ((Object)this.maintenanceRate).hashCode());
        result = result * 31 + this.maintenancePeriodicity.hashCode();
        result = result * 31 + (this.yieldRate == null ? 0 : ((Object)this.yieldRate).hashCode());
        result = result * 31 + this.yieldPeriodicity.hashCode();
        result = result * 31 + this.yieldUtilisation.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TangibleAsset)) {
            return false;
        }
        TangibleAsset tangibleAsset = (TangibleAsset)other;
        if (!Intrinsics.areEqual((Object)this.tag, (Object)tangibleAsset.tag)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.owner, (Object)tangibleAsset.owner)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.taxCode, (Object)tangibleAsset.taxCode)) {
            return false;
        }
        if (Double.compare(this.reconBalance, tangibleAsset.reconBalance) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.insuranceRate, (Object)tangibleAsset.insuranceRate)) {
            return false;
        }
        if (this.insurancePeriodicity != tangibleAsset.insurancePeriodicity) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.maintenanceRate, (Object)tangibleAsset.maintenanceRate)) {
            return false;
        }
        if (this.maintenancePeriodicity != tangibleAsset.maintenancePeriodicity) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.yieldRate, (Object)tangibleAsset.yieldRate)) {
            return false;
        }
        if (this.yieldPeriodicity != tangibleAsset.yieldPeriodicity) {
            return false;
        }
        return this.yieldUtilisation == tangibleAsset.yieldUtilisation;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0003\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\u0015\u0010\u0005\u001a\u00020\u00002\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\b\u001a\u00020\u00002\b\u0010\b\u001a\u0004\u0018\u00010\u0004J\u0015\u0010\t\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u0015\u0010\f\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u0010\u001a\u00020\u00002\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004J\u0015\u0010\u0011\u001a\u00020\u00002\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0012\u001a\u00020\u00002\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/fincast/holding/impl/core/TangibleAsset$Builder;", "", "()V", "insurancePeriodicity", "Lio/fincast/enums/Periodicity;", "insuranceRate", "", "Ljava/lang/Double;", "maintenancePeriodicity", "maintenanceRate", "owner", "Lio/fincast/household/Person;", "reconBalance", "tag", "", "taxCode", "yieldPeriodicity", "yieldRate", "yieldUtilisation", "Lio/fincast/enums/FundsUtilisation;", "build", "Lio/fincast/holding/impl/core/TangibleAsset;", "(Ljava/lang/Double;)Lio/fincast/holding/impl/core/TangibleAsset$Builder;", "fincast"})
    @SourceDebugExtension(value={"SMAP\nTangibleAsset.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TangibleAsset.kt\nio/fincast/holding/impl/core/TangibleAsset$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n1#2:123\n*E\n"})
    public static final class Builder {
        @Nullable
        private String tag;
        @Nullable
        private String taxCode;
        @Nullable
        private Person owner;
        @Nullable
        private Double reconBalance;
        @Nullable
        private Double insuranceRate;
        @Nullable
        private Periodicity insurancePeriodicity;
        @Nullable
        private Double maintenanceRate;
        @Nullable
        private Periodicity maintenancePeriodicity;
        @Nullable
        private Double yieldRate;
        @Nullable
        private Periodicity yieldPeriodicity;
        @Nullable
        private FundsUtilisation yieldUtilisation;

        @NotNull
        public final Builder tag(@NotNull String tag) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Builder $this$tag_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$tag_u24lambda_u240.tag = tag;
            return builder;
        }

        @NotNull
        public final Builder taxCode(@Nullable String taxCode) {
            Builder builder;
            Builder $this$taxCode_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$taxCode_u24lambda_u241.taxCode = taxCode;
            return builder;
        }

        @NotNull
        public final Builder owner(@NotNull Person owner) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Builder $this$owner_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$owner_u24lambda_u242.owner = owner;
            return builder;
        }

        @NotNull
        public final Builder reconBalance(@Nullable Double reconBalance) {
            Builder builder;
            Builder $this$reconBalance_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$reconBalance_u24lambda_u243.reconBalance = reconBalance;
            return builder;
        }

        @NotNull
        public final Builder insuranceRate(@Nullable Double insuranceRate) {
            Builder builder;
            Builder $this$insuranceRate_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$insuranceRate_u24lambda_u244.insuranceRate = insuranceRate;
            return builder;
        }

        @NotNull
        public final Builder insurancePeriodicity(@Nullable Periodicity insurancePeriodicity) {
            Builder builder;
            Builder $this$insurancePeriodicity_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$insurancePeriodicity_u24lambda_u245.insurancePeriodicity = insurancePeriodicity;
            return builder;
        }

        @NotNull
        public final Builder maintenanceRate(@Nullable Double maintenanceRate) {
            Builder builder;
            Builder $this$maintenanceRate_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$maintenanceRate_u24lambda_u246.maintenanceRate = maintenanceRate;
            return builder;
        }

        @NotNull
        public final Builder maintenancePeriodicity(@Nullable Periodicity maintenancePeriodicity) {
            Builder builder;
            Builder $this$maintenancePeriodicity_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$maintenancePeriodicity_u24lambda_u247.maintenancePeriodicity = maintenancePeriodicity;
            return builder;
        }

        @NotNull
        public final Builder yieldRate(@Nullable Double yieldRate) {
            Builder builder;
            Builder $this$yieldRate_u24lambda_u248 = builder = this;
            boolean bl = false;
            $this$yieldRate_u24lambda_u248.yieldRate = yieldRate;
            return builder;
        }

        @NotNull
        public final Builder yieldPeriodicity(@Nullable Periodicity yieldPeriodicity) {
            Builder builder;
            Builder $this$yieldPeriodicity_u24lambda_u249 = builder = this;
            boolean bl = false;
            $this$yieldPeriodicity_u24lambda_u249.yieldPeriodicity = yieldPeriodicity;
            return builder;
        }

        @NotNull
        public final Builder yieldUtilisation(@Nullable FundsUtilisation yieldUtilisation) {
            Builder builder;
            Builder $this$yieldUtilisation_u24lambda_u2410 = builder = this;
            boolean bl = false;
            $this$yieldUtilisation_u24lambda_u2410.yieldUtilisation = yieldUtilisation;
            return builder;
        }

        @NotNull
        public final TangibleAsset build() {
            FundsUtilisation fundsUtilisation;
            Periodicity periodicity;
            String string = this.tag;
            if (string == null) {
                throw new IllegalArgumentException("tag is required");
            }
            String string2 = string;
            String string3 = this.taxCode;
            Person person = this.owner;
            Double d = this.reconBalance;
            double d2 = d != null ? d : 0.0;
            Double d3 = this.insuranceRate;
            Periodicity periodicity2 = this.insurancePeriodicity;
            if (periodicity2 == null) {
                periodicity2 = Periodicity.YEARLY;
            }
            Periodicity periodicity3 = periodicity2;
            Double d4 = this.maintenanceRate;
            Periodicity periodicity4 = this.maintenancePeriodicity;
            if (periodicity4 == null) {
                periodicity4 = Periodicity.YEARLY;
            }
            Periodicity periodicity5 = periodicity4;
            Double d5 = this.yieldRate;
            Periodicity periodicity6 = this.yieldPeriodicity;
            if (periodicity6 == null) {
                periodicity6 = periodicity = Periodicity.YEARLY;
            }
            if ((fundsUtilisation = this.yieldUtilisation) == null) {
                fundsUtilisation = FundsUtilisation.DISBURSE;
            }
            FundsUtilisation fundsUtilisation2 = fundsUtilisation;
            return new TangibleAsset(string2, person, string3, d2, d3, periodicity3, d4, periodicity5, d5, periodicity, fundsUtilisation2);
        }
    }
}

