/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.holding.impl.core;

import io.fincast.compo.FinancialCompo;
import io.fincast.compo.ValueProviders;
import io.fincast.compo.impl.InterestCompo;
import io.fincast.enums.FundsUtilisation;
import io.fincast.enums.Periodicity;
import io.fincast.enums.ProductType;
import io.fincast.holding.base.ValuableBase;
import io.fincast.household.Person;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001-BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\bH\u00c6\u0003J\t\u0010 \u001a\u00020\u000bH\u00c6\u0003J\t\u0010!\u001a\u00020\rH\u00c6\u0003JS\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0014J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u00d6\u0003J\t\u0010*\u001a\u00020+H\u00d6\u0001J\t\u0010,\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019\u00a8\u0006."}, d2={"Lio/fincast/holding/impl/core/Liability;", "Lio/fincast/holding/base/ValuableBase;", "tag", "", "owner", "Lio/fincast/household/Person;", "taxCode", "reconBalance", "", "interestRate", "interestPeriodicity", "Lio/fincast/enums/Periodicity;", "interestUtilisation", "Lio/fincast/enums/FundsUtilisation;", "(Ljava/lang/String;Lio/fincast/household/Person;Ljava/lang/String;DDLio/fincast/enums/Periodicity;Lio/fincast/enums/FundsUtilisation;)V", "getInterestPeriodicity", "()Lio/fincast/enums/Periodicity;", "getInterestRate", "()D", "getInterestUtilisation", "()Lio/fincast/enums/FundsUtilisation;", "getOwner", "()Lio/fincast/household/Person;", "getReconBalance", "getTag", "()Ljava/lang/String;", "getTaxCode", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "createCompos", "", "Lio/fincast/compo/FinancialCompo;", "equals", "", "other", "", "hashCode", "", "toString", "Builder", "fincast"})
public final class Liability
extends ValuableBase {
    @NotNull
    private final String tag;
    @Nullable
    private final Person owner;
    @Nullable
    private final String taxCode;
    private final double reconBalance;
    private final double interestRate;
    @NotNull
    private final Periodicity interestPeriodicity;
    @NotNull
    private final FundsUtilisation interestUtilisation;

    public Liability(@NotNull String tag, @Nullable Person owner, @Nullable String taxCode, double reconBalance, double interestRate, @NotNull Periodicity interestPeriodicity, @NotNull FundsUtilisation interestUtilisation) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)interestPeriodicity), (String)"interestPeriodicity");
        Intrinsics.checkNotNullParameter((Object)((Object)interestUtilisation), (String)"interestUtilisation");
        super(tag, owner, ProductType.LIABILITY, taxCode, reconBalance);
        this.tag = tag;
        this.owner = owner;
        this.taxCode = taxCode;
        this.reconBalance = reconBalance;
        this.interestRate = interestRate;
        this.interestPeriodicity = interestPeriodicity;
        this.interestUtilisation = interestUtilisation;
    }

    public /* synthetic */ Liability(String string, Person person, String string2, double d, double d2, Periodicity periodicity, FundsUtilisation fundsUtilisation, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            person = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            d = 0.0;
        }
        if ((n & 0x10) != 0) {
            d2 = 0.0;
        }
        if ((n & 0x20) != 0) {
            periodicity = Periodicity.YEARLY;
        }
        if ((n & 0x40) != 0) {
            fundsUtilisation = FundsUtilisation.DISBURSE;
        }
        this(string, person, string2, d, d2, periodicity, fundsUtilisation);
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @Override
    @Nullable
    public Person getOwner() {
        return this.owner;
    }

    @Override
    @Nullable
    public String getTaxCode() {
        return this.taxCode;
    }

    @Override
    public double getReconBalance() {
        return this.reconBalance;
    }

    public final double getInterestRate() {
        return this.interestRate;
    }

    @NotNull
    public final Periodicity getInterestPeriodicity() {
        return this.interestPeriodicity;
    }

    @NotNull
    public final FundsUtilisation getInterestUtilisation() {
        return this.interestUtilisation;
    }

    @Override
    @NotNull
    protected List<FinancialCompo> createCompos() {
        List compos = new ArrayList();
        if (!(this.interestRate == 0.0)) {
            compos.add(new InterestCompo(this, null, null, ValueProviders.constValue(this.interestRate), this.interestPeriodicity, this.interestUtilisation, 6, null));
        }
        return compos;
    }

    @NotNull
    public final String component1() {
        return this.tag;
    }

    @Nullable
    public final Person component2() {
        return this.owner;
    }

    @Nullable
    public final String component3() {
        return this.taxCode;
    }

    public final double component4() {
        return this.reconBalance;
    }

    public final double component5() {
        return this.interestRate;
    }

    @NotNull
    public final Periodicity component6() {
        return this.interestPeriodicity;
    }

    @NotNull
    public final FundsUtilisation component7() {
        return this.interestUtilisation;
    }

    @NotNull
    public final Liability copy(@NotNull String tag, @Nullable Person owner, @Nullable String taxCode, double reconBalance, double interestRate, @NotNull Periodicity interestPeriodicity, @NotNull FundsUtilisation interestUtilisation) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)interestPeriodicity), (String)"interestPeriodicity");
        Intrinsics.checkNotNullParameter((Object)((Object)interestUtilisation), (String)"interestUtilisation");
        return new Liability(tag, owner, taxCode, reconBalance, interestRate, interestPeriodicity, interestUtilisation);
    }

    public static /* synthetic */ Liability copy$default(Liability liability, String string, Person person, String string2, double d, double d2, Periodicity periodicity, FundsUtilisation fundsUtilisation, int n, Object object) {
        if ((n & 1) != 0) {
            string = liability.tag;
        }
        if ((n & 2) != 0) {
            person = liability.owner;
        }
        if ((n & 4) != 0) {
            string2 = liability.taxCode;
        }
        if ((n & 8) != 0) {
            d = liability.reconBalance;
        }
        if ((n & 0x10) != 0) {
            d2 = liability.interestRate;
        }
        if ((n & 0x20) != 0) {
            periodicity = liability.interestPeriodicity;
        }
        if ((n & 0x40) != 0) {
            fundsUtilisation = liability.interestUtilisation;
        }
        return liability.copy(string, person, string2, d, d2, periodicity, fundsUtilisation);
    }

    @NotNull
    public String toString() {
        return "Liability(tag=" + this.tag + ", owner=" + this.owner + ", taxCode=" + this.taxCode + ", reconBalance=" + this.reconBalance + ", interestRate=" + this.interestRate + ", interestPeriodicity=" + this.interestPeriodicity + ", interestUtilisation=" + this.interestUtilisation + ")";
    }

    public int hashCode() {
        int result = this.tag.hashCode();
        result = result * 31 + (this.owner == null ? 0 : this.owner.hashCode());
        result = result * 31 + (this.taxCode == null ? 0 : this.taxCode.hashCode());
        result = result * 31 + Double.hashCode(this.reconBalance);
        result = result * 31 + Double.hashCode(this.interestRate);
        result = result * 31 + this.interestPeriodicity.hashCode();
        result = result * 31 + this.interestUtilisation.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Liability)) {
            return false;
        }
        Liability liability = (Liability)other;
        if (!Intrinsics.areEqual((Object)this.tag, (Object)liability.tag)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.owner, (Object)liability.owner)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.taxCode, (Object)liability.taxCode)) {
            return false;
        }
        if (Double.compare(this.reconBalance, liability.reconBalance) != 0) {
            return false;
        }
        if (Double.compare(this.interestRate, liability.interestRate) != 0) {
            return false;
        }
        if (this.interestPeriodicity != liability.interestPeriodicity) {
            return false;
        }
        return this.interestUtilisation == liability.interestUtilisation;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0003\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\u0015\u0010\u0005\u001a\u00020\u00002\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\b\u001a\u00020\u00002\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0010\u0010\n\u001a\u00020\u00002\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0015\u0010\f\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/fincast/holding/impl/core/Liability$Builder;", "", "()V", "interestPeriodicity", "Lio/fincast/enums/Periodicity;", "interestRate", "", "Ljava/lang/Double;", "interestUtilisation", "Lio/fincast/enums/FundsUtilisation;", "owner", "Lio/fincast/household/Person;", "reconBalance", "tag", "", "taxCode", "build", "Lio/fincast/holding/impl/core/Liability;", "(Ljava/lang/Double;)Lio/fincast/holding/impl/core/Liability$Builder;", "fincast"})
    @SourceDebugExtension(value={"SMAP\nLiability.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Liability.kt\nio/fincast/holding/impl/core/Liability$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
    public static final class Builder {
        @Nullable
        private String tag;
        @Nullable
        private String taxCode;
        @Nullable
        private Person owner;
        @Nullable
        private Double reconBalance;
        @Nullable
        private Double interestRate;
        @Nullable
        private Periodicity interestPeriodicity;
        @Nullable
        private FundsUtilisation interestUtilisation;

        @NotNull
        public final Builder tag(@NotNull String tag) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Builder $this$tag_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$tag_u24lambda_u240.tag = tag;
            return builder;
        }

        @NotNull
        public final Builder taxCode(@Nullable String taxCode) {
            Builder builder;
            Builder $this$taxCode_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$taxCode_u24lambda_u241.taxCode = taxCode;
            return builder;
        }

        @NotNull
        public final Builder owner(@Nullable Person owner) {
            Builder builder;
            Builder $this$owner_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$owner_u24lambda_u242.owner = owner;
            return builder;
        }

        @NotNull
        public final Builder reconBalance(@Nullable Double reconBalance) {
            Builder builder;
            Builder $this$reconBalance_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$reconBalance_u24lambda_u243.reconBalance = reconBalance;
            return builder;
        }

        @NotNull
        public final Builder interestRate(@Nullable Double interestRate) {
            Builder builder;
            Builder $this$interestRate_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$interestRate_u24lambda_u244.interestRate = interestRate;
            return builder;
        }

        @NotNull
        public final Builder interestPeriodicity(@Nullable Periodicity interestPeriodicity) {
            Builder builder;
            Builder $this$interestPeriodicity_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$interestPeriodicity_u24lambda_u245.interestPeriodicity = interestPeriodicity;
            return builder;
        }

        @NotNull
        public final Builder interestUtilisation(@Nullable FundsUtilisation interestUtilisation) {
            Builder builder;
            Builder $this$interestUtilisation_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$interestUtilisation_u24lambda_u246.interestUtilisation = interestUtilisation;
            return builder;
        }

        @NotNull
        public final Liability build() {
            FundsUtilisation fundsUtilisation;
            Periodicity periodicity;
            String string = this.tag;
            if (string == null) {
                throw new IllegalArgumentException("tag is required");
            }
            String string2 = string;
            String string3 = this.taxCode;
            Person person = this.owner;
            Double d = this.reconBalance;
            double d2 = d != null ? d : 0.0;
            Double d3 = this.interestRate;
            double d4 = d3 != null ? d3 : 0.0;
            Periodicity periodicity2 = this.interestPeriodicity;
            if (periodicity2 == null) {
                periodicity2 = periodicity = Periodicity.YEARLY;
            }
            if ((fundsUtilisation = this.interestUtilisation) == null) {
                fundsUtilisation = FundsUtilisation.DISBURSE;
            }
            FundsUtilisation fundsUtilisation2 = fundsUtilisation;
            return new Liability(string2, person, string3, d2, d4, periodicity, fundsUtilisation2);
        }
    }
}

