/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.holding.impl.core;

import io.fincast.compo.FinancialCompo;
import io.fincast.compo.ValueProvider;
import io.fincast.compo.ValueProviders;
import io.fincast.compo.impl.CapitalGainCompo;
import io.fincast.compo.impl.CashflowCompo;
import io.fincast.compo.impl.DividendCompo;
import io.fincast.compo.impl.FlowDirection;
import io.fincast.compo.impl.InterestCompo;
import io.fincast.compo.impl.TransferCompo;
import io.fincast.engine.SimDate;
import io.fincast.enums.FundsUtilisation;
import io.fincast.enums.Periodicity;
import io.fincast.enums.ProductType;
import io.fincast.holding.Holding;
import io.fincast.holding.base.ValuableBase;
import io.fincast.holding.impl.core.AssetAllocation;
import io.fincast.household.Person;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b7\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001TB\u00cb\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0013\u0012\u0010\b\u0002\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\n\u0012\b\b\u0002\u0010\u0016\u001a\u00020\f\u0012\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u001bJ\t\u00107\u001a\u00020\u0003H\u00c6\u0003J\t\u00108\u001a\u00020\u0013H\u00c6\u0003J\t\u00109\u001a\u00020\u0013H\u00c6\u0003J\u0011\u0010:\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\nH\u00c6\u0003J\t\u0010;\u001a\u00020\fH\u00c6\u0003J\u000b\u0010<\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003J\u000b\u0010=\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003J\u0010\u0010>\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u0010)J\u0010\u0010?\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u0010)J\u000b\u0010@\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010A\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010B\u001a\u00020\bH\u00c6\u0003J\u0011\u0010C\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\nH\u00c6\u0003J\t\u0010D\u001a\u00020\fH\u00c6\u0003J\u000b\u0010E\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003J\u000b\u0010F\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003J\t\u0010G\u001a\u00020\u0011H\u00c6\u0003J\u00d8\u0001\u0010H\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00132\u0010\b\u0002\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\n2\b\b\u0002\u0010\u0016\u001a\u00020\f2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\bH\u00c6\u0001\u00a2\u0006\u0002\u0010IJ\u000e\u0010J\u001a\b\u0012\u0004\u0012\u00020L0KH\u0014J\u0013\u0010M\u001a\u00020N2\b\u0010O\u001a\u0004\u0018\u00010PH\u00d6\u0003J\t\u0010Q\u001a\u00020RH\u00d6\u0001J\t\u0010S\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0019\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010!R\u0011\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010&R\u0015\u0010\u0019\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010*\u001a\u0004\b(\u0010)R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0015\u0010\u001a\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010*\u001a\u0004\b-\u0010)R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00101R\u0019\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u001fR\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010!R\u0011\u0010\u0016\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010#R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010!\u00a8\u0006U"}, d2={"Lio/fincast/holding/impl/core/Investment;", "Lio/fincast/holding/base/ValuableBase;", "tag", "", "owner", "Lio/fincast/household/Person;", "taxCode", "reconBalance", "", "contributionAmount", "Lio/fincast/compo/ValueProvider;", "contributionPeriodicity", "Lio/fincast/enums/Periodicity;", "contributionStartDate", "Lio/fincast/engine/SimDate;", "contributionEndDate", "assetAllocation", "Lio/fincast/holding/impl/core/AssetAllocation;", "interestUtilisation", "Lio/fincast/enums/FundsUtilisation;", "dividendUtilisation", "withdrawalAmount", "withdrawalPeriodicity", "withdrawalStartDate", "withdrawalEndDate", "managementFee", "performanceFee", "(Ljava/lang/String;Lio/fincast/household/Person;Ljava/lang/String;DLio/fincast/compo/ValueProvider;Lio/fincast/enums/Periodicity;Lio/fincast/engine/SimDate;Lio/fincast/engine/SimDate;Lio/fincast/holding/impl/core/AssetAllocation;Lio/fincast/enums/FundsUtilisation;Lio/fincast/enums/FundsUtilisation;Lio/fincast/compo/ValueProvider;Lio/fincast/enums/Periodicity;Lio/fincast/engine/SimDate;Lio/fincast/engine/SimDate;Ljava/lang/Double;Ljava/lang/Double;)V", "getAssetAllocation", "()Lio/fincast/holding/impl/core/AssetAllocation;", "getContributionAmount", "()Lio/fincast/compo/ValueProvider;", "getContributionEndDate", "()Lio/fincast/engine/SimDate;", "getContributionPeriodicity", "()Lio/fincast/enums/Periodicity;", "getContributionStartDate", "getDividendUtilisation", "()Lio/fincast/enums/FundsUtilisation;", "getInterestUtilisation", "getManagementFee", "()Ljava/lang/Double;", "Ljava/lang/Double;", "getOwner", "()Lio/fincast/household/Person;", "getPerformanceFee", "getReconBalance", "()D", "getTag", "()Ljava/lang/String;", "getTaxCode", "getWithdrawalAmount", "getWithdrawalEndDate", "getWithdrawalPeriodicity", "getWithdrawalStartDate", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Ljava/lang/String;Lio/fincast/household/Person;Ljava/lang/String;DLio/fincast/compo/ValueProvider;Lio/fincast/enums/Periodicity;Lio/fincast/engine/SimDate;Lio/fincast/engine/SimDate;Lio/fincast/holding/impl/core/AssetAllocation;Lio/fincast/enums/FundsUtilisation;Lio/fincast/enums/FundsUtilisation;Lio/fincast/compo/ValueProvider;Lio/fincast/enums/Periodicity;Lio/fincast/engine/SimDate;Lio/fincast/engine/SimDate;Ljava/lang/Double;Ljava/lang/Double;)Lio/fincast/holding/impl/core/Investment;", "createCompos", "", "Lio/fincast/compo/FinancialCompo;", "equals", "", "other", "", "hashCode", "", "toString", "Builder", "fincast"})
public final class Investment
extends ValuableBase {
    @NotNull
    private final String tag;
    @Nullable
    private final Person owner;
    @Nullable
    private final String taxCode;
    private final double reconBalance;
    @Nullable
    private final ValueProvider<Double> contributionAmount;
    @NotNull
    private final Periodicity contributionPeriodicity;
    @Nullable
    private final SimDate contributionStartDate;
    @Nullable
    private final SimDate contributionEndDate;
    @NotNull
    private final AssetAllocation assetAllocation;
    @NotNull
    private final FundsUtilisation interestUtilisation;
    @NotNull
    private final FundsUtilisation dividendUtilisation;
    @Nullable
    private final ValueProvider<Double> withdrawalAmount;
    @NotNull
    private final Periodicity withdrawalPeriodicity;
    @Nullable
    private final SimDate withdrawalStartDate;
    @Nullable
    private final SimDate withdrawalEndDate;
    @Nullable
    private final Double managementFee;
    @Nullable
    private final Double performanceFee;

    public Investment(@NotNull String tag, @Nullable Person owner, @Nullable String taxCode, double reconBalance, @Nullable ValueProvider<Double> contributionAmount, @NotNull Periodicity contributionPeriodicity, @Nullable SimDate contributionStartDate, @Nullable SimDate contributionEndDate, @NotNull AssetAllocation assetAllocation, @NotNull FundsUtilisation interestUtilisation, @NotNull FundsUtilisation dividendUtilisation, @Nullable ValueProvider<Double> withdrawalAmount, @NotNull Periodicity withdrawalPeriodicity, @Nullable SimDate withdrawalStartDate, @Nullable SimDate withdrawalEndDate, @Nullable Double managementFee, @Nullable Double performanceFee) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)contributionPeriodicity), (String)"contributionPeriodicity");
        Intrinsics.checkNotNullParameter((Object)assetAllocation, (String)"assetAllocation");
        Intrinsics.checkNotNullParameter((Object)((Object)interestUtilisation), (String)"interestUtilisation");
        Intrinsics.checkNotNullParameter((Object)((Object)dividendUtilisation), (String)"dividendUtilisation");
        Intrinsics.checkNotNullParameter((Object)((Object)withdrawalPeriodicity), (String)"withdrawalPeriodicity");
        super(tag, owner, ProductType.ASSET, taxCode, reconBalance);
        this.tag = tag;
        this.owner = owner;
        this.taxCode = taxCode;
        this.reconBalance = reconBalance;
        this.contributionAmount = contributionAmount;
        this.contributionPeriodicity = contributionPeriodicity;
        this.contributionStartDate = contributionStartDate;
        this.contributionEndDate = contributionEndDate;
        this.assetAllocation = assetAllocation;
        this.interestUtilisation = interestUtilisation;
        this.dividendUtilisation = dividendUtilisation;
        this.withdrawalAmount = withdrawalAmount;
        this.withdrawalPeriodicity = withdrawalPeriodicity;
        this.withdrawalStartDate = withdrawalStartDate;
        this.withdrawalEndDate = withdrawalEndDate;
        this.managementFee = managementFee;
        this.performanceFee = performanceFee;
    }

    public /* synthetic */ Investment(String string, Person person, String string2, double d, ValueProvider valueProvider, Periodicity periodicity, SimDate simDate, SimDate simDate2, AssetAllocation assetAllocation, FundsUtilisation fundsUtilisation, FundsUtilisation fundsUtilisation2, ValueProvider valueProvider2, Periodicity periodicity2, SimDate simDate3, SimDate simDate4, Double d2, Double d3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            person = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            d = 0.0;
        }
        if ((n & 0x10) != 0) {
            valueProvider = null;
        }
        if ((n & 0x20) != 0) {
            periodicity = Periodicity.YEARLY;
        }
        if ((n & 0x40) != 0) {
            simDate = null;
        }
        if ((n & 0x80) != 0) {
            simDate2 = null;
        }
        if ((n & 0x200) != 0) {
            fundsUtilisation = FundsUtilisation.COMPOUND;
        }
        if ((n & 0x400) != 0) {
            fundsUtilisation2 = FundsUtilisation.COMPOUND;
        }
        if ((n & 0x800) != 0) {
            valueProvider2 = null;
        }
        if ((n & 0x1000) != 0) {
            periodicity2 = Periodicity.YEARLY;
        }
        if ((n & 0x2000) != 0) {
            simDate3 = null;
        }
        if ((n & 0x4000) != 0) {
            simDate4 = null;
        }
        if ((n & 0x8000) != 0) {
            d2 = 0.0;
        }
        if ((n & 0x10000) != 0) {
            d3 = 0.0;
        }
        this(string, person, string2, d, valueProvider, periodicity, simDate, simDate2, assetAllocation, fundsUtilisation, fundsUtilisation2, valueProvider2, periodicity2, simDate3, simDate4, d2, d3);
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @Override
    @Nullable
    public Person getOwner() {
        return this.owner;
    }

    @Override
    @Nullable
    public String getTaxCode() {
        return this.taxCode;
    }

    @Override
    public double getReconBalance() {
        return this.reconBalance;
    }

    @Nullable
    public final ValueProvider<Double> getContributionAmount() {
        return this.contributionAmount;
    }

    @NotNull
    public final Periodicity getContributionPeriodicity() {
        return this.contributionPeriodicity;
    }

    @Nullable
    public final SimDate getContributionStartDate() {
        return this.contributionStartDate;
    }

    @Nullable
    public final SimDate getContributionEndDate() {
        return this.contributionEndDate;
    }

    @NotNull
    public final AssetAllocation getAssetAllocation() {
        return this.assetAllocation;
    }

    @NotNull
    public final FundsUtilisation getInterestUtilisation() {
        return this.interestUtilisation;
    }

    @NotNull
    public final FundsUtilisation getDividendUtilisation() {
        return this.dividendUtilisation;
    }

    @Nullable
    public final ValueProvider<Double> getWithdrawalAmount() {
        return this.withdrawalAmount;
    }

    @NotNull
    public final Periodicity getWithdrawalPeriodicity() {
        return this.withdrawalPeriodicity;
    }

    @Nullable
    public final SimDate getWithdrawalStartDate() {
        return this.withdrawalStartDate;
    }

    @Nullable
    public final SimDate getWithdrawalEndDate() {
        return this.withdrawalEndDate;
    }

    @Nullable
    public final Double getManagementFee() {
        return this.managementFee;
    }

    @Nullable
    public final Double getPerformanceFee() {
        return this.performanceFee;
    }

    @Override
    @NotNull
    protected List<FinancialCompo> createCompos() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        List compos = new ArrayList();
        if (this.contributionAmount != null) {
            object5 = this.getHousehold().getInternalCash();
            object4 = this.contributionAmount;
            object3 = this.contributionStartDate;
            object2 = this.contributionEndDate;
            object = this.contributionPeriodicity;
            compos.add(new TransferCompo(this, "contribution", (Holding)object5, this, (ValueProvider)object4, (Periodicity)((Object)object), (SimDate)object3, (SimDate)object2, null, 256, null));
        }
        if (!(this.assetAllocation.getCashPart() == 0.0) && this.assetAllocation.getCashInterestRate() != null && !Intrinsics.areEqual((Double)this.assetAllocation.getCashInterestRate(), (double)0.0)) {
            compos.add(new InterestCompo(this, "cashInterest", null, ValueProviders.constValue(this.assetAllocation.getCashPart() / 100.0 * this.assetAllocation.getCashInterestRate()), Periodicity.YEARLY, this.interestUtilisation, 4, null));
        }
        if (!(this.assetAllocation.getBondPart() == 0.0) && this.assetAllocation.getBondInterestRate() != null && !Intrinsics.areEqual((Double)this.assetAllocation.getBondInterestRate(), (double)0.0)) {
            compos.add(new InterestCompo(this, "bondInterest", null, ValueProviders.constValue(this.assetAllocation.getBondPart() / 100.0 * this.assetAllocation.getBondInterestRate()), Periodicity.YEARLY, this.interestUtilisation, 4, null));
        }
        if (!(this.assetAllocation.getStockPart() == 0.0)) {
            if (this.assetAllocation.getStockDividendYield() != null && !Intrinsics.areEqual((Double)this.assetAllocation.getStockDividendYield(), (double)0.0)) {
                compos.add(new DividendCompo(this, ValueProviders.constValue(this.assetAllocation.getStockPart() / 100.0 * this.assetAllocation.getStockDividendYield()), Periodicity.YEARLY, this.dividendUtilisation));
            }
            if (this.assetAllocation.getStockCapitalGain() != null && !Intrinsics.areEqual((Double)this.assetAllocation.getStockCapitalGain(), (double)0.0)) {
                compos.add(new CapitalGainCompo(this, ValueProviders.constValue(this.assetAllocation.getStockPart() / 100.0 * this.assetAllocation.getStockCapitalGain()), null, 4, null));
            }
        }
        if (this.performanceFee != null && !Intrinsics.areEqual((Double)this.performanceFee, (double)0.0)) {
            object5 = FundsUtilisation.COMPOUND;
            object4 = FlowDirection.OUTGOING;
            object3 = (arg_0, arg_1) -> Investment.createCompos$lambda$0(this, arg_0, arg_1);
            object2 = Periodicity.YEARLY;
            object = this.getHousehold().getReconDate().plus(1);
            compos.add(new CashflowCompo(this, "performanceFee", (FundsUtilisation)((Object)object5), (ValueProvider)object3, (FlowDirection)((Object)object4), (Periodicity)((Object)object2), (SimDate)object, null, false, 384, null));
        }
        if (this.managementFee != null && !Intrinsics.areEqual((Double)this.managementFee, (double)0.0)) {
            object5 = FundsUtilisation.COMPOUND;
            object4 = FlowDirection.OUTGOING;
            object3 = (arg_0, arg_1) -> Investment.createCompos$lambda$1(this, arg_0, arg_1);
            object2 = Periodicity.YEARLY;
            object = this.getHousehold().getReconDate().plus(1);
            compos.add(new CashflowCompo(this, "managementFee", (FundsUtilisation)((Object)object5), (ValueProvider)object3, (FlowDirection)((Object)object4), (Periodicity)((Object)object2), (SimDate)object, null, false, 384, null));
        }
        if (this.withdrawalAmount != null) {
            object5 = this.getHousehold().getInternalCash();
            object4 = this.withdrawalAmount;
            object3 = this.withdrawalStartDate;
            object2 = this.withdrawalEndDate;
            object = this.withdrawalPeriodicity;
            compos.add(new TransferCompo(this, "withdrawal", this, (Holding)object5, (ValueProvider)object4, (Periodicity)((Object)object), (SimDate)object3, (SimDate)object2, null, 256, null));
        }
        return compos;
    }

    @NotNull
    public final String component1() {
        return this.tag;
    }

    @Nullable
    public final Person component2() {
        return this.owner;
    }

    @Nullable
    public final String component3() {
        return this.taxCode;
    }

    public final double component4() {
        return this.reconBalance;
    }

    @Nullable
    public final ValueProvider<Double> component5() {
        return this.contributionAmount;
    }

    @NotNull
    public final Periodicity component6() {
        return this.contributionPeriodicity;
    }

    @Nullable
    public final SimDate component7() {
        return this.contributionStartDate;
    }

    @Nullable
    public final SimDate component8() {
        return this.contributionEndDate;
    }

    @NotNull
    public final AssetAllocation component9() {
        return this.assetAllocation;
    }

    @NotNull
    public final FundsUtilisation component10() {
        return this.interestUtilisation;
    }

    @NotNull
    public final FundsUtilisation component11() {
        return this.dividendUtilisation;
    }

    @Nullable
    public final ValueProvider<Double> component12() {
        return this.withdrawalAmount;
    }

    @NotNull
    public final Periodicity component13() {
        return this.withdrawalPeriodicity;
    }

    @Nullable
    public final SimDate component14() {
        return this.withdrawalStartDate;
    }

    @Nullable
    public final SimDate component15() {
        return this.withdrawalEndDate;
    }

    @Nullable
    public final Double component16() {
        return this.managementFee;
    }

    @Nullable
    public final Double component17() {
        return this.performanceFee;
    }

    @NotNull
    public final Investment copy(@NotNull String tag, @Nullable Person owner, @Nullable String taxCode, double reconBalance, @Nullable ValueProvider<Double> contributionAmount, @NotNull Periodicity contributionPeriodicity, @Nullable SimDate contributionStartDate, @Nullable SimDate contributionEndDate, @NotNull AssetAllocation assetAllocation, @NotNull FundsUtilisation interestUtilisation, @NotNull FundsUtilisation dividendUtilisation, @Nullable ValueProvider<Double> withdrawalAmount, @NotNull Periodicity withdrawalPeriodicity, @Nullable SimDate withdrawalStartDate, @Nullable SimDate withdrawalEndDate, @Nullable Double managementFee, @Nullable Double performanceFee) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)contributionPeriodicity), (String)"contributionPeriodicity");
        Intrinsics.checkNotNullParameter((Object)assetAllocation, (String)"assetAllocation");
        Intrinsics.checkNotNullParameter((Object)((Object)interestUtilisation), (String)"interestUtilisation");
        Intrinsics.checkNotNullParameter((Object)((Object)dividendUtilisation), (String)"dividendUtilisation");
        Intrinsics.checkNotNullParameter((Object)((Object)withdrawalPeriodicity), (String)"withdrawalPeriodicity");
        return new Investment(tag, owner, taxCode, reconBalance, contributionAmount, contributionPeriodicity, contributionStartDate, contributionEndDate, assetAllocation, interestUtilisation, dividendUtilisation, withdrawalAmount, withdrawalPeriodicity, withdrawalStartDate, withdrawalEndDate, managementFee, performanceFee);
    }

    public static /* synthetic */ Investment copy$default(Investment investment, String string, Person person, String string2, double d, ValueProvider valueProvider, Periodicity periodicity, SimDate simDate, SimDate simDate2, AssetAllocation assetAllocation, FundsUtilisation fundsUtilisation, FundsUtilisation fundsUtilisation2, ValueProvider valueProvider2, Periodicity periodicity2, SimDate simDate3, SimDate simDate4, Double d2, Double d3, int n, Object object) {
        if ((n & 1) != 0) {
            string = investment.tag;
        }
        if ((n & 2) != 0) {
            person = investment.owner;
        }
        if ((n & 4) != 0) {
            string2 = investment.taxCode;
        }
        if ((n & 8) != 0) {
            d = investment.reconBalance;
        }
        if ((n & 0x10) != 0) {
            valueProvider = investment.contributionAmount;
        }
        if ((n & 0x20) != 0) {
            periodicity = investment.contributionPeriodicity;
        }
        if ((n & 0x40) != 0) {
            simDate = investment.contributionStartDate;
        }
        if ((n & 0x80) != 0) {
            simDate2 = investment.contributionEndDate;
        }
        if ((n & 0x100) != 0) {
            assetAllocation = investment.assetAllocation;
        }
        if ((n & 0x200) != 0) {
            fundsUtilisation = investment.interestUtilisation;
        }
        if ((n & 0x400) != 0) {
            fundsUtilisation2 = investment.dividendUtilisation;
        }
        if ((n & 0x800) != 0) {
            valueProvider2 = investment.withdrawalAmount;
        }
        if ((n & 0x1000) != 0) {
            periodicity2 = investment.withdrawalPeriodicity;
        }
        if ((n & 0x2000) != 0) {
            simDate3 = investment.withdrawalStartDate;
        }
        if ((n & 0x4000) != 0) {
            simDate4 = investment.withdrawalEndDate;
        }
        if ((n & 0x8000) != 0) {
            d2 = investment.managementFee;
        }
        if ((n & 0x10000) != 0) {
            d3 = investment.performanceFee;
        }
        return investment.copy(string, person, string2, d, valueProvider, periodicity, simDate, simDate2, assetAllocation, fundsUtilisation, fundsUtilisation2, valueProvider2, periodicity2, simDate3, simDate4, d2, d3);
    }

    @NotNull
    public String toString() {
        return "Investment(tag=" + this.tag + ", owner=" + this.owner + ", taxCode=" + this.taxCode + ", reconBalance=" + this.reconBalance + ", contributionAmount=" + this.contributionAmount + ", contributionPeriodicity=" + this.contributionPeriodicity + ", contributionStartDate=" + this.contributionStartDate + ", contributionEndDate=" + this.contributionEndDate + ", assetAllocation=" + this.assetAllocation + ", interestUtilisation=" + this.interestUtilisation + ", dividendUtilisation=" + this.dividendUtilisation + ", withdrawalAmount=" + this.withdrawalAmount + ", withdrawalPeriodicity=" + this.withdrawalPeriodicity + ", withdrawalStartDate=" + this.withdrawalStartDate + ", withdrawalEndDate=" + this.withdrawalEndDate + ", managementFee=" + this.managementFee + ", performanceFee=" + this.performanceFee + ")";
    }

    public int hashCode() {
        int result = this.tag.hashCode();
        result = result * 31 + (this.owner == null ? 0 : this.owner.hashCode());
        result = result * 31 + (this.taxCode == null ? 0 : this.taxCode.hashCode());
        result = result * 31 + Double.hashCode(this.reconBalance);
        result = result * 31 + (this.contributionAmount == null ? 0 : this.contributionAmount.hashCode());
        result = result * 31 + this.contributionPeriodicity.hashCode();
        result = result * 31 + (this.contributionStartDate == null ? 0 : this.contributionStartDate.hashCode());
        result = result * 31 + (this.contributionEndDate == null ? 0 : this.contributionEndDate.hashCode());
        result = result * 31 + this.assetAllocation.hashCode();
        result = result * 31 + this.interestUtilisation.hashCode();
        result = result * 31 + this.dividendUtilisation.hashCode();
        result = result * 31 + (this.withdrawalAmount == null ? 0 : this.withdrawalAmount.hashCode());
        result = result * 31 + this.withdrawalPeriodicity.hashCode();
        result = result * 31 + (this.withdrawalStartDate == null ? 0 : this.withdrawalStartDate.hashCode());
        result = result * 31 + (this.withdrawalEndDate == null ? 0 : this.withdrawalEndDate.hashCode());
        result = result * 31 + (this.managementFee == null ? 0 : ((Object)this.managementFee).hashCode());
        result = result * 31 + (this.performanceFee == null ? 0 : ((Object)this.performanceFee).hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Investment)) {
            return false;
        }
        Investment investment = (Investment)other;
        if (!Intrinsics.areEqual((Object)this.tag, (Object)investment.tag)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.owner, (Object)investment.owner)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.taxCode, (Object)investment.taxCode)) {
            return false;
        }
        if (Double.compare(this.reconBalance, investment.reconBalance) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual(this.contributionAmount, investment.contributionAmount)) {
            return false;
        }
        if (this.contributionPeriodicity != investment.contributionPeriodicity) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.contributionStartDate, (Object)investment.contributionStartDate)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.contributionEndDate, (Object)investment.contributionEndDate)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.assetAllocation, (Object)investment.assetAllocation)) {
            return false;
        }
        if (this.interestUtilisation != investment.interestUtilisation) {
            return false;
        }
        if (this.dividendUtilisation != investment.dividendUtilisation) {
            return false;
        }
        if (!Intrinsics.areEqual(this.withdrawalAmount, investment.withdrawalAmount)) {
            return false;
        }
        if (this.withdrawalPeriodicity != investment.withdrawalPeriodicity) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.withdrawalStartDate, (Object)investment.withdrawalStartDate)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.withdrawalEndDate, (Object)investment.withdrawalEndDate)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.managementFee, (Object)investment.managementFee)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.performanceFee, (Object)investment.performanceFee);
    }

    private static final Double createCompos$lambda$0(Investment this$0, FinancialCompo financialCompo, SimDate date) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)financialCompo, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        SimDate sop = SimDate.Companion.max(date.minus(12), this$0.getHousehold().getReconDate());
        double delta = this$0.getBalance(date) - this$0.getBalance(sop);
        return this$0.performanceFee / (double)100 * delta;
    }

    private static final Double createCompos$lambda$1(Investment this$0, FinancialCompo compo, SimDate date) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)compo, (String)"compo");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return this$0.managementFee / 100.0 * compo.getHolding().getBalance(date.minus(1));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010\u0005\u001a\u00020\u00002\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006J\u0010\u0010\b\u001a\u00020\u00002\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0010\u0010\n\u001a\u00020\u00002\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\f\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\tJ\u0010\u0010\r\u001a\u00020\u00002\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eJ\u0015\u0010\u0010\u001a\u00020\u00002\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010\u0012\u001a\u00020\u00002\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0015\u0010\u0014\u001a\u00020\u00002\b\u0010\u0014\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u001fJ\u0015\u0010\u0015\u001a\u00020\u00002\b\u0010\u0015\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u001fJ\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00002\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017J\u0016\u0010\u0019\u001a\u00020\u00002\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006J\u0010\u0010\u001a\u001a\u00020\u00002\b\u0010\u001a\u001a\u0004\u0018\u00010\tJ\u0010\u0010\u001b\u001a\u00020\u00002\b\u0010\u001b\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\u001c\u001a\u00020\u00002\b\u0010\u001c\u001a\u0004\u0018\u00010\tR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lio/fincast/holding/impl/core/Investment$Builder;", "", "()V", "assetAllocation", "Lio/fincast/holding/impl/core/AssetAllocation;", "contributionAmount", "Lio/fincast/compo/ValueProvider;", "", "contributionEndDate", "Lio/fincast/engine/SimDate;", "contributionPeriodicity", "Lio/fincast/enums/Periodicity;", "contributionStartDate", "dividendUtilisation", "Lio/fincast/enums/FundsUtilisation;", "interestUtilisation", "managementFee", "Ljava/lang/Double;", "owner", "Lio/fincast/household/Person;", "performanceFee", "reconBalance", "tag", "", "taxCode", "withdrawalAmount", "withdrawalEndDate", "withdrawalPeriodicity", "withdrawalStartDate", "build", "Lio/fincast/holding/impl/core/Investment;", "(Ljava/lang/Double;)Lio/fincast/holding/impl/core/Investment$Builder;", "fincast"})
    @SourceDebugExtension(value={"SMAP\nInvestment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Investment.kt\nio/fincast/holding/impl/core/Investment$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,278:1\n1#2:279\n*E\n"})
    public static final class Builder {
        @Nullable
        private String tag;
        @Nullable
        private String taxCode;
        @Nullable
        private Person owner;
        @Nullable
        private Double reconBalance;
        @Nullable
        private ValueProvider<Double> contributionAmount;
        @Nullable
        private Periodicity contributionPeriodicity;
        @Nullable
        private SimDate contributionStartDate;
        @Nullable
        private SimDate contributionEndDate;
        @Nullable
        private AssetAllocation assetAllocation;
        @Nullable
        private FundsUtilisation interestUtilisation;
        @Nullable
        private FundsUtilisation dividendUtilisation;
        @Nullable
        private ValueProvider<Double> withdrawalAmount;
        @Nullable
        private Periodicity withdrawalPeriodicity;
        @Nullable
        private SimDate withdrawalStartDate;
        @Nullable
        private SimDate withdrawalEndDate;
        @Nullable
        private Double managementFee;
        @Nullable
        private Double performanceFee;

        @NotNull
        public final Builder tag(@NotNull String tag) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Builder $this$tag_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$tag_u24lambda_u240.tag = tag;
            return builder;
        }

        @NotNull
        public final Builder taxCode(@Nullable String taxCode) {
            Builder builder;
            Builder $this$taxCode_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$taxCode_u24lambda_u241.taxCode = taxCode;
            return builder;
        }

        @NotNull
        public final Builder owner(@Nullable Person owner) {
            Builder builder;
            Builder $this$owner_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$owner_u24lambda_u242.owner = owner;
            return builder;
        }

        @NotNull
        public final Builder reconBalance(@Nullable Double reconBalance) {
            Builder builder;
            Builder $this$reconBalance_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$reconBalance_u24lambda_u243.reconBalance = reconBalance;
            return builder;
        }

        @NotNull
        public final Builder contributionAmount(@Nullable ValueProvider<Double> contributionAmount) {
            Builder builder;
            Builder $this$contributionAmount_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$contributionAmount_u24lambda_u244.contributionAmount = contributionAmount;
            return builder;
        }

        @NotNull
        public final Builder contributionPeriodicity(@Nullable Periodicity contributionPeriodicity) {
            Builder builder;
            Builder $this$contributionPeriodicity_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$contributionPeriodicity_u24lambda_u245.contributionPeriodicity = contributionPeriodicity;
            return builder;
        }

        @NotNull
        public final Builder contributionStartDate(@Nullable SimDate contributionStartDate) {
            Builder builder;
            Builder $this$contributionStartDate_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$contributionStartDate_u24lambda_u246.contributionStartDate = contributionStartDate;
            return builder;
        }

        @NotNull
        public final Builder contributionEndDate(@Nullable SimDate contributionEndDate) {
            Builder builder;
            Builder $this$contributionEndDate_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$contributionEndDate_u24lambda_u247.contributionEndDate = contributionEndDate;
            return builder;
        }

        @NotNull
        public final Builder assetAllocation(@Nullable AssetAllocation assetAllocation) {
            Builder builder;
            Builder $this$assetAllocation_u24lambda_u248 = builder = this;
            boolean bl = false;
            $this$assetAllocation_u24lambda_u248.assetAllocation = assetAllocation;
            return builder;
        }

        @NotNull
        public final Builder interestUtilisation(@Nullable FundsUtilisation interestUtilisation) {
            Builder builder;
            Builder $this$interestUtilisation_u24lambda_u249 = builder = this;
            boolean bl = false;
            $this$interestUtilisation_u24lambda_u249.interestUtilisation = interestUtilisation;
            return builder;
        }

        @NotNull
        public final Builder dividendUtilisation(@Nullable FundsUtilisation dividendUtilisation) {
            Builder builder;
            Builder $this$dividendUtilisation_u24lambda_u2410 = builder = this;
            boolean bl = false;
            $this$dividendUtilisation_u24lambda_u2410.dividendUtilisation = dividendUtilisation;
            return builder;
        }

        @NotNull
        public final Builder withdrawalAmount(@Nullable ValueProvider<Double> withdrawalAmount) {
            Builder builder;
            Builder $this$withdrawalAmount_u24lambda_u2411 = builder = this;
            boolean bl = false;
            $this$withdrawalAmount_u24lambda_u2411.withdrawalAmount = withdrawalAmount;
            return builder;
        }

        @NotNull
        public final Builder withdrawalPeriodicity(@Nullable Periodicity withdrawalPeriodicity) {
            Builder builder;
            Builder $this$withdrawalPeriodicity_u24lambda_u2412 = builder = this;
            boolean bl = false;
            $this$withdrawalPeriodicity_u24lambda_u2412.withdrawalPeriodicity = withdrawalPeriodicity;
            return builder;
        }

        @NotNull
        public final Builder withdrawalStartDate(@Nullable SimDate withdrawalStartDate) {
            Builder builder;
            Builder $this$withdrawalStartDate_u24lambda_u2413 = builder = this;
            boolean bl = false;
            $this$withdrawalStartDate_u24lambda_u2413.withdrawalStartDate = withdrawalStartDate;
            return builder;
        }

        @NotNull
        public final Builder withdrawalEndDate(@Nullable SimDate withdrawalEndDate) {
            Builder builder;
            Builder $this$withdrawalEndDate_u24lambda_u2414 = builder = this;
            boolean bl = false;
            $this$withdrawalEndDate_u24lambda_u2414.withdrawalEndDate = withdrawalEndDate;
            return builder;
        }

        @NotNull
        public final Builder managementFee(@Nullable Double managementFee) {
            Builder builder;
            Builder $this$managementFee_u24lambda_u2415 = builder = this;
            boolean bl = false;
            $this$managementFee_u24lambda_u2415.managementFee = managementFee;
            return builder;
        }

        @NotNull
        public final Builder performanceFee(@Nullable Double performanceFee) {
            Builder builder;
            Builder $this$performanceFee_u24lambda_u2416 = builder = this;
            boolean bl = false;
            $this$performanceFee_u24lambda_u2416.performanceFee = performanceFee;
            return builder;
        }

        @NotNull
        public final Investment build() {
            FundsUtilisation fundsUtilisation;
            FundsUtilisation fundsUtilisation2;
            String string = this.tag;
            if (string == null) {
                throw new IllegalArgumentException("tag is required");
            }
            String string2 = string;
            String string3 = this.taxCode;
            Person person = this.owner;
            Double d = this.reconBalance;
            double d2 = d != null ? d : 0.0;
            ValueProvider<Double> valueProvider = this.contributionAmount;
            Periodicity periodicity = this.contributionPeriodicity;
            if (periodicity == null) {
                periodicity = Periodicity.YEARLY;
            }
            Periodicity periodicity2 = periodicity;
            SimDate simDate = this.contributionStartDate;
            SimDate simDate2 = this.contributionEndDate;
            AssetAllocation assetAllocation = this.assetAllocation;
            if (assetAllocation == null) {
                throw new IllegalArgumentException("assetAllocation is required");
            }
            AssetAllocation assetAllocation2 = assetAllocation;
            FundsUtilisation fundsUtilisation3 = this.interestUtilisation;
            if (fundsUtilisation3 == null) {
                fundsUtilisation3 = fundsUtilisation2 = FundsUtilisation.COMPOUND;
            }
            if ((fundsUtilisation = this.dividendUtilisation) == null) {
                fundsUtilisation = FundsUtilisation.COMPOUND;
            }
            FundsUtilisation fundsUtilisation4 = fundsUtilisation;
            ValueProvider<Double> valueProvider2 = this.withdrawalAmount;
            Periodicity periodicity3 = this.withdrawalPeriodicity;
            if (periodicity3 == null) {
                periodicity3 = Periodicity.YEARLY;
            }
            Periodicity periodicity4 = periodicity3;
            SimDate simDate3 = this.withdrawalStartDate;
            SimDate simDate4 = this.withdrawalEndDate;
            Double d3 = this.managementFee;
            double d4 = d3 != null ? d3 : 0.0;
            Double d5 = this.performanceFee;
            double d6 = d5 != null ? d5 : 0.0;
            return new Investment(string2, person, string3, d2, valueProvider, periodicity2, simDate, simDate2, assetAllocation2, fundsUtilisation2, fundsUtilisation4, valueProvider2, periodicity4, simDate3, simDate4, d4, d6);
        }
    }
}

