/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.holding.impl.core;

import io.fincast.compo.FinancialCompo;
import io.fincast.compo.ValueProvider;
import io.fincast.compo.impl.CashflowCompo;
import io.fincast.compo.impl.FlowDirection;
import io.fincast.engine.SimDate;
import io.fincast.enums.FundsUtilisation;
import io.fincast.enums.Periodicity;
import io.fincast.enums.ProductType;
import io.fincast.holding.Contract;
import io.fincast.holding.base.HoldingBase;
import io.fincast.household.Person;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002:\u0001/BU\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u001d\u001a\u00020\u0004H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\u000f\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J\t\u0010!\u001a\u00020\fH\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003J]\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u00c6\u0001J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0014J\u0013\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+H\u00d6\u0003J\t\u0010,\u001a\u00020-H\u00d6\u0001J\t\u0010.\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001b\u00a8\u00060"}, d2={"Lio/fincast/holding/impl/core/Expense;", "Lio/fincast/holding/Contract;", "Lio/fincast/holding/base/HoldingBase;", "tag", "", "owner", "Lio/fincast/household/Person;", "taxCode", "amount", "Lio/fincast/compo/ValueProvider;", "", "periodicity", "Lio/fincast/enums/Periodicity;", "startDate", "Lio/fincast/engine/SimDate;", "endDate", "(Ljava/lang/String;Lio/fincast/household/Person;Ljava/lang/String;Lio/fincast/compo/ValueProvider;Lio/fincast/enums/Periodicity;Lio/fincast/engine/SimDate;Lio/fincast/engine/SimDate;)V", "getAmount", "()Lio/fincast/compo/ValueProvider;", "getEndDate", "()Lio/fincast/engine/SimDate;", "getOwner", "()Lio/fincast/household/Person;", "getPeriodicity", "()Lio/fincast/enums/Periodicity;", "getStartDate", "getTag", "()Ljava/lang/String;", "getTaxCode", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "createCompos", "", "Lio/fincast/compo/FinancialCompo;", "equals", "", "other", "", "hashCode", "", "toString", "Builder", "fincast"})
public final class Expense
extends HoldingBase
implements Contract {
    @NotNull
    private final String tag;
    @Nullable
    private final Person owner;
    @Nullable
    private final String taxCode;
    @NotNull
    private final ValueProvider<Double> amount;
    @NotNull
    private final Periodicity periodicity;
    @Nullable
    private final SimDate startDate;
    @Nullable
    private final SimDate endDate;

    public Expense(@NotNull String tag, @Nullable Person owner, @Nullable String taxCode, @NotNull ValueProvider<Double> amount, @NotNull Periodicity periodicity, @Nullable SimDate startDate, @Nullable SimDate endDate) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter(amount, (String)"amount");
        Intrinsics.checkNotNullParameter((Object)((Object)periodicity), (String)"periodicity");
        super(tag, owner, ProductType.EXPENSE, taxCode);
        this.tag = tag;
        this.owner = owner;
        this.taxCode = taxCode;
        this.amount = amount;
        this.periodicity = periodicity;
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public /* synthetic */ Expense(String string, Person person, String string2, ValueProvider valueProvider, Periodicity periodicity, SimDate simDate, SimDate simDate2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            person = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 0x10) != 0) {
            periodicity = Periodicity.YEARLY;
        }
        if ((n & 0x20) != 0) {
            simDate = null;
        }
        if ((n & 0x40) != 0) {
            simDate2 = null;
        }
        this(string, person, string2, valueProvider, periodicity, simDate, simDate2);
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @Override
    @Nullable
    public Person getOwner() {
        return this.owner;
    }

    @Override
    @Nullable
    public String getTaxCode() {
        return this.taxCode;
    }

    @NotNull
    public final ValueProvider<Double> getAmount() {
        return this.amount;
    }

    @NotNull
    public final Periodicity getPeriodicity() {
        return this.periodicity;
    }

    @Override
    @Nullable
    public SimDate getStartDate() {
        return this.startDate;
    }

    @Override
    @Nullable
    public SimDate getEndDate() {
        return this.endDate;
    }

    @Override
    @NotNull
    protected List<FinancialCompo> createCompos() {
        Object object = this.getOwner();
        if (object == null || (object = object.getEndOfExpenseDate(this.getEndDate())) == null) {
            object = this.getEndDate();
        }
        Object endDate = object;
        FundsUtilisation fundsUtilisation = FundsUtilisation.DISBURSE;
        FlowDirection flowDirection = FlowDirection.OUTGOING;
        ValueProvider<Double> valueProvider = this.amount;
        SimDate simDate = this.getStartDate();
        Periodicity periodicity = this.periodicity;
        CashflowCompo cf = new CashflowCompo(this, "expense", fundsUtilisation, valueProvider, flowDirection, periodicity, simDate, (SimDate)endDate, false, 256, null);
        return CollectionsKt.listOf((Object)cf);
    }

    @NotNull
    public final String component1() {
        return this.tag;
    }

    @Nullable
    public final Person component2() {
        return this.owner;
    }

    @Nullable
    public final String component3() {
        return this.taxCode;
    }

    @NotNull
    public final ValueProvider<Double> component4() {
        return this.amount;
    }

    @NotNull
    public final Periodicity component5() {
        return this.periodicity;
    }

    @Nullable
    public final SimDate component6() {
        return this.startDate;
    }

    @Nullable
    public final SimDate component7() {
        return this.endDate;
    }

    @NotNull
    public final Expense copy(@NotNull String tag, @Nullable Person owner, @Nullable String taxCode, @NotNull ValueProvider<Double> amount, @NotNull Periodicity periodicity, @Nullable SimDate startDate, @Nullable SimDate endDate) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter(amount, (String)"amount");
        Intrinsics.checkNotNullParameter((Object)((Object)periodicity), (String)"periodicity");
        return new Expense(tag, owner, taxCode, amount, periodicity, startDate, endDate);
    }

    public static /* synthetic */ Expense copy$default(Expense expense, String string, Person person, String string2, ValueProvider valueProvider, Periodicity periodicity, SimDate simDate, SimDate simDate2, int n, Object object) {
        if ((n & 1) != 0) {
            string = expense.tag;
        }
        if ((n & 2) != 0) {
            person = expense.owner;
        }
        if ((n & 4) != 0) {
            string2 = expense.taxCode;
        }
        if ((n & 8) != 0) {
            valueProvider = expense.amount;
        }
        if ((n & 0x10) != 0) {
            periodicity = expense.periodicity;
        }
        if ((n & 0x20) != 0) {
            simDate = expense.startDate;
        }
        if ((n & 0x40) != 0) {
            simDate2 = expense.endDate;
        }
        return expense.copy(string, person, string2, valueProvider, periodicity, simDate, simDate2);
    }

    @NotNull
    public String toString() {
        return "Expense(tag=" + this.tag + ", owner=" + this.owner + ", taxCode=" + this.taxCode + ", amount=" + this.amount + ", periodicity=" + this.periodicity + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ")";
    }

    public int hashCode() {
        int result = this.tag.hashCode();
        result = result * 31 + (this.owner == null ? 0 : this.owner.hashCode());
        result = result * 31 + (this.taxCode == null ? 0 : this.taxCode.hashCode());
        result = result * 31 + this.amount.hashCode();
        result = result * 31 + this.periodicity.hashCode();
        result = result * 31 + (this.startDate == null ? 0 : this.startDate.hashCode());
        result = result * 31 + (this.endDate == null ? 0 : this.endDate.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Expense)) {
            return false;
        }
        Expense expense = (Expense)other;
        if (!Intrinsics.areEqual((Object)this.tag, (Object)expense.tag)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.owner, (Object)expense.owner)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.taxCode, (Object)expense.taxCode)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.amount, expense.amount)) {
            return false;
        }
        if (this.periodicity != expense.periodicity) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.startDate, (Object)expense.startDate)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.endDate, (Object)expense.endDate);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00002\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0006\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\b\u001a\u00020\u00002\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0010\u0010\n\u001a\u00020\u00002\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\f\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eR\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/fincast/holding/impl/core/Expense$Builder;", "", "()V", "amount", "Lio/fincast/compo/ValueProvider;", "", "endDate", "Lio/fincast/engine/SimDate;", "owner", "Lio/fincast/household/Person;", "periodicity", "Lio/fincast/enums/Periodicity;", "startDate", "tag", "", "taxCode", "build", "Lio/fincast/holding/impl/core/Expense;", "fincast"})
    @SourceDebugExtension(value={"SMAP\nExpense.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Expense.kt\nio/fincast/holding/impl/core/Expense$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n1#2:86\n*E\n"})
    public static final class Builder {
        @Nullable
        private String tag;
        @Nullable
        private String taxCode;
        @Nullable
        private Person owner;
        @Nullable
        private ValueProvider<Double> amount;
        @Nullable
        private Periodicity periodicity;
        @Nullable
        private SimDate startDate;
        @Nullable
        private SimDate endDate;

        @NotNull
        public final Builder tag(@NotNull String tag) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Builder $this$tag_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$tag_u24lambda_u240.tag = tag;
            return builder;
        }

        @NotNull
        public final Builder taxCode(@Nullable String taxCode) {
            Builder builder;
            Builder $this$taxCode_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$taxCode_u24lambda_u241.taxCode = taxCode;
            return builder;
        }

        @NotNull
        public final Builder owner(@Nullable Person owner) {
            Builder builder;
            Builder $this$owner_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$owner_u24lambda_u242.owner = owner;
            return builder;
        }

        @NotNull
        public final Builder amount(@NotNull ValueProvider<Double> amount) {
            Builder builder;
            Intrinsics.checkNotNullParameter(amount, (String)"amount");
            Builder $this$amount_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$amount_u24lambda_u243.amount = amount;
            return builder;
        }

        @NotNull
        public final Builder periodicity(@Nullable Periodicity periodicity) {
            Builder builder;
            Builder $this$periodicity_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$periodicity_u24lambda_u244.periodicity = periodicity;
            return builder;
        }

        @NotNull
        public final Builder startDate(@Nullable SimDate startDate) {
            Builder builder;
            Builder $this$startDate_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$startDate_u24lambda_u245.startDate = startDate;
            return builder;
        }

        @NotNull
        public final Builder endDate(@Nullable SimDate endDate) {
            Builder builder;
            Builder $this$endDate_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$endDate_u24lambda_u246.endDate = endDate;
            return builder;
        }

        @NotNull
        public final Expense build() {
            String string = this.tag;
            if (string == null) {
                throw new IllegalArgumentException("tag is required");
            }
            String string2 = string;
            String string3 = this.taxCode;
            Person person = this.owner;
            ValueProvider<Double> valueProvider = this.amount;
            if (valueProvider == null) {
                throw new IllegalArgumentException("amount is required");
            }
            ValueProvider<Double> valueProvider2 = valueProvider;
            Periodicity periodicity = this.periodicity;
            if (periodicity == null) {
                periodicity = Periodicity.YEARLY;
            }
            Periodicity periodicity2 = periodicity;
            SimDate simDate = this.startDate;
            SimDate simDate2 = this.endDate;
            return new Expense(string2, person, string3, valueProvider2, periodicity2, simDate, simDate2);
        }
    }
}

