/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.holding.impl.core;

import io.fincast.compo.FinancialCompo;
import io.fincast.compo.ValueProviders;
import io.fincast.compo.impl.InterestCompo;
import io.fincast.enums.FundsUtilisation;
import io.fincast.enums.Periodicity;
import io.fincast.enums.ProductType;
import io.fincast.holding.base.ValuableBase;
import io.fincast.household.Person;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001.BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\bH\u00c6\u0003J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010 \u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJ\t\u0010!\u001a\u00020\fH\u00c6\u0003J\\\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001\u00a2\u0006\u0002\u0010#J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0014J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u00d6\u0003J\t\u0010+\u001a\u00020,H\u00d6\u0001J\t\u0010-\u001a\u00020\u0003H\u00d6\u0001R\u0015\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0015\u0010\n\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019\u00a8\u0006/"}, d2={"Lio/fincast/holding/impl/core/BankAccount;", "Lio/fincast/holding/base/ValuableBase;", "tag", "", "owner", "Lio/fincast/household/Person;", "taxCode", "reconBalance", "", "creditInterestRate", "debitInterestRate", "interestPeriodicity", "Lio/fincast/enums/Periodicity;", "(Ljava/lang/String;Lio/fincast/household/Person;Ljava/lang/String;DLjava/lang/Double;Ljava/lang/Double;Lio/fincast/enums/Periodicity;)V", "getCreditInterestRate", "()Ljava/lang/Double;", "Ljava/lang/Double;", "getDebitInterestRate", "getInterestPeriodicity", "()Lio/fincast/enums/Periodicity;", "getOwner", "()Lio/fincast/household/Person;", "getReconBalance", "()D", "getTag", "()Ljava/lang/String;", "getTaxCode", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "(Ljava/lang/String;Lio/fincast/household/Person;Ljava/lang/String;DLjava/lang/Double;Ljava/lang/Double;Lio/fincast/enums/Periodicity;)Lio/fincast/holding/impl/core/BankAccount;", "createCompos", "", "Lio/fincast/compo/FinancialCompo;", "equals", "", "other", "", "hashCode", "", "toString", "Builder", "fincast"})
public final class BankAccount
extends ValuableBase {
    @NotNull
    private final String tag;
    @Nullable
    private final Person owner;
    @Nullable
    private final String taxCode;
    private final double reconBalance;
    @Nullable
    private final Double creditInterestRate;
    @Nullable
    private final Double debitInterestRate;
    @NotNull
    private final Periodicity interestPeriodicity;

    public BankAccount(@NotNull String tag, @Nullable Person owner, @Nullable String taxCode, double reconBalance, @Nullable Double creditInterestRate, @Nullable Double debitInterestRate, @NotNull Periodicity interestPeriodicity) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)interestPeriodicity), (String)"interestPeriodicity");
        super(tag, owner, ProductType.VALUABLE, taxCode, reconBalance);
        this.tag = tag;
        this.owner = owner;
        this.taxCode = taxCode;
        this.reconBalance = reconBalance;
        this.creditInterestRate = creditInterestRate;
        this.debitInterestRate = debitInterestRate;
        this.interestPeriodicity = interestPeriodicity;
    }

    public /* synthetic */ BankAccount(String string, Person person, String string2, double d, Double d2, Double d3, Periodicity periodicity, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            person = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            d = 0.0;
        }
        if ((n & 0x10) != 0) {
            d2 = 0.0;
        }
        if ((n & 0x20) != 0) {
            d3 = 0.0;
        }
        if ((n & 0x40) != 0) {
            periodicity = Periodicity.YEARLY;
        }
        this(string, person, string2, d, d2, d3, periodicity);
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @Override
    @Nullable
    public Person getOwner() {
        return this.owner;
    }

    @Override
    @Nullable
    public String getTaxCode() {
        return this.taxCode;
    }

    @Override
    public double getReconBalance() {
        return this.reconBalance;
    }

    @Nullable
    public final Double getCreditInterestRate() {
        return this.creditInterestRate;
    }

    @Nullable
    public final Double getDebitInterestRate() {
        return this.debitInterestRate;
    }

    @NotNull
    public final Periodicity getInterestPeriodicity() {
        return this.interestPeriodicity;
    }

    @Override
    @NotNull
    protected List<FinancialCompo> createCompos() {
        List compos = new ArrayList();
        if (this.creditInterestRate != null && !Intrinsics.areEqual((Double)this.creditInterestRate, (double)0.0)) {
            compos.add(new InterestCompo(this, "creditInterest", ValueProviders.prevEomCreditBalance(), ValueProviders.constValue(this.creditInterestRate), this.interestPeriodicity, FundsUtilisation.COMPOUND));
        }
        if (this.debitInterestRate != null && !Intrinsics.areEqual((Double)this.debitInterestRate, (double)0.0)) {
            compos.add(new InterestCompo(this, "debitInterest", ValueProviders.prevEomDebitBalance(), ValueProviders.constValue(this.debitInterestRate), this.interestPeriodicity, FundsUtilisation.COMPOUND));
        }
        return compos;
    }

    @NotNull
    public final String component1() {
        return this.tag;
    }

    @Nullable
    public final Person component2() {
        return this.owner;
    }

    @Nullable
    public final String component3() {
        return this.taxCode;
    }

    public final double component4() {
        return this.reconBalance;
    }

    @Nullable
    public final Double component5() {
        return this.creditInterestRate;
    }

    @Nullable
    public final Double component6() {
        return this.debitInterestRate;
    }

    @NotNull
    public final Periodicity component7() {
        return this.interestPeriodicity;
    }

    @NotNull
    public final BankAccount copy(@NotNull String tag, @Nullable Person owner, @Nullable String taxCode, double reconBalance, @Nullable Double creditInterestRate, @Nullable Double debitInterestRate, @NotNull Periodicity interestPeriodicity) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)interestPeriodicity), (String)"interestPeriodicity");
        return new BankAccount(tag, owner, taxCode, reconBalance, creditInterestRate, debitInterestRate, interestPeriodicity);
    }

    public static /* synthetic */ BankAccount copy$default(BankAccount bankAccount, String string, Person person, String string2, double d, Double d2, Double d3, Periodicity periodicity, int n, Object object) {
        if ((n & 1) != 0) {
            string = bankAccount.tag;
        }
        if ((n & 2) != 0) {
            person = bankAccount.owner;
        }
        if ((n & 4) != 0) {
            string2 = bankAccount.taxCode;
        }
        if ((n & 8) != 0) {
            d = bankAccount.reconBalance;
        }
        if ((n & 0x10) != 0) {
            d2 = bankAccount.creditInterestRate;
        }
        if ((n & 0x20) != 0) {
            d3 = bankAccount.debitInterestRate;
        }
        if ((n & 0x40) != 0) {
            periodicity = bankAccount.interestPeriodicity;
        }
        return bankAccount.copy(string, person, string2, d, d2, d3, periodicity);
    }

    @NotNull
    public String toString() {
        return "BankAccount(tag=" + this.tag + ", owner=" + this.owner + ", taxCode=" + this.taxCode + ", reconBalance=" + this.reconBalance + ", creditInterestRate=" + this.creditInterestRate + ", debitInterestRate=" + this.debitInterestRate + ", interestPeriodicity=" + this.interestPeriodicity + ")";
    }

    public int hashCode() {
        int result = this.tag.hashCode();
        result = result * 31 + (this.owner == null ? 0 : this.owner.hashCode());
        result = result * 31 + (this.taxCode == null ? 0 : this.taxCode.hashCode());
        result = result * 31 + Double.hashCode(this.reconBalance);
        result = result * 31 + (this.creditInterestRate == null ? 0 : ((Object)this.creditInterestRate).hashCode());
        result = result * 31 + (this.debitInterestRate == null ? 0 : ((Object)this.debitInterestRate).hashCode());
        result = result * 31 + this.interestPeriodicity.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BankAccount)) {
            return false;
        }
        BankAccount bankAccount = (BankAccount)other;
        if (!Intrinsics.areEqual((Object)this.tag, (Object)bankAccount.tag)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.owner, (Object)bankAccount.owner)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.taxCode, (Object)bankAccount.taxCode)) {
            return false;
        }
        if (Double.compare(this.reconBalance, bankAccount.reconBalance) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.creditInterestRate, (Object)bankAccount.creditInterestRate)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.debitInterestRate, (Object)bankAccount.debitInterestRate)) {
            return false;
        }
        return this.interestPeriodicity == bankAccount.interestPeriodicity;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J\u0015\u0010\u0003\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010\u0006\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0007\u001a\u00020\u00002\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0010\u0010\t\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0015\u0010\u000b\u001a\u00020\u00002\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u00002\b\u0010\u000e\u001a\u0004\u0018\u00010\rR\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/fincast/holding/impl/core/BankAccount$Builder;", "", "()V", "creditInterestRate", "", "Ljava/lang/Double;", "debitInterestRate", "interestPeriodicity", "Lio/fincast/enums/Periodicity;", "owner", "Lio/fincast/household/Person;", "reconBalance", "tag", "", "taxCode", "build", "Lio/fincast/holding/impl/core/BankAccount;", "(Ljava/lang/Double;)Lio/fincast/holding/impl/core/BankAccount$Builder;", "fincast"})
    @SourceDebugExtension(value={"SMAP\nBankAccount.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BankAccount.kt\nio/fincast/holding/impl/core/BankAccount$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1#2:96\n*E\n"})
    public static final class Builder {
        @Nullable
        private String tag;
        @Nullable
        private String taxCode;
        @Nullable
        private Person owner;
        @Nullable
        private Double reconBalance;
        @Nullable
        private Double creditInterestRate;
        @Nullable
        private Double debitInterestRate;
        @Nullable
        private Periodicity interestPeriodicity;

        @NotNull
        public final Builder tag(@NotNull String tag) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Builder $this$tag_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$tag_u24lambda_u240.tag = tag;
            return builder;
        }

        @NotNull
        public final Builder taxCode(@Nullable String taxCode) {
            Builder builder;
            Builder $this$taxCode_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$taxCode_u24lambda_u241.taxCode = taxCode;
            return builder;
        }

        @NotNull
        public final Builder owner(@Nullable Person owner) {
            Builder builder;
            Builder $this$owner_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$owner_u24lambda_u242.owner = owner;
            return builder;
        }

        @NotNull
        public final Builder reconBalance(@Nullable Double reconBalance) {
            Builder builder;
            Builder $this$reconBalance_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$reconBalance_u24lambda_u243.reconBalance = reconBalance;
            return builder;
        }

        @NotNull
        public final Builder creditInterestRate(@Nullable Double creditInterestRate) {
            Builder builder;
            Builder $this$creditInterestRate_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$creditInterestRate_u24lambda_u244.creditInterestRate = creditInterestRate;
            return builder;
        }

        @NotNull
        public final Builder debitInterestRate(@Nullable Double debitInterestRate) {
            Builder builder;
            Builder $this$debitInterestRate_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$debitInterestRate_u24lambda_u245.debitInterestRate = debitInterestRate;
            return builder;
        }

        @NotNull
        public final Builder interestPeriodicity(@Nullable Periodicity interestPeriodicity) {
            Builder builder;
            Builder $this$interestPeriodicity_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$interestPeriodicity_u24lambda_u246.interestPeriodicity = interestPeriodicity;
            return builder;
        }

        @NotNull
        public final BankAccount build() {
            String string = this.tag;
            if (string == null) {
                throw new IllegalArgumentException("tag is required");
            }
            String string2 = string;
            String string3 = this.taxCode;
            Person person = this.owner;
            Double d = this.reconBalance;
            double d2 = d != null ? d : 0.0;
            Double d3 = this.creditInterestRate;
            double d4 = d3 != null ? d3 : 0.0;
            Double d5 = this.debitInterestRate;
            double d6 = d5 != null ? d5 : 0.0;
            Periodicity periodicity = this.interestPeriodicity;
            if (periodicity == null) {
                periodicity = Periodicity.YEARLY;
            }
            Periodicity periodicity2 = periodicity;
            return new BankAccount(string2, person, string3, d2, (Double)d4, d6, periodicity2);
        }
    }
}

