/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.holding.impl.ch;

import io.fincast.compo.FinancialCompo;
import io.fincast.engine.Booking;
import io.fincast.engine.ProjectionListener;
import io.fincast.engine.SimDate;
import io.fincast.enums.BookingKind;
import io.fincast.enums.ProductType;
import io.fincast.enums.Religion;
import io.fincast.holding.Contract;
import io.fincast.holding.Holding;
import io.fincast.holding.TaxHandler;
import io.fincast.holding.base.HoldingBase;
import io.fincast.holding.impl.ch.ChPillarOne;
import io.fincast.holding.impl.ch.ChPillarTwoCapital;
import io.fincast.holding.impl.ch.ChPillarTwoPension;
import io.fincast.holding.impl.ch.HouseholdExpenses;
import io.fincast.holding.impl.ch.IncomeTaxAggregation;
import io.fincast.holding.impl.ch.PersonalExpenses;
import io.fincast.holding.impl.core.Expense;
import io.fincast.holding.impl.core.Income;
import io.fincast.holding.impl.core.Investment;
import io.fincast.holding.impl.core.RealEstate;
import io.fincast.household.Person;
import io.fincast.spi.ChTaxHouseholdInfo;
import io.fincast.spi.ChTaxPersonalInfo;
import io.fincast.spi.ChTaxResult;
import io.fincast.spi.ChTaxService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u0086\b\u0018\u0000 ?2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0002>?B-\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\fJ\t\u0010\"\u001a\u00020\u0006H\u00c6\u0003J\t\u0010#\u001a\u00020\bH\u00c6\u0003J\t\u0010$\u001a\u00020\nH\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\nH\u00c6\u0003J3\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00c6\u0001J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0014J\u0013\u0010*\u001a\u00020\u00142\b\u0010+\u001a\u0004\u0018\u00010,H\u00d6\u0003J\u0018\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u000e2\u0006\u00100\u001a\u000201H\u0016J\t\u00102\u001a\u000203H\u00d6\u0001J\u0010\u00104\u001a\u00020\u00142\u0006\u00105\u001a\u000206H\u0002J\u0010\u00107\u001a\u00020.2\u0006\u00108\u001a\u000209H\u0016J\u0010\u0010:\u001a\u00020.2\u0006\u0010/\u001a\u00020\u000eH\u0016J\b\u0010;\u001a\u00020<H\u0002J\t\u0010=\u001a\u00020\u0006H\u00d6\u0001R\u0016\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0010R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006@"}, d2={"Lio/fincast/holding/impl/ch/ChTax;", "Lio/fincast/holding/Contract;", "Lio/fincast/holding/base/HoldingBase;", "Lio/fincast/engine/ProjectionListener;", "Lio/fincast/holding/TaxHandler;", "tag", "", "householdExpenses", "Lio/fincast/holding/impl/ch/HouseholdExpenses;", "partner1Expenses", "Lio/fincast/holding/impl/ch/PersonalExpenses;", "partner2Expenses", "(Ljava/lang/String;Lio/fincast/holding/impl/ch/HouseholdExpenses;Lio/fincast/holding/impl/ch/PersonalExpenses;Lio/fincast/holding/impl/ch/PersonalExpenses;)V", "endDate", "Lio/fincast/engine/SimDate;", "getEndDate", "()Lio/fincast/engine/SimDate;", "getHouseholdExpenses", "()Lio/fincast/holding/impl/ch/HouseholdExpenses;", "isActive", "", "getPartner1Expenses", "()Lio/fincast/holding/impl/ch/PersonalExpenses;", "getPartner2Expenses", "startDate", "getStartDate", "getTag", "()Ljava/lang/String;", "taxAggregation", "Lio/fincast/holding/impl/ch/IncomeTaxAggregation;", "getTaxAggregation", "()Lio/fincast/holding/impl/ch/IncomeTaxAggregation;", "setTaxAggregation", "(Lio/fincast/holding/impl/ch/IncomeTaxAggregation;)V", "component1", "component2", "component3", "component4", "copy", "createCompos", "", "Lio/fincast/compo/FinancialCompo;", "equals", "other", "", "handleTaxes", "", "date", "taxService", "Lio/fincast/spi/ChTaxService;", "hashCode", "", "isTaxableHolding", "holding", "Lio/fincast/holding/Holding;", "onBooking", "booking", "Lio/fincast/engine/Booking;", "onStartOfMonth", "taxableNetWealth", "", "toString", "Builder", "Companion", "fincast"})
@SourceDebugExtension(value={"SMAP\nChTax.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChTax.kt\nio/fincast/holding/impl/ch/ChTax\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,317:1\n766#2:318\n857#2,2:319\n1549#2:321\n1620#2,3:322\n*S KotlinDebug\n*F\n+ 1 ChTax.kt\nio/fincast/holding/impl/ch/ChTax\n*L\n291#1:318\n291#1:319,2\n292#1:321\n292#1:322,3\n*E\n"})
public final class ChTax
extends HoldingBase
implements Contract,
ProjectionListener,
TaxHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String tag;
    @NotNull
    private final HouseholdExpenses householdExpenses;
    @NotNull
    private final PersonalExpenses partner1Expenses;
    @Nullable
    private final PersonalExpenses partner2Expenses;
    @Nullable
    private final SimDate startDate;
    @Nullable
    private final SimDate endDate;
    private boolean isActive;
    @NotNull
    private IncomeTaxAggregation taxAggregation;
    @NotNull
    private static final String SalaryPrimary = "primarySalary";
    @NotNull
    private static final String SalarySecondary = "secondarySalary";
    @NotNull
    private static final String ExpenseRent = "rent";
    @NotNull
    private static final String ExpenseAlimonyMinor = "alimonyMinor";
    @NotNull
    private static final String ExpenseAlimonyAdult = "alimonyAdult";
    @NotNull
    private static final String Investment3a = "3a";

    public ChTax(@NotNull String tag, @NotNull HouseholdExpenses householdExpenses, @NotNull PersonalExpenses partner1Expenses, @Nullable PersonalExpenses partner2Expenses) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)householdExpenses, (String)"householdExpenses");
        Intrinsics.checkNotNullParameter((Object)partner1Expenses, (String)"partner1Expenses");
        super(tag, null, ProductType.EXPENSE, null);
        this.tag = tag;
        this.householdExpenses = householdExpenses;
        this.partner1Expenses = partner1Expenses;
        this.partner2Expenses = partner2Expenses;
        this.taxAggregation = new IncomeTaxAggregation(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Short.MAX_VALUE, null);
    }

    public /* synthetic */ ChTax(String string, HouseholdExpenses householdExpenses, PersonalExpenses personalExpenses, PersonalExpenses personalExpenses2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            householdExpenses = new HouseholdExpenses(0.0, 0.0, 0.0, 7, null);
        }
        if ((n & 4) != 0) {
            personalExpenses = new PersonalExpenses(0.0, 0.0, 0.0, 0.0, 15, null);
        }
        if ((n & 8) != 0) {
            personalExpenses2 = null;
        }
        this(string, householdExpenses, personalExpenses, personalExpenses2);
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @NotNull
    public final HouseholdExpenses getHouseholdExpenses() {
        return this.householdExpenses;
    }

    @NotNull
    public final PersonalExpenses getPartner1Expenses() {
        return this.partner1Expenses;
    }

    @Nullable
    public final PersonalExpenses getPartner2Expenses() {
        return this.partner2Expenses;
    }

    @Override
    @Nullable
    public SimDate getStartDate() {
        return this.startDate;
    }

    @Override
    @Nullable
    public SimDate getEndDate() {
        return this.endDate;
    }

    @NotNull
    public final IncomeTaxAggregation getTaxAggregation() {
        return this.taxAggregation;
    }

    public final void setTaxAggregation(@NotNull IncomeTaxAggregation incomeTaxAggregation) {
        Intrinsics.checkNotNullParameter((Object)incomeTaxAggregation, (String)"<set-?>");
        this.taxAggregation = incomeTaxAggregation;
    }

    @Override
    @NotNull
    protected List<FinancialCompo> createCompos() {
        return CollectionsKt.emptyList();
    }

    @Override
    public void onStartOfMonth(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        boolean bl = this.isActive = this.isActive || date.isStartOfYear();
        if (date.isStartOfYear()) {
            this.taxAggregation = new IncomeTaxAggregation(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Short.MAX_VALUE, null);
        }
    }

    @Override
    public void onBooking(@NotNull Booking booking) {
        IncomeTaxAggregation incomeTaxAggregation;
        Intrinsics.checkNotNullParameter((Object)booking, (String)"booking");
        if (!this.isActive || !(booking instanceof Booking.Lifecycle)) {
            return;
        }
        BookingKind bookingKind = booking.getBookingKind();
        double amount = booking.getAmount();
        Holding holding = booking.getHolding();
        Holding trigHolding = ((Booking.Lifecycle)booking).getTrigHolding();
        if (Intrinsics.areEqual((Object)holding, (Object)this.getHousehold().getExternalCash()) && amount < 0.0) {
            if (trigHolding instanceof Income) {
                if (Intrinsics.areEqual((Object)trigHolding.getOwner(), (Object)this.getHousehold().getPartner1())) {
                    if (Intrinsics.areEqual((Object)trigHolding.getTaxCode(), (Object)SalaryPrimary)) {
                        incomeTaxAggregation = this.taxAggregation;
                        incomeTaxAggregation.setP1PrimarySalary(incomeTaxAggregation.getP1PrimarySalary() - amount);
                    } else {
                        incomeTaxAggregation = this.taxAggregation;
                        incomeTaxAggregation.setP1SecondarySalary(incomeTaxAggregation.getP1SecondarySalary() - amount);
                    }
                } else if (Intrinsics.areEqual((Object)trigHolding.getTaxCode(), (Object)SalaryPrimary)) {
                    incomeTaxAggregation = this.taxAggregation;
                    incomeTaxAggregation.setP2PrimarySalary(incomeTaxAggregation.getP2PrimarySalary() - amount);
                } else {
                    incomeTaxAggregation = this.taxAggregation;
                    incomeTaxAggregation.setP2SecondarySalary(incomeTaxAggregation.getP2SecondarySalary() - amount);
                }
            } else if (trigHolding instanceof ChPillarOne || trigHolding instanceof ChPillarTwoPension) {
                if (Intrinsics.areEqual((Object)trigHolding.getOwner(), (Object)this.getHousehold().getPartner1())) {
                    incomeTaxAggregation = this.taxAggregation;
                    incomeTaxAggregation.setP1PensionIncome(incomeTaxAggregation.getP1PensionIncome() - amount);
                } else {
                    incomeTaxAggregation = this.taxAggregation;
                    incomeTaxAggregation.setP2PensionIncome(incomeTaxAggregation.getP2PensionIncome() - amount);
                }
            } else if (trigHolding instanceof RealEstate) {
                incomeTaxAggregation = this.taxAggregation;
                incomeTaxAggregation.setHhRentalIncome(incomeTaxAggregation.getHhRentalIncome() - amount);
            } else if (bookingKind == BookingKind.INTEREST || bookingKind == BookingKind.DIVIDEND) {
                incomeTaxAggregation = this.taxAggregation;
                incomeTaxAggregation.setHhInvestmentIncome(incomeTaxAggregation.getHhInvestmentIncome() - amount);
            }
        }
        if (Intrinsics.areEqual((Object)holding, (Object)this.getHousehold().getExternalCash()) && amount > 0.0) {
            if (trigHolding instanceof RealEstate) {
                incomeTaxAggregation = this.taxAggregation;
                incomeTaxAggregation.setHhBuildingMaintenanceCosts(incomeTaxAggregation.getHhBuildingMaintenanceCosts() + amount);
            } else if (trigHolding instanceof Expense && Intrinsics.areEqual((Object)trigHolding.getTaxCode(), (Object)ExpenseRent)) {
                incomeTaxAggregation = this.taxAggregation;
                incomeTaxAggregation.setHhRentalExpense(incomeTaxAggregation.getHhRentalExpense() + amount);
            } else if (bookingKind == BookingKind.INTEREST) {
                incomeTaxAggregation = this.taxAggregation;
                incomeTaxAggregation.setHhDebtInterest(incomeTaxAggregation.getHhDebtInterest() + amount);
            }
        }
        if ((holding instanceof ChPillarTwoCapital || holding instanceof ChPillarTwoPension) && bookingKind == BookingKind.TRANSFER) {
            if (amount > 0.0) {
                incomeTaxAggregation = this.taxAggregation;
                incomeTaxAggregation.setHhPillar3aContributions(incomeTaxAggregation.getHhPillar3aContributions() + amount);
            } else if (Intrinsics.areEqual((Object)trigHolding.getOwner(), (Object)this.getHousehold().getPartner1())) {
                incomeTaxAggregation = this.taxAggregation;
                incomeTaxAggregation.setP1PensionPayment(incomeTaxAggregation.getP1PensionPayment() - amount);
            } else {
                incomeTaxAggregation = this.taxAggregation;
                incomeTaxAggregation.setP2PensionPayment(incomeTaxAggregation.getP2PensionPayment() - amount);
            }
        }
        if (holding instanceof Investment && Intrinsics.areEqual((Object)holding.getTaxCode(), (Object)Investment3a) && bookingKind == BookingKind.TRANSFER) {
            if (amount > 0.0) {
                incomeTaxAggregation = this.taxAggregation;
                incomeTaxAggregation.setHhPillar3aContributions(incomeTaxAggregation.getHhPillar3aContributions() + amount);
            } else if (Intrinsics.areEqual((Object)trigHolding.getOwner(), (Object)this.getHousehold().getPartner1())) {
                incomeTaxAggregation = this.taxAggregation;
                incomeTaxAggregation.setP1PensionPayment(incomeTaxAggregation.getP1PensionPayment() - amount);
            } else {
                incomeTaxAggregation = this.taxAggregation;
                incomeTaxAggregation.setP2PensionPayment(incomeTaxAggregation.getP2PensionPayment() - amount);
            }
        }
    }

    @Override
    public void handleTaxes(@NotNull SimDate date, @NotNull ChTaxService taxService) {
        ChTaxPersonalInfo chTaxPersonalInfo;
        boolean p2HasSecondaryIncome;
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)taxService, (String)"taxService");
        if (!this.isActive || !date.isEndOfYear()) {
            return;
        }
        this.taxAggregation.setP1PrimarySalary(Math.rint(this.taxAggregation.getP1PrimarySalary()));
        this.taxAggregation.setP1SecondarySalary(Math.rint(this.taxAggregation.getP1SecondarySalary()));
        this.taxAggregation.setP1PensionIncome(Math.rint(this.taxAggregation.getP1PensionIncome()));
        this.taxAggregation.setP1PensionPayment(Math.rint(this.taxAggregation.getP1PensionPayment()));
        this.taxAggregation.setP2PrimarySalary(Math.rint(this.taxAggregation.getP2PrimarySalary()));
        this.taxAggregation.setP2SecondarySalary(Math.rint(this.taxAggregation.getP2SecondarySalary()));
        this.taxAggregation.setP2PensionIncome(Math.rint(this.taxAggregation.getP2PensionIncome()));
        this.taxAggregation.setP2PensionPayment(Math.rint(this.taxAggregation.getP2PensionPayment()));
        this.taxAggregation.setHhInvestmentIncome(Math.rint(this.taxAggregation.getHhInvestmentIncome()));
        this.taxAggregation.setHhInvestmentIncomeParticipations(Math.rint(this.taxAggregation.getHhInvestmentIncomeParticipations()));
        this.taxAggregation.setHhRentalExpense(Math.rint(this.taxAggregation.getHhRentalExpense()));
        this.taxAggregation.setHhRentalIncome(Math.rint(this.taxAggregation.getHhRentalIncome()));
        this.taxAggregation.setHhDebtInterest(Math.rint(this.taxAggregation.getHhDebtInterest()));
        this.taxAggregation.setHhBuildingMaintenanceCosts(Math.rint(this.taxAggregation.getHhBuildingMaintenanceCosts()));
        this.taxAggregation.setHhPillar3aContributions(Math.rint(this.taxAggregation.getHhPillar3aContributions()));
        Person partner1 = this.getHousehold().getPartner1();
        Person partner2 = this.getHousehold().getPartner2();
        double d = this.taxableNetWealth();
        double d2 = this.householdExpenses.getInsurance();
        double d3 = this.householdExpenses.getChildCareCosts();
        double d4 = this.householdExpenses.getOther();
        double d5 = this.taxAggregation.getHhRentalExpense();
        double d6 = this.taxAggregation.getHhInvestmentIncome();
        double d7 = this.taxAggregation.getHhRentalIncome();
        double d8 = this.taxAggregation.getHhDebtInterest();
        double d9 = this.taxAggregation.getHhBuildingMaintenanceCosts();
        double d10 = this.taxAggregation.getHhPillar3aContributions();
        ChTaxHouseholdInfo householdInfo = new ChTaxHouseholdInfo(0.0, d2, d3, d4, d5, d6, d7, d8, d9, d10, d);
        boolean p1HasPrimaryIncome = this.taxAggregation.getP1PrimarySalary() > 0.0;
        boolean p1HasSecondaryIncome = this.taxAggregation.getP1SecondarySalary() > 0.0;
        ChTaxPersonalInfo partner1Info = new ChTaxPersonalInfo(partner1.getAgeAt(date), this.getHousehold().getPartner1().getReligiousAffiliation(), p1HasPrimaryIncome ? this.partner1Expenses.getPrimaryOccupationMealCosts() : 0.0, p1HasPrimaryIncome ? this.partner1Expenses.getPrimaryOccupationTravelCosts() : 0.0, p1HasPrimaryIncome ? this.partner1Expenses.getPrimaryOccupationOtherExpenses() : 0.0, p1HasSecondaryIncome ? this.partner1Expenses.getSecondaryOccupationExpenses() : 0.0, this.taxAggregation.getP1PrimarySalary() + this.taxAggregation.getP1PensionIncome(), this.taxAggregation.getP1SecondarySalary(), this.taxAggregation.getP1PensionPayment());
        boolean p2HasPrimaryIncome = this.taxAggregation.getP2PrimarySalary() > 0.0;
        boolean bl = p2HasSecondaryIncome = this.taxAggregation.getP2SecondarySalary() > 0.0;
        if (partner2 == null) {
            chTaxPersonalInfo = null;
        } else {
            double d11;
            double d12;
            double d13;
            double d14;
            int n = partner2.getAgeAt(date);
            Religion religion = partner2.getReligiousAffiliation();
            if (p2HasPrimaryIncome) {
                PersonalExpenses personalExpenses = this.partner2Expenses;
                d14 = personalExpenses != null ? personalExpenses.getPrimaryOccupationMealCosts() : 0.0;
            } else {
                d14 = 0.0;
            }
            if (p2HasPrimaryIncome) {
                PersonalExpenses personalExpenses = this.partner2Expenses;
                d13 = personalExpenses != null ? personalExpenses.getPrimaryOccupationTravelCosts() : 0.0;
            } else {
                d13 = 0.0;
            }
            if (p2HasPrimaryIncome) {
                PersonalExpenses personalExpenses = this.partner2Expenses;
                d12 = personalExpenses != null ? personalExpenses.getPrimaryOccupationOtherExpenses() : 0.0;
            } else {
                d12 = 0.0;
            }
            if (p2HasSecondaryIncome) {
                PersonalExpenses personalExpenses = this.partner2Expenses;
                d11 = personalExpenses != null ? personalExpenses.getSecondaryOccupationExpenses() : 0.0;
            } else {
                d11 = 0.0;
            }
            chTaxPersonalInfo = new ChTaxPersonalInfo(n, religion, d14, d13, d12, d11, this.taxAggregation.getP2PrimarySalary() + this.taxAggregation.getP2PensionIncome(), this.taxAggregation.getP2SecondarySalary(), this.taxAggregation.getP2PensionPayment());
        }
        ChTaxPersonalInfo partner2Info = chTaxPersonalInfo;
        ChTaxResult taxResult = taxService.getTaxes(date.getYear(), this.getHousehold().getZip() * 100000, this.getHousehold().getCivilStatus(), householdInfo, partner1Info, partner2Info, CollectionsKt.emptyList());
        if (taxResult.getIncomeTax() > 0.0) {
            this.getHousehold().getInternalCash().bookCashflow(date, BookingKind.CASHFLOW, -taxResult.getIncomeTax(), this, "incomeTax");
        }
        if (taxResult.getWealthTax() > 0.0) {
            this.getHousehold().getInternalCash().bookCashflow(date, BookingKind.CASHFLOW, -taxResult.getWealthTax(), this, "wealthTax");
        }
        if (taxResult.getCapitalTax() > 0.0) {
            this.getHousehold().getInternalCash().bookCashflow(date, BookingKind.CASHFLOW, -taxResult.getCapitalTax(), this, "capitalTax");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final double taxableNetWealth() {
        void $this$mapTo$iv$iv;
        Holding it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = CollectionsKt.plus((Collection)this.getHousehold().getHoldings(), (Object)this.getHousehold().getInternalCash());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Holding)element$iv$iv;
            boolean bl = false;
            if (!this.isTaxableHolding(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Holding)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getBalance());
        }
        return CollectionsKt.sumOfDouble((Iterable)((List)destination$iv$iv));
    }

    private final boolean isTaxableHolding(Holding holding) {
        if (!holding.getProductType().isValuable) {
            return false;
        }
        if (holding instanceof ChPillarTwoCapital) {
            return false;
        }
        return !(holding instanceof Investment) || !Intrinsics.areEqual((Object)holding.getTaxCode(), (Object)Investment3a);
    }

    @Override
    public void onEndOfMonth(@NotNull SimDate date) {
        ProjectionListener.DefaultImpls.onEndOfMonth(this, date);
    }

    @NotNull
    public final String component1() {
        return this.tag;
    }

    @NotNull
    public final HouseholdExpenses component2() {
        return this.householdExpenses;
    }

    @NotNull
    public final PersonalExpenses component3() {
        return this.partner1Expenses;
    }

    @Nullable
    public final PersonalExpenses component4() {
        return this.partner2Expenses;
    }

    @NotNull
    public final ChTax copy(@NotNull String tag, @NotNull HouseholdExpenses householdExpenses, @NotNull PersonalExpenses partner1Expenses, @Nullable PersonalExpenses partner2Expenses) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)householdExpenses, (String)"householdExpenses");
        Intrinsics.checkNotNullParameter((Object)partner1Expenses, (String)"partner1Expenses");
        return new ChTax(tag, householdExpenses, partner1Expenses, partner2Expenses);
    }

    public static /* synthetic */ ChTax copy$default(ChTax chTax, String string, HouseholdExpenses householdExpenses, PersonalExpenses personalExpenses, PersonalExpenses personalExpenses2, int n, Object object) {
        if ((n & 1) != 0) {
            string = chTax.tag;
        }
        if ((n & 2) != 0) {
            householdExpenses = chTax.householdExpenses;
        }
        if ((n & 4) != 0) {
            personalExpenses = chTax.partner1Expenses;
        }
        if ((n & 8) != 0) {
            personalExpenses2 = chTax.partner2Expenses;
        }
        return chTax.copy(string, householdExpenses, personalExpenses, personalExpenses2);
    }

    @NotNull
    public String toString() {
        return "ChTax(tag=" + this.tag + ", householdExpenses=" + this.householdExpenses + ", partner1Expenses=" + this.partner1Expenses + ", partner2Expenses=" + this.partner2Expenses + ")";
    }

    public int hashCode() {
        int result = this.tag.hashCode();
        result = result * 31 + this.householdExpenses.hashCode();
        result = result * 31 + this.partner1Expenses.hashCode();
        result = result * 31 + (this.partner2Expenses == null ? 0 : this.partner2Expenses.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ChTax)) {
            return false;
        }
        ChTax chTax = (ChTax)other;
        if (!Intrinsics.areEqual((Object)this.tag, (Object)chTax.tag)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.householdExpenses, (Object)chTax.householdExpenses)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.partner1Expenses, (Object)chTax.partner1Expenses)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.partner2Expenses, (Object)chTax.partner2Expenses);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u0003\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0005\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0007\u001a\u00020\u00002\b\u0010\r\u001a\u0004\u0018\u00010\u0006J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/fincast/holding/impl/ch/ChTax$Builder;", "", "()V", "householdExpenses", "Lio/fincast/holding/impl/ch/HouseholdExpenses;", "partner1Expenses", "Lio/fincast/holding/impl/ch/PersonalExpenses;", "partner2Expenses", "tag", "", "build", "Lio/fincast/holding/impl/ch/ChTax;", "partner1Deductions", "partner2Deductions", "fincast"})
    @SourceDebugExtension(value={"SMAP\nChTax.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChTax.kt\nio/fincast/holding/impl/ch/ChTax$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,317:1\n1#2:318\n*E\n"})
    public static final class Builder {
        @Nullable
        private String tag;
        @Nullable
        private HouseholdExpenses householdExpenses;
        @Nullable
        private PersonalExpenses partner1Expenses;
        @Nullable
        private PersonalExpenses partner2Expenses;

        @NotNull
        public final Builder tag(@NotNull String tag) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Builder $this$tag_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$tag_u24lambda_u240.tag = tag;
            return builder;
        }

        @NotNull
        public final Builder householdExpenses(@Nullable HouseholdExpenses householdExpenses) {
            Builder builder;
            Builder $this$householdExpenses_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$householdExpenses_u24lambda_u241.householdExpenses = householdExpenses;
            return builder;
        }

        @NotNull
        public final Builder partner1Expenses(@Nullable PersonalExpenses partner1Deductions) {
            Builder builder;
            Builder $this$partner1Expenses_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$partner1Expenses_u24lambda_u242.partner1Expenses = partner1Deductions;
            return builder;
        }

        @NotNull
        public final Builder partner2Expenses(@Nullable PersonalExpenses partner2Deductions) {
            Builder builder;
            Builder $this$partner2Expenses_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$partner2Expenses_u24lambda_u243.partner2Expenses = partner2Deductions;
            return builder;
        }

        @NotNull
        public final ChTax build() {
            String string = this.tag;
            if (string == null) {
                throw new IllegalArgumentException("tag is required");
            }
            HouseholdExpenses householdExpenses = this.householdExpenses;
            if (householdExpenses == null) {
                throw new IllegalArgumentException("householdDeductions is required");
            }
            PersonalExpenses personalExpenses = this.partner1Expenses;
            if (personalExpenses == null) {
                throw new IllegalArgumentException("partner1Deductions is required");
            }
            return new ChTax(string, householdExpenses, personalExpenses, this.partner2Expenses);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lio/fincast/holding/impl/ch/ChTax$Companion;", "", "()V", "ExpenseAlimonyAdult", "", "getExpenseAlimonyAdult", "()Ljava/lang/String;", "ExpenseAlimonyMinor", "getExpenseAlimonyMinor", "ExpenseRent", "getExpenseRent", "Investment3a", "getInvestment3a", "SalaryPrimary", "getSalaryPrimary", "SalarySecondary", "getSalarySecondary", "fincast"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getSalaryPrimary() {
            return SalaryPrimary;
        }

        @NotNull
        public final String getSalarySecondary() {
            return SalarySecondary;
        }

        @NotNull
        public final String getExpenseRent() {
            return ExpenseRent;
        }

        @NotNull
        public final String getExpenseAlimonyMinor() {
            return ExpenseAlimonyMinor;
        }

        @NotNull
        public final String getExpenseAlimonyAdult() {
            return ExpenseAlimonyAdult;
        }

        @NotNull
        public final String getInvestment3a() {
            return Investment3a;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

