/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.holding.impl.ch;

import io.fincast.compo.FinancialCompo;
import io.fincast.compo.ValueProvider;
import io.fincast.compo.ValueProviders;
import io.fincast.compo.impl.CashflowCompo;
import io.fincast.compo.impl.FlowDirection;
import io.fincast.engine.SimDate;
import io.fincast.enums.FundsUtilisation;
import io.fincast.enums.Periodicity;
import io.fincast.enums.ProductType;
import io.fincast.holding.Contract;
import io.fincast.holding.base.HoldingBase;
import io.fincast.household.Person;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002:\u00010BI\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\t\u0012\b\b\u0002\u0010\f\u001a\u00020\t\u00a2\u0006\u0002\u0010\rJ\t\u0010\u001e\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\t\u0010!\u001a\u00020\tH\u00c6\u0003J\t\u0010\"\u001a\u00020\tH\u00c6\u0003J\t\u0010#\u001a\u00020\tH\u00c6\u0003J\t\u0010$\u001a\u00020\tH\u00c6\u0003JQ\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\tH\u00c6\u0001J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0014J\u0013\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,H\u00d6\u0003J\t\u0010-\u001a\u00020.H\u00d6\u0001J\t\u0010/\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u000b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001bR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u000f\u00a8\u00061"}, d2={"Lio/fincast/holding/impl/ch/ChPillarTwoPension;", "Lio/fincast/holding/Contract;", "Lio/fincast/holding/base/HoldingBase;", "tag", "", "owner", "Lio/fincast/household/Person;", "taxCode", "vestedBenefits", "", "projectedVestedBenefits", "capitalWithdrawal", "conversionRate", "(Ljava/lang/String;Lio/fincast/household/Person;Ljava/lang/String;DDDD)V", "getCapitalWithdrawal", "()D", "getConversionRate", "endDate", "Lio/fincast/engine/SimDate;", "getEndDate", "()Lio/fincast/engine/SimDate;", "getOwner", "()Lio/fincast/household/Person;", "getProjectedVestedBenefits", "startDate", "getStartDate", "getTag", "()Ljava/lang/String;", "getTaxCode", "getVestedBenefits", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "createCompos", "", "Lio/fincast/compo/FinancialCompo;", "equals", "", "other", "", "hashCode", "", "toString", "Builder", "fincast"})
public final class ChPillarTwoPension
extends HoldingBase
implements Contract {
    @NotNull
    private final String tag;
    @NotNull
    private final Person owner;
    @Nullable
    private final String taxCode;
    private final double vestedBenefits;
    private final double projectedVestedBenefits;
    private final double capitalWithdrawal;
    private final double conversionRate;
    @Nullable
    private final SimDate startDate;
    @Nullable
    private final SimDate endDate;

    public ChPillarTwoPension(@NotNull String tag, @NotNull Person owner, @Nullable String taxCode, double vestedBenefits, double projectedVestedBenefits, double capitalWithdrawal, double conversionRate) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super(tag, owner, ProductType.CONTRACT, taxCode);
        this.tag = tag;
        this.owner = owner;
        this.taxCode = taxCode;
        this.vestedBenefits = vestedBenefits;
        this.projectedVestedBenefits = projectedVestedBenefits;
        this.capitalWithdrawal = capitalWithdrawal;
        this.conversionRate = conversionRate;
    }

    public /* synthetic */ ChPillarTwoPension(String string, Person person, String string2, double d, double d2, double d3, double d4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            d = 0.0;
        }
        if ((n & 0x10) != 0) {
            d2 = 0.0;
        }
        if ((n & 0x20) != 0) {
            d3 = 0.0;
        }
        if ((n & 0x40) != 0) {
            d4 = 0.0;
        }
        this(string, person, string2, d, d2, d3, d4);
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @Override
    @NotNull
    public Person getOwner() {
        return this.owner;
    }

    @Override
    @Nullable
    public String getTaxCode() {
        return this.taxCode;
    }

    public final double getVestedBenefits() {
        return this.vestedBenefits;
    }

    public final double getProjectedVestedBenefits() {
        return this.projectedVestedBenefits;
    }

    public final double getCapitalWithdrawal() {
        return this.capitalWithdrawal;
    }

    public final double getConversionRate() {
        return this.conversionRate;
    }

    @Override
    @Nullable
    public SimDate getStartDate() {
        return this.startDate;
    }

    @Override
    @Nullable
    public SimDate getEndDate() {
        return this.endDate;
    }

    @Override
    @NotNull
    protected List<FinancialCompo> createCompos() {
        SimDate retirementDate = this.getOwner().getActualRetirementDate();
        SimDate deathDate = this.getOwner().getDeathDate();
        if (deathDate != null && deathDate.compareTo(retirementDate) <= 0) {
            return CollectionsKt.emptyList();
        }
        if (this.projectedVestedBenefits == 0.0) {
            return CollectionsKt.emptyList();
        }
        if (this.capitalWithdrawal == 1.0 || this.capitalWithdrawal >= this.projectedVestedBenefits) {
            return CollectionsKt.emptyList();
        }
        double capitalWithdrawal = this.capitalWithdrawal <= 1.0 ? this.capitalWithdrawal * this.projectedVestedBenefits : Math.min(this.capitalWithdrawal, this.projectedVestedBenefits);
        double pensionBase = this.projectedVestedBenefits - capitalWithdrawal;
        if (pensionBase > 0.0) {
            FundsUtilisation fundsUtilisation = FundsUtilisation.DISBURSE;
            FlowDirection flowDirection = FlowDirection.INCOMING;
            ValueProvider<Double> valueProvider = ValueProviders.constValue(pensionBase * this.conversionRate / 100.0 / (double)12);
            SimDate simDate = retirementDate.plus(1);
            Periodicity periodicity = Periodicity.MONTHLY;
            CashflowCompo compo = new CashflowCompo(this, "pension", fundsUtilisation, valueProvider, flowDirection, periodicity, simDate, deathDate, false, 256, null);
            return CollectionsKt.listOf((Object)compo);
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public final String component1() {
        return this.tag;
    }

    @NotNull
    public final Person component2() {
        return this.owner;
    }

    @Nullable
    public final String component3() {
        return this.taxCode;
    }

    public final double component4() {
        return this.vestedBenefits;
    }

    public final double component5() {
        return this.projectedVestedBenefits;
    }

    public final double component6() {
        return this.capitalWithdrawal;
    }

    public final double component7() {
        return this.conversionRate;
    }

    @NotNull
    public final ChPillarTwoPension copy(@NotNull String tag, @NotNull Person owner, @Nullable String taxCode, double vestedBenefits, double projectedVestedBenefits, double capitalWithdrawal, double conversionRate) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        return new ChPillarTwoPension(tag, owner, taxCode, vestedBenefits, projectedVestedBenefits, capitalWithdrawal, conversionRate);
    }

    public static /* synthetic */ ChPillarTwoPension copy$default(ChPillarTwoPension chPillarTwoPension, String string, Person person, String string2, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 1) != 0) {
            string = chPillarTwoPension.tag;
        }
        if ((n & 2) != 0) {
            person = chPillarTwoPension.owner;
        }
        if ((n & 4) != 0) {
            string2 = chPillarTwoPension.taxCode;
        }
        if ((n & 8) != 0) {
            d = chPillarTwoPension.vestedBenefits;
        }
        if ((n & 0x10) != 0) {
            d2 = chPillarTwoPension.projectedVestedBenefits;
        }
        if ((n & 0x20) != 0) {
            d3 = chPillarTwoPension.capitalWithdrawal;
        }
        if ((n & 0x40) != 0) {
            d4 = chPillarTwoPension.conversionRate;
        }
        return chPillarTwoPension.copy(string, person, string2, d, d2, d3, d4);
    }

    @NotNull
    public String toString() {
        return "ChPillarTwoPension(tag=" + this.tag + ", owner=" + this.owner + ", taxCode=" + this.taxCode + ", vestedBenefits=" + this.vestedBenefits + ", projectedVestedBenefits=" + this.projectedVestedBenefits + ", capitalWithdrawal=" + this.capitalWithdrawal + ", conversionRate=" + this.conversionRate + ")";
    }

    public int hashCode() {
        int result = this.tag.hashCode();
        result = result * 31 + this.owner.hashCode();
        result = result * 31 + (this.taxCode == null ? 0 : this.taxCode.hashCode());
        result = result * 31 + Double.hashCode(this.vestedBenefits);
        result = result * 31 + Double.hashCode(this.projectedVestedBenefits);
        result = result * 31 + Double.hashCode(this.capitalWithdrawal);
        result = result * 31 + Double.hashCode(this.conversionRate);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ChPillarTwoPension)) {
            return false;
        }
        ChPillarTwoPension chPillarTwoPension = (ChPillarTwoPension)other;
        if (!Intrinsics.areEqual((Object)this.tag, (Object)chPillarTwoPension.tag)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.owner, (Object)chPillarTwoPension.owner)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.taxCode, (Object)chPillarTwoPension.taxCode)) {
            return false;
        }
        if (Double.compare(this.vestedBenefits, chPillarTwoPension.vestedBenefits) != 0) {
            return false;
        }
        if (Double.compare(this.projectedVestedBenefits, chPillarTwoPension.projectedVestedBenefits) != 0) {
            return false;
        }
        if (Double.compare(this.capitalWithdrawal, chPillarTwoPension.capitalWithdrawal) != 0) {
            return false;
        }
        return Double.compare(this.conversionRate, chPillarTwoPension.conversionRate) == 0;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0015\u0010\u0003\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010\u0006\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u0015\u0010\t\u001a\u00020\u00002\b\u0010\r\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\u000bJ\u0015\u0010\r\u001a\u00020\u00002\b\u0010\r\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0010R\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006\u0011"}, d2={"Lio/fincast/holding/impl/ch/ChPillarTwoPension$Builder;", "", "()V", "capitalWithdrawal", "", "Ljava/lang/Double;", "conversionRate", "owner", "Lio/fincast/household/Person;", "projectedVestedBenefits", "tag", "", "taxCode", "vestedBenefits", "build", "Lio/fincast/holding/impl/ch/ChPillarTwoPension;", "(Ljava/lang/Double;)Lio/fincast/holding/impl/ch/ChPillarTwoPension$Builder;", "fincast"})
    @SourceDebugExtension(value={"SMAP\nChPillarTwoPension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChPillarTwoPension.kt\nio/fincast/holding/impl/ch/ChPillarTwoPension$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1#2:98\n*E\n"})
    public static final class Builder {
        @Nullable
        private String tag;
        @Nullable
        private String taxCode;
        @Nullable
        private Person owner;
        @Nullable
        private Double vestedBenefits;
        @Nullable
        private Double projectedVestedBenefits;
        @Nullable
        private Double capitalWithdrawal;
        @Nullable
        private Double conversionRate;

        @NotNull
        public final Builder tag(@NotNull String tag) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Builder $this$tag_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$tag_u24lambda_u240.tag = tag;
            return builder;
        }

        @NotNull
        public final Builder taxCode(@Nullable String taxCode) {
            Builder builder;
            Builder $this$taxCode_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$taxCode_u24lambda_u241.taxCode = taxCode;
            return builder;
        }

        @NotNull
        public final Builder owner(@NotNull Person owner) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Builder $this$owner_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$owner_u24lambda_u242.owner = owner;
            return builder;
        }

        @NotNull
        public final Builder vestedBenefits(@Nullable Double vestedBenefits) {
            Builder builder;
            Builder $this$vestedBenefits_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$vestedBenefits_u24lambda_u243.vestedBenefits = vestedBenefits;
            return builder;
        }

        @NotNull
        public final Builder projectedVestedBenefits(@Nullable Double vestedBenefits) {
            Builder builder;
            Builder $this$projectedVestedBenefits_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$projectedVestedBenefits_u24lambda_u244.projectedVestedBenefits = vestedBenefits;
            return builder;
        }

        @NotNull
        public final Builder capitalWithdrawal(@Nullable Double capitalWithdrawal) {
            Builder builder;
            Builder $this$capitalWithdrawal_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$capitalWithdrawal_u24lambda_u245.capitalWithdrawal = capitalWithdrawal;
            return builder;
        }

        @NotNull
        public final Builder conversionRate(@Nullable Double conversionRate) {
            Builder builder;
            Builder $this$conversionRate_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$conversionRate_u24lambda_u246.conversionRate = conversionRate;
            return builder;
        }

        @NotNull
        public final ChPillarTwoPension build() {
            String string = this.tag;
            if (string == null) {
                throw new IllegalArgumentException("tag is required");
            }
            String string2 = string;
            String string3 = this.taxCode;
            Person person = this.owner;
            if (person == null) {
                throw new IllegalArgumentException("owner is required");
            }
            Person person2 = person;
            Double d = this.vestedBenefits;
            double d2 = d != null ? d : 0.0;
            Double d3 = this.projectedVestedBenefits;
            double d4 = d3 != null ? d3 : 0.0;
            Double d5 = this.capitalWithdrawal;
            double d6 = d5 != null ? d5 : 0.0;
            Double d7 = this.conversionRate;
            double d8 = d7 != null ? d7 : 0.0;
            return new ChPillarTwoPension(string2, person2, string3, d2, d4, d6, d8);
        }
    }
}

