/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.holding.impl.ch;

import io.fincast.compo.FinancialCompo;
import io.fincast.compo.ValueProvider;
import io.fincast.compo.ValueProviders;
import io.fincast.compo.impl.CashflowCompo;
import io.fincast.compo.impl.FlowDirection;
import io.fincast.compo.impl.TransferCompo;
import io.fincast.engine.SimDate;
import io.fincast.enums.FundsUtilisation;
import io.fincast.enums.Periodicity;
import io.fincast.enums.ProductType;
import io.fincast.holding.Holding;
import io.fincast.holding.base.ValuableBase;
import io.fincast.household.Person;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0018\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001*B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001e\u001a\u00020\bH\u00c6\u0003JG\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\bH\u00c6\u0001J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0014J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001J\t\u0010)\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\f\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0014\u0010\u0013\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000e\u00a8\u0006+"}, d2={"Lio/fincast/holding/impl/ch/ChPillarTwoCapital;", "Lio/fincast/holding/base/ValuableBase;", "tag", "", "owner", "Lio/fincast/household/Person;", "taxCode", "vestedBenefits", "", "projectedVestedBenefits", "capitalWithdrawal", "(Ljava/lang/String;Lio/fincast/household/Person;Ljava/lang/String;DDD)V", "capitalVestedBenefits", "getCapitalVestedBenefits", "()D", "getCapitalWithdrawal", "getOwner", "()Lio/fincast/household/Person;", "getProjectedVestedBenefits", "reconBalance", "getReconBalance", "getTag", "()Ljava/lang/String;", "getTaxCode", "getVestedBenefits", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "createCompos", "", "Lio/fincast/compo/FinancialCompo;", "equals", "", "other", "", "hashCode", "", "toString", "Builder", "fincast"})
public final class ChPillarTwoCapital
extends ValuableBase {
    @NotNull
    private final String tag;
    @NotNull
    private final Person owner;
    @Nullable
    private final String taxCode;
    private final double vestedBenefits;
    private final double projectedVestedBenefits;
    private final double capitalWithdrawal;

    public ChPillarTwoCapital(@NotNull String tag, @NotNull Person owner, @Nullable String taxCode, double vestedBenefits, double projectedVestedBenefits, double capitalWithdrawal) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super(tag, owner, ProductType.ASSET, taxCode, vestedBenefits);
        this.tag = tag;
        this.owner = owner;
        this.taxCode = taxCode;
        this.vestedBenefits = vestedBenefits;
        this.projectedVestedBenefits = projectedVestedBenefits;
        this.capitalWithdrawal = capitalWithdrawal;
    }

    public /* synthetic */ ChPillarTwoCapital(String string, Person person, String string2, double d, double d2, double d3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            d = 0.0;
        }
        if ((n & 0x10) != 0) {
            d2 = 0.0;
        }
        if ((n & 0x20) != 0) {
            d3 = 0.0;
        }
        this(string, person, string2, d, d2, d3);
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @Override
    @NotNull
    public Person getOwner() {
        return this.owner;
    }

    @Override
    @Nullable
    public String getTaxCode() {
        return this.taxCode;
    }

    public final double getVestedBenefits() {
        return this.vestedBenefits;
    }

    public final double getProjectedVestedBenefits() {
        return this.projectedVestedBenefits;
    }

    public final double getCapitalWithdrawal() {
        return this.capitalWithdrawal;
    }

    @Override
    public double getReconBalance() {
        return this.getCapitalVestedBenefits();
    }

    @Override
    @NotNull
    protected List<FinancialCompo> createCompos() {
        SimDate retirementDate = this.getOwner().getActualRetirementDate();
        SimDate deathDate = this.getOwner().getDeathDate();
        if (deathDate != null && deathDate.compareTo(retirementDate) <= 0) {
            return CollectionsKt.emptyList();
        }
        if (this.projectedVestedBenefits == 0.0) {
            return CollectionsKt.emptyList();
        }
        if (this.capitalWithdrawal == 0.0) {
            return CollectionsKt.emptyList();
        }
        double capitalWithdrawal = this.capitalWithdrawal <= 1.0 ? this.capitalWithdrawal * this.projectedVestedBenefits : Math.min(this.capitalWithdrawal, this.projectedVestedBenefits);
        List compos = new ArrayList();
        SimDate simDate = this.getOwner().getEndOfExpenseDate(retirementDate);
        if (simDate == null) {
            simDate = retirementDate;
        }
        SimDate endDate = simDate;
        double monthlyContribution = (capitalWithdrawal - this.getCapitalVestedBenefits()) / (double)retirementDate.minus(this.getHousehold().getReconDate());
        Object object = FundsUtilisation.COMPOUND;
        Object object2 = FlowDirection.INCOMING;
        Object object3 = ValueProviders.constValue(monthlyContribution);
        Periodicity periodicity = Periodicity.MONTHLY;
        compos.add(new CashflowCompo(this, "capitalContribution", (FundsUtilisation)((Object)object), (ValueProvider)object3, (FlowDirection)((Object)object2), periodicity, null, endDate, false, 320, null));
        object = this.getHousehold().getInternalCash();
        object2 = ValueProviders.constValue(capitalWithdrawal);
        object3 = retirementDate.plus(1);
        periodicity = Periodicity.ONCE;
        compos.add(new TransferCompo(this, "capitalWithdrawal", this, (Holding)object, (ValueProvider)object2, periodicity, null, (SimDate)object3, null, 320, null));
        return compos;
    }

    private final double getCapitalVestedBenefits() {
        double capitalQuota = this.capitalWithdrawal <= 1.0 ? this.capitalWithdrawal : this.capitalWithdrawal / this.projectedVestedBenefits;
        return capitalQuota * this.vestedBenefits;
    }

    @NotNull
    public final String component1() {
        return this.tag;
    }

    @NotNull
    public final Person component2() {
        return this.owner;
    }

    @Nullable
    public final String component3() {
        return this.taxCode;
    }

    public final double component4() {
        return this.vestedBenefits;
    }

    public final double component5() {
        return this.projectedVestedBenefits;
    }

    public final double component6() {
        return this.capitalWithdrawal;
    }

    @NotNull
    public final ChPillarTwoCapital copy(@NotNull String tag, @NotNull Person owner, @Nullable String taxCode, double vestedBenefits, double projectedVestedBenefits, double capitalWithdrawal) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        return new ChPillarTwoCapital(tag, owner, taxCode, vestedBenefits, projectedVestedBenefits, capitalWithdrawal);
    }

    public static /* synthetic */ ChPillarTwoCapital copy$default(ChPillarTwoCapital chPillarTwoCapital, String string, Person person, String string2, double d, double d2, double d3, int n, Object object) {
        if ((n & 1) != 0) {
            string = chPillarTwoCapital.tag;
        }
        if ((n & 2) != 0) {
            person = chPillarTwoCapital.owner;
        }
        if ((n & 4) != 0) {
            string2 = chPillarTwoCapital.taxCode;
        }
        if ((n & 8) != 0) {
            d = chPillarTwoCapital.vestedBenefits;
        }
        if ((n & 0x10) != 0) {
            d2 = chPillarTwoCapital.projectedVestedBenefits;
        }
        if ((n & 0x20) != 0) {
            d3 = chPillarTwoCapital.capitalWithdrawal;
        }
        return chPillarTwoCapital.copy(string, person, string2, d, d2, d3);
    }

    @NotNull
    public String toString() {
        return "ChPillarTwoCapital(tag=" + this.tag + ", owner=" + this.owner + ", taxCode=" + this.taxCode + ", vestedBenefits=" + this.vestedBenefits + ", projectedVestedBenefits=" + this.projectedVestedBenefits + ", capitalWithdrawal=" + this.capitalWithdrawal + ")";
    }

    public int hashCode() {
        int result = this.tag.hashCode();
        result = result * 31 + this.owner.hashCode();
        result = result * 31 + (this.taxCode == null ? 0 : this.taxCode.hashCode());
        result = result * 31 + Double.hashCode(this.vestedBenefits);
        result = result * 31 + Double.hashCode(this.projectedVestedBenefits);
        result = result * 31 + Double.hashCode(this.capitalWithdrawal);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ChPillarTwoCapital)) {
            return false;
        }
        ChPillarTwoCapital chPillarTwoCapital = (ChPillarTwoCapital)other;
        if (!Intrinsics.areEqual((Object)this.tag, (Object)chPillarTwoCapital.tag)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.owner, (Object)chPillarTwoCapital.owner)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.taxCode, (Object)chPillarTwoCapital.taxCode)) {
            return false;
        }
        if (Double.compare(this.vestedBenefits, chPillarTwoCapital.vestedBenefits) != 0) {
            return false;
        }
        if (Double.compare(this.projectedVestedBenefits, chPillarTwoCapital.projectedVestedBenefits) != 0) {
            return false;
        }
        return Double.compare(this.capitalWithdrawal, chPillarTwoCapital.capitalWithdrawal) == 0;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\u0015\u0010\u0003\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u0015\u0010\b\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\u00002\b\u0010\u000b\u001a\u0004\u0018\u00010\nJ\u0015\u0010\f\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u000fR\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006\u0010"}, d2={"Lio/fincast/holding/impl/ch/ChPillarTwoCapital$Builder;", "", "()V", "capitalWithdrawal", "", "Ljava/lang/Double;", "owner", "Lio/fincast/household/Person;", "projectedVestedBenefits", "tag", "", "taxCode", "vestedBenefits", "build", "Lio/fincast/holding/impl/ch/ChPillarTwoCapital;", "(Ljava/lang/Double;)Lio/fincast/holding/impl/ch/ChPillarTwoCapital$Builder;", "fincast"})
    @SourceDebugExtension(value={"SMAP\nChPillarTwoCapital.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChPillarTwoCapital.kt\nio/fincast/holding/impl/ch/ChPillarTwoCapital$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n1#2:108\n*E\n"})
    public static final class Builder {
        @Nullable
        private String tag;
        @Nullable
        private String taxCode;
        @Nullable
        private Person owner;
        @Nullable
        private Double vestedBenefits;
        @Nullable
        private Double projectedVestedBenefits;
        @Nullable
        private Double capitalWithdrawal;

        @NotNull
        public final Builder tag(@NotNull String tag) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Builder $this$tag_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$tag_u24lambda_u240.tag = tag;
            return builder;
        }

        @NotNull
        public final Builder taxCode(@Nullable String taxCode) {
            Builder builder;
            Builder $this$taxCode_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$taxCode_u24lambda_u241.taxCode = taxCode;
            return builder;
        }

        @NotNull
        public final Builder owner(@NotNull Person owner) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Builder $this$owner_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$owner_u24lambda_u242.owner = owner;
            return builder;
        }

        @NotNull
        public final Builder vestedBenefits(@Nullable Double vestedBenefits) {
            Builder builder;
            Builder $this$vestedBenefits_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$vestedBenefits_u24lambda_u243.vestedBenefits = vestedBenefits;
            return builder;
        }

        @NotNull
        public final Builder projectedVestedBenefits(@Nullable Double vestedBenefits) {
            Builder builder;
            Builder $this$projectedVestedBenefits_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$projectedVestedBenefits_u24lambda_u244.projectedVestedBenefits = vestedBenefits;
            return builder;
        }

        @NotNull
        public final Builder capitalWithdrawal(@Nullable Double capitalWithdrawal) {
            Builder builder;
            Builder $this$capitalWithdrawal_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$capitalWithdrawal_u24lambda_u245.capitalWithdrawal = capitalWithdrawal;
            return builder;
        }

        @NotNull
        public final ChPillarTwoCapital build() {
            String string = this.tag;
            if (string == null) {
                throw new IllegalArgumentException("tag is required");
            }
            String string2 = string;
            String string3 = this.taxCode;
            Person person = this.owner;
            if (person == null) {
                throw new IllegalArgumentException("owner is required");
            }
            Person person2 = person;
            Double d = this.vestedBenefits;
            double d2 = d != null ? d : 0.0;
            Double d3 = this.projectedVestedBenefits;
            double d4 = d3 != null ? d3 : 0.0;
            Double d5 = this.capitalWithdrawal;
            double d6 = d5 != null ? d5 : 0.0;
            return new ChPillarTwoCapital(string2, person2, string3, d2, d4, d6);
        }
    }
}

