/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.holding.impl.ch;

import io.fincast.compo.FinancialCompo;
import io.fincast.compo.ValueProvider;
import io.fincast.compo.ValueProviders;
import io.fincast.compo.impl.CashflowCompo;
import io.fincast.compo.impl.FlowDirection;
import io.fincast.engine.SimDate;
import io.fincast.enums.FundsUtilisation;
import io.fincast.enums.Periodicity;
import io.fincast.enums.ProductType;
import io.fincast.holding.Contract;
import io.fincast.holding.base.HoldingBase;
import io.fincast.household.Person;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u000f\b\u0086\b\u0018\u0000 ;2\u00020\u00012\u00020\u0002:\u0002:;B9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u001e\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\u0010\u0010!\u001a\u0004\u0018\u00010\tH\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\"\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0015JF\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00c6\u0001\u00a2\u0006\u0002\u0010$J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0014J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020'0&H\u0002J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020'0&H\u0002J\u0013\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-H\u00d6\u0003J\b\u0010.\u001a\u00020\tH\u0002J\u0010\u0010.\u001a\u00020\t2\u0006\u0010/\u001a\u00020\u0006H\u0002J\n\u00100\u001a\u0004\u0018\u00010\u0011H\u0002J\b\u00101\u001a\u00020\u0006H\u0002J$\u00102\u001a\u00020'2\u0006\u00103\u001a\u00020\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0012\u00104\u001a\u0004\u0018\u00010\u00002\u0006\u0010/\u001a\u00020\u0006H\u0002J\b\u00105\u001a\u00020\tH\u0002J\u0010\u00105\u001a\u00020\t2\u0006\u0010/\u001a\u00020\u0006H\u0002J\b\u00106\u001a\u00020\tH\u0002J\u0010\u00106\u001a\u00020\t2\u0006\u0010/\u001a\u00020\u0006H\u0002J\t\u00107\u001a\u00020\u000bH\u00d6\u0001J\b\u00108\u001a\u00020+H\u0002J\t\u00109\u001a\u00020\u0004H\u00d6\u0001R\u0015\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0015\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0013R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001c\u00a8\u0006<"}, d2={"Lio/fincast/holding/impl/ch/ChPillarOne;", "Lio/fincast/holding/Contract;", "Lio/fincast/holding/base/HoldingBase;", "tag", "", "owner", "Lio/fincast/household/Person;", "taxCode", "annualPension44", "", "missingContributionYears", "", "(Ljava/lang/String;Lio/fincast/household/Person;Ljava/lang/String;Ljava/lang/Double;Ljava/lang/Integer;)V", "getAnnualPension44", "()Ljava/lang/Double;", "Ljava/lang/Double;", "endDate", "Lio/fincast/engine/SimDate;", "getEndDate", "()Lio/fincast/engine/SimDate;", "getMissingContributionYears", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getOwner", "()Lio/fincast/household/Person;", "startDate", "getStartDate", "getTag", "()Ljava/lang/String;", "getTaxCode", "component1", "component2", "component3", "component4", "component5", "copy", "(Ljava/lang/String;Lio/fincast/household/Person;Ljava/lang/String;Ljava/lang/Double;Ljava/lang/Integer;)Lio/fincast/holding/impl/ch/ChPillarOne;", "createCompos", "", "Lio/fincast/compo/FinancialCompo;", "createCoupleCompos", "createSingleCompos", "equals", "", "other", "", "getBasePension", "person", "getLastDeathDate", "getPartner", "getPensionCompo", "pension", "getPillarOne", "getSinglePension", "getWidowPension", "hashCode", "isCouple", "toString", "Builder", "Companion", "fincast"})
@SourceDebugExtension(value={"SMAP\nChPillarOne.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChPillarOne.kt\nio/fincast/holding/impl/ch/ChPillarOne\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,264:1\n800#2,11:265\n288#2,2:276\n1#3:278\n*S KotlinDebug\n*F\n+ 1 ChPillarOne.kt\nio/fincast/holding/impl/ch/ChPillarOne\n*L\n203#1:265,11\n203#1:276,2\n*E\n"})
public final class ChPillarOne
extends HoldingBase
implements Contract {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String tag;
    @NotNull
    private final Person owner;
    @Nullable
    private final String taxCode;
    @Nullable
    private final Double annualPension44;
    @Nullable
    private final Integer missingContributionYears;
    public static final double MaxSinglePension = 29400.0;
    public static final double MaxCouplePension = 44100.0;
    public static final double ReductionPerMissingYear = 2.27;
    public static final double ReductionPerAdvanceYear = 6.8;
    public static final double IncreasePerDelayedYear = 5.2;

    public ChPillarOne(@NotNull String tag, @NotNull Person owner, @Nullable String taxCode, @Nullable Double annualPension44, @Nullable Integer missingContributionYears) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super(tag, owner, ProductType.CONTRACT, taxCode);
        this.tag = tag;
        this.owner = owner;
        this.taxCode = taxCode;
        this.annualPension44 = annualPension44;
        this.missingContributionYears = missingContributionYears;
    }

    public /* synthetic */ ChPillarOne(String string, Person person, String string2, Double d, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            string2 = null;
        }
        if ((n2 & 8) != 0) {
            d = 0.0;
        }
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        this(string, person, string2, d, n);
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @Override
    @NotNull
    public Person getOwner() {
        return this.owner;
    }

    @Override
    @Nullable
    public String getTaxCode() {
        return this.taxCode;
    }

    @Nullable
    public final Double getAnnualPension44() {
        return this.annualPension44;
    }

    @Nullable
    public final Integer getMissingContributionYears() {
        return this.missingContributionYears;
    }

    @Override
    @NotNull
    public SimDate getStartDate() {
        return this.getOwner().getActualRetirementDate().plus(1);
    }

    @Override
    @Nullable
    public SimDate getEndDate() {
        return this.getLastDeathDate();
    }

    @Override
    @NotNull
    protected List<FinancialCompo> createCompos() {
        return this.isCouple() ? this.createCoupleCompos() : this.createSingleCompos();
    }

    private final List<FinancialCompo> createSingleCompos() {
        boolean ownerHasRetirementPhase;
        SimDate ownerRetirementDate = this.getOwner().getActualRetirementDate();
        SimDate ownerDeathDate = this.getOwner().getDeathDate();
        boolean bl = ownerHasRetirementPhase = ownerDeathDate == null || ownerDeathDate.compareTo(ownerRetirementDate) > 0;
        if (ownerHasRetirementPhase) {
            double ownerPension = this.getSinglePension(this.getOwner());
            return CollectionsKt.listOf((Object)this.getPensionCompo(ownerPension, ownerRetirementDate.plus(1), ownerDeathDate));
        }
        return CollectionsKt.emptyList();
    }

    private final List<FinancialCompo> createCoupleCompos() {
        SimDate firstDeathDate;
        List compos = new ArrayList();
        SimDate ownerRetirementDate = this.getOwner().getActualRetirementDate();
        SimDate ownerDeathDate = this.getOwner().getDeathDate();
        boolean ownerHasRetirementPhase = ownerDeathDate == null || ownerDeathDate.compareTo(ownerRetirementDate) > 0;
        double ownerBasePension = this.getBasePension(this.getOwner());
        double ownerSinglePension = this.getSinglePension(this.getOwner());
        Person partner = this.getPartner();
        SimDate partnerRetirementDate = partner.getActualRetirementDate();
        SimDate partnerDeathDate = partner.getDeathDate();
        SimDate simDate = partnerDeathDate;
        if (simDate == null) {
            simDate = partnerRetirementDate;
        }
        SimDate partnerEndOfWorkDate = SimDate.Companion.min(partnerRetirementDate, simDate);
        boolean partnerHasRetirementPhase = partnerDeathDate == null || partnerDeathDate.compareTo(partnerRetirementDate) > 0;
        double partnerBasePension = this.getBasePension(partner);
        double partnerSinglePension = this.getSinglePension(partner);
        SimDate simDate2 = ownerDeathDate == null ? partnerDeathDate : (firstDeathDate = partnerDeathDate == null ? null : SimDate.Companion.min(ownerDeathDate, partnerDeathDate));
        if (ownerHasRetirementPhase) {
            if (partnerEndOfWorkDate.compareTo(ownerRetirementDate) > 0) {
                SimDate simDate3 = ownerDeathDate;
                SimDate workEndDate = simDate3 == null ? partnerEndOfWorkDate : SimDate.Companion.min(simDate3, partnerEndOfWorkDate);
                compos.add(this.getPensionCompo(ownerSinglePension, ownerRetirementDate.plus(1), workEndDate));
            }
            if (firstDeathDate == null || firstDeathDate.compareTo(partnerRetirementDate) > 0 && firstDeathDate.compareTo(ownerRetirementDate) > 0) {
                SimDate retirementStartDate = SimDate.Companion.max(partnerRetirementDate, ownerRetirementDate).plus(1);
                double pension = ownerBasePension;
                double couplePension = pension + partnerBasePension;
                if (couplePension > 44100.0) {
                    pension *= 44100.0 / couplePension;
                }
                compos.add(this.getPensionCompo(pension, retirementStartDate, firstDeathDate));
            }
            if (partnerDeathDate != null && (ownerDeathDate == null || partnerDeathDate.plus(1).compareTo(ownerDeathDate) < 0) && ownerSinglePension >= this.getWidowPension(partner)) {
                SimDate deathStartDate = SimDate.Companion.max(partnerDeathDate, ownerRetirementDate).plus(1);
                compos.add(this.getPensionCompo(ownerSinglePension, deathStartDate, ownerDeathDate));
            }
        }
        if (ownerDeathDate != null && (partnerDeathDate == null || ownerDeathDate.plus(1).compareTo(partnerDeathDate) < 0)) {
            double widowPension = this.getWidowPension();
            if (ownerDeathDate.plus(1).compareTo(partnerEndOfWorkDate) < 0) {
                compos.add(this.getPensionCompo(widowPension, ownerDeathDate.plus(1), partnerEndOfWorkDate));
            }
            if (partnerHasRetirementPhase && widowPension > partnerSinglePension) {
                compos.add(this.getPensionCompo(widowPension, partnerEndOfWorkDate.plus(1), partnerDeathDate));
            }
        }
        return compos;
    }

    private final FinancialCompo getPensionCompo(double pension, SimDate startDate, SimDate endDate) {
        double monthlyPension = pension / (double)12;
        FundsUtilisation fundsUtilisation = FundsUtilisation.DISBURSE;
        FlowDirection flowDirection = FlowDirection.INCOMING;
        ValueProvider<Double> valueProvider = ValueProviders.constValue(monthlyPension);
        Periodicity periodicity = Periodicity.MONTHLY;
        return new CashflowCompo(this, "pension", fundsUtilisation, valueProvider, flowDirection, periodicity, startDate, endDate, false, 256, null);
    }

    private final double getBasePension(Person person) {
        ChPillarOne chPillarOne = this.getPillarOne(person);
        if (chPillarOne == null) {
            return 0.0;
        }
        ChPillarOne pillarOne = chPillarOne;
        return pillarOne.getBasePension();
    }

    private final double getSinglePension(Person person) {
        ChPillarOne chPillarOne = this.getPillarOne(person);
        if (chPillarOne == null) {
            return 0.0;
        }
        ChPillarOne pillarOne = chPillarOne;
        return pillarOne.getSinglePension();
    }

    private final double getWidowPension(Person person) {
        ChPillarOne chPillarOne = this.getPillarOne(person);
        if (chPillarOne == null) {
            return 0.0;
        }
        ChPillarOne pillarOne = chPillarOne;
        return pillarOne.getWidowPension();
    }

    /*
     * WARNING - void declaration
     */
    private final ChPillarOne getPillarOne(Person person) {
        Object v0;
        block2: {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = this.getHousehold().getHoldings();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ChPillarOne)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ChPillarOne it = (ChPillarOne)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getOwner(), (Object)person)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    private final double getSinglePension() {
        double pension = this.getBasePension();
        if (pension > 29400.0) {
            pension = 29400.0;
        }
        return pension;
    }

    private final double getWidowPension() {
        double pension = 0.8 * this.getBasePension();
        if (pension > 29400.0) {
            pension = 29400.0;
        }
        return pension;
    }

    private final double getBasePension() {
        double annualPension;
        Double d = this.annualPension44;
        if (d == null) {
            return 0.0;
        }
        double pension = annualPension = d.doubleValue();
        int retirementAge = this.getOwner().getActualRetirementAge();
        int stdRetirementAge = this.getOwner().getStatutoryRetirementAge();
        if (retirementAge < stdRetirementAge) {
            int ageDiff = stdRetirementAge - retirementAge;
            pension *= 1.0 - (double)ageDiff * 6.8 / (double)100;
        } else if (retirementAge > stdRetirementAge) {
            int ageDiff = retirementAge - stdRetirementAge;
            pension *= 1.0 + (double)ageDiff * 5.2 / (double)100;
        }
        if (this.missingContributionYears != null) {
            pension *= 1.0 - (double)this.missingContributionYears.intValue() * 2.27 / (double)100;
        }
        return pension;
    }

    private final Person getPartner() {
        Person person;
        if (!this.isCouple()) {
            boolean bl = false;
            String string = "only valid for couples";
            throw new IllegalArgumentException(string.toString());
        }
        if (Intrinsics.areEqual((Object)this.getOwner(), (Object)this.getHousehold().getPartner1())) {
            Person person2 = this.getHousehold().getPartner2();
            person = person2;
            Intrinsics.checkNotNull((Object)person2);
        } else {
            person = this.getHousehold().getPartner1();
        }
        return person;
    }

    private final SimDate getLastDeathDate() {
        SimDate simDate = this.getOwner().getDeathDate();
        if (simDate == null) {
            return null;
        }
        SimDate deathDate = simDate;
        Object object = this.getHousehold().getPartner2();
        if (object == null || (object = object.getDeathDate()) == null) {
            return deathDate;
        }
        Object partnerDeathDate = object;
        return SimDate.Companion.max(deathDate, (SimDate)partnerDeathDate);
    }

    private final boolean isCouple() {
        return this.getHousehold().getPartner2() != null;
    }

    @NotNull
    public final String component1() {
        return this.tag;
    }

    @NotNull
    public final Person component2() {
        return this.owner;
    }

    @Nullable
    public final String component3() {
        return this.taxCode;
    }

    @Nullable
    public final Double component4() {
        return this.annualPension44;
    }

    @Nullable
    public final Integer component5() {
        return this.missingContributionYears;
    }

    @NotNull
    public final ChPillarOne copy(@NotNull String tag, @NotNull Person owner, @Nullable String taxCode, @Nullable Double annualPension44, @Nullable Integer missingContributionYears) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        return new ChPillarOne(tag, owner, taxCode, annualPension44, missingContributionYears);
    }

    public static /* synthetic */ ChPillarOne copy$default(ChPillarOne chPillarOne, String string, Person person, String string2, Double d, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = chPillarOne.tag;
        }
        if ((n2 & 2) != 0) {
            person = chPillarOne.owner;
        }
        if ((n2 & 4) != 0) {
            string2 = chPillarOne.taxCode;
        }
        if ((n2 & 8) != 0) {
            d = chPillarOne.annualPension44;
        }
        if ((n2 & 0x10) != 0) {
            n = chPillarOne.missingContributionYears;
        }
        return chPillarOne.copy(string, person, string2, d, n);
    }

    @NotNull
    public String toString() {
        return "ChPillarOne(tag=" + this.tag + ", owner=" + this.owner + ", taxCode=" + this.taxCode + ", annualPension44=" + this.annualPension44 + ", missingContributionYears=" + this.missingContributionYears + ")";
    }

    public int hashCode() {
        int result = this.tag.hashCode();
        result = result * 31 + this.owner.hashCode();
        result = result * 31 + (this.taxCode == null ? 0 : this.taxCode.hashCode());
        result = result * 31 + (this.annualPension44 == null ? 0 : ((Object)this.annualPension44).hashCode());
        result = result * 31 + (this.missingContributionYears == null ? 0 : ((Object)this.missingContributionYears).hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ChPillarOne)) {
            return false;
        }
        ChPillarOne chPillarOne = (ChPillarOne)other;
        if (!Intrinsics.areEqual((Object)this.tag, (Object)chPillarOne.tag)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.owner, (Object)chPillarOne.owner)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.taxCode, (Object)chPillarOne.taxCode)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.annualPension44, (Object)chPillarOne.annualPension44)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.missingContributionYears, (Object)chPillarOne.missingContributionYears);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0015\u0010\u0006\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u00002\b\u0010\r\u001a\u0004\u0018\u00010\fR\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/fincast/holding/impl/ch/ChPillarOne$Builder;", "", "()V", "annualPension44", "", "Ljava/lang/Double;", "missingContributionYears", "", "Ljava/lang/Integer;", "owner", "Lio/fincast/household/Person;", "tag", "", "taxCode", "(Ljava/lang/Double;)Lio/fincast/holding/impl/ch/ChPillarOne$Builder;", "build", "Lio/fincast/holding/impl/ch/ChPillarOne;", "(Ljava/lang/Integer;)Lio/fincast/holding/impl/ch/ChPillarOne$Builder;", "fincast"})
    @SourceDebugExtension(value={"SMAP\nChPillarOne.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChPillarOne.kt\nio/fincast/holding/impl/ch/ChPillarOne$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,264:1\n1#2:265\n*E\n"})
    public static final class Builder {
        @Nullable
        private String tag;
        @Nullable
        private String taxCode;
        @Nullable
        private Person owner;
        @Nullable
        private Double annualPension44;
        @Nullable
        private Integer missingContributionYears;

        @NotNull
        public final Builder tag(@NotNull String tag) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Builder $this$tag_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$tag_u24lambda_u240.tag = tag;
            return builder;
        }

        @NotNull
        public final Builder taxCode(@Nullable String taxCode) {
            Builder builder;
            Builder $this$taxCode_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$taxCode_u24lambda_u241.taxCode = taxCode;
            return builder;
        }

        @NotNull
        public final Builder owner(@NotNull Person owner) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Builder $this$owner_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$owner_u24lambda_u242.owner = owner;
            return builder;
        }

        @NotNull
        public final Builder annualPension44(@Nullable Double annualPension44) {
            Builder builder;
            Builder $this$annualPension44_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$annualPension44_u24lambda_u243.annualPension44 = annualPension44;
            return builder;
        }

        @NotNull
        public final Builder missingContributionYears(@Nullable Integer missingContributionYears) {
            Builder builder;
            Builder $this$missingContributionYears_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$missingContributionYears_u24lambda_u244.missingContributionYears = missingContributionYears;
            return builder;
        }

        @NotNull
        public final ChPillarOne build() {
            String string = this.tag;
            if (string == null) {
                throw new IllegalArgumentException("tag is required");
            }
            String string2 = string;
            String string3 = this.taxCode;
            Person person = this.owner;
            if (person == null) {
                throw new IllegalArgumentException("owner is required");
            }
            Person person2 = person;
            Double d = this.annualPension44;
            double d2 = d != null ? d : 0.0;
            Integer n = this.missingContributionYears;
            int n2 = n != null ? n : 0;
            return new ChPillarOne(string2, person2, string3, d2, n2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/fincast/holding/impl/ch/ChPillarOne$Companion;", "", "()V", "IncreasePerDelayedYear", "", "MaxCouplePension", "MaxSinglePension", "ReductionPerAdvanceYear", "ReductionPerMissingYear", "fincast"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

