/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.holding.base;

import io.fincast.compo.FinancialCompo;
import io.fincast.engine.Booking;
import io.fincast.engine.BookingListener;
import io.fincast.engine.SimDate;
import io.fincast.enums.BookingKind;
import io.fincast.enums.BookingType;
import io.fincast.enums.ProductType;
import io.fincast.holding.Holding;
import io.fincast.holding.ProjectionPhase;
import io.fincast.household.Household;
import io.fincast.household.Person;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\tJ\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J8\u0010'\u001a\u00020(2\u0006\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u00020\u00012\u0006\u00100\u001a\u00020\u00012\u0006\u00101\u001a\u00020\u0003H\u0002J0\u00102\u001a\u00020(2\u0006\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\r2\u0006\u00100\u001a\u00020\u00012\u0006\u00101\u001a\u00020\u0003H\u0016J\u0018\u00103\u001a\u00020(2\u0006\u0010+\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0016J0\u00104\u001a\u00020(2\u0006\u0010+\u001a\u00020\u00102\u0006\u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u00020\u00012\u0006\u00100\u001a\u00020\u00012\u0006\u00101\u001a\u00020\u0003H\u0016J\u000e\u00105\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H$J\b\u00106\u001a\u00020\rH\u0016J\u0010\u00106\u001a\u00020\r2\u0006\u0010+\u001a\u00020\u0010H\u0016J\n\u00107\u001a\u0004\u0018\u00010\u0010H\u0002J\u0010\u00108\u001a\u00020(2\u0006\u0010+\u001a\u00020\u0010H\u0016J\u0018\u00109\u001a\u00020(2\u0006\u0010+\u001a\u00020\u00102\u0006\u0010:\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020(2\u0006\u0010+\u001a\u00020\u0010H\u0016J\u0010\u0010=\u001a\u00020(2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010>\u001a\u00020(2\u0006\u0010\u001a\u001a\u00020\u000bR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\r0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001b\u0010\u001a\u001a\u00020\u000b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0010\u0010#\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0016\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010%\u00a8\u0006?"}, d2={"Lio/fincast/holding/base/HoldingBase;", "Lio/fincast/holding/Holding;", "tag", "", "owner", "Lio/fincast/household/Person;", "productType", "Lio/fincast/enums/ProductType;", "taxCode", "(Ljava/lang/String;Lio/fincast/household/Person;Lio/fincast/enums/ProductType;Ljava/lang/String;)V", "_household", "Lio/fincast/household/Household;", "balance", "", "balances", "", "Lio/fincast/engine/SimDate;", "bookingListener", "Lio/fincast/engine/BookingListener;", "compos", "", "Lio/fincast/compo/FinancialCompo;", "getCompos", "()Ljava/util/List;", "setCompos", "(Ljava/util/List;)V", "household", "getHousehold", "()Lio/fincast/household/Household;", "household$delegate", "Lkotlin/Lazy;", "getOwner", "()Lio/fincast/household/Person;", "getProductType", "()Lio/fincast/enums/ProductType;", "reconDate", "getTag", "()Ljava/lang/String;", "getTaxCode", "addBooking", "", "booking", "Lio/fincast/engine/Booking;", "date", "bookingKind", "Lio/fincast/enums/BookingKind;", "amount", "counterHolding", "trigHolding", "trigCompo", "bookCashflow", "bookReconciliation", "bookTransfer", "createCompos", "getBalance", "getLastDate", "handleEndOfMonth", "handleLifecycle", "projectionPhase", "Lio/fincast/holding/ProjectionPhase;", "handleReconciliation", "initProjection", "setHousehold", "fincast"})
@SourceDebugExtension(value={"SMAP\nHoldingBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HoldingBase.kt\nio/fincast/holding/base/HoldingBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n766#2:128\n857#2,2:129\n1855#2,2:131\n1#3:133\n*S KotlinDebug\n*F\n+ 1 HoldingBase.kt\nio/fincast/holding/base/HoldingBase\n*L\n51#1:128\n51#1:129,2\n51#1:131,2\n*E\n"})
public abstract class HoldingBase
implements Holding {
    @NotNull
    private final String tag;
    @Nullable
    private final Person owner;
    @NotNull
    private final ProductType productType;
    @Nullable
    private final String taxCode;
    @Nullable
    private Household _household;
    @NotNull
    private final Lazy household$delegate;
    @NotNull
    private List<? extends FinancialCompo> compos;
    private double balance;
    @Nullable
    private SimDate reconDate;
    @NotNull
    private final Map<SimDate, Double> balances;
    @Nullable
    private BookingListener bookingListener;

    public HoldingBase(@NotNull String tag, @Nullable Person owner, @NotNull ProductType productType, @Nullable String taxCode) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)productType), (String)"productType");
        this.tag = tag;
        this.owner = owner;
        this.productType = productType;
        this.taxCode = taxCode;
        this.household$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Household>(this){
            final /* synthetic */ HoldingBase this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Household invoke() {
                Household household2 = HoldingBase.access$get_household$p(this.this$0);
                if (household2 == null) {
                    throw new IllegalStateException("household not set");
                }
                return household2;
            }
        }));
        this.compos = CollectionsKt.emptyList();
        this.balances = new LinkedHashMap();
    }

    public /* synthetic */ HoldingBase(String string, Person person, ProductType productType, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            person = null;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        this(string, person, productType, string2);
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @Override
    @Nullable
    public Person getOwner() {
        return this.owner;
    }

    @Override
    @NotNull
    public ProductType getProductType() {
        return this.productType;
    }

    @Override
    @Nullable
    public String getTaxCode() {
        return this.taxCode;
    }

    @Override
    @NotNull
    public Household getHousehold() {
        Lazy lazy = this.household$delegate;
        return (Household)lazy.getValue();
    }

    public final void setHousehold(@NotNull Household household2) {
        Intrinsics.checkNotNullParameter((Object)household2, (String)"household");
        this._household = household2;
    }

    @Override
    @NotNull
    public List<FinancialCompo> getCompos() {
        return this.compos;
    }

    public void setCompos(@NotNull List<? extends FinancialCompo> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.compos = list;
    }

    @Override
    public void initProjection(@NotNull BookingListener bookingListener) {
        Intrinsics.checkNotNullParameter((Object)bookingListener, (String)"bookingListener");
        this.setCompos(this.createCompos());
        this.bookingListener = bookingListener;
    }

    @NotNull
    protected abstract List<FinancialCompo> createCompos();

    @Override
    public void handleReconciliation(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handleLifecycle(@NotNull SimDate date, @NotNull ProjectionPhase projectionPhase) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)((Object)projectionPhase), (String)"projectionPhase");
        Iterable $this$filter$iv = this.getCompos();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FinancialCompo it = (FinancialCompo)element$iv$iv;
            boolean bl = false;
            if (!(it.getProjectionPhase() == projectionPhase)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FinancialCompo it = (FinancialCompo)element$iv;
            boolean bl = false;
            it.handleLifecycle(date);
        }
    }

    @Override
    public double getBalance() {
        return this.balance;
    }

    @Override
    public double getBalance(@NotNull SimDate date) {
        double d;
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        if (date.compareTo(this.getHousehold().getReconDate()) < 0) {
            d = 0.0;
        } else if (!this.balances.containsKey(date)) {
            d = this.getBalance();
        } else {
            Double d2 = this.balances.get(date);
            Intrinsics.checkNotNull((Object)d2);
            d = ((Number)d2).doubleValue();
        }
        return d;
    }

    @Override
    public void bookReconciliation(@NotNull SimDate date, double balance) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        this.addBooking(new Booking.Reconciliation(this, date, balance));
    }

    @Override
    public void bookTransfer(@NotNull SimDate date, double amount, @NotNull Holding counterHolding, @NotNull Holding trigHolding, @NotNull String trigCompo) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)counterHolding, (String)"counterHolding");
        Intrinsics.checkNotNullParameter((Object)trigHolding, (String)"trigHolding");
        Intrinsics.checkNotNullParameter((Object)trigCompo, (String)"trigCompo");
        if (!(!this.isExternalCash() && !counterHolding.isExternalCash())) {
            boolean bl = false;
            String string = "cannot transfer to/from external cash";
            throw new IllegalArgumentException(string.toString());
        }
        if (amount == 0.0) {
            return;
        }
        this.addBooking(date, BookingKind.TRANSFER, amount, counterHolding, trigHolding, trigCompo);
        ((HoldingBase)counterHolding).addBooking(date, BookingKind.TRANSFER, -amount, this, trigHolding, trigCompo);
    }

    @Override
    public void bookCashflow(@NotNull SimDate date, @NotNull BookingKind bookingKind, double amount, @NotNull Holding trigHolding, @NotNull String trigCompo) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)((Object)bookingKind), (String)"bookingKind");
        Intrinsics.checkNotNullParameter((Object)trigHolding, (String)"trigHolding");
        Intrinsics.checkNotNullParameter((Object)trigCompo, (String)"trigCompo");
        if (!this.getProductType().isValuable) {
            boolean bl = false;
            String string = "can only book cashflow from/to valuable";
            throw new IllegalArgumentException(string.toString());
        }
        if (amount == 0.0) {
            return;
        }
        this.addBooking(date, bookingKind, amount, this.getHousehold().getExternalCash(), trigHolding, trigCompo);
        Holding holding = this.getHousehold().getExternalCash();
        Intrinsics.checkNotNull((Object)holding, (String)"null cannot be cast to non-null type io.fincast.holding.base.HoldingBase");
        ((HoldingBase)holding).addBooking(date, bookingKind, -amount, this, trigHolding, trigCompo);
    }

    private final void addBooking(SimDate date, BookingKind bookingKind, double amount, Holding counterHolding, Holding trigHolding, String trigCompo) {
        this.addBooking(new Booking.Lifecycle(this, date, bookingKind, amount, counterHolding, trigHolding, trigCompo));
    }

    /*
     * Unable to fully structure code
     */
    private final void addBooking(Booking booking) {
        lastDate = this.getLastDate();
        if (!(lastDate == null || booking.getDate().compareTo(lastDate) >= 0)) {
            $i$a$-require-HoldingBase$addBooking$1 = false;
            $i$a$-require-HoldingBase$addBooking$1 = "bookings must be sequential i: " + booking.getDate() + " >= " + lastDate;
            throw new IllegalArgumentException($i$a$-require-HoldingBase$addBooking$1.toString());
        }
        if (!(lastDate == null || booking.getDate().compareTo(lastDate.plus(1)) <= 0)) {
            $i$a$-require-HoldingBase$addBooking$2 = false;
            $i$a$-require-HoldingBase$addBooking$2 = "bookings must be sequential ii: " + booking.getDate() + " >= " + lastDate;
            throw new IllegalArgumentException($i$a$-require-HoldingBase$addBooking$2.toString());
        }
        if (this.reconDate == null) ** GOTO lbl-1000
        v0 = booking.getDate();
        v1 = this.reconDate;
        Intrinsics.checkNotNull((Object)v1);
        if (v0.compareTo(v1) > 0) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        if (!v2) {
            $i$a$-require-HoldingBase$addBooking$3 = false;
            var3_8 = "cannot add booking to reconciled period";
            throw new IllegalArgumentException(var3_8.toString());
        }
        if (0.0 == booking.getAmount()) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[booking.getBookingKind().getBookingType().ordinal()]) {
            case 1: {
                this.balance = booking.getAmount();
                this.reconDate = booking.getDate();
                break;
            }
            case 2: 
            case 3: {
                this.balance += booking.getAmount();
            }
        }
        v3 = this.bookingListener;
        Intrinsics.checkNotNull((Object)v3);
        v3.onBooking(booking);
    }

    @Override
    public void handleEndOfMonth(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        this.balances.put(date, this.balance);
    }

    private final SimDate getLastDate() {
        return (SimDate)CollectionsKt.maxOrNull((Iterable)this.balances.keySet());
    }

    @Override
    public boolean isAuxiliary() {
        return Holding.DefaultImpls.isAuxiliary(this);
    }

    @Override
    public boolean isExternalCash() {
        return Holding.DefaultImpls.isExternalCash(this);
    }

    @Override
    public boolean isInternalCash() {
        return Holding.DefaultImpls.isInternalCash(this);
    }

    @Override
    public boolean isBufferInvestment() {
        return Holding.DefaultImpls.isBufferInvestment(this);
    }

    @Override
    public double getYield() {
        return Holding.DefaultImpls.getYield(this);
    }

    public static final /* synthetic */ Household access$get_household$p(HoldingBase $this) {
        return $this._household;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BookingType.values().length];
            try {
                nArray[BookingType.RECONCILE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BookingType.CASHFLOW.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BookingType.TRANSFER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

