/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.engine.impl;

import io.fincast.compo.ValueProviders;
import io.fincast.engine.Booking;
import io.fincast.engine.HoldingPeriod;
import io.fincast.engine.ProjectionEngine;
import io.fincast.engine.ProjectionListener;
import io.fincast.engine.ProjectionPeriod;
import io.fincast.engine.ProjectionRun;
import io.fincast.engine.SimDate;
import io.fincast.engine.TaxInfo;
import io.fincast.enums.BookingKind;
import io.fincast.enums.BookingType;
import io.fincast.enums.CivilStatus;
import io.fincast.enums.Periodicity;
import io.fincast.holding.Holding;
import io.fincast.holding.ProjectionPhase;
import io.fincast.holding.TaxHandler;
import io.fincast.holding.Valuable;
import io.fincast.household.Household;
import io.fincast.spi.ChTaxChild;
import io.fincast.spi.ChTaxHouseholdInfo;
import io.fincast.spi.ChTaxPersonalInfo;
import io.fincast.spi.ChTaxResult;
import io.fincast.spi.ChTaxService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B/\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0002J\b\u0010#\u001a\u00020!H\u0016J\u0010\u0010$\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0016H\u0016JH\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u0001002\f\u00102\u001a\b\u0012\u0004\u0012\u0002030\u0016H\u0016J\u001c\u00104\u001a\b\u0012\u0004\u0012\u0002050\u00162\f\u00106\u001a\b\u0012\u0004\u0012\u0002050\u0016H\u0002J\u0010\u00107\u001a\u00020!2\u0006\u00108\u001a\u000205H\u0016J\u0010\u00109\u001a\u00020!2\u0006\u0010:\u001a\u00020\rH\u0016J\u0010\u0010;\u001a\u00020!2\u0006\u0010:\u001a\u00020\rH\u0016J\u001e\u0010<\u001a\u00020\u001e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u00162\u0006\u0010:\u001a\u00020\rH\u0002J\u0018\u0010=\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010:\u001a\u00020\rH\u0002J\u0010\u0010>\u001a\u00020!2\u0006\u0010:\u001a\u00020\rH\u0002J\u0016\u0010?\u001a\u00020!2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0016H\u0002R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lio/fincast/engine/impl/ProjectionRunImpl;", "Lio/fincast/engine/ProjectionRun;", "Lio/fincast/engine/ProjectionListener;", "Lio/fincast/spi/ChTaxService;", "engine", "Lio/fincast/engine/ProjectionEngine;", "household", "Lio/fincast/household/Household;", "holding", "Lio/fincast/holding/Holding;", "periodicity", "Lio/fincast/enums/Periodicity;", "endDate", "Lio/fincast/engine/SimDate;", "(Lio/fincast/engine/ProjectionEngine;Lio/fincast/household/Household;Lio/fincast/holding/Holding;Lio/fincast/enums/Periodicity;Lio/fincast/engine/SimDate;)V", "getEndDate", "()Lio/fincast/engine/SimDate;", "getEngine", "()Lio/fincast/engine/ProjectionEngine;", "getHolding", "()Lio/fincast/holding/Holding;", "holdings", "", "getHousehold", "()Lio/fincast/household/Household;", "getPeriodicity", "()Lio/fincast/enums/Periodicity;", "projectionListeners", "", "projectionPeriod", "Lio/fincast/engine/ProjectionPeriod;", "projectionPeriods", "addProjectionListener", "", "listener", "calcProjection", "closeProjectionPeriod", "getProjection", "getTaxes", "Lio/fincast/spi/ChTaxResult;", "taxYear", "", "taxLocationId", "civilStatus", "Lio/fincast/enums/CivilStatus;", "householdInfo", "Lio/fincast/spi/ChTaxHouseholdInfo;", "partner1Info", "Lio/fincast/spi/ChTaxPersonalInfo;", "partner2Info", "children", "Lio/fincast/spi/ChTaxChild;", "groupLifecycleBookings", "Lio/fincast/engine/Booking;", "bookings", "onBooking", "booking", "onEndOfMonth", "date", "onStartOfMonth", "openFirstPeriod", "openNextPeriod", "rebalance", "showProjectionResult", "projectionResult", "fincast"})
@SourceDebugExtension(value={"SMAP\nProjectionRunImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectionRunImpl.kt\nio/fincast/engine/impl/ProjectionRunImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,281:1\n1#2:282\n1855#3,2:283\n800#3,11:285\n1855#3,2:296\n1855#3,2:298\n1855#3,2:300\n1855#3,2:302\n1855#3,2:304\n1855#3,2:306\n1855#3,2:308\n1855#3,2:310\n800#3,11:312\n1855#3,2:323\n1855#3,2:325\n1855#3,2:327\n1855#3,2:329\n1549#3:331\n1620#3,3:332\n1194#3,2:335\n1222#3,4:337\n1238#3,4:343\n1855#3,2:347\n800#3,11:349\n1477#3:360\n1502#3,3:361\n1505#3,3:371\n1477#3:377\n1502#3,3:378\n1505#3,3:388\n800#3,11:398\n1855#3,2:409\n453#4:341\n403#4:342\n372#4,7:364\n372#4,7:381\n76#5:374\n96#5,2:375\n125#5:391\n152#5,3:392\n98#5,3:395\n*S KotlinDebug\n*F\n+ 1 ProjectionRunImpl.kt\nio/fincast/engine/impl/ProjectionRunImpl\n*L\n37#1:283,2\n41#1:285,11\n41#1:296,2\n51#1:298,2\n52#1:300,2\n53#1:302,2\n54#1:304,2\n62#1:306,2\n64#1:308,2\n65#1:310,2\n67#1:312,11\n67#1:323,2\n70#1:325,2\n77#1:327,2\n79#1:329,2\n110#1:331\n110#1:332,3\n110#1:335,2\n110#1:337,4\n119#1:343,4\n144#1:347,2\n166#1:349,11\n167#1:360\n167#1:361,3\n167#1:371,3\n169#1:377\n169#1:378,3\n169#1:388,3\n183#1:398,11\n187#1:409,2\n119#1:341\n119#1:342\n167#1:364,7\n169#1:381,7\n168#1:374\n168#1:375,2\n170#1:391\n170#1:392,3\n168#1:395,3\n*E\n"})
public final class ProjectionRunImpl
implements ProjectionRun,
ProjectionListener,
ChTaxService {
    @NotNull
    private final ProjectionEngine engine;
    @NotNull
    private final Household household;
    @Nullable
    private final Holding holding;
    @NotNull
    private final Periodicity periodicity;
    @NotNull
    private final SimDate endDate;
    @NotNull
    private final List<Holding> holdings;
    @NotNull
    private final List<ProjectionListener> projectionListeners;
    @NotNull
    private final List<ProjectionPeriod> projectionPeriods;
    @Nullable
    private ProjectionPeriod projectionPeriod;

    /*
     * WARNING - void declaration
     */
    public ProjectionRunImpl(@NotNull ProjectionEngine engine, @NotNull Household household2, @Nullable Holding holding, @NotNull Periodicity periodicity, @NotNull SimDate endDate) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter((Object)household2, (String)"household");
        Intrinsics.checkNotNullParameter((Object)((Object)periodicity), (String)"periodicity");
        Intrinsics.checkNotNullParameter((Object)endDate, (String)"endDate");
        this.engine = engine;
        this.household = household2;
        this.holding = holding;
        this.periodicity = periodicity;
        this.endDate = endDate;
        this.projectionListeners = new ArrayList();
        this.projectionPeriods = new ArrayList();
        if (!(this.getPeriodicity() == Periodicity.MONTHLY || this.getPeriodicity() == Periodicity.YEARLY)) {
            boolean $i$a$-check-ProjectionRunImpl$22 = false;
            String $i$a$-check-ProjectionRunImpl$22 = "periodicity must be MONTHLY or YEARLY";
            throw new IllegalStateException($i$a$-check-ProjectionRunImpl$22.toString());
        }
        Object[] $i$a$-check-ProjectionRunImpl$22 = new Holding[]{this.getHousehold().getInternalCash(), this.getHousehold().getExternalCash(), this.getHousehold().getBufferInvestment()};
        List auxHoldings = CollectionsKt.listOf((Object[])$i$a$-check-ProjectionRunImpl$22);
        this.holdings = CollectionsKt.plus((Collection)(this.getHolding() == null ? this.getHousehold().getHoldings() : CollectionsKt.listOf((Object)this.getHolding())), (Iterable)auxHoldings);
        Iterable $this$forEach$iv = this.holdings;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Holding it = (Holding)element$iv;
            boolean bl = false;
            it.initProjection(this);
        }
        this.addProjectionListener(this);
        Iterable $this$filterIsInstance$iv = this.holdings;
        boolean $i$f$filterIsInstance = false;
        Iterator iterator = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ProjectionListener)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProjectionListener listener = (ProjectionListener)element$iv;
            boolean bl = false;
            this.addProjectionListener(listener);
        }
    }

    @Override
    @NotNull
    public ProjectionEngine getEngine() {
        return this.engine;
    }

    @Override
    @NotNull
    public Household getHousehold() {
        return this.household;
    }

    @Override
    @Nullable
    public Holding getHolding() {
        return this.holding;
    }

    @Override
    @NotNull
    public Periodicity getPeriodicity() {
        return this.periodicity;
    }

    @Override
    @NotNull
    public SimDate getEndDate() {
        return this.endDate;
    }

    @Override
    public void calcProjection() {
        Object it;
        SimDate reconDate = this.getHousehold().getReconDate();
        Iterable $this$forEach$iv = this.projectionListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ProjectionListener)element$iv;
            boolean bl = false;
            it.onStartOfMonth(reconDate);
        }
        $this$forEach$iv = this.holdings;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Holding)element$iv;
            boolean bl = false;
            it.handleReconciliation(reconDate);
        }
        $this$forEach$iv = this.holdings;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Holding)element$iv;
            boolean bl = false;
            it.handleEndOfMonth(reconDate);
        }
        $this$forEach$iv = this.projectionListeners;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ProjectionListener)element$iv;
            boolean bl = false;
            it.onEndOfMonth(reconDate);
        }
        SimDate startDate = reconDate.plus(1);
        SimDate simDate = Periodicity.endOfPeriod$default(this.getPeriodicity(), this.getEndDate(), null, null, 6, null);
        Intrinsics.checkNotNull((Object)simDate);
        SimDate endDate = simDate;
        for (SimDate date : startDate.rangeTo(endDate)) {
            Iterator it2;
            Iterable $this$forEach$iv2 = this.projectionListeners;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                it2 = (ProjectionListener)element$iv;
                boolean bl = false;
                it2.onStartOfMonth(date);
            }
            $this$forEach$iv2 = this.holdings;
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                it2 = (Holding)element$iv;
                boolean bl = false;
                it2.handleLifecycle(date, ProjectionPhase.LIFECYCLE);
            }
            $this$forEach$iv2 = this.holdings;
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                it2 = (Holding)element$iv;
                boolean bl = false;
                it2.handleLifecycle(date, ProjectionPhase.EOP_TRANSFER);
            }
            if (date.isEndOfYear()) {
                Iterator $this$filterIsInstanceTo$iv$iv22;
                Iterable $this$filterIsInstance$iv = this.holdings;
                boolean $i$f$filterIsInstance = false;
                Iterator iterator = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                Iterator bl = $this$filterIsInstanceTo$iv$iv22.iterator();
                while (bl.hasNext()) {
                    Object element$iv$iv = bl.next();
                    if (!(element$iv$iv instanceof TaxHandler)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                $i$f$forEach2 = false;
                $this$filterIsInstanceTo$iv$iv22 = $this$forEach$iv2.iterator();
                while ($this$filterIsInstanceTo$iv$iv22.hasNext()) {
                    Object element$iv;
                    element$iv = $this$filterIsInstanceTo$iv$iv22.next();
                    TaxHandler it3 = (TaxHandler)element$iv;
                    boolean bl2 = false;
                    it3.handleTaxes(date, this);
                }
                Double d = this.getHousehold().getTargetCashBalance();
                double $this$filterIsInstanceTo$iv$iv22 = this.getHousehold().getInternalCash().getBalance() - (d != null ? d : 0.0);
                double it3 = 0.0;
                double totalProfit = Math.max($this$filterIsInstanceTo$iv$iv22, it3);
                ValueProviders.INSTANCE.setTotalProfit(totalProfit);
                Iterable $this$forEach$iv3 = this.holdings;
                boolean $i$f$forEach3 = false;
                for (Object element$iv : $this$forEach$iv3) {
                    Holding it4 = (Holding)element$iv;
                    boolean bl3 = false;
                    Double d2 = this.getHousehold().getTargetCashBalance();
                    double d3 = this.getHousehold().getInternalCash().getBalance() - (d2 != null ? d2 : 0.0);
                    double d4 = 0.0;
                    double availableProfit = Math.max(d3, d4);
                    ValueProviders.INSTANCE.setAvailableProfit(availableProfit);
                    it4.handleLifecycle(date, ProjectionPhase.EOY_REBALANCE);
                }
                if (this.getHousehold().getTargetCashBalance() != null) {
                    this.rebalance(date);
                }
            }
            $this$forEach$iv2 = this.holdings;
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                it2 = (Holding)element$iv;
                boolean bl = false;
                it2.handleEndOfMonth(date);
            }
            $this$forEach$iv2 = this.projectionListeners;
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                it2 = (ProjectionListener)element$iv;
                boolean bl = false;
                it2.onEndOfMonth(date);
            }
        }
    }

    @Override
    @NotNull
    public List<ProjectionPeriod> getProjection() {
        return this.projectionPeriods;
    }

    public final void addProjectionListener(@NotNull ProjectionListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.projectionListeners.add(listener);
    }

    @Override
    public void onStartOfMonth(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        SimDate simDate = Periodicity.endOfPeriod$default(this.getPeriodicity(), date, null, null, 6, null);
        Intrinsics.checkNotNull((Object)simDate);
        SimDate endOfPeriod = simDate;
        ProjectionPeriod projectionPeriod = this.projectionPeriod;
        if (projectionPeriod == null) {
            this.projectionPeriod = this.openFirstPeriod(this.holdings, endOfPeriod);
        } else if (this.getPeriodicity().isStartOfPeriod(date)) {
            this.projectionPeriod = this.openNextPeriod(projectionPeriod, endOfPeriod);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ProjectionPeriod openFirstPeriod(List<? extends Holding> holdings, SimDate date) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = holdings;
        List list = new ArrayList();
        SimDate simDate = date;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Holding holding = (Holding)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(new HoldingPeriod(date, (Holding)it, 0.0, 0.0, 0.0, 0.0, null, 124, null));
        }
        object = (List)destination$iv$iv;
        $this$map$iv = (Iterable)object;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            HoldingPeriod bl = (HoldingPeriod)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl2 = false;
            object.put(it.getHolding(), element$iv$iv);
        }
        object = destination$iv$iv2;
        TaxInfo taxInfo = null;
        Object object2 = object;
        List list2 = list;
        SimDate simDate2 = simDate;
        return new ProjectionPeriod(simDate2, list2, (Map<Holding, HoldingPeriod>)object2, taxInfo);
    }

    /*
     * WARNING - void declaration
     */
    private final ProjectionPeriod openNextPeriod(ProjectionPeriod projectionPeriod, SimDate date) {
        Map map;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Map<Holding, HoldingPeriod> map2 = projectionPeriod.getHoldings();
        List list = new ArrayList();
        SimDate simDate = date;
        boolean $i$f$mapValues = false;
        void var5_7 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            map = map3;
            boolean bl2 = false;
            HoldingPeriod h = (HoldingPeriod)entry2.getValue();
            HoldingPeriod holdingPeriod = HoldingPeriod.copy$default(h, date, null, 0.0, 0.0, 0.0, 0.0, new ArrayList(), 6, null);
            map.put(k, holdingPeriod);
        }
        map = destination$iv$iv;
        TaxInfo taxInfo = null;
        Map map4 = map;
        List list2 = list;
        SimDate simDate2 = simDate;
        return new ProjectionPeriod(simDate2, list2, map4, taxInfo);
    }

    @Override
    public void onEndOfMonth(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        if (this.getPeriodicity().isEndOfPeriod(date)) {
            ProjectionPeriod projectionPeriod = this.projectionPeriod;
            Intrinsics.checkNotNull((Object)projectionPeriod);
            this.closeProjectionPeriod(projectionPeriod);
            ProjectionPeriod projectionPeriod2 = this.projectionPeriod;
            Intrinsics.checkNotNull((Object)projectionPeriod2);
            this.projectionPeriods.add(projectionPeriod2);
        }
    }

    private final void closeProjectionPeriod(ProjectionPeriod projectionPeriod) {
        for (HoldingPeriod holdingPeriod : projectionPeriod.getHoldings().values()) {
            List<Booking> hBookings = this.groupLifecycleBookings(holdingPeriod.getBookings());
            holdingPeriod.getBookings().clear();
            holdingPeriod.getBookings().addAll((Collection<Booking>)hBookings);
            Iterable $this$forEach$iv = holdingPeriod.getBookings();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Booking booking = (Booking)element$iv;
                boolean bl = false;
                BookingKind bookingKind = booking.getBookingKind();
                BookingType bookingType = bookingKind.getBookingType();
                if (bookingKind == BookingKind.RECONCILE) {
                    holdingPeriod.setBalance(booking.getAmount());
                } else if (bookingType == BookingType.CASHFLOW || bookingType == BookingType.TRANSFER) {
                    if (bookingKind == BookingKind.CAPITAL_GAIN) {
                        holdingPeriod.setGain(holdingPeriod.getGain() + booking.getAmount());
                    } else if (booking.getAmount() > 0.0) {
                        holdingPeriod.setInflows(holdingPeriod.getInflows() + booking.getAmount());
                    } else {
                        holdingPeriod.setOutflows(holdingPeriod.getOutflows() + booking.getAmount());
                    }
                    holdingPeriod.setBalance(holdingPeriod.getBalance() + booking.getAmount());
                }
                projectionPeriod.getBookings().add(booking);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Booking> groupLifecycleBookings(List<? extends Booking> bookings) {
        Iterable $this$flatMapTo$iv$iv;
        Iterable answer$iv$iv$iv;
        boolean bl;
        Object it;
        Object $this$groupByTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = bookings;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object t : $this$filterIsInstanceTo$iv$iv) {
            if (!(t instanceof Booking.Lifecycle)) continue;
            destination$iv$iv.add(t);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterIsInstanceTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator<Object> iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            SimDate key$iv$iv;
            Object t = iterator.next();
            it = (Booking.Lifecycle)t;
            bl = false;
            Intrinsics.checkNotNull((Object)Periodicity.endOfPeriod$default(this.getPeriodicity(), ((Booking.Lifecycle)it).getDate(), null, null, 6, null));
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(t);
        }
        Object $this$flatMap$iv = destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$groupByTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Map.Entry entry : $this$flatMapTo$iv$iv.entrySet()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$groupByTo$iv$iv2;
            it = entry;
            bl = false;
            SimDate date = (SimDate)it.getKey();
            List periodBookings = (List)it.getValue();
            Object $this$groupBy$iv2 = periodBookings;
            boolean $i$f$groupBy2 = false;
            answer$iv$iv$iv = $this$groupBy$iv2;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo2 = false;
            for (Object element$iv$iv2 : $this$groupByTo$iv$iv2) {
                Object object;
                Booking.Lifecycle it2 = (Booking.Lifecycle)element$iv$iv2;
                boolean bl3 = false;
                String key$iv$iv = it2.getHolding().getTag() + ":" + it2.getBookingKind().getCode() + ":" + it2.getCounterHolding().getTag() + ":" + it2.getTrigHolding().getTag() + ":" + it2.getTrigCompo();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl4 = false;
                    List answer$iv$iv$iv2 = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv2);
                    object = answer$iv$iv$iv2;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv2);
            }
            $this$groupBy$iv2 = destination$iv$iv2;
            boolean $i$f$map = false;
            $this$groupByTo$iv$iv2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator<Object> iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry2 = item$iv$iv = (Map.Entry)iterator2.next();
                Collection collection = destination$iv$iv3;
                boolean bl5 = false;
                List keyBookings = (List)entry2.getValue();
                Booking.Lifecycle keyBooking = (Booking.Lifecycle)CollectionsKt.first((List)keyBookings);
                Iterable iterable2 = keyBookings;
                double d = 0.0;
                for (Object t : iterable2) {
                    void it3;
                    Booking.Lifecycle lifecycle = (Booking.Lifecycle)t;
                    double d2 = d;
                    boolean bl6 = false;
                    double d3 = it3.getAmount();
                    d = d2 + d3;
                }
                double amount = d;
                collection.add(new Booking.Lifecycle(keyBooking.getHolding(), date, keyBooking.getBookingKind(), amount, keyBooking.getCounterHolding(), keyBooking.getTrigHolding(), keyBooking.getTrigCompo()));
            }
            Iterable list$iv$iv = (List)destination$iv$iv3;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = bookings;
        Collection collection = (List)destination$iv$iv;
        $i$f$filterIsInstance = false;
        $this$flatMapTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterIsInstanceTo = false;
        for (Object object : $this$filterIsInstanceTo$iv$iv) {
            if (!(object instanceof Booking.Reconciliation)) continue;
            destination$iv$iv.add(object);
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    @Override
    public void onBooking(@NotNull Booking booking) {
        Intrinsics.checkNotNullParameter((Object)booking, (String)"booking");
        Iterable $this$forEach$iv = this.projectionListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProjectionListener it = (ProjectionListener)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it, (Object)this)) continue;
            it.onBooking(booking);
        }
        ProjectionPeriod projectionPeriod = this.projectionPeriod;
        Intrinsics.checkNotNull((Object)projectionPeriod);
        HoldingPeriod holdingPeriod = projectionPeriod.getHoldings().get(booking.getHolding());
        Intrinsics.checkNotNull((Object)holdingPeriod);
        HoldingPeriod holdingPeriod2 = holdingPeriod;
        holdingPeriod2.getBookings().add(booking);
    }

    private final void rebalance(SimDate date) {
        Double targetCashBalance = this.getHousehold().getTargetCashBalance();
        if (targetCashBalance == null || targetCashBalance <= 0.0) {
            return;
        }
        double internalCashBalance = this.getHousehold().getInternalCash().getBalance();
        double bufferBalance = this.getHousehold().getBufferInvestment().getBalance();
        if (internalCashBalance > targetCashBalance) {
            double amount = internalCashBalance - targetCashBalance;
            this.getHousehold().getBufferInvestment().bookTransfer(date, amount, this.getHousehold().getInternalCash(), this.getHousehold().getBufferInvestment(), "rebalance");
        } else if (internalCashBalance < targetCashBalance && bufferBalance > 0.0) {
            double amount = Math.min(targetCashBalance - internalCashBalance, bufferBalance);
            this.getHousehold().getInternalCash().bookTransfer(date, amount, this.getHousehold().getBufferInvestment(), this.getHousehold().getBufferInvestment(), "rebalance");
        }
    }

    @Override
    @NotNull
    public ChTaxResult getTaxes(int taxYear, int taxLocationId, @NotNull CivilStatus civilStatus, @NotNull ChTaxHouseholdInfo householdInfo, @NotNull ChTaxPersonalInfo partner1Info, @Nullable ChTaxPersonalInfo partner2Info, @NotNull List<ChTaxChild> children) {
        Intrinsics.checkNotNullParameter((Object)((Object)civilStatus), (String)"civilStatus");
        Intrinsics.checkNotNullParameter((Object)householdInfo, (String)"householdInfo");
        Intrinsics.checkNotNullParameter((Object)partner1Info, (String)"partner1Info");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        ChTaxResult taxResult = this.getEngine().getTaxService().getTaxes(taxYear, taxLocationId, civilStatus, householdInfo, partner1Info, partner2Info, children);
        ProjectionPeriod projectionPeriod = this.projectionPeriod;
        Intrinsics.checkNotNull((Object)projectionPeriod);
        projectionPeriod.setTaxInfo(new TaxInfo(taxYear, taxLocationId, civilStatus, householdInfo, partner1Info, partner2Info, children, taxResult));
        return taxResult;
    }

    private final void showProjectionResult(List<ProjectionPeriod> projectionResult) {
        System.out.println((Object)("\nPROJECTION RESULT from " + ((ProjectionPeriod)CollectionsKt.first(projectionResult)).getDate() + " to " + ((ProjectionPeriod)CollectionsKt.last(projectionResult)).getDate()));
        System.out.println((Object)"\nHolding Aggregates:");
        System.out.println((Object)"-------------------");
        int lastYear = ((ProjectionPeriod)CollectionsKt.first(projectionResult)).getDate().getYear();
        for (ProjectionPeriod period : projectionResult) {
            if (period.getDate().getYear() != lastYear) {
                System.out.println();
                lastYear = period.getDate().getYear();
            }
            for (HoldingPeriod holding : period.getHoldings().values()) {
                if (!(holding.getHolding() instanceof Valuable)) continue;
                System.out.println(holding);
            }
        }
        System.out.println((Object)"\nBookings:");
        System.out.println((Object)"---------");
        lastYear = ((ProjectionPeriod)CollectionsKt.first(projectionResult)).getDate().getYear();
        for (ProjectionPeriod period : projectionResult) {
            if (period.getDate().getYear() != lastYear) {
                System.out.println();
                lastYear = period.getDate().getYear();
            }
            for (Booking booking : period.getBookings()) {
                if (booking instanceof Booking.Reconciliation) {
                    System.out.println(booking);
                    continue;
                }
                if (!(booking instanceof Booking.Lifecycle)) continue;
                if (!Intrinsics.areEqual((Object)booking.getHolding(), (Object)this.getHousehold().getExternalCash())) {
                    System.out.println(booking);
                    continue;
                }
                if (Intrinsics.areEqual((Object)((Booking.Lifecycle)booking).getCounterHolding(), (Object)this.getHousehold().getInternalCash())) continue;
                System.out.println(booking);
            }
        }
    }
}

