/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.engine;

import io.fincast.engine.SimDate;
import io.fincast.enums.BookingKind;
import io.fincast.holding.Holding;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0002\u0012\u0013R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u0082\u0001\u0002\u0014\u0015\u00a8\u0006\u0016"}, d2={"Lio/fincast/engine/Booking;", "", "amount", "", "getAmount", "()D", "bookingKind", "Lio/fincast/enums/BookingKind;", "getBookingKind", "()Lio/fincast/enums/BookingKind;", "date", "Lio/fincast/engine/SimDate;", "getDate", "()Lio/fincast/engine/SimDate;", "holding", "Lio/fincast/holding/Holding;", "getHolding", "()Lio/fincast/holding/Holding;", "Lifecycle", "Reconciliation", "Lio/fincast/engine/Booking$Lifecycle;", "Lio/fincast/engine/Booking$Reconciliation;", "fincast"})
public interface Booking {
    @NotNull
    public Holding getHolding();

    @NotNull
    public SimDate getDate();

    @NotNull
    public BookingKind getBookingKind();

    public double getAmount();

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\rH\u00c6\u0003JO\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001J\b\u0010)\u001a\u00020\rH\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0014\u00a8\u0006*"}, d2={"Lio/fincast/engine/Booking$Lifecycle;", "Lio/fincast/engine/Booking;", "holding", "Lio/fincast/holding/Holding;", "date", "Lio/fincast/engine/SimDate;", "bookingKind", "Lio/fincast/enums/BookingKind;", "amount", "", "counterHolding", "trigHolding", "trigCompo", "", "(Lio/fincast/holding/Holding;Lio/fincast/engine/SimDate;Lio/fincast/enums/BookingKind;DLio/fincast/holding/Holding;Lio/fincast/holding/Holding;Ljava/lang/String;)V", "getAmount", "()D", "getBookingKind", "()Lio/fincast/enums/BookingKind;", "getCounterHolding", "()Lio/fincast/holding/Holding;", "getDate", "()Lio/fincast/engine/SimDate;", "getHolding", "getTrigCompo", "()Ljava/lang/String;", "getTrigHolding", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "", "hashCode", "", "toString", "fincast"})
    public static final class Lifecycle
    implements Booking {
        @NotNull
        private final Holding holding;
        @NotNull
        private final SimDate date;
        @NotNull
        private final BookingKind bookingKind;
        private final double amount;
        @NotNull
        private final Holding counterHolding;
        @NotNull
        private final Holding trigHolding;
        @NotNull
        private final String trigCompo;

        public Lifecycle(@NotNull Holding holding, @NotNull SimDate date, @NotNull BookingKind bookingKind, double amount, @NotNull Holding counterHolding, @NotNull Holding trigHolding, @NotNull String trigCompo) {
            Intrinsics.checkNotNullParameter((Object)holding, (String)"holding");
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            Intrinsics.checkNotNullParameter((Object)((Object)bookingKind), (String)"bookingKind");
            Intrinsics.checkNotNullParameter((Object)counterHolding, (String)"counterHolding");
            Intrinsics.checkNotNullParameter((Object)trigHolding, (String)"trigHolding");
            Intrinsics.checkNotNullParameter((Object)trigCompo, (String)"trigCompo");
            this.holding = holding;
            this.date = date;
            this.bookingKind = bookingKind;
            this.amount = amount;
            this.counterHolding = counterHolding;
            this.trigHolding = trigHolding;
            this.trigCompo = trigCompo;
        }

        @Override
        @NotNull
        public Holding getHolding() {
            return this.holding;
        }

        @Override
        @NotNull
        public SimDate getDate() {
            return this.date;
        }

        @Override
        @NotNull
        public BookingKind getBookingKind() {
            return this.bookingKind;
        }

        @Override
        public double getAmount() {
            return this.amount;
        }

        @NotNull
        public final Holding getCounterHolding() {
            return this.counterHolding;
        }

        @NotNull
        public final Holding getTrigHolding() {
            return this.trigHolding;
        }

        @NotNull
        public final String getTrigCompo() {
            return this.trigCompo;
        }

        @NotNull
        public String toString() {
            SimDate simDate = this.getDate();
            String string = this.getBookingKind().getCode();
            String string2 = this.getHolding().getTag();
            String string3 = "%.0f";
            Object[] objectArray = new Object[]{this.getAmount()};
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            return simDate + ": " + string + " " + string2 + " " + string4 + " [against " + this.counterHolding.getTag() + ", trig by " + this.trigHolding.getTag() + "." + this.trigCompo + "]";
        }

        @NotNull
        public final Holding component1() {
            return this.holding;
        }

        @NotNull
        public final SimDate component2() {
            return this.date;
        }

        @NotNull
        public final BookingKind component3() {
            return this.bookingKind;
        }

        public final double component4() {
            return this.amount;
        }

        @NotNull
        public final Holding component5() {
            return this.counterHolding;
        }

        @NotNull
        public final Holding component6() {
            return this.trigHolding;
        }

        @NotNull
        public final String component7() {
            return this.trigCompo;
        }

        @NotNull
        public final Lifecycle copy(@NotNull Holding holding, @NotNull SimDate date, @NotNull BookingKind bookingKind, double amount, @NotNull Holding counterHolding, @NotNull Holding trigHolding, @NotNull String trigCompo) {
            Intrinsics.checkNotNullParameter((Object)holding, (String)"holding");
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            Intrinsics.checkNotNullParameter((Object)((Object)bookingKind), (String)"bookingKind");
            Intrinsics.checkNotNullParameter((Object)counterHolding, (String)"counterHolding");
            Intrinsics.checkNotNullParameter((Object)trigHolding, (String)"trigHolding");
            Intrinsics.checkNotNullParameter((Object)trigCompo, (String)"trigCompo");
            return new Lifecycle(holding, date, bookingKind, amount, counterHolding, trigHolding, trigCompo);
        }

        public static /* synthetic */ Lifecycle copy$default(Lifecycle lifecycle, Holding holding, SimDate simDate, BookingKind bookingKind, double d, Holding holding2, Holding holding3, String string, int n, Object object) {
            if ((n & 1) != 0) {
                holding = lifecycle.holding;
            }
            if ((n & 2) != 0) {
                simDate = lifecycle.date;
            }
            if ((n & 4) != 0) {
                bookingKind = lifecycle.bookingKind;
            }
            if ((n & 8) != 0) {
                d = lifecycle.amount;
            }
            if ((n & 0x10) != 0) {
                holding2 = lifecycle.counterHolding;
            }
            if ((n & 0x20) != 0) {
                holding3 = lifecycle.trigHolding;
            }
            if ((n & 0x40) != 0) {
                string = lifecycle.trigCompo;
            }
            return lifecycle.copy(holding, simDate, bookingKind, d, holding2, holding3, string);
        }

        public int hashCode() {
            int result = this.holding.hashCode();
            result = result * 31 + this.date.hashCode();
            result = result * 31 + this.bookingKind.hashCode();
            result = result * 31 + Double.hashCode(this.amount);
            result = result * 31 + this.counterHolding.hashCode();
            result = result * 31 + this.trigHolding.hashCode();
            result = result * 31 + this.trigCompo.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Lifecycle)) {
                return false;
            }
            Lifecycle lifecycle = (Lifecycle)other;
            if (!Intrinsics.areEqual((Object)this.holding, (Object)lifecycle.holding)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.date, (Object)lifecycle.date)) {
                return false;
            }
            if (this.bookingKind != lifecycle.bookingKind) {
                return false;
            }
            if (Double.compare(this.amount, lifecycle.amount) != 0) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.counterHolding, (Object)lifecycle.counterHolding)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.trigHolding, (Object)lifecycle.trigHolding)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.trigCompo, (Object)lifecycle.trigCompo);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lio/fincast/engine/Booking$Reconciliation;", "Lio/fincast/engine/Booking;", "holding", "Lio/fincast/holding/Holding;", "date", "Lio/fincast/engine/SimDate;", "amount", "", "(Lio/fincast/holding/Holding;Lio/fincast/engine/SimDate;D)V", "getAmount", "()D", "bookingKind", "Lio/fincast/enums/BookingKind;", "getBookingKind", "()Lio/fincast/enums/BookingKind;", "getDate", "()Lio/fincast/engine/SimDate;", "getHolding", "()Lio/fincast/holding/Holding;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "fincast"})
    public static final class Reconciliation
    implements Booking {
        @NotNull
        private final Holding holding;
        @NotNull
        private final SimDate date;
        private final double amount;
        @NotNull
        private final BookingKind bookingKind;

        public Reconciliation(@NotNull Holding holding, @NotNull SimDate date, double amount) {
            Intrinsics.checkNotNullParameter((Object)holding, (String)"holding");
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            this.holding = holding;
            this.date = date;
            this.amount = amount;
            this.bookingKind = BookingKind.RECONCILE;
        }

        @Override
        @NotNull
        public Holding getHolding() {
            return this.holding;
        }

        @Override
        @NotNull
        public SimDate getDate() {
            return this.date;
        }

        @Override
        public double getAmount() {
            return this.amount;
        }

        @Override
        @NotNull
        public BookingKind getBookingKind() {
            return this.bookingKind;
        }

        @NotNull
        public String toString() {
            SimDate simDate = this.getDate();
            String string = this.getBookingKind().getCode();
            String string2 = this.getHolding().getTag();
            String string3 = "%.0f";
            Object[] objectArray = new Object[]{this.getAmount()};
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            return simDate + ": " + string + " " + string2 + " " + string4;
        }

        @NotNull
        public final Holding component1() {
            return this.holding;
        }

        @NotNull
        public final SimDate component2() {
            return this.date;
        }

        public final double component3() {
            return this.amount;
        }

        @NotNull
        public final Reconciliation copy(@NotNull Holding holding, @NotNull SimDate date, double amount) {
            Intrinsics.checkNotNullParameter((Object)holding, (String)"holding");
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            return new Reconciliation(holding, date, amount);
        }

        public static /* synthetic */ Reconciliation copy$default(Reconciliation reconciliation, Holding holding, SimDate simDate, double d, int n, Object object) {
            if ((n & 1) != 0) {
                holding = reconciliation.holding;
            }
            if ((n & 2) != 0) {
                simDate = reconciliation.date;
            }
            if ((n & 4) != 0) {
                d = reconciliation.amount;
            }
            return reconciliation.copy(holding, simDate, d);
        }

        public int hashCode() {
            int result = this.holding.hashCode();
            result = result * 31 + this.date.hashCode();
            result = result * 31 + Double.hashCode(this.amount);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Reconciliation)) {
                return false;
            }
            Reconciliation reconciliation = (Reconciliation)other;
            if (!Intrinsics.areEqual((Object)this.holding, (Object)reconciliation.holding)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.date, (Object)reconciliation.date)) {
                return false;
            }
            return Double.compare(this.amount, reconciliation.amount) == 0;
        }
    }
}

