/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.compo.impl;

import io.fincast.compo.FinancialCompo;
import io.fincast.compo.ValueProvider;
import io.fincast.engine.SimDate;
import io.fincast.enums.Periodicity;
import io.fincast.holding.Holding;
import io.fincast.holding.ProjectionPhase;
import io.fincast.household.Household;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010&\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J\t\u0010'\u001a\u00020\fH\u00c6\u0003J\u000b\u0010(\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003J\u000b\u0010)\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003J\t\u0010*\u001a\u00020\u0011H\u00c6\u0003Jm\u0010+\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u00c6\u0001J\u0013\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010/H\u00d6\u0003J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u000eH\u0016J\t\u00103\u001a\u000204H\u00d6\u0001J\t\u00105\u001a\u00020\u0005H\u00d6\u0001R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0018\u00a8\u00066"}, d2={"Lio/fincast/compo/impl/TransferCompo;", "Lio/fincast/compo/FinancialCompo;", "holding", "Lio/fincast/holding/Holding;", "tag", "", "fromHolding", "toHolding", "amount", "Lio/fincast/compo/ValueProvider;", "", "periodicity", "Lio/fincast/enums/Periodicity;", "startDate", "Lio/fincast/engine/SimDate;", "endDate", "projectionPhase", "Lio/fincast/holding/ProjectionPhase;", "(Lio/fincast/holding/Holding;Ljava/lang/String;Lio/fincast/holding/Holding;Lio/fincast/holding/Holding;Lio/fincast/compo/ValueProvider;Lio/fincast/enums/Periodicity;Lio/fincast/engine/SimDate;Lio/fincast/engine/SimDate;Lio/fincast/holding/ProjectionPhase;)V", "getAmount", "()Lio/fincast/compo/ValueProvider;", "getEndDate", "()Lio/fincast/engine/SimDate;", "getFromHolding", "()Lio/fincast/holding/Holding;", "getHolding", "getPeriodicity", "()Lio/fincast/enums/Periodicity;", "getProjectionPhase", "()Lio/fincast/holding/ProjectionPhase;", "getStartDate", "getTag", "()Ljava/lang/String;", "getToHolding", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "", "handleLifecycle", "", "date", "hashCode", "", "toString", "fincast"})
public final class TransferCompo
implements FinancialCompo {
    @NotNull
    private final Holding holding;
    @NotNull
    private final String tag;
    @NotNull
    private final Holding fromHolding;
    @NotNull
    private final Holding toHolding;
    @NotNull
    private final ValueProvider<Double> amount;
    @NotNull
    private final Periodicity periodicity;
    @Nullable
    private final SimDate startDate;
    @Nullable
    private final SimDate endDate;
    @NotNull
    private final ProjectionPhase projectionPhase;

    public TransferCompo(@NotNull Holding holding, @NotNull String tag, @NotNull Holding fromHolding, @NotNull Holding toHolding, @NotNull ValueProvider<Double> amount, @NotNull Periodicity periodicity, @Nullable SimDate startDate, @Nullable SimDate endDate, @NotNull ProjectionPhase projectionPhase) {
        Intrinsics.checkNotNullParameter((Object)holding, (String)"holding");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)fromHolding, (String)"fromHolding");
        Intrinsics.checkNotNullParameter((Object)toHolding, (String)"toHolding");
        Intrinsics.checkNotNullParameter(amount, (String)"amount");
        Intrinsics.checkNotNullParameter((Object)((Object)periodicity), (String)"periodicity");
        Intrinsics.checkNotNullParameter((Object)((Object)projectionPhase), (String)"projectionPhase");
        this.holding = holding;
        this.tag = tag;
        this.fromHolding = fromHolding;
        this.toHolding = toHolding;
        this.amount = amount;
        this.periodicity = periodicity;
        this.startDate = startDate;
        this.endDate = endDate;
        this.projectionPhase = projectionPhase;
        if (this.getProjectionPhase() != ProjectionPhase.EOP_TRANSFER && this.getProjectionPhase() != ProjectionPhase.EOY_REBALANCE) {
            throw new IllegalArgumentException("invalid projectionPhase " + this.getProjectionPhase() + " (must be eop or eoy)");
        }
    }

    public /* synthetic */ TransferCompo(Holding holding, String string, Holding holding2, Holding holding3, ValueProvider valueProvider, Periodicity periodicity, SimDate simDate, SimDate simDate2, ProjectionPhase projectionPhase, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            simDate = null;
        }
        if ((n & 0x80) != 0) {
            simDate2 = null;
        }
        if ((n & 0x100) != 0) {
            projectionPhase = ProjectionPhase.EOP_TRANSFER;
        }
        this(holding, string, holding2, holding3, valueProvider, periodicity, simDate, simDate2, projectionPhase);
    }

    @Override
    @NotNull
    public Holding getHolding() {
        return this.holding;
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @NotNull
    public final Holding getFromHolding() {
        return this.fromHolding;
    }

    @NotNull
    public final Holding getToHolding() {
        return this.toHolding;
    }

    @NotNull
    public final ValueProvider<Double> getAmount() {
        return this.amount;
    }

    @NotNull
    public final Periodicity getPeriodicity() {
        return this.periodicity;
    }

    @Nullable
    public final SimDate getStartDate() {
        return this.startDate;
    }

    @Nullable
    public final SimDate getEndDate() {
        return this.endDate;
    }

    @Override
    @NotNull
    public ProjectionPhase getProjectionPhase() {
        return this.projectionPhase;
    }

    @Override
    public void handleLifecycle(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        if (this.periodicity.isEndOfPeriod(date, this.startDate, this.endDate)) {
            Double d = this.amount.getValue(this, date);
            double amount = -(d != null ? d : 0.0);
            this.fromHolding.bookTransfer(date, amount, this.toHolding, this.getHolding(), this.getTag());
        }
    }

    @Override
    @NotNull
    public Household getHousehold() {
        return FinancialCompo.DefaultImpls.getHousehold(this);
    }

    @Override
    public double getYield() {
        return FinancialCompo.DefaultImpls.getYield(this);
    }

    @NotNull
    public final Holding component1() {
        return this.holding;
    }

    @NotNull
    public final String component2() {
        return this.tag;
    }

    @NotNull
    public final Holding component3() {
        return this.fromHolding;
    }

    @NotNull
    public final Holding component4() {
        return this.toHolding;
    }

    @NotNull
    public final ValueProvider<Double> component5() {
        return this.amount;
    }

    @NotNull
    public final Periodicity component6() {
        return this.periodicity;
    }

    @Nullable
    public final SimDate component7() {
        return this.startDate;
    }

    @Nullable
    public final SimDate component8() {
        return this.endDate;
    }

    @NotNull
    public final ProjectionPhase component9() {
        return this.projectionPhase;
    }

    @NotNull
    public final TransferCompo copy(@NotNull Holding holding, @NotNull String tag, @NotNull Holding fromHolding, @NotNull Holding toHolding, @NotNull ValueProvider<Double> amount, @NotNull Periodicity periodicity, @Nullable SimDate startDate, @Nullable SimDate endDate, @NotNull ProjectionPhase projectionPhase) {
        Intrinsics.checkNotNullParameter((Object)holding, (String)"holding");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)fromHolding, (String)"fromHolding");
        Intrinsics.checkNotNullParameter((Object)toHolding, (String)"toHolding");
        Intrinsics.checkNotNullParameter(amount, (String)"amount");
        Intrinsics.checkNotNullParameter((Object)((Object)periodicity), (String)"periodicity");
        Intrinsics.checkNotNullParameter((Object)((Object)projectionPhase), (String)"projectionPhase");
        return new TransferCompo(holding, tag, fromHolding, toHolding, amount, periodicity, startDate, endDate, projectionPhase);
    }

    public static /* synthetic */ TransferCompo copy$default(TransferCompo transferCompo, Holding holding, String string, Holding holding2, Holding holding3, ValueProvider valueProvider, Periodicity periodicity, SimDate simDate, SimDate simDate2, ProjectionPhase projectionPhase, int n, Object object) {
        if ((n & 1) != 0) {
            holding = transferCompo.holding;
        }
        if ((n & 2) != 0) {
            string = transferCompo.tag;
        }
        if ((n & 4) != 0) {
            holding2 = transferCompo.fromHolding;
        }
        if ((n & 8) != 0) {
            holding3 = transferCompo.toHolding;
        }
        if ((n & 0x10) != 0) {
            valueProvider = transferCompo.amount;
        }
        if ((n & 0x20) != 0) {
            periodicity = transferCompo.periodicity;
        }
        if ((n & 0x40) != 0) {
            simDate = transferCompo.startDate;
        }
        if ((n & 0x80) != 0) {
            simDate2 = transferCompo.endDate;
        }
        if ((n & 0x100) != 0) {
            projectionPhase = transferCompo.projectionPhase;
        }
        return transferCompo.copy(holding, string, holding2, holding3, valueProvider, periodicity, simDate, simDate2, projectionPhase);
    }

    @NotNull
    public String toString() {
        return "TransferCompo(holding=" + this.holding + ", tag=" + this.tag + ", fromHolding=" + this.fromHolding + ", toHolding=" + this.toHolding + ", amount=" + this.amount + ", periodicity=" + this.periodicity + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", projectionPhase=" + this.projectionPhase + ")";
    }

    public int hashCode() {
        int result = this.holding.hashCode();
        result = result * 31 + this.tag.hashCode();
        result = result * 31 + this.fromHolding.hashCode();
        result = result * 31 + this.toHolding.hashCode();
        result = result * 31 + this.amount.hashCode();
        result = result * 31 + this.periodicity.hashCode();
        result = result * 31 + (this.startDate == null ? 0 : this.startDate.hashCode());
        result = result * 31 + (this.endDate == null ? 0 : this.endDate.hashCode());
        result = result * 31 + this.projectionPhase.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TransferCompo)) {
            return false;
        }
        TransferCompo transferCompo = (TransferCompo)other;
        if (!Intrinsics.areEqual((Object)this.holding, (Object)transferCompo.holding)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.tag, (Object)transferCompo.tag)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fromHolding, (Object)transferCompo.fromHolding)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.toHolding, (Object)transferCompo.toHolding)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.amount, transferCompo.amount)) {
            return false;
        }
        if (this.periodicity != transferCompo.periodicity) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.startDate, (Object)transferCompo.startDate)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.endDate, (Object)transferCompo.endDate)) {
            return false;
        }
        return this.projectionPhase == transferCompo.projectionPhase;
    }
}

