/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.compo.impl;

import io.fincast.compo.FinancialCompo;
import io.fincast.compo.ValueProvider;
import io.fincast.compo.impl.FlowDirection;
import io.fincast.engine.SimDate;
import io.fincast.enums.BookingKind;
import io.fincast.enums.FundsUtilisation;
import io.fincast.enums.Periodicity;
import io.fincast.holding.Holding;
import io.fincast.holding.ProjectionPhase;
import io.fincast.household.Household;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u001e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0010\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\u0005H\u00c6\u0003J\t\u0010(\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010)\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J\t\u0010*\u001a\u00020\fH\u00c6\u0003J\t\u0010+\u001a\u00020\u000eH\u00c6\u0003J\u000b\u0010,\u001a\u0004\u0018\u00010\u0010H\u00c6\u0003J\u000b\u0010-\u001a\u0004\u0018\u00010\u0010H\u00c6\u0003J\t\u0010.\u001a\u00020\u0013H\u00c6\u0003Jm\u0010/\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u00c6\u0001J\u0013\u00100\u001a\u00020\u00132\b\u00101\u001a\u0004\u0018\u000102H\u00d6\u0003J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u0010H\u0016J\t\u00106\u001a\u000207H\u00d6\u0001J\t\u00108\u001a\u00020\u0005H\u00d6\u0001R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001aR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u00069"}, d2={"Lio/fincast/compo/impl/CashflowCompo;", "Lio/fincast/compo/FinancialCompo;", "holding", "Lio/fincast/holding/Holding;", "tag", "", "fundsUtilisation", "Lio/fincast/enums/FundsUtilisation;", "amount", "Lio/fincast/compo/ValueProvider;", "", "direction", "Lio/fincast/compo/impl/FlowDirection;", "periodicity", "Lio/fincast/enums/Periodicity;", "startDate", "Lio/fincast/engine/SimDate;", "endDate", "proRata", "", "(Lio/fincast/holding/Holding;Ljava/lang/String;Lio/fincast/enums/FundsUtilisation;Lio/fincast/compo/ValueProvider;Lio/fincast/compo/impl/FlowDirection;Lio/fincast/enums/Periodicity;Lio/fincast/engine/SimDate;Lio/fincast/engine/SimDate;Z)V", "getAmount", "()Lio/fincast/compo/ValueProvider;", "getDirection", "()Lio/fincast/compo/impl/FlowDirection;", "getEndDate", "()Lio/fincast/engine/SimDate;", "getFundsUtilisation", "()Lio/fincast/enums/FundsUtilisation;", "getHolding", "()Lio/fincast/holding/Holding;", "getPeriodicity", "()Lio/fincast/enums/Periodicity;", "getProRata", "()Z", "getStartDate", "getTag", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "", "handleLifecycle", "", "date", "hashCode", "", "toString", "fincast"})
public final class CashflowCompo
implements FinancialCompo {
    @NotNull
    private final Holding holding;
    @NotNull
    private final String tag;
    @NotNull
    private final FundsUtilisation fundsUtilisation;
    @NotNull
    private final ValueProvider<Double> amount;
    @NotNull
    private final FlowDirection direction;
    @NotNull
    private final Periodicity periodicity;
    @Nullable
    private final SimDate startDate;
    @Nullable
    private final SimDate endDate;
    private final boolean proRata;

    public CashflowCompo(@NotNull Holding holding, @NotNull String tag, @NotNull FundsUtilisation fundsUtilisation, @NotNull ValueProvider<Double> amount, @NotNull FlowDirection direction, @NotNull Periodicity periodicity, @Nullable SimDate startDate, @Nullable SimDate endDate, boolean proRata) {
        Intrinsics.checkNotNullParameter((Object)holding, (String)"holding");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)fundsUtilisation), (String)"fundsUtilisation");
        Intrinsics.checkNotNullParameter(amount, (String)"amount");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        Intrinsics.checkNotNullParameter((Object)((Object)periodicity), (String)"periodicity");
        this.holding = holding;
        this.tag = tag;
        this.fundsUtilisation = fundsUtilisation;
        this.amount = amount;
        this.direction = direction;
        this.periodicity = periodicity;
        this.startDate = startDate;
        this.endDate = endDate;
        this.proRata = proRata;
    }

    public /* synthetic */ CashflowCompo(Holding holding, String string, FundsUtilisation fundsUtilisation, ValueProvider valueProvider, FlowDirection flowDirection, Periodicity periodicity, SimDate simDate, SimDate simDate2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            simDate = null;
        }
        if ((n & 0x80) != 0) {
            simDate2 = null;
        }
        if ((n & 0x100) != 0) {
            bl = true;
        }
        this(holding, string, fundsUtilisation, valueProvider, flowDirection, periodicity, simDate, simDate2, bl);
    }

    @Override
    @NotNull
    public Holding getHolding() {
        return this.holding;
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @NotNull
    public final FundsUtilisation getFundsUtilisation() {
        return this.fundsUtilisation;
    }

    @NotNull
    public final ValueProvider<Double> getAmount() {
        return this.amount;
    }

    @NotNull
    public final FlowDirection getDirection() {
        return this.direction;
    }

    @NotNull
    public final Periodicity getPeriodicity() {
        return this.periodicity;
    }

    @Nullable
    public final SimDate getStartDate() {
        return this.startDate;
    }

    @Nullable
    public final SimDate getEndDate() {
        return this.endDate;
    }

    public final boolean getProRata() {
        return this.proRata;
    }

    @Override
    public void handleLifecycle(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        if (this.periodicity.isEndOfPeriod(date, this.startDate, this.endDate)) {
            int sign = this.direction == FlowDirection.INCOMING ? 1 : -1;
            Double d = this.amount.getValue(this, date);
            double amount = (d != null ? d : 0.0) * (double)sign;
            SimDate sop = Periodicity.startOfPeriod$default(this.periodicity, date, null, null, 6, null);
            if (this.proRata && this.startDate != null && this.periodicity.getMonths() > 1) {
                SimDate simDate = sop;
                Intrinsics.checkNotNull((Object)simDate);
                if (simDate.compareTo(this.startDate) < 0) {
                    amount = amount * (double)(date.minus(this.startDate) + 1) / (double)this.periodicity.getMonths();
                }
            }
            Holding holding = this.fundsUtilisation == FundsUtilisation.COMPOUND ? this.getHolding() : (Holding)this.getHousehold().getInternalCash();
            holding.bookCashflow(date, BookingKind.CASHFLOW, amount, this.getHolding(), this.getTag());
        }
    }

    @Override
    @NotNull
    public Household getHousehold() {
        return FinancialCompo.DefaultImpls.getHousehold(this);
    }

    @Override
    @NotNull
    public ProjectionPhase getProjectionPhase() {
        return FinancialCompo.DefaultImpls.getProjectionPhase(this);
    }

    @Override
    public double getYield() {
        return FinancialCompo.DefaultImpls.getYield(this);
    }

    @NotNull
    public final Holding component1() {
        return this.holding;
    }

    @NotNull
    public final String component2() {
        return this.tag;
    }

    @NotNull
    public final FundsUtilisation component3() {
        return this.fundsUtilisation;
    }

    @NotNull
    public final ValueProvider<Double> component4() {
        return this.amount;
    }

    @NotNull
    public final FlowDirection component5() {
        return this.direction;
    }

    @NotNull
    public final Periodicity component6() {
        return this.periodicity;
    }

    @Nullable
    public final SimDate component7() {
        return this.startDate;
    }

    @Nullable
    public final SimDate component8() {
        return this.endDate;
    }

    public final boolean component9() {
        return this.proRata;
    }

    @NotNull
    public final CashflowCompo copy(@NotNull Holding holding, @NotNull String tag, @NotNull FundsUtilisation fundsUtilisation, @NotNull ValueProvider<Double> amount, @NotNull FlowDirection direction, @NotNull Periodicity periodicity, @Nullable SimDate startDate, @Nullable SimDate endDate, boolean proRata) {
        Intrinsics.checkNotNullParameter((Object)holding, (String)"holding");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)fundsUtilisation), (String)"fundsUtilisation");
        Intrinsics.checkNotNullParameter(amount, (String)"amount");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        Intrinsics.checkNotNullParameter((Object)((Object)periodicity), (String)"periodicity");
        return new CashflowCompo(holding, tag, fundsUtilisation, amount, direction, periodicity, startDate, endDate, proRata);
    }

    public static /* synthetic */ CashflowCompo copy$default(CashflowCompo cashflowCompo, Holding holding, String string, FundsUtilisation fundsUtilisation, ValueProvider valueProvider, FlowDirection flowDirection, Periodicity periodicity, SimDate simDate, SimDate simDate2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            holding = cashflowCompo.holding;
        }
        if ((n & 2) != 0) {
            string = cashflowCompo.tag;
        }
        if ((n & 4) != 0) {
            fundsUtilisation = cashflowCompo.fundsUtilisation;
        }
        if ((n & 8) != 0) {
            valueProvider = cashflowCompo.amount;
        }
        if ((n & 0x10) != 0) {
            flowDirection = cashflowCompo.direction;
        }
        if ((n & 0x20) != 0) {
            periodicity = cashflowCompo.periodicity;
        }
        if ((n & 0x40) != 0) {
            simDate = cashflowCompo.startDate;
        }
        if ((n & 0x80) != 0) {
            simDate2 = cashflowCompo.endDate;
        }
        if ((n & 0x100) != 0) {
            bl = cashflowCompo.proRata;
        }
        return cashflowCompo.copy(holding, string, fundsUtilisation, valueProvider, flowDirection, periodicity, simDate, simDate2, bl);
    }

    @NotNull
    public String toString() {
        return "CashflowCompo(holding=" + this.holding + ", tag=" + this.tag + ", fundsUtilisation=" + this.fundsUtilisation + ", amount=" + this.amount + ", direction=" + this.direction + ", periodicity=" + this.periodicity + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", proRata=" + this.proRata + ")";
    }

    public int hashCode() {
        int result = this.holding.hashCode();
        result = result * 31 + this.tag.hashCode();
        result = result * 31 + this.fundsUtilisation.hashCode();
        result = result * 31 + this.amount.hashCode();
        result = result * 31 + this.direction.hashCode();
        result = result * 31 + this.periodicity.hashCode();
        result = result * 31 + (this.startDate == null ? 0 : this.startDate.hashCode());
        result = result * 31 + (this.endDate == null ? 0 : this.endDate.hashCode());
        result = result * 31 + Boolean.hashCode(this.proRata);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CashflowCompo)) {
            return false;
        }
        CashflowCompo cashflowCompo = (CashflowCompo)other;
        if (!Intrinsics.areEqual((Object)this.holding, (Object)cashflowCompo.holding)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.tag, (Object)cashflowCompo.tag)) {
            return false;
        }
        if (this.fundsUtilisation != cashflowCompo.fundsUtilisation) {
            return false;
        }
        if (!Intrinsics.areEqual(this.amount, cashflowCompo.amount)) {
            return false;
        }
        if (this.direction != cashflowCompo.direction) {
            return false;
        }
        if (this.periodicity != cashflowCompo.periodicity) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.startDate, (Object)cashflowCompo.startDate)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.endDate, (Object)cashflowCompo.endDate)) {
            return false;
        }
        return this.proRata == cashflowCompo.proRata;
    }
}

