/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.compo.base;

import io.fincast.compo.FinancialCompo;
import io.fincast.compo.ValueProvider;
import io.fincast.engine.SimDate;
import io.fincast.enums.BookingKind;
import io.fincast.enums.FundsUtilisation;
import io.fincast.enums.Periodicity;
import io.fincast.holding.Holding;
import io.fincast.holding.ProjectionPhase;
import io.fincast.household.Household;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J \u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u001d\u001a\u00020\u0005H\u0016J\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00020\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lio/fincast/compo/base/YieldCompoBase;", "Lio/fincast/compo/FinancialCompo;", "()V", "amount", "Lio/fincast/compo/ValueProvider;", "", "getAmount", "()Lio/fincast/compo/ValueProvider;", "bookingKind", "Lio/fincast/enums/BookingKind;", "getBookingKind", "()Lio/fincast/enums/BookingKind;", "fundsUtilisation", "Lio/fincast/enums/FundsUtilisation;", "getFundsUtilisation", "()Lio/fincast/enums/FundsUtilisation;", "yield", "yieldPeriodicity", "Lio/fincast/enums/Periodicity;", "getYieldPeriodicity", "()Lio/fincast/enums/Periodicity;", "yieldRate", "getYieldRate", "addAccrual", "", "accrual", "bookYield", "date", "Lio/fincast/engine/SimDate;", "getYield", "handleLifecycle", "fincast"})
public abstract class YieldCompoBase
implements FinancialCompo {
    private double yield;

    @NotNull
    public abstract ValueProvider<Double> getAmount();

    @NotNull
    public abstract ValueProvider<Double> getYieldRate();

    @NotNull
    public abstract Periodicity getYieldPeriodicity();

    @NotNull
    public abstract BookingKind getBookingKind();

    @NotNull
    public abstract FundsUtilisation getFundsUtilisation();

    @Override
    public double getYield() {
        return this.yield;
    }

    @Override
    public void handleLifecycle(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Double amount = this.getAmount().getValue(this, date);
        Double yieldRate = this.getYieldRate().getValue(this, date);
        Double d = amount;
        Double d2 = yieldRate;
        double yield = (d != null ? d : 0.0) * (d2 != null ? d2 : 0.0) / (double)100 / (double)12;
        this.addAccrual(yield);
        if (this.getYieldPeriodicity().isEndOfPeriod(date)) {
            this.bookYield(date, this.getBookingKind(), this.getFundsUtilisation());
        }
    }

    private final void addAccrual(double accrual) {
        this.yield += accrual;
    }

    private final void bookYield(SimDate date, BookingKind bookingKind, FundsUtilisation fundsUtilisation) {
        Holding holding = fundsUtilisation == FundsUtilisation.COMPOUND ? this.getHolding() : (Holding)this.getHousehold().getInternalCash();
        holding.bookCashflow(date, bookingKind, this.yield, this.getHolding(), this.getTag());
        this.yield = 0.0;
    }

    @Override
    @NotNull
    public Household getHousehold() {
        return FinancialCompo.DefaultImpls.getHousehold(this);
    }

    @Override
    @NotNull
    public ProjectionPhase getProjectionPhase() {
        return FinancialCompo.DefaultImpls.getProjectionPhase(this);
    }
}

