/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.compo;

import io.fincast.compo.FinancialCompo;
import io.fincast.compo.ValueProvider;
import io.fincast.engine.SimDate;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\f0\u0004\"\u0004\b\u0000\u0010\f2\u0006\u0010\r\u001a\u0002H\fH\u0007\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0010\u001a\u00020\u0005H\u0007J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\r\u001a\u00020\u0005H\u0007J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u0005R\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/fincast/compo/ValueProviders;", "", "()V", "Zero", "Lio/fincast/compo/ValueProvider;", "", "getZero$annotations", "getZero", "()Lio/fincast/compo/ValueProvider;", "availableProfit", "totalProfit", "constValue", "T", "value", "(Ljava/lang/Object;)Lio/fincast/compo/ValueProvider;", "currentRelativeValue", "percentage", "prevEomBalance", "prevEomCreditBalance", "prevEomDebitBalance", "profitShare", "setAvailableProfit", "", "setTotalProfit", "fincast"})
public final class ValueProviders {
    @NotNull
    public static final ValueProviders INSTANCE = new ValueProviders();
    @NotNull
    private static final ValueProvider<Double> Zero = ValueProviders.constValue(0.0);
    private static double totalProfit;
    private static double availableProfit;

    private ValueProviders() {
    }

    @NotNull
    public static final ValueProvider<Double> getZero() {
        return Zero;
    }

    @JvmStatic
    public static /* synthetic */ void getZero$annotations() {
    }

    public final void setTotalProfit(double value) {
        totalProfit = value;
    }

    public final void setAvailableProfit(double value) {
        availableProfit = value;
    }

    @JvmStatic
    @NotNull
    public static final <T> ValueProvider<T> constValue(T value) {
        return (arg_0, arg_1) -> ValueProviders.constValue$lambda$0(value, arg_0, arg_1);
    }

    @JvmStatic
    @NotNull
    public static final ValueProvider<Double> currentRelativeValue(double percentage) {
        return (arg_0, arg_1) -> ValueProviders.currentRelativeValue$lambda$1(percentage, arg_0, arg_1);
    }

    @JvmStatic
    @NotNull
    public static final ValueProvider<Double> prevEomBalance() {
        return ValueProviders::prevEomBalance$lambda$2;
    }

    @JvmStatic
    @NotNull
    public static final ValueProvider<Double> prevEomCreditBalance() {
        return ValueProviders::prevEomCreditBalance$lambda$3;
    }

    @JvmStatic
    @NotNull
    public static final ValueProvider<Double> prevEomDebitBalance() {
        return ValueProviders::prevEomDebitBalance$lambda$4;
    }

    @JvmStatic
    @NotNull
    public static final ValueProvider<Double> profitShare(double value) {
        return (arg_0, arg_1) -> ValueProviders.profitShare$lambda$5(value, arg_0, arg_1);
    }

    private static final Object constValue$lambda$0(Object $value, FinancialCompo financialCompo, SimDate simDate) {
        Intrinsics.checkNotNullParameter((Object)financialCompo, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)simDate, (String)"<anonymous parameter 1>");
        return $value;
    }

    private static final Double currentRelativeValue$lambda$1(double $percentage, FinancialCompo compo, SimDate date) {
        Intrinsics.checkNotNullParameter((Object)compo, (String)"compo");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return $percentage / 100.0 * compo.getHolding().getBalance(date);
    }

    private static final Double prevEomBalance$lambda$2(FinancialCompo compo, SimDate date) {
        Intrinsics.checkNotNullParameter((Object)compo, (String)"compo");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return compo.getHolding().getBalance(date.minus(1));
    }

    private static final Double prevEomCreditBalance$lambda$3(FinancialCompo compo, SimDate date) {
        Intrinsics.checkNotNullParameter((Object)compo, (String)"compo");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        double eomBalance = compo.getHolding().getBalance(date.minus(1));
        return RangesKt.coerceAtLeast((double)eomBalance, (double)0.0);
    }

    private static final Double prevEomDebitBalance$lambda$4(FinancialCompo compo, SimDate date) {
        Intrinsics.checkNotNullParameter((Object)compo, (String)"compo");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        double eomBalance = compo.getHolding().getBalance(date.minus(1));
        return RangesKt.coerceAtMost((double)eomBalance, (double)0.0);
    }

    private static final Double profitShare$lambda$5(double $value, FinancialCompo financialCompo, SimDate d) {
        Intrinsics.checkNotNullParameter((Object)financialCompo, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        double profit = $value <= 1.0 ? $value * totalProfit : $value;
        return Math.min(profit, availableProfit);
    }
}

