package io.fincast.spi

import io.fincast.enums.CivilStatus
import io.fincast.enums.Religion

data class ChTaxHouseholdInfo(
	// income (config)
	val otherIncome: Double = 0.0,
	// deductions (config)
	val insurance: Double = 0.0,
	val childCareCosts: Double = 0.0,
	val otherDeductions: Double = 0.0,
	val rent: Double = 0.0,
	// income (calculated)
	val investmentIncome: Double = 0.0,
	val rentalIncome: Double = 0.0,
	// deductions (calculated)
	val debtInterestExpenses: Double = 0.0,
	val realEstateMaintenance: Double = 0.0,
	val pillar3aContributions: Double = 0.0,
	// wealth (calculated)
	val netWealth: Double = 0.0,
)

data class ChTaxPersonalInfo(
	// static data
	val age: Int,
	val confession: Religion,
	// deductions (config)
	val primaryOccupationMealCosts: Double = 0.0,
	val primaryOccupationTravelCosts: Double = 0.0,
	val primaryOccupationOtherExpenses: Double = 0.0,
	val secondaryOccupationExpenses: Double = 0.0,
	// income (calculated)
	val primaryNetIncome: Double = 0.0,
	val secondaryNetIncome: Double = 0.0,
	// income (calculated)
	val pensionPayment: Double = 0.0,
)

data class ChTaxChild(
	val age: Int,
)

data class ChTaxResult(
	val taxableIncomeCanton: Double,
	val taxableIncomeFederal: Double,
	val taxableWealth: Double,
	// income tax
	val incomeTaxCommunity: Double,
	val incomeTaxCanton: Double,
	val incomeTaxFederal: Double,
	val incomeTaxChurch: Double,
	val incomeTax: Double,
	// wealth tax
	val wealthTaxCommunity: Double,
	val wealthTaxCanton: Double,
	val wealthTaxChurch: Double,
	val wealthTax: Double,
	// capital tax (TODO nyi)
	val capitalTaxCommunity: Double,
	val capitalTaxCanton: Double,
	val capitalTaxFederal: Double,
	val capitalTaxChurch: Double,
	val capitalTax: Double,
)


interface ChTaxService {

	fun getTaxes(
		taxYear: Int,
		//
		taxLocationId: Int,
		civilStatus: CivilStatus,
		//
		householdInfo: ChTaxHouseholdInfo,
		partner1Info: ChTaxPersonalInfo,
		partner2Info: ChTaxPersonalInfo? = null,
		children: List<ChTaxChild> = emptyList(),
	): ChTaxResult

}
