package io.fincast.household.impl

import io.fincast.engine.SimDate
import io.fincast.enums.CivilStatus
import io.fincast.holding.Holding
import io.fincast.holding.base.HoldingBase
import io.fincast.holding.impl.core.BankAccount
import io.fincast.holding.impl.core.Investment
import io.fincast.household.Household
import io.fincast.household.Person

data class HouseholdImpl(
	override val zip: Int,
	override val civilStatus: CivilStatus,
	override val partner1: Person,
	override val partner2: Person?,
	override val reconDate: SimDate,
	override val holdings: List<Holding>,
	override val internalCash: BankAccount,
	override val bufferInvestment: Investment,
	override val targetCashBalance: Double?,
) : Household {

	override val externalCash: Holding = BankAccount(Household.EXTERNAL_CASH_TAG)

	private val holdingsByTag: Map<String, Holding>

	init {
		val allHoldings = holdings + internalCash + externalCash + bufferInvestment
		allHoldings.forEach { (it as HoldingBase).setHousehold(this) }
		holdingsByTag = allHoldings.associateBy { it.tag }
	}

	override fun getHoldingByTag(tag: String): Holding? {
		return holdingsByTag[tag]
	}

}
