package io.fincast.household

import io.fincast.engine.SimDate
import io.fincast.enums.CivilStatus
import io.fincast.holding.Holding
import io.fincast.holding.impl.core.BankAccount
import io.fincast.holding.impl.core.Investment
import io.fincast.household.impl.HouseholdImpl

interface Household {

	val zip: Int

	val civilStatus: CivilStatus

	val partner1: Person

	val partner2: Person?

	val reconDate: SimDate

	val holdings: List<Holding>

	val internalCash: BankAccount

	val bufferInvestment: Investment

	val targetCashBalance: Double?

	val externalCash: Holding

	fun getHoldingByTag(tag: String): Holding?

	class Builder {
		private var zip: Int? = null
		private var civilStatus: CivilStatus? = null
		private var partner1: Person? = null
		private var partner2: Person? = null
		private var reconDate: SimDate? = null
		private var holdings: List<Holding> = emptyList()
		private var internalCash: BankAccount? = null
		private var bufferInvestment: Investment? = null
		private var targetCashBalance: Double? = null
		fun zip(zip: Int) = apply { this.zip = zip }
		fun civilStatus(civilStatus: CivilStatus) = apply { this.civilStatus = civilStatus }
		fun partner1(partner1: Person) = apply { this.partner1 = partner1 }
		fun partner2(partner2: Person) = apply { this.partner2 = partner2 }
		fun reconDate(reconDate: SimDate) = apply { this.reconDate = reconDate }
		fun holdings(holdings: List<Holding>) = apply { this.holdings = holdings }
		fun internalCash(internalCash: BankAccount) = apply { this.internalCash = internalCash }
		fun bufferInvestment(bufferInvestment: Investment) = apply { this.bufferInvestment = bufferInvestment }
		fun targetCashBalance(targetCashBalance: Double?) = apply { this.targetCashBalance = targetCashBalance }
		fun build(): Household {
			return HouseholdImpl(
				zip = zip ?: throw IllegalArgumentException("zip is required"),
				civilStatus = civilStatus ?: throw IllegalArgumentException("civilStatus is required"),
				partner1 = partner1 ?: throw IllegalArgumentException("partner1 is required"),
				partner2 = partner2,
				reconDate = reconDate ?: throw IllegalArgumentException("reconDate is required"),
				holdings = holdings,
				internalCash = internalCash ?: throw IllegalArgumentException("internalCash is required"),
				bufferInvestment = bufferInvestment ?: throw IllegalArgumentException("bufferInvestment is required"),
				targetCashBalance = targetCashBalance,
			)
		}
	}

	companion object {

		const val EXTERNAL_CASH_TAG = "#externalCash"

	}

}
