package io.fincast.holding.base

import io.fincast.engine.SimDate
import io.fincast.enums.ProductType
import io.fincast.holding.Valuable
import io.fincast.household.Person

abstract class ValuableBase(
	override val tag: String,
	override val owner: Person? = null,
	override val productType: ProductType,
	override val taxCode: String? = null,
	override val reconBalance: Double = 0.0,
) : Valuable, HoldingBase(tag, owner, productType, taxCode) {

	override fun handleReconciliation(date: SimDate) {
		if (reconBalance != 0.0) {
			this.bookReconciliation(date, reconBalance)
		}
	}

}
