package io.fincast.enums

import io.fincast.engine.SimDate
import java.util.*

enum class Periodicity(val months: Int) {
	ONCE(0),
	MONTHLY(1),
	QUARTERLY(3),
	YEARLY(12);

	fun startOfPeriod(date: SimDate, startDate: SimDate? = null, endDate: SimDate? = null): SimDate? {
		if (months == 0) {
			return null
		} else if (startDate != null && date < startDate) {
			return null
		} else if (endDate != null && date > endDate) {
			return null
		}
		val startOfPeriod = SimDate.of(date.year, (date.month - 1) / months * months + 1)
		return SimDate.max(startOfPeriod, startDate ?: startOfPeriod)
	}

	fun isStartOfPeriod(date: SimDate, startDate: SimDate? = null, endDate: SimDate? = null): Boolean {
		val startOfPeriod = startOfPeriod(date, startDate, endDate)
		return startOfPeriod != null && date == startOfPeriod
	}

	fun isStartOfPeriod(date: SimDate): Boolean {
		return isStartOfPeriod(date, null, null)
	}

	fun endOfPeriod(date: SimDate, startDate: SimDate? = null, endDate: SimDate? = null): SimDate? {
		if (this.months == 0) {
			if (startDate == null && endDate == null) {
				return null
			}
			return SimDate.min(startDate ?: endDate!!, endDate ?: startDate!!)
		}
		assert(months > 0) { "months > 0" }
		if (startDate != null && date < startDate) {
			return null
		} else if (endDate != null && date > endDate) {
			return null
		}
		val endOfPeriod = SimDate.of(date.year, months * ((date.month - 1) / months + 1))
		return SimDate.min(endOfPeriod, endDate ?: endOfPeriod)
	}

	fun isEndOfPeriod(date: SimDate, startDate: SimDate? = null, endDate: SimDate? = null): Boolean {
		val endOfPeriod = endOfPeriod(date, startDate, endDate)
		return endOfPeriod != null && date == endOfPeriod
	}

	fun isEndOfPeriod(date: SimDate): Boolean {
		return isEndOfPeriod(date, null, null)
	}

	companion object {
		const val MONTHS_IN_YEAR = 12
		fun of(periodicity: String) = valueOf(periodicity.uppercase(Locale.getDefault()))
	}

}
