package io.fincast.engine.impl

import io.fincast.engine.ProjectionEngine
import io.fincast.engine.ProjectionRun
import io.fincast.engine.SimDate
import io.fincast.enums.Periodicity
import io.fincast.holding.Holding
import io.fincast.household.Household
import io.fincast.spi.ChTaxService

class ProjectionEngineImpl(
	override val taxService: ChTaxService,
) : ProjectionEngine {

	override fun createRun(
		household: Household,
		endDate: SimDate,
		periodicity: Periodicity,
	): ProjectionRun {
		return ProjectionRunImpl(this, household, null, periodicity, endDate)
	}

	override fun createRun(
		holding: Holding,
		endDate: SimDate,
		periodicity: Periodicity,
	): ProjectionRun {
		return ProjectionRunImpl(this, holding.household, holding, periodicity, endDate)
	}

}
