package io.fincast.engine

import io.fincast.enums.CivilStatus
import io.fincast.holding.Holding
import io.fincast.spi.ChTaxChild
import io.fincast.spi.ChTaxHouseholdInfo
import io.fincast.spi.ChTaxPersonalInfo
import io.fincast.spi.ChTaxResult

data class ProjectionPeriod(
	val date: SimDate,
	// Map<Holding>, because holding.tag is not unique
	val bookings: MutableList<Booking>,
	val holdings: Map<Holding, HoldingPeriod>,
	var taxInfo: TaxInfo?,
) {

	fun balance(): Double {
		return holdings.values.filter { !it.holding.isExternalCash }.sumOf { it.balance }
	}

	fun turnover(): Double {
		return bookings.filter { !it.holding.isExternalCash }.sumOf { it.amount }
	}

}

/**
 * Projection period for a holding.
 */
data class HoldingPeriod(
	val date: SimDate,
	val holding: Holding,
	var balance: Double = 0.0,
	var inflows: Double = 0.0,
	var outflows: Double = 0.0,
	var gain: Double = 0.0,
	val bookings: MutableList<Booking> = mutableListOf(),
) {

	override fun toString(): String {
		return "${date}: ${holding.tag} [${String.format("%.0f", balance)}] {->${String.format("%.0f", inflows)}, ${String.format("%.0f", outflows)}->, ↕${String.format("%.0f", gain)}} $bookings"
	}

}

/**
 * Tax info for a year.
 */
data class TaxInfo(
	val year: Int,
	//
	val taxLocationId: Int,
	val civilStatus: CivilStatus,
	//
	val householdInfo: ChTaxHouseholdInfo,
	val partner1Info: ChTaxPersonalInfo,
	val partner2Info: ChTaxPersonalInfo?,
	val children: List<ChTaxChild>,
	//
	val taxResult: ChTaxResult,
)
