package io.fincast.engine

import io.fincast.engine.impl.ProjectionEngineImpl
import io.fincast.enums.Periodicity
import io.fincast.holding.Holding
import io.fincast.household.Household
import io.fincast.spi.ChTaxService

interface ProjectionEngine {

	val taxService: ChTaxService

	fun createRun(
		household: Household,
		endDate: SimDate,
		periodicity: Periodicity,
	): ProjectionRun

	fun createRun(
		holding: Holding,
		endDate: SimDate,
		periodicity: Periodicity,
	): ProjectionRun

	companion object {

		@JvmStatic
		fun build(taxService: ChTaxService): ProjectionEngine {
			return ProjectionEngineImpl(taxService)
		}

	}

}
