package io.fincast.engine

sealed interface Aggregate {

	val date: SimDate

	companion object {
		/*
				@JvmStatic
				fun aggregateHouseholdPeriods(bookings: List<Booking>): List<Aggregate> {
					return bookings
						.filter { !isExternal(it) }
						.groupBy { it.date }
						.map { (date, monthlyBookings) ->
							val aggregateBookings = monthlyBookings.filterIsInstance<AggregateBooking>()
							val lifecycleBookings = monthlyBookings.filterIsInstance<LifecycleBooking>().filter { it.bookingKind.isCashflow }
							val assets = aggregateBookings.filter { it.amount > 0 }.sumOf { it.amount }
							val liabilities = aggregateBookings.filter { it.amount < 0 }.sumOf { it.amount }
							val income = lifecycleBookings.filter { it.amount > 0 }.sumOf { it.amount }
							val expense = lifecycleBookings.filter { it.amount < 0 }.sumOf { it.amount }
							HouseholdPeriod(date, assets, liabilities, income, expense)
						}
				}

				@JvmStatic
				fun aggregateCategoryPeriods(bookings: List<Booking>, categorizer: (Holding) -> String): List<Aggregate> {
					return bookings
						.filter { !isExternal(it) }
						.groupBy { it.date }
						.flatMap { (date, monthlyBookings) ->
							monthlyBookings.groupBy { categorizer(it.holding) }
								.map { (category, categoryBookings) ->
									val aggregateBookings = categoryBookings.filterIsInstance<AggregateBooking>()
									val lifecycleBookings = categoryBookings.filterIsInstance<LifecycleBooking>().filter { it.bookingKind.isCashflow }
									val assets = aggregateBookings.filter { it.amount > 0 }.sumOf { it.amount }
									val liabilities = aggregateBookings.filter { it.amount < 0 }.sumOf { it.amount }
									val income = lifecycleBookings.filter { it.amount > 0 }.sumOf { it.amount }
									val expense = lifecycleBookings.filter { it.amount < 0 }.sumOf { it.amount }
									CategoryPeriod(date, category, assets, liabilities, income, expense)
								}
						}
				}

				@JvmStatic
				fun mergeAggregates(aggregates: List<List<Aggregate>>): List<Aggregate> {
					return aggregates.flatten().sortedWith(compareBy({ it.date }, { order(it) }))
				}

				private fun isExternal(booking: Booking): Boolean {
					return booking.holding.tag == EXTERNAL_MONEY_TAG
				}

				private fun order(aggregate: Aggregate): Int {
					return when (aggregate) {
						is HouseholdPeriod -> 0
						is CategoryPeriod -> 1
						is HoldingPeriod -> 2
					}
				}
		*/
	}

}

//data class HouseholdPeriod(
//	override val date: SimDate,
//	val assets: Double,
//	val liabilities: Double,
//	val income: Double,
//	val expense: Double,
//) : Aggregate {
//
//	override fun toString(): String {
//		return "${date}: HH  ${String.format("%.0f", assets)} ${String.format("%.0f", liabilities)} ${String.format("%.0f", income)} ${String.format("%.0f", expense)}"
//	}
//
//}

//data class HoldingPeriod(
//	override val date: SimDate,
//	val holding: Holding,
//	val balance: Double,
//	val income: Double,
//	val expense: Double,
//) : Aggregate {
//
//	override fun toString(): String {
//		return "${date}: Hld ${holding.tag} ${String.format("%.0f", balance)} ${String.format("%.0f", income)} ${String.format("%.0f", expense)}"
//	}
//
//}
//
//data class CategoryPeriod(
//	override val date: SimDate,
//	val category: String,
//	val assets: Double,
//	val liabilities: Double,
//	val income: Double,
//	val expense: Double,
//) : Aggregate {
//
//	override fun toString(): String {
//		return "${date}: Cat $category ${String.format("%.0f", assets)} ${String.format("%.0f", liabilities)} ${String.format("%.0f", income)} ${String.format("%.0f", expense)}"
//	}
//
//}
