package io.fincast.compo.impl

import io.fincast.compo.FinancialCompo
import io.fincast.compo.ValueProvider
import io.fincast.engine.SimDate
import io.fincast.enums.Periodicity
import io.fincast.holding.Holding
import io.fincast.holding.ProjectionPhase

data class TransferCompo(
	override val holding: Holding,
	override val tag: String,
	val fromHolding: Holding,
	val toHolding: Holding,
	val amount: ValueProvider<Double>,
	val periodicity: Periodicity,
	val startDate: SimDate? = null,
	val endDate: SimDate? = null,
	override val projectionPhase: ProjectionPhase = ProjectionPhase.EOP_TRANSFER,
) : FinancialCompo {

	init {
		if (projectionPhase != ProjectionPhase.EOP_TRANSFER && projectionPhase != ProjectionPhase.EOY_REBALANCE) {
			throw IllegalArgumentException("invalid projectionPhase $projectionPhase (must be eop or eoy)")
		}
	}

	override fun handleLifecycle(date: SimDate) {
		if (periodicity.isEndOfPeriod(date, startDate, endDate)) {
			val amount = -(amount.getValue(this, date) ?: 0.0)
			fromHolding.bookTransfer(date, amount, toHolding, this.holding, this.tag)
		}
	}

}
